/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.net;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class WebInterface
implements Runnable {
    private Thread thread = null;
    private long request_number = 0L;
    private String last_request = "";
    private String return_string = "";
    private String access_string;
    private boolean isOnline = false;
    private boolean showLog = false;
    private ServerSocket serverSocket = null;
    private Socket connection = null;

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread) {
            if (!this.runServer()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isOnline = false;
        this.showLog = false;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "WebIF");
            this.thread.setPriority(1);
            this.thread.start();
            Common.setMessage("-> re-/start WebIFServer on Port: " + Common.getSettings().getProperty(Keys.KEY_WebServerPort));
        }
    }

    public void stop() {
        this.connection = null;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = null;
        System.gc();
        Common.setMessage("-> close WebIFServer on Port: " + Common.getSettings().getProperty(Keys.KEY_WebServerPort));
    }

    private boolean runServer() {
        int n = -1;
        try {
            this.request_number = 0L;
            while (true) {
                int n2;
                if ((n2 = this.getPort()) < 0) {
                    return false;
                }
                this.access_string = this.getAccess();
                if (this.access_string == null) {
                    return false;
                }
                this.isOnline = true;
                if (n2 != n) {
                    n = n2;
                    this.serverSocket = new ServerSocket(n);
                }
                this.connection = this.serverSocket.accept();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
                ++this.request_number;
                if (!this.getRequest(bufferedReader.readLine(), this.connection)) {
                    this.return_string = "<B>missing or wrong keyword</B>";
                }
                PrintWriter printWriter = new PrintWriter(this.connection.getOutputStream());
                printWriter.println(this.buildSite(this.return_string));
                printWriter.flush();
                this.connection.close();
            }
        }
        catch (Exception exception) {
            Common.setMessage("" + exception);
            Common.setMessage("" + exception.getMessage(), true);
            this.connection = null;
            try {
                this.serverSocket.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            System.gc();
            return true;
        }
    }

    private int getPort() {
        int n = -1;
        try {
            n = Common.getSettings().getIntProperty(Keys.KEY_WebServerPort);
            if (n < 0 || n > 65535) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            Common.setMessage("!> WebIF: invalid port number: '" + n + "'", true);
            n = -1;
        }
        return n;
    }

    private String getAccess() {
        String string = null;
        try {
            string = Common.getSettings().getProperty(Keys.KEY_WebServerAccess).trim();
            if (string == null || string.length() == 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            Common.setMessage("!> WebIF: invalid access_string: '" + string + "'", true);
            string = null;
        }
        return string;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    private String buildSite(String string) {
        String string2 = "HTTP/1.0 200 Ok\nContent-type: text/html\n\n<HTML><HEAD><META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\">\n<META HTTP-EQUIV=\"EXPIRES\" CONTENT=\"0\">\n<META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT=\"PRIVATE\">\n<TITLE>ProjectX Status of " + Common.getVersionName() + "/" + Common.getVersionDate() + "</TITLE></HEAD>\n" + "<BODY><H1>ProjectX WebInterface</H1>\n" + "<BR>request# " + this.request_number + " - " + Common.getVersionName() + " / " + Common.getVersionDate() + " - " + Common.getDateAndTime() + "<BR><PRE>" + string + "</PRE></BODY></HTML>";
        return string2;
    }

    private boolean getRequest(String string, Socket socket) {
        this.last_request = string;
        Common.setMessage("--> request# " + this.request_number + " from " + socket.getInetAddress().getHostAddress() + " - " + string);
        this.return_string = "";
        string = string.trim();
        int n = string.indexOf("GET /");
        if (n >= 3 || n < 0) {
            return false;
        }
        if (!string.endsWith("HTTP/1.0") && !string.endsWith("HTTP/1.1")) {
            return false;
        }
        string = string.substring(n + 5, string.indexOf("HTTP/1"));
        if (!(string = string.trim()).startsWith(this.access_string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            this.getCommand(stringTokenizer.nextToken());
        }
        if (this.showLog) {
            this.return_string = this.return_string + this.getLog();
        }
        this.return_string = this.return_string + this.getCollection();
        return true;
    }

    private void getCommand(String string) {
        if (string.equals("addcoll")) {
            Common.addCollection();
            Common.setActiveCollection(Common.getCollectionListSize() - 1);
            this.updateCollectionView();
        } else if (string.equals("removecoll")) {
            if (Common.removeCollection(Common.getActiveCollection())) {
                this.updateCollectionView();
            }
        } else if (string.equals("exit")) {
            Common.exitApplication(0);
        } else if (string.equals("start")) {
            if (Common.startProcess()) {
                Common.startMainProcess();
            }
        } else if (string.equals("stop")) {
            Common.breakMainProcess();
        } else if (string.equals("getlog")) {
            this.showLog = true;
        } else if (string.equals("hidelog")) {
            this.showLog = false;
        } else if (string.equals("filelist")) {
            this.return_string = this.return_string + this.getInputFileList();
        } else if (string.equals("getsettings")) {
            this.return_string = this.return_string + this.getSettings();
        } else if (string.startsWith("addfile")) {
            int n;
            Object[] objectArray;
            JobCollection jobCollection = Common.getCollection();
            if (jobCollection != null && (objectArray = Common.reloadInputDirectories()).length > (n = Integer.parseInt(string.substring(7)))) {
                jobCollection.addInputFile(objectArray[n]);
            }
            this.updateCollectionView();
        } else if (string.startsWith("removefile")) {
            JobCollection jobCollection = Common.getCollection();
            if (jobCollection != null) {
                jobCollection.removeInputFile(Integer.parseInt(string.substring(10)));
            }
            this.updateCollectionView();
        } else if (string.startsWith("setcoll")) {
            Common.setActiveCollection(Integer.parseInt(string.substring(7)));
            this.updateCollectionView();
        }
    }

    private void updateCollectionView() {
        Common.getGuiInterface().showActiveCollection(Common.getActiveCollection());
    }

    private String getInputFileList() {
        String string = "";
        Object[] objectArray = Common.reloadInputDirectories();
        string = string + "<HR><I>List of available files:</I>";
        int n = 0;
        while (n < objectArray.length) {
            string = string + "<BR><A HREF=" + this.access_string + "&addfile" + n + ">add file</A> " + n + " - <B>" + objectArray[n].toString() + "</B>";
            ++n;
        }
        return string;
    }

    private String getCollection() {
        String string = "";
        string = string + "<HR><A HREF=" + this.access_string + "&exit>shutdown remote application</A>";
        string = string + "<HR><A HREF=" + this.access_string + "&getsettings>get current settings</A>";
        string = string + "<HR><I>Process Status:</I> <A HREF=" + this.access_string + "&getlog>(show message log)</A>";
        string = string + "<BR>" + Common.getProcessedPercent() + "% - " + Common.getStatusString();
        string = string + "<BR><A HREF=" + this.access_string + "&start>start processing</A>";
        string = string + " / <A HREF=" + this.access_string + "&stop>stop processing</A>";
        string = string + "<HR><I>Collection access:</I>";
        string = string + "<BR><B>active Collection: " + Common.getActiveCollection() + "</B>";
        string = string + "<BR><A HREF=" + this.access_string + "&removecoll>remove active Collection</A>";
        string = string + " / <A HREF=" + this.access_string + "&addcoll>add new Collection</A>";
        string = string + "<BR>choose other Collection:";
        int n = 0;
        int n2 = Common.getCollectionListSize();
        while (n < n2) {
            string = string + " <A HREF=" + this.access_string + "&setcoll" + n + ">" + n + "</A>";
            ++n;
        }
        JobCollection jobCollection = Common.getCollection();
        if (jobCollection != null) {
            string = string + "<HR><I>Infos:</I>\n";
            string = string + "<U>Output to:</U> '" + jobCollection.getOutputDirectory() + "'\n";
            string = string + jobCollection.getShortSummary();
            string = string + this.getCollectionFiles(jobCollection);
        }
        return string;
    }

    private String getCollectionFiles(JobCollection jobCollection) {
        String string = "";
        Object[] objectArray = jobCollection.getInputFiles();
        string = string + "<HR><I>Content:</I> <A HREF=" + this.access_string + "&filelist>add file from fixed directories</A>";
        int n = 0;
        while (n < objectArray.length) {
            string = string + "<BR>" + n + " - <B>" + objectArray[n].toString() + "</B> <A HREF=" + this.access_string + "&removefile" + n + ">remove</A>";
            string = string + "<BR><UL>" + ((XInputFile)objectArray[n]).getStreamInfo().getFullInfo() + "</UL>";
            ++n;
        }
        return string;
    }

    private String getLog() {
        String string = "";
        string = string + "<HR><I>current processing log:</I> <A HREF=" + this.access_string + "&hidelog>(hide message log)</A> <A HREF=" + this.access_string + "&getlog>(refresh log)</A>";
        string = string + "<BR>" + Common.getMessageLog();
        return string;
    }

    private String getSettings() {
        String string = "";
        string = string + "<HR><I>current settings:</I> <A HREF=" + this.access_string + ">(hide settings)</A>";
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(Common.getSettings().storeProperties())));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + "<BR>" + string2;
            }
        }
        catch (IOException iOException) {}
        return string;
    }
}

