/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.io.BitWalker;
import net.sourceforge.dvb.projectx.parser.CommonParsing;

public class IDDBufferedOutputStream
extends BufferedOutputStream {
    long pos = 0L;
    int type = 0;
    String name = "";
    String chaptersname = "";
    boolean sequenceend = false;
    boolean chapters = false;
    boolean CreateAc3Wave = false;
    boolean CreateDtsWave = false;
    boolean CreateDts48Wave = false;
    byte[][] IddHeader = new byte[][]{{105, 100, 100, 2}, {105, 100, 100, 3}};
    byte[] DD_header = new byte[]{114, -8, 31, 78, 1, 0, 0, 0};
    byte[] padding_block = null;
    BufferedOutputStream IddOut = null;
    PrintWriter ChaptersOut = null;
    private String aInfoName = "";
    private BufferedOutputStream aInfoOut = null;
    private boolean aInfoSeqEnd = false;
    private BitWalker aBitWalker = null;
    private StringBuffer aStringBuffer = null;
    int filenumber = 1;

    public IDDBufferedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public IDDBufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream, n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block0 : switch (this.type) {
            case 3: {
                int n4;
                if ((0xF0 & byArray[n + 3]) != 224) break;
                int n5 = n + 9 + (0xFF & byArray[8]);
                while (n5 < n + n2 - 3) {
                    int n6 = CommonParsing.validateStartcode(byArray, n5);
                    if (n6 < 0) {
                        n5 += -n6 - 1;
                    } else if (byArray[n5 + 3] != 0) {
                        n5 += 3;
                    } else {
                        if (n5 + 5 >= n + n2 || (n4 = 7 & byArray[n5 + 5] >>> 3) == 0 || n4 > 3) break block0;
                        this.IddOut.write(this.VdrIndex());
                        this.IddOut.write(n4);
                        this.IddOut.write(this.filenumber);
                        this.IddOut.write(new byte[2]);
                        break block0;
                    }
                    ++n5;
                }
                break;
            }
            case 1: {
                if (this.aInfoOut != null) {
                    this.writeInfo(byArray, n, n2);
                    if (this.IddOut == null) break;
                }
                int n4 = n;
                while (n4 < n + n2 - 3) {
                    int n7 = CommonParsing.validateStartcode(byArray, n4);
                    if (n7 < 0) {
                        n4 += -n7 - 1;
                    } else if ((0xFF & byArray[n4 + 3]) == 179) {
                        this.IddOut.write(179);
                        this.IddOut.write(this.littleEndian(n4 - n));
                        n4 += 12;
                    } else if ((0xFF & byArray[n4 + 3]) == 183) {
                        this.IddOut.write(183);
                        this.IddOut.write(this.littleEndian(n4 - n));
                        this.sequenceend = true;
                        n4 += 3;
                    } else if ((0xFF & byArray[n4 + 3]) == 184) {
                        this.IddOut.write(184);
                        this.IddOut.write(this.littleEndian(n4 - n));
                        n4 += 7;
                    } else if (byArray[n4 + 3] == 0) {
                        this.IddOut.write(0);
                        this.IddOut.write(this.littleEndian(n4 - n));
                        n3 = 3 & byArray[n4 + 5] >>> 6 | (0xFF & byArray[n4 + 4]) << 2;
                        this.IddOut.write(0xFF & n3);
                        this.IddOut.write(n3 >>> 8);
                        this.IddOut.write(7 & byArray[n4 + 5] >>> 3);
                        n4 += 8;
                    }
                    ++n4;
                }
                break;
            }
            case 2: {
                if (this.pos == 0L && byArray.length <= 80) break;
                this.IddOut.write(this.littleEndian(0));
            }
        }
        if (this.CreateAc3Wave) {
            n3 = n2 << 3;
            this.DD_header[6] = (byte)(0xFF & n3);
            this.DD_header[7] = (byte)(0xFF & n3 >> 8);
            super.write(this.DD_header, 0, 8);
            this.pos += 8L;
            Common.changeByteOrder(byArray, n, n2);
            super.write(byArray, n, n2);
            super.write(this.padding_block, n2, this.padding_block.length - n2);
            this.pos += (long)this.padding_block.length;
        } else if (this.CreateDtsWave) {
            if (this.CreateDts48Wave) {
                n3 = n2 > 2048 ? 4096 : 2048;
                System.arraycopy(byArray, n, this.padding_block, 0, n2);
                Arrays.fill(this.padding_block, n2, n3 + 1, (byte)0);
                Common.changeByteOrder(this.padding_block, 0, n3);
                super.write(this.padding_block, 0, n3);
                this.pos += (long)n3;
            } else {
                n3 = 0;
                int n8 = n;
                int n9 = n + n2;
                while (n8 < n9) {
                    long l = CommonParsing.getValue(byArray, n8, 7, false);
                    this.padding_block[n3] = (byte)(0xFFL & l >> 42);
                    this.padding_block[n3 + 1] = (byte)((byte)(0xFCL & l >> 48) >> 2);
                    this.padding_block[n3 + 2] = (byte)(0xFFL & l >> 28);
                    this.padding_block[n3 + 3] = (byte)((byte)(0xFCL & l >> 34) >> 2);
                    this.padding_block[n3 + 4] = (byte)(0xFFL & l >> 14);
                    this.padding_block[n3 + 5] = (byte)((byte)(0xFCL & l >> 20) >> 2);
                    this.padding_block[n3 + 6] = (byte)(0xFFL & l);
                    this.padding_block[n3 + 7] = (byte)((byte)(0xFCL & l >> 6) >> 2);
                    n8 += 7;
                    n3 += 8;
                }
                super.write(this.padding_block, 0, n3);
                this.pos += (long)n3;
            }
        } else {
            super.write(byArray, n, n2);
            this.pos += (long)n2;
        }
    }

    public synchronized void write(int n) throws IOException {
        super.write(n);
        ++this.pos;
    }

    public byte[] VdrIndex() {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[n] = (byte)(0xFFL & this.pos >>> n * 8);
            ++n;
        }
        return byArray;
    }

    public void setWave(boolean bl, boolean bl2, boolean bl3, int n) throws IOException {
        if (!bl) {
            return;
        }
        this.CreateAc3Wave = bl2;
        this.CreateDtsWave = bl3;
        boolean bl4 = this.CreateDts48Wave = this.CreateDtsWave && n > 1411200;
        if (this.padding_block == null) {
            this.padding_block = new byte[6136];
        }
    }

    public void InitVdr(String string, int n) throws IOException {
        this.name = string;
        this.filenumber = n + 1;
        this.type = 3;
        this.IddOut = new BufferedOutputStream(new FileOutputStream(this.name, this.filenumber != 1), 655350);
    }

    public String renameVdrTo(String string, String string2) {
        String string3 = "000" + this.filenumber + ".vdr";
        String string4 = string + string3.substring(string3.length() - 7);
        File file = new File(string4);
        File file2 = new File(string2);
        if (!file2.getName().equals(file.getName()) && file.exists()) {
            file.delete();
        }
        Common.renameTo(file2, file);
        return string4;
    }

    public byte[] littleEndian(int n) {
        byte[] byArray = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray[n2] = (byte)(0xFFL & this.pos + (long)n >>> n2 * 8);
            ++n2;
        }
        return byArray;
    }

    public void InitIdd(String string, int n) throws IOException {
        this.name = string + ".id";
        this.type = n;
        this.IddOut = new BufferedOutputStream(new FileOutputStream(this.name), 655350);
        this.IddOut.write(this.IddHeader[this.type - 1]);
    }

    public void renameIddTo(File file) {
        String string = file.toString();
        File file2 = new File(string + ".idd");
        File file3 = new File(string + ".m2s.txt");
        if (file.exists()) {
            if (file2.exists()) {
                file2.delete();
            }
            if (new File(this.name).exists()) {
                Common.renameTo(new File(this.name), file2);
            }
        } else {
            new File(this.name).delete();
        }
        if (this.chapters) {
            if (file3.exists()) {
                file3.delete();
            }
            if (new File(this.chaptersname).exists()) {
                Common.renameTo(new File(this.chaptersname), file3);
            }
        }
    }

    public void renameVideoIddTo(String string) {
        File file = new File(string + ".idd");
        if (file.exists()) {
            file.delete();
        }
        Common.renameTo(new File(this.name), file);
    }

    public void deleteIdd() {
        new File(this.name).delete();
        new File(this.chaptersname).delete();
    }

    public void InitChapters(String string) throws IOException {
        this.chaptersname = string + ".chp";
        this.chapters = true;
        this.ChaptersOut = new PrintWriter(new FileOutputStream(this.chaptersname));
    }

    public void addChapter(String string) throws IOException {
        if (!this.chapters) {
            return;
        }
        this.ChaptersOut.println(string);
    }

    public synchronized void flush() throws IOException {
        super.flush();
    }

    public synchronized void close() throws IOException {
        if (this.chapters) {
            this.ChaptersOut.flush();
            this.ChaptersOut.close();
        }
        switch (this.type) {
            case 1: {
                if (this.aInfoOut != null) {
                    this.closeInfo();
                    if (this.IddOut == null) break;
                }
                if (!this.sequenceend) {
                    this.IddOut.write(183);
                    this.IddOut.write(this.littleEndian(0));
                }
                this.IddOut.flush();
                this.IddOut.close();
                this.IddOut = null;
                break;
            }
            case 2: {
                this.IddOut.write(this.littleEndian(0));
            }
            case 3: {
                this.IddOut.flush();
                this.IddOut.close();
            }
        }
        super.close();
    }

    public void InitInfo(String string) throws IOException {
        this.aInfoName = string + ".info";
        this.type = 1;
        this.aInfoOut = new BufferedOutputStream(new FileOutputStream(this.aInfoName), 655350);
        this.aInfoOut.write(-17);
        this.aInfoOut.write(-69);
        this.aInfoOut.write(-65);
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.setLength(0);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><IndexContainer xmlns=\"http://www.cuttermaran.de\"><Version>1.61</Version>");
        this.dumpInfo(stringBuffer);
    }

    public void renameVideoInfoTo(String string) {
        File file = new File(string + ".info");
        if (file.exists()) {
            file.delete();
        }
        Common.renameTo(new File(this.aInfoName), file);
        file.setLastModified(file.lastModified() + 120000L);
    }

    private void dumpInfo(StringBuffer stringBuffer) throws IOException {
        int n = stringBuffer == null ? 0 : stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            this.aInfoOut.write((byte)stringBuffer.charAt(n2));
            ++n2;
        }
    }

    private synchronized void closeInfo() throws IOException {
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.setLength(0);
        if (!this.aInfoSeqEnd) {
            stringBuffer.append("<SeqEnd adr=\"");
            stringBuffer.append(this.pos);
            stringBuffer.append('\"');
            stringBuffer.append(" />");
        }
        stringBuffer.append("</IndexContainer>");
        this.dumpInfo(stringBuffer);
        this.aInfoOut.flush();
        this.aInfoOut.close();
        this.aInfoOut = null;
        this.aInfoSeqEnd = false;
        this.setBitWalker(null);
        this.setStringBuffer(null);
    }

    public void deleteInfo() {
        new File(this.aInfoName).delete();
    }

    private synchronized void writeInfo(byte[] byArray, int n, int n2) throws IOException {
        if (this.aInfoOut == null) {
            return;
        }
        int n3 = n;
        while (n3 < n + n2 - 3) {
            StringBuffer stringBuffer;
            int n4;
            int n5 = CommonParsing.validateStartcode(byArray, n3);
            if (n5 < 0) {
                n3 += -n5 - 1;
            } else if ((0xFF & byArray[n3 + 3]) == 179) {
                n4 = 0xF & byArray[n3 + 7] >>> 4;
                stringBuffer = this.getStringBuffer();
                stringBuffer.setLength(0);
                stringBuffer.append("<Seq adr=\"");
                stringBuffer.append(this.pos + (long)n3 - (long)n);
                stringBuffer.append('\"');
                stringBuffer.append(" ratio=\"");
                stringBuffer.append(n4);
                stringBuffer.append('\"');
                stringBuffer.append(" />");
                this.dumpInfo(stringBuffer);
                n3 += 12;
            } else if ((0xFF & byArray[n3 + 3]) == 183) {
                stringBuffer = this.getStringBuffer();
                stringBuffer.setLength(0);
                stringBuffer.append("<SeqEnd adr=\"");
                stringBuffer.append(this.pos + (long)n3 - (long)n);
                stringBuffer.append('\"');
                stringBuffer.append(" />");
                this.dumpInfo(stringBuffer);
                this.aInfoSeqEnd = true;
                n3 += 3;
            } else if ((0xFF & byArray[n3 + 3]) == 184) {
                stringBuffer = this.getStringBuffer();
                stringBuffer.setLength(0);
                stringBuffer.append("<GOP adr=\"");
                stringBuffer.append(this.pos + (long)n3 - (long)n);
                stringBuffer.append('\"');
                stringBuffer.append(" />");
                this.dumpInfo(stringBuffer);
                n3 += 7;
            } else if (byArray[n3 + 3] == 0) {
                stringBuffer = this.getStringBuffer();
                stringBuffer.setLength(0);
                stringBuffer.append("<Pic adr=\"");
                stringBuffer.append(this.pos + (long)n3 - (long)n);
                stringBuffer.append('\"');
                n4 = 3 & byArray[n3 + 5] >>> 6 | (0xFF & byArray[n3 + 4]) << 2;
                stringBuffer.append(" tempRef=\"");
                stringBuffer.append(n4);
                stringBuffer.append('\"');
                int n6 = 7 & byArray[n3 + 5] >>> 3;
                stringBuffer.append(" type=\"");
                stringBuffer.append(n6);
                stringBuffer.append('\"');
                BitWalker bitWalker = this.getBitWalker();
                bitWalker.setBuf(byArray, n3 + 3);
                int n7 = bitWalker.getPictureStructure(true);
                if (n7 != 3) {
                    stringBuffer.append(" struct=\"");
                    stringBuffer.append(n7);
                    stringBuffer.append('\"');
                }
                stringBuffer.append(" />");
                this.dumpInfo(stringBuffer);
                n3 += 8;
            }
            ++n3;
        }
    }

    private BitWalker getBitWalker() {
        if (this.aBitWalker == null) {
            this.aBitWalker = new BitWalker();
        }
        return this.aBitWalker;
    }

    private void setBitWalker(BitWalker bitWalker) {
        this.aBitWalker = bitWalker;
    }

    private StringBuffer getStringBuffer() {
        if (this.aStringBuffer == null) {
            this.aStringBuffer = new StringBuffer();
        }
        return this.aStringBuffer;
    }

    private void setStringBuffer(StringBuffer stringBuffer) {
        this.aStringBuffer = stringBuffer;
    }
}

