/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;

public class SubpictureFrame
extends JFrame {
    String title = Resource.getString("subpicture.title");
    private Picture picture;

    public SubpictureFrame() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SubpictureFrame.this.close();
            }
        });
        this.buildMenu();
        this.picture = new Picture();
        this.getContentPane().add("Center", this.picture);
        this.setTitle(this.title);
        this.setBounds(200, 100, 726, 621);
        this.setResizable(false);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    public void setFrameTitle(String string) {
        this.setTitle(this.title + " " + string);
    }

    public void repaintSubpicture() {
        this.picture.repaint();
    }

    public void close() {
        this.dispose();
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SubpictureFrame.this.close();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public class Picture
    extends JPanel {
        public Picture() {
            this.setBackground(Color.gray);
            this.setPreferredSize(new Dimension(720, 576));
            this.setMinimumSize(new Dimension(720, 576));
            this.setMaximumSize(new Dimension(720, 576));
        }

        public void paint(Graphics graphics) {
            Image image = Common.getSubpictureClass().getImage();
            if (image != null) {
                graphics.drawImage(image, 0, 0, this);
            }
        }
    }
}

