/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import net.sourceforge.dvb.projectx.common.GuiInterfaceIF;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.MainFrame;
import net.sourceforge.dvb.projectx.gui.PreSettings;
import net.sourceforge.dvb.projectx.gui.ProcessWindow;
import net.sourceforge.dvb.projectx.gui.StartUp;
import net.sourceforge.dvb.projectx.gui.SubpictureFrame;
import net.sourceforge.dvb.projectx.gui.TeletextPageMatrix;

public class GuiInterfaceImpl
implements GuiInterfaceIF {
    private TeletextPageMatrix teletextpagematrix;
    private PreSettings presettings;
    private ProcessWindow processwindow;
    private SubpictureFrame subpictureframe;
    private StartUp startup;

    public GuiInterfaceImpl() {
        this.init();
    }

    private void init() {
        new CommonGui();
        this.processwindow = new ProcessWindow();
    }

    public void loadGui() {
        this.startup = new StartUp();
        this.startup.show();
        new MainFrame(this.startup);
    }

    private void loadTeletextPageMatrix() {
        if (this.teletextpagematrix == null) {
            this.teletextpagematrix = new TeletextPageMatrix();
        }
    }

    public void showTtxPageMatrix() {
        this.loadTeletextPageMatrix();
        this.teletextpagematrix.show();
    }

    public void initTtxPageMatrix(String string) {
        this.loadTeletextPageMatrix();
        this.teletextpagematrix.picture.init(string);
    }

    public void updateTtxPageMatrix(String string) {
        this.loadTeletextPageMatrix();
        this.teletextpagematrix.picture.update(string);
    }

    private void initPreSettings() {
        if (this.presettings == null) {
            this.presettings = new PreSettings();
        }
    }

    public void showPreSettings() {
        this.initPreSettings();
        if (this.presettings.isVisible()) {
            this.presettings.setState(0);
            this.presettings.toFront();
        } else {
            this.presettings.show();
        }
    }

    public void resetBitrateMonitor() {
        this.processwindow.resetBitrateMonitor();
    }

    public void updateBitrateMonitor(int n, byte[] byArray, String string) {
        this.processwindow.updateBitrateMonitor(n, byArray, string);
    }

    public void updateTtxHeader(String string) {
        this.processwindow.updateTtxHeader(string);
    }

    public void updateVpsLabel(String string) {
        this.processwindow.updateVpsLabel(string);
    }

    public void showAVOffset(String string) {
        this.processwindow.showAVOffset(string);
    }

    public void showExportStatus(String string) {
        this.processwindow.showExportStatus(string);
    }

    public void showExportStatus(String string, int n) {
        this.processwindow.showExportStatus(string, n);
    }

    public void updateProgressBar(int n) {
        this.processwindow.updateProgressBar(n);
    }

    public void updateProgressBar(String string) {
        this.processwindow.updateProgressBar(string);
    }

    public void setMessage(String string, boolean bl, int n) {
        this.processwindow.setMessage(string, bl, n);
    }

    public void addPidToExtract(Object object) {
        this.processwindow.addPidToExtract(object);
    }

    public void closeLogWindow() {
        this.processwindow.close();
    }

    public void showLogWindow() {
        if (this.processwindow.isVisible()) {
            this.processwindow.setState(0);
            this.processwindow.toFront();
        } else {
            this.processwindow.show();
        }
    }

    public String getUserInputDialog(String string, String string2) {
        return CommonGui.getUserInput(string, string2);
    }

    public boolean getUserConfirmationDialog(String string) {
        return CommonGui.getUserConfirmation(string);
    }

    public void showErrorMessageDialog(Object object, String string) {
        CommonGui.showErrorMessageDialog(object, string);
    }

    public void showMessageDialog(Object object, String string) {
        CommonGui.showMessageDialog(object, string);
    }

    public Object getMainFrameBounds() {
        return MainFrame.getFrameBounds();
    }

    public void showMainFrame(boolean bl) {
        MainFrame.showFrame(bl);
    }

    public void setMainFrameTitle(String string) {
        MainFrame.setFrameTitle(string);
    }

    public void resetMainFrameTitle() {
        MainFrame.resetFrameTitle();
    }

    public void addCollectionAtEnd() {
        MainFrame.addCollectionAtEnd();
    }

    public void showActiveCollection(int n) {
        MainFrame.showActiveCollection(n);
    }

    public void updateCollectionPanel(int n) {
        MainFrame.updateCollectionPanel(n);
    }

    private void initSubpictureFrame() {
        if (this.subpictureframe == null) {
            this.subpictureframe = new SubpictureFrame();
        }
    }

    public void setSubpictureTitle(String string) {
        this.initSubpictureFrame();
        this.subpictureframe.setFrameTitle(string);
    }

    public void showSubpicture() {
        this.initSubpictureFrame();
        if (this.subpictureframe.isVisible()) {
            this.subpictureframe.setState(0);
            this.subpictureframe.toFront();
        } else {
            this.subpictureframe.show();
        }
    }

    public void hideSubpicture() {
        this.initSubpictureFrame();
        this.subpictureframe.close();
    }

    public boolean isSubpictureVisible() {
        return this.subpictureframe != null && this.subpictureframe.isVisible();
    }

    public void repaintSubpicture() {
        this.initSubpictureFrame();
        this.subpictureframe.repaintSubpicture();
    }

    public void setOSDMessage(String string, boolean bl) {
        CommonGui.getPicturePanel().setOSDMessage(string, bl);
    }

    public void showCutIcon(boolean bl, Object[] objectArray, Object object) {
        CommonGui.getPicturePanel().showCutIcon(bl, objectArray, object);
    }

    public void showChapterIcon(Object[] objectArray, Object object) {
        CommonGui.getPicturePanel().showChapterIcon(objectArray, object);
    }

    public void updatePreviewPixel() {
        CommonGui.getPicturePanel().updatePreviewPixel();
    }

    public void repaintPicturePanel() {
        CommonGui.getPicturePanel().repaint();
    }
}

