/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BitrateMonitor
extends JPanel {
    private int w = 110;
    private int h = 32;
    private int divisor = 695;
    private BufferedImage bimg;
    private Graphics2D big;
    private Font font = new Font("Times New Roman", 0, 11);
    private int columnInc;
    private int[] pts;
    private int ptNum;
    private int ascent;
    private int descent;
    private int bitrate;
    private int maxbitrate = 0;
    private int minbitrate = 37500;
    private Rectangle graphOutlineRect = new Rectangle();
    private Color graphColor = new Color(46, 139, 87);
    private String usedStr;
    private String timeStr = "00:00:00";
    private boolean first = true;
    private boolean greatgop = false;
    private Color[] GOP = new Color[]{Color.black, Color.cyan, Color.magenta, Color.white, Color.green, Color.red, Color.red, Color.red, Color.yellow};
    private byte[] frame = new byte[0];

    public BitrateMonitor() {
        this.bimg = new BufferedImage(this.w, this.h, 1);
        this.big = this.bimg.createGraphics();
        this.big.setFont(this.font);
        FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
        this.ascent = fontMetrics.getAscent();
        this.descent = fontMetrics.getDescent();
        this.reset();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.black);
        this.setVisible(true);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.w, this.h);
    }

    public void paint(Graphics graphics) {
        if (this.big == null) {
            return;
        }
        graphics.drawImage(this.bimg, 0, 0, this);
    }

    private void refresh() {
        if (this.big == null) {
            return;
        }
        this.big.setColor(Color.black);
        this.big.clearRect(0, 0, this.w, this.h);
        this.big.setColor(Color.white);
        this.usedStr = String.valueOf(this.bitrate * 400 / 1000) + "kbps ";
        this.big.drawString(this.usedStr, 60, this.h - this.descent - 9 - this.descent);
        this.big.drawString(this.timeStr, 60, this.h - this.descent);
        this.big.setColor(this.graphColor);
        int n = 2;
        int n2 = 1;
        int n3 = 50;
        int n4 = 30;
        this.graphOutlineRect.setRect(n, n2, n3, n4);
        this.big.draw(this.graphOutlineRect);
        int n5 = n4 / 5;
        int n6 = n2;
        while (n6 <= n4 + n2) {
            this.big.drawLine(n, n6, n + n3, n6);
            n6 += n5;
        }
        int n7 = n3 / 5;
        int n8 = n;
        while (n8 < n3 + n) {
            this.big.drawLine(n8, n2, n8, n2 + n4);
            n8 += n7;
        }
        this.big.setColor(Color.red);
        this.big.drawLine(2, 5, 52, 5);
        this.big.setColor(Color.magenta);
        this.big.drawLine(2, 28, 52, 28);
        this.big.setColor(Color.white);
        this.big.drawLine(52, n2 + n4 - this.maxbitrate / this.divisor, 56, n2 + n4 - this.maxbitrate / 695);
        this.big.drawLine(52, n2 + n4 - this.minbitrate / this.divisor, 56, n2 + n4 - this.minbitrate / 695);
        int n9 = this.frame.length > 17 ? 17 : this.frame.length;
        int n10 = 0;
        while (n10 < n9) {
            this.big.setColor(this.GOP[0xF & this.frame[n10]]);
            if ((0x80 & this.frame[n10]) != 0) {
                this.big.fillRect(60 + n10 * 3, 2, 2, 5);
            } else {
                this.big.fillRect(60 + n10 * 3, 2, 2, 2);
                this.big.fillRect(60 + n10 * 3, 5, 2, 2);
            }
            ++n10;
        }
        if (this.frame.length > 16) {
            this.greatgop = true;
        }
        if (this.greatgop) {
            this.big.setColor(Color.red);
            this.big.fillRect(52, 40, 2, 5);
        }
        if (this.pts == null) {
            this.pts = new int[n3];
            this.ptNum = 0;
        } else {
            this.big.setColor(Color.yellow);
            this.pts[this.ptNum] = n2 + n4 - this.bitrate / this.divisor;
            if (this.pts[this.ptNum] < 1) {
                this.pts[this.ptNum] = 0;
            }
            int n11 = n + n3 - this.ptNum;
            int n12 = 0;
            while (n12 < this.ptNum) {
                if (n12 != 0) {
                    if (this.pts[n12] != this.pts[n12 - 1]) {
                        this.big.drawLine(n11 - 1, this.pts[n12 - 1], n11, this.pts[n12]);
                    } else {
                        this.big.fillRect(n11, this.pts[n12], 1, 1);
                    }
                }
                ++n12;
                ++n11;
            }
            if (this.ptNum + 2 == this.pts.length) {
                int n13 = 1;
                while (n13 < this.ptNum) {
                    this.pts[n13 - 1] = this.pts[n13];
                    ++n13;
                }
                --this.ptNum;
            } else {
                ++this.ptNum;
            }
        }
    }

    public void reset() {
        this.greatgop = false;
        this.maxbitrate = 0;
        this.minbitrate = 37500;
        this.timeStr = "00:00:00";
        this.bitrate = 0;
        this.frame = new byte[0];
        this.refresh();
        this.repaint();
    }

    public void update(int n, byte[] byArray, String string) {
        this.bitrate = n;
        if (this.bitrate > this.maxbitrate) {
            this.maxbitrate = this.bitrate;
        }
        if (this.bitrate < this.minbitrate) {
            this.minbitrate = this.bitrate;
        }
        this.timeStr = string;
        this.frame = byArray;
        this.refresh();
        this.repaint();
    }
}

