/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.video;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.video.IDCTRefNative;
import net.sourceforge.dvb.projectx.video.IDCTSseNative;
import net.sourceforge.dvb.projectx.video.WSS;

public class MpvDecoder {
    private IDCTRefNative idct;
    private IDCTSseNative idctsse;
    private int[] pixels2 = new int[147456];
    private int[] pixels = new int[250];
    private int Fault_Flag = 0;
    private int BitPos = 0;
    private int BufferPos = 0;
    private int SequenceHeader = 0;
    private long StartPos = 0L;
    private boolean acceleration = false;
    private boolean FAST = false;
    private boolean PLAY = true;
    private boolean DIRECTION = false;
    private boolean ERROR1 = false;
    private boolean ERROR2 = false;
    private boolean viewGOP = true;
    private String info_4 = "";
    private String info_3 = "";
    private String info_2 = "";
    private String info_1 = "";
    private byte[] buf = new byte[0];
    final int PICTURE_START_CODE = 256;
    final int SLICE_START_CODE_MIN = 257;
    final int SLICE_START_CODE_MAX = 431;
    final int USER_DATA_START_CODE = 434;
    final int SEQUENCE_HEADER_CODE = 435;
    final int EXTENSION_START_CODE = 437;
    final int SEQUENCE_END_CODE = 439;
    final int GROUP_START_CODE = 440;
    final int SYSTEM_END_CODE = 441;
    final int PACK_START_CODE = 442;
    final int SYSTEM_START_CODE = 443;
    private int File_Flag;
    private int File_Limit;
    private int FO_Flag;
    private int IDCT_Flag;
    private int Luminance_Flag;
    private int Scale_Flag;
    private int SystemStream_Flag;
    private int ERROR_CODE = 0;
    private int ERROR_CODE1 = 0;
    final int SEQUENCE_EXTENSION_ID = 1;
    final int SEQUENCE_DISPLAY_EXTENSION_ID = 2;
    final int QUANT_MATRIX_EXTENSION_ID = 3;
    final int COPYRIGHT_EXTENSION_ID = 4;
    final int PICTURE_DISPLAY_EXTENSION_ID = 7;
    final int PICTURE_CODING_EXTENSION_ID = 8;
    final int ZIG_ZAG = 0;
    final int MB_WEIGHT = 32;
    final int MB_CLASS4 = 64;
    final int MC_FIELD = 1;
    final int MC_FRAME = 2;
    final int MC_16X8 = 2;
    final int MC_DMV = 3;
    final int MV_FIELD = 0;
    final int MV_FRAME = 1;
    final int I_TYPE = 1;
    final int P_TYPE = 2;
    final int B_TYPE = 3;
    final int TOP_FIELD = 1;
    final int BOTTOM_FIELD = 2;
    final int FRAME_PICTURE = 3;
    final int MACROBLOCK_INTRA = 1;
    final int MACROBLOCK_PATTERN = 2;
    final int MACROBLOCK_MOTION_BACKWARD = 4;
    final int MACROBLOCK_MOTION_FORWARD = 8;
    final int MACROBLOCK_QUANT = 16;
    final int CHROMA420 = 1;
    final int CHROMA422 = 2;
    final int CHROMA444 = 3;
    final int IDCT_CLIP_TABLE_OFFSET = 512;
    private int q_scale_type = 0;
    private int quantizer_scale = 0;
    private int alternate_scan = 0;
    private int Coded_Picture_Width = 0;
    private int Coded_Picture_Height = 0;
    private int Chroma_Width = 0;
    private int Chroma_Height = 0;
    private int block_count = 0;
    private int Second_Field = 0;
    private int horizontal_size = 0;
    private int vertical_size = 0;
    private int mb_width = 0;
    private int mb_height = 0;
    private int frame_rate_code = 0;
    private int aspect_ratio_information = 0;
    private int progressive_sequence = 1;
    private int chroma_format = 1;
    private int profile_and_level_indication;
    private int video_format;
    private String[] video_format_S = new String[]{"comp", "PAL", "NTSC", "SECAM", "MAC", "unspec", "res", "res"};
    private String[] prof = new String[]{"res", "HP", "SS", "SNR", "MP", "SP", "res", "res"};
    private String[] lev = new String[]{"res", "res", "res", "res", "HL", "res", "HL1440", "res", "ML", "res", "LL", "res", "res", "res", "res"};
    private int picture_coding_type = 0;
    private int temporal_reference = 0;
    private int[][] f_code = new int[2][2];
    private int picture_structure = 3;
    private int frame_pred_frame_dct = 1;
    private int progressive_frame = 1;
    private int concealment_motion_vectors = 0;
    private int intra_dc_precision = 0;
    private int top_field_first = 0;
    private int repeat_first_field = 0;
    private int intra_vlc_format = 0;
    private int[] intra_quantizer_matrix = new int[64];
    private int[] non_intra_quantizer_matrix = new int[64];
    private int[] chroma_intra_quantizer_matrix = new int[64];
    private int[] chroma_non_intra_quantizer_matrix = new int[64];
    private int load_intra_quantizer_matrix = 0;
    private int load_non_intra_quantizer_matrix = 0;
    private int load_chroma_intra_quantizer_matrix = 0;
    private int load_chroma_non_intra_quantizer_matrix = 0;
    private short[][] block = new short[12][64];
    final String[] picture_coding_type_string = new String[]{"bad", "I", "P", "B", "D"};
    final String[] progressive_string = new String[]{"i", "p"};
    final String[] aspect_ratio_string = new String[]{"bad", "(1:1)", "(4:3)", "(16:9)", "(2.21:1)", "(0.8055)", "(0.8437)", "(0.9375)", "(0.9815)", "(1.0255)", "(1.0695)", "(1.1250)", "(1.1575)", "(1.2015)"};
    final float[][] ref_dct_matrix = new float[][]{{0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f}, {0.49039263f, 0.4157348f, 0.27778512f, 0.09754516f, -0.09754516f, -0.27778512f, -0.4157348f, -0.49039263f}, {0.46193975f, 0.19134171f, -0.19134171f, -0.46193975f, -0.46193975f, -0.19134171f, 0.19134171f, 0.46193975f}, {0.4157348f, -0.09754516f, -0.49039263f, -0.27778512f, 0.27778512f, 0.49039263f, 0.09754516f, -0.4157348f}, {0.35355338f, -0.35355338f, -0.35355338f, 0.35355338f, 0.35355338f, -0.35355338f, -0.35355338f, 0.35355338f}, {0.27778512f, -0.49039263f, 0.09754516f, 0.4157348f, -0.4157348f, -0.09754516f, 0.49039263f, -0.27778512f}, {0.19134171f, -0.46193975f, 0.46193975f, -0.19134171f, -0.19134171f, 0.46193975f, -0.46193975f, 0.19134171f}, {0.09754516f, -0.27778512f, 0.4157348f, -0.49039263f, 0.49039263f, -0.4157348f, 0.27778512f, -0.09754516f}};
    final short[] idct_clip_table = new short[]{-256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -255, -254, -253, -252, -251, -250, -249, -248, -247, -246, -245, -244, -243, -242, -241, -240, -239, -238, -237, -236, -235, -234, -233, -232, -231, -230, -229, -228, -227, -226, -225, -224, -223, -222, -221, -220, -219, -218, -217, -216, -215, -214, -213, -212, -211, -210, -209, -208, -207, -206, -205, -204, -203, -202, -201, -200, -199, -198, -197, -196, -195, -194, -193, -192, -191, -190, -189, -188, -187, -186, -185, -184, -183, -182, -181, -180, -179, -178, -177, -176, -175, -174, -173, -172, -171, -170, -169, -168, -167, -166, -165, -164, -163, -162, -161, -160, -159, -158, -157, -156, -155, -154, -153, -152, -151, -150, -149, -148, -147, -146, -145, -144, -143, -142, -141, -140, -139, -138, -137, -136, -135, -134, -133, -132, -131, -130, -129, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    final byte[] cc_table = new byte[]{0, 0, 0, 0, 1, 2, 1, 2, 1, 2, 1, 2};
    final int[] ChromaFormat = new int[]{0, 6, 8, 12};
    final byte[] Non_Linear_quantizer_scale = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 18, 20, 22, 24, 28, 32, 36, 40, 44, 48, 52, 56, 64, 72, 80, 88, 96, 104, 112};
    final byte[][] MBAtab1 = new byte[][]{{-1, 0}, {-1, 0}, {7, 5}, {6, 5}, {5, 4}, {5, 4}, {4, 4}, {4, 4}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {2, 3}, {2, 3}, {2, 3}, {2, 3}};
    final byte[][] MBAtab2 = new byte[][]{{33, 11}, {32, 11}, {31, 11}, {30, 11}, {29, 11}, {28, 11}, {27, 11}, {26, 11}, {25, 11}, {24, 11}, {23, 11}, {22, 11}, {21, 10}, {21, 10}, {20, 10}, {20, 10}, {19, 10}, {19, 10}, {18, 10}, {18, 10}, {17, 10}, {17, 10}, {16, 10}, {16, 10}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}};
    final int[] default_intra_quantizer_matrix = new int[]{8, 16, 19, 22, 26, 27, 29, 34, 16, 16, 22, 24, 27, 29, 34, 37, 19, 22, 26, 27, 29, 34, 34, 38, 22, 22, 26, 27, 29, 34, 37, 40, 22, 26, 27, 29, 32, 35, 40, 48, 26, 27, 29, 32, 35, 40, 48, 58, 26, 27, 29, 34, 38, 46, 56, 69, 27, 29, 35, 38, 46, 56, 69, 83};
    final byte[][] scan = new byte[][]{{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63}, {0, 8, 16, 24, 1, 9, 2, 10, 17, 25, 32, 40, 48, 56, 57, 49, 41, 33, 26, 18, 3, 11, 4, 12, 19, 27, 34, 42, 50, 58, 35, 43, 51, 59, 20, 28, 5, 13, 6, 14, 21, 29, 36, 44, 52, 60, 37, 45, 53, 61, 22, 30, 7, 15, 23, 31, 38, 46, 54, 62, 39, 47, 55, 63}};
    final byte[][] DCTtab0 = new byte[][]{{65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {2, 2, 7}, {2, 2, 7}, {9, 1, 7}, {9, 1, 7}, {0, 4, 7}, {0, 4, 7}, {8, 1, 7}, {8, 1, 7}, {7, 1, 6}, {7, 1, 6}, {7, 1, 6}, {7, 1, 6}, {6, 1, 6}, {6, 1, 6}, {6, 1, 6}, {6, 1, 6}, {1, 2, 6}, {1, 2, 6}, {1, 2, 6}, {1, 2, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {13, 1, 8}, {0, 6, 8}, {12, 1, 8}, {11, 1, 8}, {3, 2, 8}, {1, 3, 8}, {0, 5, 8}, {10, 1, 8}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}};
    final byte[][] DCTtab0a = new byte[][]{{65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {7, 1, 7}, {7, 1, 7}, {8, 1, 7}, {8, 1, 7}, {6, 1, 7}, {6, 1, 7}, {2, 2, 7}, {2, 2, 7}, {0, 7, 6}, {0, 7, 6}, {0, 7, 6}, {0, 7, 6}, {0, 6, 6}, {0, 6, 6}, {0, 6, 6}, {0, 6, 6}, {4, 1, 6}, {4, 1, 6}, {4, 1, 6}, {4, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {1, 5, 8}, {11, 1, 8}, {0, 11, 8}, {0, 10, 8}, {13, 1, 8}, {12, 1, 8}, {3, 2, 8}, {1, 4, 8}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {9, 1, 7}, {9, 1, 7}, {1, 3, 7}, {1, 3, 7}, {10, 1, 7}, {10, 1, 7}, {0, 8, 7}, {0, 8, 7}, {0, 9, 7}, {0, 9, 7}, {0, 12, 8}, {0, 13, 8}, {2, 3, 8}, {4, 2, 8}, {0, 14, 8}, {0, 15, 8}};
    final byte[][] DCTtab1 = new byte[][]{{16, 1, 10}, {5, 2, 10}, {0, 7, 10}, {2, 3, 10}, {1, 4, 10}, {15, 1, 10}, {14, 1, 10}, {4, 2, 10}};
    final byte[][] DCTtab1a = new byte[][]{{5, 2, 9}, {5, 2, 9}, {14, 1, 9}, {14, 1, 9}, {2, 4, 10}, {16, 1, 10}, {15, 1, 9}, {15, 1, 9}};
    final byte[][] DCTtab2 = new byte[][]{{0, 11, 12}, {8, 2, 12}, {4, 3, 12}, {0, 10, 12}, {2, 4, 12}, {7, 2, 12}, {21, 1, 12}, {20, 1, 12}, {0, 9, 12}, {19, 1, 12}, {18, 1, 12}, {1, 5, 12}, {3, 3, 12}, {0, 8, 12}, {6, 2, 12}, {17, 1, 12}};
    final byte[][] DCTtab3 = new byte[][]{{10, 2, 13}, {9, 2, 13}, {5, 3, 13}, {3, 4, 13}, {2, 5, 13}, {1, 7, 13}, {1, 6, 13}, {0, 15, 13}, {0, 14, 13}, {0, 13, 13}, {0, 12, 13}, {26, 1, 13}, {25, 1, 13}, {24, 1, 13}, {23, 1, 13}, {22, 1, 13}};
    final byte[][] DCTtab4 = new byte[][]{{0, 31, 14}, {0, 30, 14}, {0, 29, 14}, {0, 28, 14}, {0, 27, 14}, {0, 26, 14}, {0, 25, 14}, {0, 24, 14}, {0, 23, 14}, {0, 22, 14}, {0, 21, 14}, {0, 20, 14}, {0, 19, 14}, {0, 18, 14}, {0, 17, 14}, {0, 16, 14}};
    final byte[][] DCTtab5 = new byte[][]{{0, 40, 15}, {0, 39, 15}, {0, 38, 15}, {0, 37, 15}, {0, 36, 15}, {0, 35, 15}, {0, 34, 15}, {0, 33, 15}, {0, 32, 15}, {1, 14, 15}, {1, 13, 15}, {1, 12, 15}, {1, 11, 15}, {1, 10, 15}, {1, 9, 15}, {1, 8, 15}};
    final byte[][] DCTtab6 = new byte[][]{{1, 18, 16}, {1, 17, 16}, {1, 16, 16}, {1, 15, 16}, {6, 3, 16}, {16, 2, 16}, {15, 2, 16}, {14, 2, 16}, {13, 2, 16}, {12, 2, 16}, {11, 2, 16}, {31, 1, 16}, {30, 1, 16}, {29, 1, 16}, {28, 1, 16}, {27, 1, 16}};
    final byte[][] DCTtabfirst = new byte[][]{{0, 2, 4}, {2, 1, 4}, {1, 1, 3}, {1, 1, 3}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}};
    final byte[][] DCTtabnext = new byte[][]{{0, 2, 4}, {2, 1, 4}, {1, 1, 3}, {1, 1, 3}, {64, 0, 2}, {64, 0, 2}, {64, 0, 2}, {64, 0, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}};
    final byte[][] CBPtab0 = new byte[][]{{-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {62, 5}, {2, 5}, {61, 5}, {1, 5}, {56, 5}, {52, 5}, {44, 5}, {28, 5}, {40, 5}, {20, 5}, {48, 5}, {12, 5}, {32, 4}, {32, 4}, {16, 4}, {16, 4}, {8, 4}, {8, 4}, {4, 4}, {4, 4}, {60, 3}, {60, 3}, {60, 3}, {60, 3}};
    final byte[][] CBPtab1 = new byte[][]{{-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {58, 8}, {54, 8}, {46, 8}, {30, 8}, {57, 8}, {53, 8}, {45, 8}, {29, 8}, {38, 8}, {26, 8}, {37, 8}, {25, 8}, {43, 8}, {23, 8}, {51, 8}, {15, 8}, {42, 8}, {22, 8}, {50, 8}, {14, 8}, {41, 8}, {21, 8}, {49, 8}, {13, 8}, {35, 8}, {19, 8}, {11, 8}, {7, 8}, {34, 7}, {34, 7}, {18, 7}, {18, 7}, {10, 7}, {10, 7}, {6, 7}, {6, 7}, {33, 7}, {33, 7}, {17, 7}, {17, 7}, {9, 7}, {9, 7}, {5, 7}, {5, 7}, {63, 6}, {63, 6}, {63, 6}, {63, 6}, {3, 6}, {3, 6}, {3, 6}, {3, 6}, {36, 6}, {36, 6}, {36, 6}, {36, 6}, {24, 6}, {24, 6}, {24, 6}, {24, 6}};
    final byte[][] CBPtab2 = new byte[][]{{-1, 0}, {0, 9}, {39, 9}, {27, 9}, {59, 9}, {55, 9}, {47, 9}, {31, 9}};
    final byte[][] DClumtab0 = new byte[][]{{1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {5, 4}, {5, 4}, {6, 5}, {-1, 0}};
    final byte[][] DClumtab1 = new byte[][]{{7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {9, 8}, {9, 8}, {10, 9}, {11, 9}};
    final byte[][] DCchromtab0 = new byte[][]{{0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {4, 4}, {4, 4}, {5, 5}, {-1, 0}};
    final byte[][] DCchromtab1 = new byte[][]{{6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {8, 8}, {8, 8}, {8, 8}, {8, 8}, {9, 9}, {9, 9}, {10, 10}, {11, 10}};
    final byte[][] MVtab0 = new byte[][]{{-1, 0}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}};
    final byte[][] MVtab1 = new byte[][]{{-1, 0}, {-1, 0}, {-1, 0}, {7, 6}, {6, 6}, {5, 6}, {4, 5}, {4, 5}};
    final byte[][] MVtab2 = new byte[][]{{16, 9}, {15, 9}, {14, 9}, {13, 9}, {12, 9}, {11, 9}, {10, 8}, {10, 8}, {9, 8}, {9, 8}, {8, 8}, {8, 8}};
    final byte[][] PMBtab0 = new byte[][]{{-1, 0}, {8, 3}, {2, 2}, {2, 2}, {10, 1}, {10, 1}, {10, 1}, {10, 1}};
    final byte[][] PMBtab1 = new byte[][]{{-1, 0}, {17, 6}, {18, 5}, {18, 5}, {26, 5}, {26, 5}, {1, 5}, {1, 5}};
    final byte[][] BMBtab0 = new byte[][]{{-1, 0}, {-1, 0}, {8, 4}, {10, 4}, {4, 3}, {4, 3}, {6, 3}, {6, 3}, {12, 2}, {12, 2}, {12, 2}, {12, 2}, {14, 2}, {14, 2}, {14, 2}, {14, 2}};
    final byte[][] BMBtab1 = new byte[][]{{-1, 0}, {17, 6}, {22, 6}, {26, 6}, {30, 5}, {30, 5}, {1, 5}, {1, 5}};
    final double[] frame_rate_Table = new double[]{0.0, 23.976023976023978, 24.0, 25.0, 29.97002997002997, 30.0, 50.0, 59.94005994005994, 60.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private byte[] backward_reference_frame = new byte[3];
    private byte[] forward_reference_frame = new byte[3];
    private byte[] auxframe = new byte[3];
    private byte[] current_frame = new byte[3];
    private byte u422;
    private byte v422;
    private byte u444;
    private byte v444;
    private byte rgb24;
    private byte lum;
    private int pf_backward;
    private int pf_forward;
    private int pf_current;
    private float frame_rate;
    private float Frame_Rate;
    private int gop_hour;
    private int gop_minute;
    private int gop_sec;
    private int gop_frame;
    private int drop_flag;
    private int closed_gop;
    private int broken_link;

    /*
     * Opcode count of 18748 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public MpvDecoder() {
        Arrays.fill(this.pixels2, -11513776);
        this.idct = new IDCTRefNative();
        this.idctsse = new IDCTSseNative();
        if (IDCTRefNative.isLibraryLoaded()) {
            this.idct.init();
        }
        if (IDCTRefNative.isLibraryLoaded() || IDCTSseNative.isLibraryLoaded()) {
            this.acceleration = true;
        }
    }

    public boolean isAccelerated() {
        return this.acceleration;
    }

    public void Clear_Block(int n) {
        Arrays.fill(this.block[n], (short)0);
    }

    public void loadbits(int n) {
        this.BitPos = this.BufferPos << 3;
        this.BufferPos += n;
    }

    public int Get_Bits(int n) {
        int n2 = this.BitPos >>> 3;
        int n3 = (0xFF & this.buf[n2]) << 24 | (0xFF & this.buf[n2 + 1]) << 16 | (0xFF & this.buf[n2 + 2]) << 8 | 0xFF & this.buf[n2 + 3];
        n3 <<= this.BitPos & 7;
        this.BitPos += n;
        this.BufferPos = this.BitPos >>> 3;
        return n3 >>>= 32 - n;
    }

    public int Show_Bits(int n) {
        int n2 = this.BitPos >>> 3;
        int n3 = (0xFF & this.buf[n2]) << 24 | (0xFF & this.buf[n2 + 1]) << 16 | (0xFF & this.buf[n2 + 2]) << 8 | 0xFF & this.buf[n2 + 3];
        n3 <<= this.BitPos & 7;
        return n3 >>>= 32 - n;
    }

    public void Flush_Bits(int n) {
        this.BitPos += n;
        this.BufferPos = this.BitPos >>> 3;
    }

    public int extern_Get_Hdr() {
        while (true) {
            if (this.DIRECTION) {
                this.previous_start_code();
            } else {
                this.next_start_code();
            }
            int n = this.Get_Bits(32);
            if (n == 435) {
                this.resetDecoder();
                this.StartPos = this.BufferPos - 4;
                this.sequence_header();
                this.next_start_code();
                n = this.Get_Bits(32);
                if (n != 440) continue;
                this.group_of_pictures_header();
                this.next_start_code();
                n = this.Get_Bits(32);
                if (n != 256) continue;
                this.picture_header();
                return 1;
            }
            if (this.viewGOP && n == 440) {
                this.StartPos = this.BufferPos - 4;
                this.group_of_pictures_header();
                this.next_start_code();
                n = this.Get_Bits(32);
                if (n != 256) continue;
                this.picture_header();
                return 1;
            }
            if (!this.DIRECTION) continue;
            this.Flush_Bits(-40);
        }
    }

    public int Get_Hdr() {
        this.video_format = 5;
        while (true) {
            this.next_start_code();
            switch (this.Get_Bits(32)) {
                case 435: {
                    this.resetDecoder();
                    this.StartPos = this.BufferPos - 4;
                    this.sequence_header();
                    break;
                }
                case 440: {
                    this.group_of_pictures_header();
                    break;
                }
                case 256: {
                    this.picture_header();
                    return 1;
                }
                case 439: {
                    return 2;
                }
            }
        }
    }

    public void next_start_code() {
        this.Flush_Bits(8 - (this.BitPos & 7) & 7);
        while (this.Show_Bits(24) != 1) {
            this.Flush_Bits(8);
        }
    }

    public void previous_start_code() {
        this.Flush_Bits(8 - (this.BitPos & 7) & 7);
        while (this.Show_Bits(24) != 1) {
            this.Flush_Bits(-8);
        }
    }

    private void sequence_header() {
        int n;
        this.horizontal_size = this.Get_Bits(12);
        this.vertical_size = this.Get_Bits(12);
        this.aspect_ratio_information = this.Get_Bits(4);
        this.frame_rate_code = this.Get_Bits(4);
        int n2 = this.Get_Bits(18);
        this.Flush_Bits(1);
        int n3 = this.Get_Bits(10);
        int n4 = this.Get_Bits(1);
        this.info_4 = " ";
        this.load_intra_quantizer_matrix = this.Get_Bits(1);
        if (this.load_intra_quantizer_matrix > 0) {
            n = 0;
            while (n < 64) {
                this.intra_quantizer_matrix[this.scan[0][n]] = this.Get_Bits(8);
                ++n;
            }
            this.info_4 = this.info_4 + ",iqm";
        } else {
            System.arraycopy(this.default_intra_quantizer_matrix, 0, this.intra_quantizer_matrix, 0, 64);
        }
        this.load_non_intra_quantizer_matrix = this.Get_Bits(1);
        if (this.load_non_intra_quantizer_matrix > 0) {
            n = 0;
            while (n < 64) {
                this.non_intra_quantizer_matrix[this.scan[0][n]] = this.Get_Bits(8);
                ++n;
            }
            this.info_4 = this.info_4 + ",niqm";
        } else {
            Arrays.fill(this.non_intra_quantizer_matrix, 16);
        }
        System.arraycopy(this.intra_quantizer_matrix, 0, this.chroma_intra_quantizer_matrix, 0, 64);
        System.arraycopy(this.non_intra_quantizer_matrix, 0, this.chroma_non_intra_quantizer_matrix, 0, 64);
        this.frame_rate = (float)this.frame_rate_Table[this.frame_rate_code];
        this.extension_and_user_data();
        this.info_3 = ", " + n2 * 400 + "bps, vbv " + n3 + (n4 > 0 ? ", cpf" : "");
    }

    private void group_of_pictures_header() {
        this.drop_flag = this.Get_Bits(1);
        this.gop_hour = this.Get_Bits(5);
        this.gop_minute = this.Get_Bits(6);
        this.Flush_Bits(1);
        this.gop_sec = this.Get_Bits(6);
        this.gop_frame = this.Get_Bits(6);
        this.closed_gop = this.Get_Bits(1);
        this.broken_link = this.Get_Bits(1);
        this.extension_and_user_data();
    }

    private void extension_and_user_data() {
        int n;
        this.next_start_code();
        while ((n = this.Show_Bits(32)) == 437 || n == 434) {
            if (n == 437) {
                this.Flush_Bits(32);
                int n2 = this.Get_Bits(4);
                switch (n2) {
                    case 1: {
                        this.sequence_extension();
                        break;
                    }
                    case 2: {
                        this.sequence_display_extension();
                        break;
                    }
                    case 3: {
                        this.quant_matrix_extension();
                        break;
                    }
                    case 7: {
                        this.picture_display_extension();
                        break;
                    }
                    case 8: {
                        this.picture_coding_extension();
                        break;
                    }
                    case 4: {
                        this.copyright_extension();
                    }
                }
                this.next_start_code();
                continue;
            }
            this.info_4 = this.info_4 + ", user_data";
            this.Flush_Bits(32);
            this.next_start_code();
        }
    }

    private void picture_header() {
        this.temporal_reference = this.Get_Bits(10);
        this.picture_coding_type = this.Get_Bits(3);
        int n = this.Get_Bits(16);
        if (this.picture_coding_type == 2 || this.picture_coding_type == 3) {
            int n2 = this.Get_Bits(1);
            int n3 = this.Get_Bits(3);
        }
        if (this.picture_coding_type == 3) {
            int n4 = this.Get_Bits(1);
            int n5 = this.Get_Bits(3);
        }
        int n6 = this.extra_bit_information();
        this.extension_and_user_data();
    }

    private void sequence_extension() {
        this.profile_and_level_indication = this.Get_Bits(8);
        this.progressive_sequence = this.Get_Bits(1);
        this.chroma_format = this.Get_Bits(2);
        int n = this.Get_Bits(2);
        int n2 = this.Get_Bits(2);
        int n3 = this.Get_Bits(12);
        this.Flush_Bits(1);
        int n4 = this.Get_Bits(8);
        int n5 = this.Get_Bits(1);
        int n6 = this.Get_Bits(2);
        int n7 = this.Get_Bits(5);
        this.frame_rate = this.frame_rate * (float)(n6 + 1) / (float)(n7 + 1);
        this.horizontal_size = n << 12 | this.horizontal_size & 0xFFF;
        this.vertical_size = n2 << 12 | this.vertical_size & 0xFFF;
        this.info_4 = this.info_4 + ", ld=" + n5;
    }

    private void sequence_display_extension() {
        this.video_format = this.Get_Bits(3);
        int n = this.Get_Bits(1);
        if (n > 0) {
            int n2 = this.Get_Bits(8);
            int n3 = this.Get_Bits(8);
            int n4 = this.Get_Bits(8);
        }
        int n5 = this.Get_Bits(14);
        this.Flush_Bits(1);
        int n6 = this.Get_Bits(14);
        this.info_4 = this.info_4 + ", SDE: " + n5 + "*" + n6;
    }

    private void quant_matrix_extension() {
        int n;
        this.load_intra_quantizer_matrix = this.Get_Bits(1);
        if (this.load_intra_quantizer_matrix > 0) {
            n = 0;
            while (n < 64) {
                int n2 = this.Get_Bits(8);
                this.intra_quantizer_matrix[this.scan[0][n]] = n2;
                this.chroma_intra_quantizer_matrix[this.scan[0][n]] = n2;
                ++n;
            }
        }
        if ((this.load_non_intra_quantizer_matrix = this.Get_Bits(1)) > 0) {
            n = 0;
            while (n < 64) {
                int n3 = this.Get_Bits(8);
                this.non_intra_quantizer_matrix[this.scan[0][n]] = n3;
                this.chroma_non_intra_quantizer_matrix[this.scan[0][n]] = n3;
                ++n;
            }
        }
        if ((this.load_chroma_intra_quantizer_matrix = this.Get_Bits(1)) > 0) {
            n = 0;
            while (n < 64) {
                this.chroma_intra_quantizer_matrix[this.scan[0][n]] = this.Get_Bits(8);
                ++n;
            }
        }
        if ((this.load_chroma_non_intra_quantizer_matrix = this.Get_Bits(1)) > 0) {
            n = 0;
            while (n < 64) {
                this.chroma_non_intra_quantizer_matrix[this.scan[0][n]] = this.Get_Bits(8);
                ++n;
            }
        }
    }

    private void picture_display_extension() {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n = this.progressive_sequence > 0 ? (this.repeat_first_field > 0 ? (this.top_field_first > 0 ? 3 : 2) : 1) : (this.picture_structure != 3 ? 1 : (this.repeat_first_field > 0 ? 3 : 2));
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.Get_Bits(16);
            this.Flush_Bits(1);
            nArray2[n2] = this.Get_Bits(16);
            this.Flush_Bits(1);
            this.info_3 = this.info_3 + ", (" + nArray[n2] + "," + nArray2[n2] + ")";
            ++n2;
        }
    }

    private void picture_coding_extension() {
        this.f_code[0][0] = this.Get_Bits(4);
        this.f_code[0][1] = this.Get_Bits(4);
        this.f_code[1][0] = this.Get_Bits(4);
        this.f_code[1][1] = this.Get_Bits(4);
        this.intra_dc_precision = this.Get_Bits(2);
        this.picture_structure = this.Get_Bits(2);
        this.top_field_first = this.Get_Bits(1);
        this.frame_pred_frame_dct = this.Get_Bits(1);
        this.concealment_motion_vectors = this.Get_Bits(1);
        this.q_scale_type = this.Get_Bits(1);
        this.intra_vlc_format = this.Get_Bits(1);
        this.alternate_scan = this.Get_Bits(1);
        this.repeat_first_field = this.Get_Bits(1);
        int n = this.Get_Bits(1);
        this.progressive_frame = this.Get_Bits(1);
        int n2 = this.Get_Bits(1);
        if (n2 > 0) {
            int n3 = this.Get_Bits(1);
            int n4 = this.Get_Bits(3);
            int n5 = this.Get_Bits(1);
            int n6 = this.Get_Bits(7);
            int n7 = this.Get_Bits(8);
            this.info_3 = this.info_3 + ", cdf";
        }
    }

    public void copyright_extension() {
        int n = this.Get_Bits(1);
        int n2 = this.Get_Bits(8);
        int n3 = this.Get_Bits(1);
        int n4 = this.Get_Bits(7);
        this.Flush_Bits(1);
        int n5 = this.Get_Bits(20);
        this.Flush_Bits(1);
        int n6 = this.Get_Bits(22);
        this.Flush_Bits(1);
        int n7 = this.Get_Bits(22);
    }

    public void resetDecoder() {
        this.Fault_Flag = 0;
        this.picture_coding_type = 0;
        this.SequenceHeader = 1;
        this.video_format = 5;
        this.progressive_sequence = 1;
        this.chroma_format = 1;
        this.profile_and_level_indication = 0;
        this.Second_Field = 0;
        this.intra_dc_precision = 0;
        this.picture_structure = 3;
        this.top_field_first = 0;
        this.frame_pred_frame_dct = 1;
        this.concealment_motion_vectors = 0;
        this.intra_vlc_format = 0;
        this.repeat_first_field = 0;
        this.progressive_frame = 1;
        this.q_scale_type = 0;
        this.quantizer_scale = 0;
        this.alternate_scan = 0;
    }

    public void InitialDecoder() {
        this.mb_width = (this.horizontal_size + 15) / 16;
        this.mb_height = this.progressive_sequence > 0 ? (this.vertical_size + 15) / 16 : 2 * ((this.vertical_size + 31) / 32);
        this.Coded_Picture_Width = 16 * this.mb_width;
        this.Coded_Picture_Height = 16 * this.mb_height;
        this.Chroma_Width = this.chroma_format == 3 ? this.Coded_Picture_Width : this.Coded_Picture_Width >> 1;
        this.Chroma_Height = this.chroma_format != 1 ? this.Coded_Picture_Height : this.Coded_Picture_Height >> 1;
        this.block_count = this.ChromaFormat[this.chroma_format];
        if (this.picture_coding_type == 1) {
            this.pixels = new int[this.Coded_Picture_Width * this.Coded_Picture_Height];
        }
    }

    public void Decode_Picture() {
        if (this.picture_structure == 3 && this.Second_Field > 0) {
            this.Second_Field = 0;
        }
        if (this.picture_coding_type != 3) {
            this.pf_forward = this.pf_backward;
            this.pf_backward = this.pf_current;
        }
        String[] stringArray = new String[]{"G", "S"};
        String[] stringArray2 = new String[]{"res.", "4:2:0", "4:2:2", "4:4:4"};
        String[] stringArray3 = new String[]{"bff", "tff"};
        String[] stringArray4 = new String[]{"-", "T", "B", "F"};
        this.info_2 = "" + this.gop_hour + ":" + this.gop_minute + ":" + this.gop_sec + ":" + this.gop_frame + " ";
        this.info_2 = this.info_2 + ", " + this.drop_flag + "/" + this.closed_gop + "/" + this.broken_link + " ";
        this.info_2 = this.info_2 + ", " + (float)Math.round(this.frame_rate * 1000.0f) / 1000.0f + "fps ";
        this.info_2 = this.info_2 + ", " + stringArray[this.SequenceHeader] + " ";
        this.info_2 = this.info_2 + ", " + stringArray4[this.picture_structure];
        this.info_2 = this.info_2 + ", " + (this.progressive_sequence == 0 ? stringArray3[this.top_field_first] : "-") + " ";
        this.info_2 = this.info_2 + ", " + stringArray2[this.chroma_format];
        this.info_2 = this.info_2 + this.info_3;
        this.SequenceHeader = 0;
        this.Update_Picture_Buffers();
        this.picture_data();
        this.scale_Picture();
        if (this.picture_structure != 3) {
            this.Second_Field ^= this.Second_Field;
        }
    }

    public void Update_Picture_Buffers() {
        int n = 0;
        while (n < 3) {
            if (this.picture_coding_type == 3) {
                this.current_frame[n] = this.auxframe[n];
            } else {
                if (this.Second_Field < 1) {
                    byte by = this.forward_reference_frame[n];
                    this.forward_reference_frame[n] = this.backward_reference_frame[n];
                    this.backward_reference_frame[n] = by;
                }
                this.current_frame[n] = this.backward_reference_frame[n];
            }
            if (this.picture_structure == 2) {
                int n2 = n;
                this.current_frame[n2] = (byte)(this.current_frame[n2] + (n == 0 ? this.Coded_Picture_Width : this.Chroma_Width));
            }
            ++n;
        }
    }

    public void picture_data() {
        boolean bl = false;
        int n = this.mb_width * this.mb_height;
        if (this.picture_structure != 3) {
            n >>= 1;
        }
        while (this.slice(n) >= 0) {
        }
    }

    public int slice_header() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.vertical_size > 2800 ? this.Get_Bits(3) : 0;
        int n5 = this.Get_Bits(5);
        int n6 = this.quantizer_scale = this.q_scale_type > 0 ? this.Non_Linear_quantizer_scale[n5] : n5 << 1;
        if (this.Get_Bits(1) > 0) {
            this.Get_Bits(1);
            n = this.Get_Bits(1);
            n2 = this.Get_Bits(6);
            n3 = this.extra_bit_information();
        }
        return n4;
    }

    public int extra_bit_information() {
        int n = 0;
        while (this.Get_Bits(1) > 0) {
            this.Flush_Bits(8);
            ++n;
        }
        return n;
    }

    public int slice(int n) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int n2 = 0;
        int[] nArray6 = new int[3];
        int[][][] nArray7 = new int[2][2][2];
        int[][] nArray8 = new int[2][2];
        int[] nArray9 = new int[2];
        n2 = this.start_of_slice(nArray, nArray2, nArray6, nArray7);
        if (n2 != 1) {
            return n2;
        }
        do {
            if (nArray[0] >= n) {
                return -1;
            }
            if (nArray2[0] == 0) {
                if (this.Show_Bits(23) < 1 || this.Fault_Flag > 0) {
                    this.Fault_Flag = 0;
                    return 0;
                }
                nArray2[0] = this.Get_macroblock_address_increment();
                if (this.Fault_Flag > 0) {
                    this.Fault_Flag = 0;
                    return 0;
                }
            }
            if (nArray2[0] == 1) {
                if (this.decode_macroblock(nArray3, nArray4, nArray5, nArray7, nArray6, nArray8, nArray9) < 1) {
                    this.Fault_Flag = 0;
                    return 0;
                }
            } else {
                this.skipped_macroblock(nArray6, nArray7, nArray4, nArray8, nArray3);
            }
            this.motion_compensation(nArray, nArray3, nArray4, nArray7, nArray8, nArray9, nArray5);
            nArray[0] = nArray[0] + 1;
            nArray2[0] = nArray2[0] - 1;
        } while (nArray[0] < n);
        return -1;
    }

    public void skipped_macroblock(int[] nArray, int[][][] nArray2, int[] nArray3, int[][] nArray4, int[] nArray5) {
        int n = 0;
        while (n < this.block_count) {
            this.Clear_Block(n);
            ++n;
        }
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        if (this.picture_coding_type == 2) {
            nArray2[1][0][1] = 0;
            nArray2[1][0][0] = 0;
            nArray2[0][0][1] = 0;
            nArray2[0][0][0] = 0;
        }
        if (this.picture_structure == 3) {
            nArray3[0] = 2;
        } else {
            nArray3[0] = 1;
            int n2 = this.picture_structure == 2 ? 1 : 0;
            nArray4[0][1] = n2;
            nArray4[0][0] = n2;
        }
        nArray5[0] = nArray5[0] & 0xFFFFFFFE;
    }

    public int decode_macroblock(int[] nArray, int[] nArray2, int[] nArray3, int[][][] nArray4, int[] nArray5, int[][] nArray6, int[] nArray7) {
        int n;
        int[] nArray8 = new int[]{0};
        int[] nArray9 = new int[]{0};
        int[] nArray10 = new int[]{0};
        int[] nArray11 = new int[]{0};
        this.macroblock_modes(nArray, nArray2, nArray8, nArray9, nArray10, nArray11, nArray3);
        if (this.Fault_Flag > 0) {
            return 0;
        }
        if ((nArray[0] & 0x10) > 0) {
            int n2 = this.Get_Bits(5);
            int n3 = this.quantizer_scale = this.q_scale_type > 0 ? this.Non_Linear_quantizer_scale[n2] : n2 << 1;
        }
        if ((nArray[0] & 8) > 0 || (nArray[0] & 1) > 0 && this.concealment_motion_vectors > 0) {
            this.motion_vectors(nArray4, nArray7, nArray6, 0, nArray8, nArray9, this.f_code[0][0] - 1, this.f_code[0][1] - 1, nArray10, nArray11);
        }
        if (this.Fault_Flag > 0) {
            return 0;
        }
        if ((nArray[0] & 4) > 0) {
            this.motion_vectors(nArray4, nArray7, nArray6, 1, nArray8, nArray9, this.f_code[1][0] - 1, this.f_code[1][1] - 1, new int[1], nArray11);
        }
        if (this.Fault_Flag > 0) {
            return 0;
        }
        if ((nArray[0] & 1) > 0 && this.concealment_motion_vectors > 0) {
            this.Flush_Bits(1);
        }
        if ((nArray[0] & 2) > 0) {
            n = this.Get_coded_block_pattern();
            if (this.chroma_format == 2) {
                n = n << 2 | this.Get_Bits(2);
            } else if (this.chroma_format == 3) {
                n = n << 6 | this.Get_Bits(6);
            }
        } else {
            int n4 = n = (nArray[0] & 1) > 0 ? (1 << this.block_count) - 1 : 0;
        }
        if (this.Fault_Flag > 0) {
            return 0;
        }
        int n5 = 0;
        while (n5 < this.block_count) {
            this.Clear_Block(n5);
            if ((n & 1 << this.block_count - 1 - n5) > 0) {
                if ((nArray[0] & 1) > 0) {
                    this.Decode_MPEG2_Intra_Block(n5, nArray5);
                } else {
                    this.Decode_MPEG2_Non_Intra_Block(n5);
                }
                if (this.Fault_Flag > 0) {
                    return 0;
                }
            }
            ++n5;
        }
        if ((nArray[0] & 1) < 1) {
            nArray5[2] = 0;
            nArray5[1] = 0;
            nArray5[0] = 0;
        }
        if ((nArray[0] & 1) > 0 && this.concealment_motion_vectors < 1) {
            nArray4[1][0][1] = 0;
            nArray4[1][0][0] = 0;
            nArray4[0][0][1] = 0;
            nArray4[0][0][0] = 0;
            nArray4[1][1][1] = 0;
            nArray4[1][1][0] = 0;
            nArray4[0][1][1] = 0;
            nArray4[0][1][0] = 0;
        }
        if (this.picture_coding_type == 2 && (nArray[0] & 9) < 1) {
            nArray4[1][0][1] = 0;
            nArray4[1][0][0] = 0;
            nArray4[0][0][1] = 0;
            nArray4[0][0][0] = 0;
            if (this.picture_structure == 3) {
                nArray2[0] = 2;
            } else {
                nArray2[0] = 1;
                nArray6[0][0] = this.picture_structure == 2 ? 1 : 0;
            }
        }
        return 1;
    }

    public void Decode_MPEG2_Intra_Block(int n, int[] nArray) {
        int n2 = 0;
        short[] sArray = this.block[n];
        int[] nArray2 = n < 4 || this.chroma_format == 1 ? this.intra_quantizer_matrix : this.chroma_intra_quantizer_matrix;
        switch (this.cc_table[n]) {
            case 0: {
                n2 = nArray[0] = nArray[0] + this.Get_Luma_DC_dct_diff();
                break;
            }
            case 1: {
                n2 = nArray[1] = nArray[1] + this.Get_Chroma_DC_dct_diff();
                break;
            }
            case 2: {
                n2 = nArray[2] = nArray[2] + this.Get_Chroma_DC_dct_diff();
            }
        }
        sArray[0] = (short)(n2 << 3 - this.intra_dc_precision);
        int n3 = 1;
        while (true) {
            int n4;
            byte[] byArray;
            int n5;
            if ((n5 = this.Show_Bits(16)) >= 16384 && this.intra_vlc_format < 1) {
                byArray = this.DCTtabnext[(n5 >> 12) - 4];
            } else if (n5 >= 1024) {
                byArray = this.intra_vlc_format > 0 ? this.DCTtab0a[(n5 >> 8) - 4] : this.DCTtab0[(n5 >> 8) - 4];
            } else if (n5 >= 512) {
                byArray = this.intra_vlc_format > 0 ? this.DCTtab1a[(n5 >> 6) - 8] : this.DCTtab1[(n5 >> 6) - 8];
            } else if (n5 >= 256) {
                byArray = this.DCTtab2[(n5 >> 4) - 16];
            } else if (n5 >= 128) {
                byArray = this.DCTtab3[(n5 >> 3) - 16];
            } else if (n5 >= 64) {
                byArray = this.DCTtab4[(n5 >> 2) - 16];
            } else if (n5 >= 32) {
                byArray = this.DCTtab5[(n5 >> 1) - 16];
            } else if (n5 >= 16) {
                byArray = this.DCTtab6[n5 - 16];
            } else {
                this.Fault_Flag = 1;
                return;
            }
            this.Flush_Bits(byArray[2]);
            if (byArray[0] < 64) {
                n3 += byArray[0];
                n2 = byArray[1];
                n4 = this.Get_Bits(1);
            } else {
                if (byArray[0] == 64) {
                    return;
                }
                if (this.profile_and_level_indication == 0) {
                    n3 += this.Get_Bits(6);
                    n2 = this.Get_Bits(8);
                    if (n2 == 0) {
                        n2 = this.Get_Bits(8);
                    } else if (n2 == 128) {
                        n2 = this.Get_Bits(8) - 128;
                    } else if (n2 > 128) {
                        n2 -= 256;
                    }
                    n4 = 0;
                } else {
                    n3 += this.Get_Bits(6);
                    n2 = this.Get_Bits(12);
                    n4 = n2 >= 2048 ? 1 : 0;
                    if (n4 > 0) {
                        n2 = 4096 - n2;
                    }
                }
            }
            byte by = this.scan[this.alternate_scan][n3];
            n2 = n2 * this.quantizer_scale * nArray2[by] >> 4;
            sArray[by] = (short)(n4 > 0 ? -n2 : n2);
            ++n3;
        }
    }

    public void Decode_MPEG2_Non_Intra_Block(int n) {
        short[] sArray = this.block[n];
        int[] nArray = n < 4 || this.chroma_format == 1 ? this.non_intra_quantizer_matrix : this.chroma_non_intra_quantizer_matrix;
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            byte[] byArray;
            int n5;
            if ((n5 = this.Show_Bits(16)) >= 16384) {
                byArray = n2 == 0 ? this.DCTtabfirst[(n5 >> 12) - 4] : this.DCTtabnext[(n5 >> 12) - 4];
            } else if (n5 >= 1024) {
                byArray = this.DCTtab0[(n5 >> 8) - 4];
            } else if (n5 >= 512) {
                byArray = this.DCTtab1[(n5 >> 6) - 8];
            } else if (n5 >= 256) {
                byArray = this.DCTtab2[(n5 >> 4) - 16];
            } else if (n5 >= 128) {
                byArray = this.DCTtab3[(n5 >> 3) - 16];
            } else if (n5 >= 64) {
                byArray = this.DCTtab4[(n5 >> 2) - 16];
            } else if (n5 >= 32) {
                byArray = this.DCTtab5[(n5 >> 1) - 16];
            } else if (n5 >= 16) {
                byArray = this.DCTtab6[n5 - 16];
            } else {
                this.Fault_Flag = 1;
                return;
            }
            this.Flush_Bits(byArray[2]);
            if (byArray[0] < 64) {
                n2 += byArray[0];
                n4 = byArray[1];
                n3 = this.Get_Bits(1);
            } else {
                if (byArray[0] == 64) {
                    return;
                }
                n2 += this.Get_Bits(6);
                n4 = this.Get_Bits(12);
                n3 = n4 >= 2048 ? 1 : 0;
                if (n3 > 0) {
                    n4 = 4096 - n4;
                }
            }
            byte by = this.scan[this.alternate_scan][n2];
            n4 = ((n4 << 1) + 1) * this.quantizer_scale * nArray[by] >> 5;
            sArray[by] = (short)(n3 > 0 ? -n4 : n4);
            ++n2;
        }
    }

    public int Get_Luma_DC_dct_diff() {
        int n;
        byte by;
        int n2 = this.Show_Bits(5);
        if (n2 < 31) {
            by = this.DClumtab0[n2][0];
            this.Flush_Bits(this.DClumtab0[n2][1]);
        } else {
            n2 = this.Show_Bits(9) - 496;
            by = this.DClumtab1[n2][0];
            this.Flush_Bits(this.DClumtab1[n2][1]);
        }
        if (by == 0) {
            n = 0;
        } else {
            n = this.Get_Bits(by);
            if ((n & 1 << by - 1) == 0) {
                n -= (1 << by) - 1;
            }
        }
        return n;
    }

    public int Get_Chroma_DC_dct_diff() {
        int n;
        byte by;
        int n2 = this.Show_Bits(5);
        if (n2 < 31) {
            by = this.DCchromtab0[n2][0];
            this.Flush_Bits(this.DCchromtab0[n2][1]);
        } else {
            n2 = this.Show_Bits(10) - 992;
            by = this.DCchromtab1[n2][0];
            this.Flush_Bits(this.DCchromtab1[n2][1]);
        }
        if (by == 0) {
            n = 0;
        } else {
            n = this.Get_Bits(by);
            if ((n & 1 << by - 1) == 0) {
                n -= (1 << by) - 1;
            }
        }
        return n;
    }

    public int Get_coded_block_pattern() {
        int n = this.Show_Bits(9);
        if (n >= 128) {
            this.Flush_Bits(this.CBPtab0[n >>= 4][1]);
            return this.CBPtab0[n][0];
        }
        if (n >= 8) {
            this.Flush_Bits(this.CBPtab1[n >>= 1][1]);
            return this.CBPtab1[n][0];
        }
        if (n < 1) {
            this.Fault_Flag = 3;
            return 0;
        }
        this.Flush_Bits(this.CBPtab2[n][1]);
        return this.CBPtab2[n][0];
    }

    public int start_of_slice(int[] nArray, int[] nArray2, int[] nArray3, int[][][] nArray4) {
        this.next_start_code();
        int n = this.Get_Bits(32);
        if (n < 257 || n > 431) {
            this.Fault_Flag = 10;
            return -1;
        }
        int n2 = this.slice_header();
        nArray2[0] = this.Get_macroblock_address_increment();
        if (this.Fault_Flag > 0) {
            return -1;
        }
        nArray[0] = ((n2 << 7) + (n & 0xFF) - 1) * this.mb_width + nArray2[0] - 1;
        nArray2[0] = 1;
        nArray3[2] = 0;
        nArray3[1] = 0;
        nArray3[0] = 0;
        nArray4[1][0][1] = 0;
        nArray4[1][0][0] = 0;
        nArray4[0][0][1] = 0;
        nArray4[0][0][0] = 0;
        nArray4[1][1][1] = 0;
        nArray4[1][1][0] = 0;
        nArray4[0][1][1] = 0;
        nArray4[0][1][0] = 0;
        return 1;
    }

    public int Get_macroblock_address_increment() {
        int n = 0;
        int n2 = 0;
        while ((n = this.Show_Bits(11)) < 24) {
            if (n != 15) {
                if (n == 8) {
                    n2 += 33;
                } else {
                    this.Fault_Flag = 4;
                    return 1;
                }
            }
            this.Flush_Bits(11);
        }
        if (n >= 1024) {
            this.Flush_Bits(1);
            return n2 + 1;
        }
        if (n >= 128) {
            this.Flush_Bits(this.MBAtab1[n >>= 6][1]);
            return n2 + this.MBAtab1[n][0];
        }
        this.Flush_Bits(this.MBAtab2[n -= 24][1]);
        return n2 + this.MBAtab2[n][0];
    }

    public void motion_vectors(int[][][] nArray, int[] nArray2, int[][] nArray3, int n, int[] nArray4, int[] nArray5, int n2, int n3, int[] nArray6, int[] nArray7) {
        if (nArray4[0] == 1) {
            if (nArray5[0] == 0 && nArray6[0] < 1) {
                int n4 = this.Get_Bits(1);
                nArray3[0][n] = n4;
                nArray3[1][n] = n4;
            }
            this.motion_vector(nArray[0][n], nArray2, n2, n3, nArray6, nArray7, 0);
            nArray[1][n][0] = nArray[0][n][0];
            nArray[1][n][1] = nArray[0][n][1];
        } else {
            nArray3[0][n] = this.Get_Bits(1);
            this.motion_vector(nArray[0][n], nArray2, n2, n3, nArray6, nArray7, 0);
            nArray3[1][n] = this.Get_Bits(1);
            this.motion_vector(nArray[1][n], nArray2, n2, n3, nArray6, nArray7, 0);
        }
    }

    public void motion_vector(int[] nArray, int[] nArray2, int n, int n2, int[] nArray3, int[] nArray4, int n3) {
        int n4 = this.Get_motion_code();
        int n5 = n != 0 && n4 != 0 ? this.Get_Bits(n) : 0;
        this.decode_motion_vector(nArray[0], n, n4, n5, n3);
        if (nArray3[0] > 0) {
            nArray2[0] = this.Get_dmvector();
        }
        n4 = this.Get_motion_code();
        int n6 = n5 = n2 != 0 && n4 != 0 ? this.Get_Bits(n2) : 0;
        if (nArray4[0] > 0) {
            nArray[1] = nArray[1] >> 1;
        }
        this.decode_motion_vector(nArray[1], n2, n4, n5, n3);
        if (nArray4[0] > 0) {
            nArray[1] = nArray[1] << 1;
        }
        if (nArray3[0] > 0) {
            nArray2[1] = this.Get_dmvector();
        }
    }

    public void decode_motion_vector(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = 16 << n2;
        int n8 = n6 = n5 > 0 ? n >> 1 : n;
        if (n3 > 0) {
            if ((n6 += (n3 - 1 << n2) + n4 + 1) >= n7) {
                n6 -= n7 + n7;
            }
        } else if (n3 < 0 && (n6 -= (-n3 - 1 << n2) + n4 + 1) < -n7) {
            n6 += n7 + n7;
        }
        n = n5 > 0 ? n6 << 1 : n6;
    }

    public void Dual_Prime_Arithmetic(int[][] nArray, int[] nArray2, int n, int n2) {
        if (this.picture_structure == 3) {
            if (this.top_field_first > 0) {
                nArray[0][0] = (n + (n > 0 ? 1 : 0) >> 1) + nArray2[0];
                nArray[0][1] = (n2 + (n2 > 0 ? 1 : 0) >> 1) + nArray2[1] - 1;
                nArray[1][0] = (3 * n + (n > 0 ? 1 : 0) >> 1) + nArray2[0];
                nArray[1][1] = (3 * n2 + (n2 > 0 ? 1 : 0) >> 1) + nArray2[1] + 1;
            } else {
                nArray[0][0] = (3 * n + (n > 0 ? 1 : 0) >> 1) + nArray2[0];
                nArray[0][1] = (3 * n2 + (n2 > 0 ? 1 : 0) >> 1) + nArray2[1] - 1;
                nArray[1][0] = (n + (n > 0 ? 1 : 0) >> 1) + nArray2[0];
                nArray[1][1] = (n2 + (n2 > 0 ? 1 : 0) >> 1) + nArray2[1] + 1;
            }
        } else {
            nArray[0][0] = (n + (n > 0 ? 1 : 0) >> 1) + nArray2[0];
            nArray[0][1] = (n2 + (n2 > 0 ? 1 : 0) >> 1) + nArray2[1];
            if (this.picture_structure == 1) {
                int[] nArray3 = nArray[0];
                nArray3[1] = nArray3[1] - 1;
            } else {
                int[] nArray4 = nArray[0];
                nArray4[1] = nArray4[1] + 1;
            }
        }
    }

    public void motion_compensation(int[] nArray, int[] nArray2, int[] nArray3, int[][][] nArray4, int[][] nArray5, int[] nArray6, int[] nArray7) {
        int n = 16 * (nArray[0] % this.mb_width);
        int n2 = 16 * (nArray[0] / this.mb_width);
        int n3 = 0;
        while (n3 < this.block_count) {
            if (IDCTSseNative.isLibraryLoaded()) {
                this.idctsse.referenceIDCT(this.block[n3]);
            } else if (IDCTRefNative.isLibraryLoaded()) {
                this.idct.referenceIDCT(this.block[n3]);
            } else {
                this.IDCT_reference(this.block[n3], this.FAST ? 1 : 8);
            }
            this.Add_Block(n3, n, n2, nArray7, (nArray2[0] & 1) == 0);
            ++n3;
        }
    }

    public void IDCT_reference(short[] sArray, int n) {
        int n2;
        float f;
        int n3;
        float[] fArray = new float[64];
        int n4 = 0;
        while (n4 < n) {
            n3 = 0;
            while (n3 < n) {
                f = 0.0f;
                n2 = 0;
                while (n2 < 8) {
                    f += this.ref_dct_matrix[n2][n3] * (float)sArray[8 * n4 + n2];
                    ++n2;
                }
                fArray[8 * n4 + n3] = f;
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < n) {
            n4 = 0;
            while (n4 < n) {
                f = 0.0f;
                n2 = 0;
                while (n2 < 8) {
                    f += this.ref_dct_matrix[n2][n4] * fArray[8 * n2 + n3];
                    ++n2;
                }
                int n5 = (int)Math.floor((double)f + 0.5);
                sArray[8 * n4 + n3] = this.idct_clip_table[512 + n5];
                ++n4;
            }
            ++n3;
        }
        if (n == 1) {
            Arrays.fill(sArray, sArray[0]);
        }
    }

    public void Add_Block(int n, int n2, int n3, int[] nArray, boolean bl) {
        int n4;
        int n5;
        short[] sArray = this.block[n];
        byte by = this.cc_table[n];
        if (by == 0) {
            if (this.picture_structure == 3) {
                if (nArray[0] > 0) {
                    n5 = this.current_frame[0] + this.Coded_Picture_Width * (n3 + ((n & 2) >> 1)) + n2 + ((n & 1) << 3);
                    n4 = (this.Coded_Picture_Width << 1) - 8;
                } else {
                    n5 = this.current_frame[0] + this.Coded_Picture_Width * (n3 + ((n & 2) << 2)) + n2 + ((n & 1) << 3);
                    n4 = this.Coded_Picture_Width - 8;
                }
            } else {
                n5 = this.current_frame[0] + (this.Coded_Picture_Width << 1) * (n3 + ((n & 2) << 2)) + n2 + ((n & 1) << 3);
                n4 = (this.Coded_Picture_Width << 1) - 8;
            }
        } else {
            if (this.chroma_format != 3) {
                n2 >>= 1;
            }
            if (this.picture_structure == 3) {
                if (nArray[0] > 0 && this.chroma_format != 1) {
                    n5 = this.current_frame[by] + this.Chroma_Width * (n3 + ((n & 2) >> 1)) + n2 + (n & 8);
                    n4 = (this.Chroma_Width << 1) - 8;
                } else {
                    n5 = this.current_frame[by] + this.Chroma_Width * (n3 + ((n & 2) << 2)) + n2 + (n & 8);
                    n4 = this.Chroma_Width - 8;
                }
            } else {
                n5 = this.current_frame[by] + (this.Chroma_Width << 1) * (n3 + ((n & 2) << 2)) + n2 + (n & 8);
                n4 = (this.Chroma_Width << 1) - 8;
            }
        }
        n4 += 8;
        if (by == 0) {
            int n6 = 0;
            while (n6 < 8) {
                int n7 = 0;
                while (n7 < 8) {
                    int n8 = n5 + n7 + n6 * n4;
                    int n9 = sArray[n7 + n6 * 8] + (this.picture_coding_type == 1 ? 128 : 0);
                    n9 = n9 < 0 ? 0 : (n9 > 255 ? 255 : n9);
                    int n10 = n8;
                    this.pixels[n10] = this.pixels[n10] | n9 << 16;
                    ++n7;
                }
                ++n6;
            }
        } else {
            if (this.chroma_format != 3) {
                n5 <<= 1;
                n4 <<= 1;
            }
            int n11 = 0;
            while (n11 < 16) {
                int n12 = 0;
                while (n12 < 16) {
                    int n13 = n5 + (n12 >> (this.chroma_format == 3 ? 1 : 0)) + (n11 >> (this.chroma_format != 1 ? 1 : 0)) * n4;
                    int n14 = 128 + sArray[(n12 >> 1) + 8 * (this.chroma_format != 1 ? n11 >> 1 : ((n11 & 1) == 0 ? n11 >> 1 & ~nArray[0] : n11 >> 1 | nArray[0]))];
                    int n15 = n14 < 0 ? 0 : (n14 = n14 > 255 ? 255 : n14);
                    if (by == 1) {
                        int n16 = n13;
                        this.pixels[n16] = this.pixels[n16] | n14 << 8;
                    } else {
                        int n17 = n13;
                        this.pixels[n17] = this.pixels[n17] | n14;
                    }
                    if (this.chroma_format == 3) {
                        ++n12;
                    }
                    ++n12;
                }
                if (this.chroma_format != 1) {
                    ++n11;
                }
                ++n11;
            }
        }
    }

    public void macroblock_modes(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.Get_macroblock_type();
        if (this.Fault_Flag > 0) {
            return;
        }
        if ((n4 & 0xC) > 0) {
            n3 = this.picture_structure == 3 ? (this.frame_pred_frame_dct > 0 ? 2 : this.Get_Bits(2)) : this.Get_Bits(2);
        } else if ((n4 & 1) > 0 && this.concealment_motion_vectors > 0) {
            int n5 = n3 = this.picture_structure == 3 ? 2 : 1;
        }
        if (this.picture_structure == 3) {
            n2 = n3 == 1 ? 2 : 1;
            n = n3 == 2 ? 1 : 0;
        } else {
            n2 = n3 == 2 ? 2 : 1;
            n = 0;
        }
        int n6 = n3 == 3 ? 1 : 0;
        int n7 = n == 0 && this.picture_structure == 3 ? 1 : 0;
        int n8 = this.picture_structure == 3 && this.frame_pred_frame_dct < 1 && (n4 & 3) > 0 ? this.Get_Bits(1) : 0;
        nArray[0] = n4;
        nArray2[0] = n3;
        nArray3[0] = n2;
        nArray4[0] = n;
        nArray5[0] = n6;
        nArray6[0] = n7;
        nArray7[0] = n8;
    }

    private int Get_macroblock_type() {
        int n = 0;
        switch (this.picture_coding_type) {
            case 1: {
                n = this.Get_I_macroblock_type();
                break;
            }
            case 2: {
                n = this.Get_P_macroblock_type();
                break;
            }
            case 3: {
                n = this.Get_B_macroblock_type();
            }
        }
        return n;
    }

    private int Get_I_macroblock_type() {
        if (this.Get_Bits(1) > 0) {
            return 1;
        }
        if (this.Get_Bits(1) < 1) {
            this.Fault_Flag = 2;
        }
        return 17;
    }

    private int Get_P_macroblock_type() {
        int n = this.Show_Bits(6);
        if (n >= 8) {
            this.Flush_Bits(this.PMBtab0[n >>= 3][1]);
            return this.PMBtab0[n][0];
        }
        if (n == 0) {
            this.Fault_Flag = 2;
            return 0;
        }
        this.Flush_Bits(this.PMBtab1[n][1]);
        return this.PMBtab1[n][0];
    }

    private int Get_B_macroblock_type() {
        int n = this.Show_Bits(6);
        if (n >= 8) {
            this.Flush_Bits(this.BMBtab0[n >>= 2][1]);
            return this.BMBtab0[n][0];
        }
        if (n == 0) {
            this.Fault_Flag = 2;
            return 0;
        }
        this.Flush_Bits(this.BMBtab1[n][1]);
        return this.BMBtab1[n][0];
    }

    private int Get_motion_code() {
        if (this.Get_Bits(1) > 0) {
            return 0;
        }
        int n = this.Show_Bits(9);
        if (n >= 64) {
            this.Flush_Bits(this.MVtab0[n >>= 6][1]);
            return this.Get_Bits(1) > 0 ? -this.MVtab0[n][0] : this.MVtab0[n][0];
        }
        if (n >= 24) {
            this.Flush_Bits(this.MVtab1[n >>= 3][1]);
            return this.Get_Bits(1) > 0 ? -this.MVtab1[n][0] : this.MVtab1[n][0];
        }
        if ((n -= 12) < 0) {
            this.Fault_Flag = 10;
            return 0;
        }
        this.Flush_Bits(this.MVtab2[n][1]);
        return this.Get_Bits(1) > 0 ? -this.MVtab2[n][0] : this.MVtab2[n][0];
    }

    private int Get_dmvector() {
        if (this.Get_Bits(1) > 0) {
            return this.Get_Bits(1) > 0 ? -1 : 1;
        }
        return 0;
    }

    private int YUVtoRGB(int n) {
        int n2 = 255;
        int n3 = 0xFF & n >>> 16;
        int n4 = 0xFF & n >>> 8;
        int n5 = 0xFF & n;
        if (n3 == 0) {
            return 0;
        }
        int n6 = (int)((float)n3 + 1.402f * (float)(n5 - 128));
        int n7 = (int)((double)n3 - 0.34414 * (double)(n4 - 128) - 0.71414 * (double)(n5 - 128));
        int n8 = (int)((double)n3 + 1.722 * (double)(n4 - 128));
        int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
        int n10 = n7 < 0 ? 0 : (n7 = n7 > 255 ? 255 : n7);
        n8 = n8 < 0 ? 0 : (n8 > 255 ? 255 : n8);
        return n2 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    private void scale_Picture() {
        Arrays.fill(this.pixels2, -11513776);
        int n = (this.aspect_ratio_information == 3 || this.aspect_ratio_information == 4) && this.profile_and_level_indication != 0 ? 0 : 64;
        int n2 = 512;
        int n3 = 288;
        int n4 = n == 0 ? n2 : n2 - n;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = (float)this.vertical_size / (float)n3;
        float f4 = (float)this.horizontal_size / (float)(n4 - n);
        int n5 = 0;
        while (f < (float)this.vertical_size && n5 < n3) {
            int n6 = n;
            while (f2 < (float)this.horizontal_size && n6 < n4) {
                this.pixels2[n6 + n5 * n2] = this.YUVtoRGB(this.pixels[(int)f2 + (int)f * this.horizontal_size]);
                f2 += f4;
                ++n6;
            }
            f += f3;
            ++n5;
            f2 = 0.0f;
        }
        Common.getGuiInterface().updatePreviewPixel();
        this.messageStreamInfo();
        WSS.init(this.pixels, this.horizontal_size);
    }

    private void messageStreamInfo() {
        String[] stringArray = new String[]{"i", "p"};
        this.info_1 = this.horizontal_size + "*" + this.vertical_size;
        this.info_1 = this.info_1 + stringArray[this.progressive_sequence] + " ";
        this.info_1 = this.info_1 + this.aspect_ratio_string[this.aspect_ratio_information] + " ";
        this.info_1 = this.info_1 + this.picture_coding_type_string[this.picture_coding_type];
        this.info_1 = this.info_1 + "(" + this.temporal_reference + ")";
        this.info_1 = this.info_1 + this.progressive_string[this.progressive_frame] + " ";
        this.info_1 = this.info_1 + ", " + this.video_format_S[this.video_format] + " ";
        this.info_1 = this.info_1 + ", " + (this.profile_and_level_indication == 0 ? "MPEG1" : (1 & this.profile_and_level_indication >>> 7) + "|" + this.prof[7 & this.profile_and_level_indication >>> 4] + "@" + this.lev[0xF & this.profile_and_level_indication]);
        this.info_1 = this.info_1 + "(" + this.Coded_Picture_Width + "*" + this.Coded_Picture_Height + ") ";
        this.info_1 = this.info_1 + this.info_4;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int[] getPreviewPixel() {
        return this.pixels2;
    }

    public void clearPreviewPixel() {
        this.info_1 = "";
        this.info_2 = "";
        Arrays.fill(this.pixels2, -11513776);
        WSS.init(new int[0], 0);
        Common.getGuiInterface().updatePreviewPixel();
    }

    public int getWidth() {
        return this.horizontal_size;
    }

    public int getHeight() {
        return this.vertical_size;
    }

    public int getAspectRatio() {
        return this.aspect_ratio_information;
    }

    public String getInfo_1() {
        return this.info_1;
    }

    public String getInfo_2() {
        return this.info_2;
    }

    public String getWSSInfo() {
        return WSS.getWSS();
    }

    public boolean getPalPlusInfo() {
        return WSS.isPalPlus();
    }

    public String getWSSFormatInfo() {
        return WSS.getFormatInfo();
    }

    public int getErrors() {
        return 0 | (this.ERROR1 ? 1 : 0) | (this.ERROR2 ? 2 : 0);
    }

    private void repaint() {
        Common.getGuiInterface().repaintPicturePanel();
    }

    public int[] getCutImage() {
        int n = 126;
        int n2 = 224;
        int n3 = 288;
        int n4 = 512;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = (float)n3 / (float)n;
        float f4 = (float)n4 / (float)n2;
        int[] nArray = new int[n2 * n];
        int n5 = 0;
        while (f < (float)n3 && n5 < n) {
            int n6 = 0;
            while (f2 < (float)n4 && n6 < n2) {
                nArray[n6 + n5 * n2] = this.pixels2[(int)f2 + (int)f * n4];
                f2 += f4;
                ++n6;
            }
            f += f3;
            ++n5;
            f2 = 0.0f;
        }
        return nArray;
    }

    public long decodeArray(byte[] byArray, boolean bl, boolean bl2, boolean bl3) {
        return this.decodeArray(byArray, 0, bl, bl2, bl3);
    }

    public long decodeArray(byte[] byArray, int n, boolean bl, boolean bl2, boolean bl3) {
        this.FAST = bl3;
        this.DIRECTION = bl;
        this.ERROR1 = false;
        this.ERROR2 = false;
        this.buf = byArray;
        this.BufferPos = n;
        this.BitPos = this.BufferPos << 3;
        this.StartPos = this.BufferPos;
        this.viewGOP = bl2;
        if (this.DIRECTION) {
            this.BufferPos = this.buf.length - 4;
            this.StartPos = this.BufferPos;
            this.BitPos = this.BufferPos << 3;
        }
        try {
            while (this.BufferPos < this.buf.length && this.BufferPos >= 0) {
                this.ERROR_CODE1 = this.extern_Get_Hdr();
                if (this.ERROR_CODE1 == 1) {
                    if (this.picture_coding_type != 1) {
                        this.BufferPos += 2048;
                        continue;
                    }
                    this.InitialDecoder();
                    this.Decode_Picture();
                    this.repaint();
                    return this.StartPos;
                }
                if (this.ERROR_CODE1 == 2) {
                    this.repaint();
                    return 0L;
                }
                ++this.BufferPos;
            }
            this.ERROR2 = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.ERROR1 = true;
        }
        catch (Error error) {
            this.ERROR1 = true;
        }
        this.repaint();
        return 0L;
    }
}

