/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class UnicodeWriter {
    private DataOutputStream out1;
    private PrintWriter out2;
    private boolean useUnicode = false;

    private UnicodeWriter() {
    }

    public UnicodeWriter(ByteArrayOutputStream byteArrayOutputStream, boolean bl) {
        this.useUnicode = bl;
        if (this.useUnicode) {
            this.out1 = new DataOutputStream(byteArrayOutputStream);
        } else {
            this.out2 = new PrintWriter(byteArrayOutputStream, true);
        }
    }

    public void flush() throws IOException {
        if (this.useUnicode) {
            this.out1.flush();
        } else {
            this.out2.flush();
        }
    }

    public void close() throws IOException {
        if (this.useUnicode) {
            this.out1.close();
        } else {
            this.out2.close();
        }
    }

    public void print(String string) throws IOException {
        if (this.useUnicode) {
            if (this.out1.size() == 0) {
                this.out1.writeChar(65279);
            }
            this.out1.writeChars(string);
        } else {
            this.out2.print(string);
        }
    }

    public void println(String string) throws IOException {
        if (this.useUnicode) {
            this.print(string);
            this.print(System.getProperty("line.separator"));
        } else {
            this.out2.println(string);
        }
    }

    public void println() throws IOException {
        if (this.useUnicode) {
            this.print(System.getProperty("line.separator"));
        } else {
            this.out2.println();
        }
    }
}

