/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.VBI;
import net.sourceforge.dvb.projectx.video.Video;

public class StreamDemultiplexer {
    private boolean ptsover = false;
    private boolean misshead = false;
    private boolean first = true;
    private boolean overlap = false;
    private boolean seqhead = false;
    private boolean isPTSwritten = false;
    private boolean WriteNonVideo;
    private boolean WriteVideo;
    private boolean Debug;
    private boolean DecodeVBI;
    private boolean RebuildPTS;
    private boolean Streamtype_MpgVideo;
    private boolean Streamtype_MpgAudio;
    private boolean Streamtype_Ac3Audio;
    private boolean Streamtype_PcmAudio;
    private boolean Streamtype_Teletext;
    private boolean Streamtype_Subpicture;
    private boolean AddSequenceEndcode;
    private boolean RenameVideo;
    private boolean CreateD2vIndex;
    private boolean CreateM2sIndex;
    private boolean SplitProjectFile;
    private boolean CreateCellTimes;
    private long AddOffset = 0L;
    private long target_position = 0L;
    private long ptsoffset = 0L;
    private long pts = -1L;
    private long lastPTS = -1L;
    private int pack = -1;
    private int pes_ID = 0;
    private int newID = 0;
    private int PID = 0;
    private int es_streamtype = 0;
    private int subid = 511;
    private int pes_streamtype = 0;
    private int lfn = -1;
    private int buffersize = 1024;
    private int sourcetype = 0;
    private int[] MPGVideotype = new int[]{0};
    private String FileName = "";
    private String parentname = "";
    private String[] type = new String[]{"ac", "tt", "mp", "mv", "pc", "sp", "vp"};
    private String[] source = new String[]{".$spes$", ".$ppes$", ".$ts$", ".$pva$"};
    private String[] videoext = new String[]{".mpv", ".mpv", ".m1v", ".m2v"};
    private IDDBufferedOutputStream out;
    private DataOutputStream pts_log;
    private ByteArrayOutputStream vidbuf;
    private ByteArrayOutputStream vptsbytes;
    private ByteArrayOutputStream packet;
    private DataOutputStream vpts;
    private byte[] subpicture_header = new byte[]{83, 80, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] lpcm_header = new byte[]{80, 67, 77, 0, 0, 0, 0, 0, 0, 0};

    public StreamDemultiplexer() {
        this.getSettings();
    }

    public StreamDemultiplexer(long l) {
        this.getSettings();
        this.ptsoffset = l;
    }

    public int getNum() {
        return this.lfn;
    }

    public int getPID() {
        return this.PID;
    }

    public int getID() {
        return this.pes_ID;
    }

    public void setPID(int n) {
        this.PID = n;
    }

    public void setID(int n) {
        this.pes_ID = n;
    }

    public void setnewID(int n) {
        this.newID = n;
    }

    public int getnewID() {
        return this.newID;
    }

    public int getPackCount() {
        return this.pack;
    }

    public int getType() {
        return this.es_streamtype;
    }

    public void setStreamType(int n) {
        this.pes_streamtype = n;
    }

    public int getStreamType() {
        return this.pes_streamtype;
    }

    public void setType(int n) {
        this.es_streamtype = n;
    }

    public void setsubID(int n) {
        this.subid = n;
    }

    public int subID() {
        return this.subid;
    }

    public boolean isTTX() {
        return this.es_streamtype == 1;
    }

    public void setTTX(boolean bl) {
        if (bl) {
            this.es_streamtype = 1;
        }
    }

    public long getPTS() {
        return this.pts;
    }

    public void PTSOffset(long l) {
        this.ptsoffset = l;
    }

    public boolean StreamEnabled() {
        switch (this.newID >>> 4) {
            case 14: {
                return this.Streamtype_MpgVideo;
            }
            case 12: 
            case 13: {
                return this.Streamtype_MpgAudio;
            }
            case 8: {
                return this.Streamtype_Ac3Audio;
            }
            case 10: {
                return this.Streamtype_PcmAudio;
            }
            case 9: {
                return this.Streamtype_Teletext;
            }
            case 2: 
            case 3: {
                return this.Streamtype_Subpicture;
            }
        }
        return true;
    }

    private void getSettings() {
        this.Streamtype_MpgVideo = Common.getSettings().getBooleanProperty(Keys.KEY_Streamtype_MpgVideo);
        this.Streamtype_MpgAudio = Common.getSettings().getBooleanProperty(Keys.KEY_Streamtype_MpgAudio);
        this.Streamtype_Ac3Audio = Common.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Ac3Audio);
        this.Streamtype_PcmAudio = Common.getSettings().getBooleanProperty(Keys.KEY_Streamtype_PcmAudio);
        this.Streamtype_Teletext = Common.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Teletext);
        this.Streamtype_Subpicture = Common.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Subpicture);
        this.AddOffset = Common.getSettings().getBooleanProperty(Keys.KEY_additionalOffset) ? 90L * (long)Common.getSettings().getIntProperty(Keys.KEY_ExportPanel_additionalOffset_Value) : 0L;
        this.WriteNonVideo = Common.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeAudio);
        this.WriteVideo = Common.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeVideo);
        this.Debug = Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.DecodeVBI = Common.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Vbi);
        this.RebuildPTS = Common.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_rebuildPTS);
        this.AddSequenceEndcode = Common.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_addEndcode);
        this.RenameVideo = Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_renameVideo);
        this.CreateD2vIndex = Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createD2vIndex);
        this.CreateM2sIndex = Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createM2sIndex);
        this.SplitProjectFile = Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile);
        this.CreateCellTimes = Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createCellTimes);
    }

    private void initNonVideo(String string) {
        this.parentname = string;
        this.FileName = this.parentname + this.source[this.sourcetype] + this.lfn;
        this.target_position = 0L;
        this.getSettings();
        try {
            this.out = new IDDBufferedOutputStream(new FileOutputStream(this.FileName), this.buffersize);
            this.pts_log = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.FileName + ".pts"), 65535));
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void init(String string, int n, int n2, int n3) {
        this.lfn = n2;
        this.buffersize = n;
        this.sourcetype = n3;
        this.initNonVideo(string);
    }

    public void init2(String string) {
        this.initNonVideo(string);
    }

    public void write(JobProcessing jobProcessing, byte[] byArray, boolean bl) {
        this.write(jobProcessing, byArray, 0, byArray.length, bl);
    }

    public void write(JobProcessing jobProcessing, byte[] byArray, int n, int n2, boolean bl) {
        boolean bl2 = false;
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        ++this.pack;
        if (bl) {
            block58: {
                if (CommonParsing.validateStartcode(byArray, n4) < 0) {
                    Common.setMessage(Resource.getString("demux.error.audio.startcode") + " " + this.pack + " (" + Integer.toHexString(this.PID) + "/" + Integer.toHexString(this.pes_ID) + "/" + Integer.toHexString(this.newID) + "/" + this.es_streamtype + ")");
                    return;
                }
                this.pes_ID = CommonParsing.getPES_IdField(byArray, n4);
                n2 = CommonParsing.getPES_LengthField(byArray, n4);
                boolean bl3 = bl2 = (this.pes_streamtype == 1 || this.pes_streamtype == 3) && (4 & byArray[6 + n4]) != 0;
                if (this.pes_streamtype == 2) {
                    block32: while (true) {
                        switch (0xC0 & byArray[6 + n4]) {
                            case 64: {
                                n4 += 2;
                                continue block32;
                            }
                            case 128: {
                                n4 += 3;
                                continue block32;
                            }
                            case 192: {
                                ++n4;
                                continue block32;
                            }
                        }
                        switch (0x30 & byArray[6 + n4]) {
                            case 32: {
                                n3 = 5;
                                break block58;
                            }
                            case 48: {
                                n3 = 10;
                                break block58;
                            }
                            case 16: {
                                n4 += 5;
                                break block58;
                            }
                            case 0: {
                                ++n4;
                                break block58;
                            }
                        }
                    }
                }
                n3 = CommonParsing.getPES_ExtensionLengthField(byArray, n4);
                if (this.pes_ID == 189 && n3 == 36 && (0xFF & byArray[9 + n3 + n4]) >>> 4 == 1) {
                    n5 = 1;
                }
                if ((0x80 & byArray[7 + n4]) == 0) {
                    n4 += n3;
                    n3 = 0;
                }
                n4 += 3;
            }
            this.es_streamtype = this.pes_ID == 189 ? n5 : 2;
            this.subid = !(this.es_streamtype != 0 && this.es_streamtype != 6 && this.es_streamtype != 1 || (this.pes_streamtype != 1 || !bl2 && this.es_streamtype != 1) && this.pes_streamtype != 3) ? 0xFF & byArray[9 + (0xFF & byArray[8 + n]) + n] : 0;
            switch (this.subid >>> 4) {
                case 8: {
                    if (this.pes_streamtype == 1 || this.pes_streamtype == 2) {
                        this.subid = 0;
                        break;
                    }
                }
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    break;
                }
                default: {
                    if (this.pes_streamtype == 3) break;
                    this.subid = 0;
                }
            }
            switch (this.subid >>> 4) {
                case 10: {
                    this.es_streamtype = 4;
                    break;
                }
                case 2: 
                case 3: {
                    this.es_streamtype = 5;
                    break;
                }
                case 0: 
                case 1: 
                case 8: {
                    break;
                }
                case 9: {
                    if (!bl2) break;
                    if (this.pes_streamtype == 2 || this.pes_streamtype == 1) {
                        this.subid = 0;
                    }
                    if (this.DecodeVBI) {
                        VBI.parsePES(byArray, n);
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            n2 -= n4 - n + n3;
            n4 += 6;
        }
        if (!this.WriteNonVideo) {
            return;
        }
        if (this.out == null) {
            return;
        }
        try {
            if (this.es_streamtype == 1 && this.RebuildPTS) {
                if (jobProcessing.getBorrowedPts() != this.lastPTS) {
                    this.lastPTS = jobProcessing.getBorrowedPts();
                    this.pts_log.writeLong(this.lastPTS);
                    this.pts_log.writeLong(this.target_position);
                    if (this.Debug) {
                        System.out.println(" stolen ttx PTS: " + this.lastPTS + " /ao " + this.AddOffset + " /tp " + this.target_position);
                    }
                }
            } else if (n3 > 0 && n2 >= 0) {
                this.pts = CommonParsing.getPTSfromBytes(byArray, n4);
                this.pts -= jobProcessing.getNextFileStartPts();
                this.pts &= 0xFFFFFFFFL;
                if ((this.pts & 0xFF000000L) == 0xFF000000L) {
                    this.ptsover = true;
                }
                if (this.ptsover && this.pts < 0xF0000000L) {
                    this.pts |= 0x100000000L;
                }
                this.pts += this.ptsoffset;
                this.pts += this.AddOffset;
                if (this.lastPTS != this.pts) {
                    if ((this.es_streamtype == 2 || this.es_streamtype == 0 || this.es_streamtype == 6 || this.es_streamtype == 4) && this.lastPTS != -1L && Math.abs(this.lastPTS - this.pts) > 100000L) {
                        Common.setMessage("!> ID 0x" + Integer.toHexString(this.pes_ID).toUpperCase() + " (sub 0x" + Integer.toHexString(this.subid).toUpperCase() + ") packet# " + this.pack + ", big PTS difference: new " + this.pts + ", old " + this.lastPTS);
                    }
                    this.pts_log.writeLong(this.pts);
                    this.pts_log.writeLong(this.target_position);
                }
                if (this.Debug) {
                    System.out.println(" pda PTS: " + this.pts + "/ " + this.AddOffset + "/ " + this.target_position);
                }
                this.lastPTS = this.pts;
            }
            if (this.newID == 192 && jobProcessing.getBorrowedPts() != this.lastPTS) {
                jobProcessing.setBorrowedPts(this.lastPTS);
            }
            switch (this.subid >>> 4) {
                case 10: {
                    ++n4;
                    --n2;
                    break;
                }
                case 8: {
                    n4 += 4;
                    n2 -= 4;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    ++n4;
                    --n2;
                }
            }
            if (n2 <= 0) {
                return;
            }
            if (n3 > 0) {
                switch (this.es_streamtype) {
                    case 5: {
                        CommonParsing.setValue(this.subpicture_header, 2, 8, true, this.pts);
                        this.target_position += (long)this.writePacket(this.subpicture_header);
                        if (CommonParsing.nextBits(byArray, (n4 + n3) * 8, 16) != 15) break;
                        this.out.write(0xFF & n2 + 3 >>> 8);
                        this.out.write(0xFF & n2 + 3);
                        this.out.write(0);
                        this.target_position += 3L;
                        break;
                    }
                    case 4: {
                        CommonParsing.setValue(this.lpcm_header, 3, 5, true, this.pts);
                        this.lpcm_header[8] = (byte)(0xFF & n2 >>> 8);
                        this.lpcm_header[9] = (byte)(0xFF & n2);
                        this.target_position += (long)this.writePacket(this.lpcm_header);
                    }
                }
            } else if (this.es_streamtype == 5 && bl2 && CommonParsing.nextBits(byArray, (n4 + n3) * 8, 16) == 15) {
                CommonParsing.setValue(this.subpicture_header, 2, 8, true, 0L);
                this.target_position += (long)this.writePacket(this.subpicture_header);
                this.out.write(0xFF & n2 + 3 >>> 8);
                this.out.write(0xFF & n2 + 3);
                this.out.write(0);
                this.target_position += 3L;
            }
            this.target_position += (long)this.writePacket(byArray, n4 + n3, n2);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public String[] close(JobProcessing jobProcessing, String string) {
        String string2 = this.FileName + ".pts";
        String[] stringArray = new String[]{this.FileName, string2, this.type[this.es_streamtype], this.parentname};
        try {
            if (this.out == null) {
                stringArray[0] = "";
                return stringArray;
            }
            this.out.flush();
            this.out.close();
            this.pts_log.flush();
            this.pts_log.close();
            if (new File(string2).length() < 10L) {
                CommonParsing.logAlias(jobProcessing, string, string2);
            }
            if (new File(this.FileName).length() < 10L) {
                new File(this.FileName).delete();
                new File(string2).delete();
                stringArray[0] = "";
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return stringArray;
    }

    public void initVideo(String string, int n, int n2, int n3) {
        this.getSettings();
        this.parentname = string;
        this.lfn = n2;
        this.buffersize = n;
        this.sourcetype = n3;
        this.FileName = this.parentname + this.source[this.sourcetype] + this.lfn;
        this.es_streamtype = 3;
        this.MPGVideotype[0] = 0;
        try {
            this.out = new IDDBufferedOutputStream(new FileOutputStream(this.FileName), this.buffersize);
            if (this.CreateM2sIndex) {
                this.out.InitIdd(this.FileName, 1);
            }
            this.pts_log = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.FileName + ".pts"), 65535));
            this.packet = new ByteArrayOutputStream();
            this.vidbuf = new ByteArrayOutputStream();
            this.vptsbytes = new ByteArrayOutputStream();
            this.vpts = new DataOutputStream(this.vptsbytes);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void initVideo2(String string) {
        this.getSettings();
        this.parentname = string;
        this.FileName = this.parentname + this.source[this.sourcetype] + this.lfn;
        this.first = true;
        this.MPGVideotype[0] = 0;
        try {
            this.out = new IDDBufferedOutputStream(new FileOutputStream(this.FileName), this.buffersize);
            if (this.CreateM2sIndex) {
                this.out.InitIdd(this.FileName, 1);
            }
            this.pts_log = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.FileName + ".pts"), 65535));
            this.packet.reset();
            this.vidbuf.reset();
            this.vptsbytes.reset();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void resetVideo() {
        if (this.vidbuf != null) {
            this.vidbuf.reset();
        }
        if (this.packet != null) {
            this.packet.reset();
        }
        if (this.vptsbytes != null) {
            this.vptsbytes.reset();
        }
        this.first = true;
    }

    public String closeVideo(JobProcessing jobProcessing, String string) {
        String string2;
        block11: {
            string2 = "-1";
            List list = jobProcessing.getCellTimes();
            int[] nArray = jobProcessing.getStatusVariables();
            try {
                if (this.AddSequenceEndcode && jobProcessing.getExportedVideoFrameNumber() > 0) {
                    this.out.write(Video.getSequenceEndCode());
                    jobProcessing.countMediaFilesExportLength(4L);
                    jobProcessing.countAllMediaFilesExportLength(4L);
                }
                this.packet.close();
                this.vidbuf.flush();
                this.vidbuf.close();
                this.out.flush();
                this.out.close();
                this.pts_log.flush();
                this.pts_log.close();
                this.vpts.flush();
                this.vpts.close();
                this.vptsbytes.flush();
                this.vptsbytes.close();
                String string3 = "";
                if (new File(this.FileName).length() < 10L) {
                    new File(this.FileName).delete();
                    if (!this.WriteVideo && new File(this.FileName + ".pts").length() > 16L) {
                        string2 = this.FileName + ".pts";
                    } else {
                        new File(this.FileName + ".pts").delete();
                    }
                } else {
                    int n = this.RenameVideo || this.CreateD2vIndex || this.SplitProjectFile ? 0 : 2;
                    string3 = this.parentname + this.videoext[this.MPGVideotype[0] + n];
                    File file = new File(string3);
                    if (file.exists()) {
                        file.delete();
                    }
                    Common.renameTo(new File(this.FileName), file);
                    string2 = this.FileName + ".pts";
                    CommonParsing.setVideoHeader(jobProcessing, string3, string2, nArray, this.MPGVideotype);
                    if (this.CreateCellTimes && !list.isEmpty()) {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + "CellTimes.txt"));
                        int n2 = 0;
                        while (n2 < list.size()) {
                            bufferedWriter.write(list.get(n2).toString());
                            bufferedWriter.newLine();
                            ++n2;
                        }
                        bufferedWriter.close();
                        Common.setMessage(Resource.getString("demux.msg.celltimes", string));
                        long l = new File(string + "CellTimes.txt").length();
                        jobProcessing.countMediaFilesExportLength(l);
                        jobProcessing.countAllMediaFilesExportLength(l);
                    }
                    list.clear();
                }
                if (!this.CreateM2sIndex) break block11;
                if (new File(string3).exists()) {
                    this.out.renameVideoIddTo(this.parentname);
                    break block11;
                }
                this.out.deleteIdd();
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
        return string2;
    }

    public void writeVideoES(JobProcessing jobProcessing, IDDBufferedOutputStream iDDBufferedOutputStream, byte[] byArray, byte[] byArray2, DataOutputStream dataOutputStream, String string, int[] nArray, List list, List list2, boolean bl) {
        jobProcessing.getGop().goptest(jobProcessing, iDDBufferedOutputStream, byArray, byArray2, dataOutputStream, string, nArray, list, list2, bl);
    }

    public void writeVideo(JobProcessing jobProcessing, byte[] byArray, boolean bl, List list, List list2) {
        this.writeVideo(jobProcessing, byArray, 0, byArray.length, bl, list, list2);
    }

    public void writeVideo(JobProcessing jobProcessing, byte[] byArray, int n, int n2, boolean bl, List list, List list2) {
        int n3 = 0;
        int n4 = n;
        byte[] byArray2 = null;
        int[] nArray = jobProcessing.getStatusVariables();
        ++this.pack;
        if (!bl) {
            if (jobProcessing.getPvaVideoPts() != -1L) {
                n4 -= 4;
                n3 += 4;
            }
        } else {
            block54: {
                if (CommonParsing.validateStartcode(byArray, n4) < 0) {
                    Common.setMessage(Resource.getString("demux.error.video.startcode") + " " + this.pack + " (" + Integer.toHexString(this.PID) + "/" + Integer.toHexString(this.pes_ID) + "/" + Integer.toHexString(this.newID) + "/" + this.es_streamtype + ")");
                    return;
                }
                this.pes_ID = CommonParsing.getPES_IdField(byArray, n4);
                n2 = CommonParsing.getPES_LengthField(byArray, n4);
                if (this.pes_streamtype == 2) {
                    block13: while (true) {
                        switch (0xC0 & byArray[6 + n4]) {
                            case 64: {
                                n4 += 2;
                                continue block13;
                            }
                            case 128: {
                                n4 += 3;
                                continue block13;
                            }
                            case 192: {
                                ++n4;
                                continue block13;
                            }
                        }
                        switch (0x30 & byArray[6 + n4]) {
                            case 32: {
                                n3 = 5;
                                break block54;
                            }
                            case 48: {
                                n3 = 10;
                                break block54;
                            }
                            case 16: {
                                n4 += 5;
                                break block54;
                            }
                            case 0: {
                                ++n4;
                                break block54;
                            }
                        }
                    }
                }
                n3 = CommonParsing.getPES_ExtensionLengthField(byArray, n4);
                if ((0x80 & byArray[7 + n4]) == 0) {
                    n4 += n3;
                    n3 = 0;
                }
                n4 += 3;
            }
            n2 -= n4 - n + n3;
            n4 += 6;
        }
        if (n3 > 0 && n2 >= 0) {
            this.pts = !bl ? jobProcessing.getPvaVideoPts() : CommonParsing.getPTSfromBytes(byArray, n4);
            this.pts -= jobProcessing.getNextFileStartPts();
            this.pts &= 0xFFFFFFFFL;
            if ((this.pts & 0xFF000000L) == 0xFF000000L) {
                this.ptsover = true;
            }
            if (this.ptsover && this.pts < 0xF0000000L) {
                this.pts |= 0x100000000L;
            }
            this.pts += this.ptsoffset;
            if (this.Debug) {
                System.out.println(" pdv PTS: " + this.pts);
            }
            this.isPTSwritten = false;
        }
        try {
            if (n2 <= 0) {
                Common.setMessage(Resource.getString("demux.error.video.payload") + " (" + this.pack + "/" + byArray.length + "/" + n4 + "/" + n3 + "/" + n2 + ")");
            } else {
                this.packet.write(byArray, n4 + n3, n2);
            }
            this.packet.flush();
            byArray2 = this.packet.toByteArray();
            this.packet.reset();
            boolean bl2 = false;
            boolean bl3 = true;
            int n5 = 0;
            int n6 = 0;
            while (n5 < byArray2.length - 3) {
                int n7 = CommonParsing.validateStartcode(byArray2, n5);
                if (n7 < 0) {
                    n5 += -n7 - 1;
                } else {
                    int n8 = CommonParsing.getPES_IdField(byArray2, n5);
                    if (!this.isPTSwritten && bl3 && n8 == 0) {
                        if (this.misshead && n5 < 3) {
                            this.misshead = false;
                        } else {
                            if (this.pts != -1L) {
                                this.vpts.writeLong(this.pts);
                                this.vpts.writeLong(this.vidbuf.size());
                                this.vpts.flush();
                            }
                            this.isPTSwritten = true;
                            bl3 = false;
                            n5 += 8;
                        }
                    } else if (n8 == 179 || n8 == 183 || n8 == 184) {
                        if (n8 == 179) {
                            this.seqhead = true;
                        }
                        if (n8 == 184 && this.seqhead && this.vidbuf.size() < 400) {
                            this.seqhead = false;
                        } else {
                            this.vidbuf.write(byArray2, n6, n5);
                            if (!this.first) {
                                jobProcessing.getGop().goptest(jobProcessing, this.out, this.vidbuf.toByteArray(), this.vptsbytes.toByteArray(), this.pts_log, this.parentname, this.MPGVideotype, list, list2);
                            }
                            this.vptsbytes.reset();
                            this.vidbuf.reset();
                            if (jobProcessing.getSplitSize() > 0L && jobProcessing.getSplitSize() < jobProcessing.getAllMediaFilesExportLength()) {
                                return;
                            }
                            if (this.SplitProjectFile && jobProcessing.getProjectFileExportLength() > jobProcessing.getProjectFileSplitSize()) {
                                int n9 = jobProcessing.getProjectFileD2V().getPart() + 1;
                                String string = this.parentname + "[" + n9 + "].mpv";
                                if (this.WriteVideo && this.AddSequenceEndcode && jobProcessing.getExportedVideoFrameNumber() > 0) {
                                    this.out.write(Video.getSequenceEndCode());
                                    jobProcessing.countMediaFilesExportLength(4L);
                                    jobProcessing.countAllMediaFilesExportLength(4L);
                                }
                                this.out.flush();
                                this.out.close();
                                this.out = new IDDBufferedOutputStream(new FileOutputStream(string), this.buffersize);
                                if (this.CreateM2sIndex) {
                                    this.out.InitIdd(string, 1);
                                }
                                jobProcessing.getProjectFileD2V().setFile(string);
                                jobProcessing.setProjectFileExportLength(0L);
                            }
                            if (!this.isPTSwritten && bl3) {
                                if (this.pts != -1L) {
                                    this.vpts.writeLong(this.pts);
                                    this.vpts.writeLong(this.vidbuf.size());
                                    this.vpts.flush();
                                }
                                this.isPTSwritten = true;
                            }
                            if (n8 != 183) {
                                this.vidbuf.write(byArray2, n5, byArray2.length - n5);
                                if (n8 == 184) {
                                    jobProcessing.setSequenceHeader(false);
                                    if (jobProcessing.getSplitPart() > 0) {
                                        this.first = false;
                                    }
                                } else if (n8 == 179) {
                                    jobProcessing.setSequenceHeader(true);
                                    this.first = false;
                                }
                                bl2 = true;
                                this.misshead = false;
                                break;
                            }
                            Common.setMessage(Resource.getString("demux.msg.skip.sec") + " " + nArray[6]);
                            this.first = true;
                            jobProcessing.setSequenceHeader(false);
                            n5 += 3;
                        }
                    }
                }
                ++n5;
            }
            if (!bl2) {
                if (byArray2.length > 2) {
                    this.vidbuf.write(byArray2, 0, byArray2.length - 3);
                    this.packet.write(byArray2, byArray2.length - 3, 3);
                    this.misshead = true;
                } else {
                    this.vidbuf.write(byArray2);
                }
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        if (this.vidbuf.size() > 6144000) {
            this.vptsbytes.reset();
            this.vidbuf.reset();
            this.packet.reset();
            Common.setMessage(Resource.getString("demux.error.gop.toobig"));
            this.misshead = false;
            this.first = true;
        }
    }

    private int writePacket(byte[] byArray) throws IOException {
        return this.writePacket(byArray, 0, byArray.length);
    }

    private int writePacket(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n >= byArray.length) {
            Common.setMessage("!> packet writing: index out of bounds, ignore it.. (" + Integer.toHexString(this.getPID()) + " / " + Integer.toHexString(this.getID()) + " / " + Integer.toHexString(this.getnewID()) + " / " + this.getPackCount() + " -- " + byArray.length + " / " + n + " / " + n2 + ") @ PTS " + Common.formatTime_1(this.lastPTS / 90L));
            return 0;
        }
        if (n + n2 > byArray.length) {
            Common.setMessage("!> packet writing: length index out of bounds, shortened.. (" + Integer.toHexString(this.getPID()) + " / " + Integer.toHexString(this.getID()) + " / " + Integer.toHexString(this.getnewID()) + " / " + this.getPackCount() + " -- " + byArray.length + " / " + n + " / " + n2 + ") @ PTS " + Common.formatTime_1(this.lastPTS / 90L));
            n2 = byArray.length - n;
        }
        this.out.write(byArray, n, n2);
        return n2;
    }
}

