/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxItemListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.TextFieldKeyListener;
import net.sourceforge.dvb.projectx.gui.TextFieldListener;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;

public class PreSettings
extends JFrame {
    private String title = Resource.getString("PreferencesPanel.Title");
    private final Color head_color = new Color(224, 224, 224);
    private ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    private ComboBoxItemListener _ComboBoxItemListener = new ComboBoxItemListener();
    private CheckBoxListener _CheckBoxListener = new CheckBoxListener();
    private TextFieldListener _TextFieldListener = new TextFieldListener();
    private TextFieldKeyListener _TextFieldKeyListener = new TextFieldKeyListener();

    public PreSettings() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreSettings.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.buildMenu();
        jPanel.add(this.buildTabPanel());
        this.getContentPane().add(jPanel);
        this.setTitle(this.title);
        this.setBounds(200, 100, 720, 400);
        this.setResizable(false);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    public void close() {
        this.dispose();
    }

    public void savePreferences() {
        String string = CommonGui.getUserInput(this, "save ini", "save inifile", Common.getSettings().getInifile());
        if (string != null && string.length() > 0) {
            Common.saveSettings(string);
        }
        this.toFront();
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.SaveAs");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreSettings.this.savePreferences();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem();
        CommonGui.localize(jMenuItem2, "Common.Close");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreSettings.this.close();
            }
        });
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected JPanel buildTabPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        JTabbedPane jTabbedPane = new JTabbedPane(2);
        jTabbedPane.addTab(Resource.getString("TabPanel.OptionPanel"), this.buildOptionPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.ExportPanel"), this.buildExportPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.SpecialPanel"), this.buildSpecialPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.VideoPanel"), this.buildVideoPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.AudioPanel"), this.buildAudioPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.SubtitlePanel"), this.buildSubtitlePanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.ExternPanel"), this.buildExternPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.NetPanel"), this.buildNetPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.PostCommandsPanel"), this.buildPostCommandsPanel());
        jTabbedPane.setSelectedIndex(0);
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    protected JPanel buildHeadPanel(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(this.head_color);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.add(new JLabel(" " + string));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "North");
        return jPanel3;
    }

    protected JPanel buildMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        return jPanel;
    }

    protected JPanel buildSpecialPanel() {
        String[][] stringArrayArray;
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("SpecialPanel.Title1")));
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_PVA_FileOverlap, Keys.KEY_PVA_Audio, Keys.KEY_VOB_resetPts, Keys.KEY_TS_ignoreScrambled, Keys.KEY_TS_blindSearch, Keys.KEY_TS_joinPackets, Keys.KEY_TS_HumaxAdaption, Keys.KEY_TS_FinepassAdaption, Keys.KEY_TS_generatePmt, Keys.KEY_TS_generateTtx, Keys.KEY_TS_setMainAudioAc3};
        int n = 0;
        while (n < stringArrayArray2.length) {
            jComponent = new JCheckBox(Resource.getString(stringArrayArray2[n][0]));
            jComponent.setToolTipText(Resource.getString(stringArrayArray2[n][0] + ".Tip"));
            jComponent.setPreferredSize(new Dimension(270, 20));
            jComponent.setMaximumSize(new Dimension(270, 20));
            ((AbstractButton)jComponent).setActionCommand(stringArrayArray2[n][0]);
            ((AbstractButton)jComponent).setSelected(Common.getSettings().getBooleanProperty(stringArrayArray2[n]));
            ((AbstractButton)jComponent).addActionListener(this._CheckBoxListener);
            if (n == 2 || n == 3) {
                jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
            }
            jPanel2.add(jComponent);
            ++n;
        }
        jComponent = new JComboBox<Object>(Keys.ITEMS_TsHeaderMode);
        jComponent.setPreferredSize(new Dimension(270, 20));
        jComponent.setMaximumSize(new Dimension(270, 20));
        ((JComboBox)jComponent).setActionCommand(Keys.KEY_TsHeaderMode[0]);
        ((JComboBox)jComponent).setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_TsHeaderMode));
        ((JComboBox)jComponent).addActionListener(this._ComboBoxIndexListener);
        jPanel2.add(jComponent);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Resource.getString("SpecialPanel.Title2")));
        JLabel jLabel = new JLabel(Resource.getString("SpecialPanel.PtsShift") + " ");
        jLabel.setToolTipText(Resource.getString("SpecialPanel.PtsShift.Tip"));
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_PtsShift);
        jComboBox.setPreferredSize(new Dimension(60, 20));
        jComboBox.setMaximumSize(new Dimension(60, 20));
        jComboBox.setEditable(true);
        jComboBox.setActionCommand(Keys.KEY_PtsShift_Value[0]);
        jComboBox.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_PtsShift_Value));
        jComboBox.addActionListener(this._ComboBoxItemListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jLabel);
        jPanel4.add(jComboBox);
        jPanel3.add(jPanel4);
        String[][] stringArrayArray3 = new String[][]{Keys.KEY_Input_getEnclosedPackets, Keys.KEY_Input_concatenateForeignRecords, Keys.KEY_Audio_ignoreErrors, Keys.KEY_Audio_limitPts, Keys.KEY_Video_ignoreErrors, Keys.KEY_Video_trimPts};
        int n2 = 0;
        while (n2 < stringArrayArray3.length) {
            stringArrayArray = new JCheckBox(Resource.getString(stringArrayArray3[n2][0]));
            stringArrayArray.setToolTipText(Resource.getString(stringArrayArray3[n2][0] + ".Tip"));
            stringArrayArray.setPreferredSize(new Dimension(270, 20));
            stringArrayArray.setMaximumSize(new Dimension(270, 20));
            stringArrayArray.setActionCommand(stringArrayArray3[n2][0]);
            stringArrayArray.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray3[n2]));
            stringArrayArray.addActionListener(this._CheckBoxListener);
            if (n2 == 2 || n2 == 4) {
                jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
            }
            jPanel3.add((Component)stringArrayArray);
            ++n2;
        }
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(new JLabel(Resource.getString("SpecialPanel.Conversion")));
        stringArrayArray = new String[][]{Keys.KEY_Conversion_startWithVideo};
        JCheckBox jCheckBox = new JCheckBox(Resource.getString(stringArrayArray[0][0]));
        jCheckBox.setToolTipText(Resource.getString(stringArrayArray[0][0] + ".Tip"));
        jCheckBox.setPreferredSize(new Dimension(270, 20));
        jCheckBox.setMaximumSize(new Dimension(270, 20));
        jCheckBox.setActionCommand(stringArrayArray[0][0]);
        jCheckBox.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[0]));
        jCheckBox.addActionListener(this._CheckBoxListener);
        jPanel3.add(jCheckBox);
        String[][] stringArrayArray4 = new String[][]{Keys.KEY_Conversion_addPcrToStream};
        JCheckBox jCheckBox2 = new JCheckBox(Resource.getString(stringArrayArray4[0][0]));
        jCheckBox2.setToolTipText(Resource.getString(stringArrayArray4[0][0] + ".Tip"));
        jCheckBox2.setPreferredSize(new Dimension(192, 20));
        jCheckBox2.setMaximumSize(new Dimension(192, 20));
        jCheckBox2.setActionCommand(stringArrayArray4[0][0]);
        jCheckBox2.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray4[0]));
        jCheckBox2.addActionListener(this._CheckBoxListener);
        String[][] stringArrayArray5 = new String[][]{Keys.KEY_Conversion_PcrCounter};
        JCheckBox jCheckBox3 = new JCheckBox(Resource.getString(stringArrayArray5[0][0]));
        jCheckBox3.setToolTipText(Resource.getString(stringArrayArray5[0][0] + ".Tip"));
        jCheckBox3.setPreferredSize(new Dimension(80, 20));
        jCheckBox3.setMaximumSize(new Dimension(80, 20));
        jCheckBox3.setActionCommand(stringArrayArray5[0][0]);
        jCheckBox3.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray5[0]));
        jCheckBox3.addActionListener(this._CheckBoxListener);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(jCheckBox2);
        jPanel5.add(jCheckBox3);
        jPanel3.add(jPanel5);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_PcrDelta);
        jComboBox2.setPreferredSize(new Dimension(60, 20));
        jComboBox2.setMaximumSize(new Dimension(60, 20));
        jComboBox2.setEditable(true);
        jComboBox2.setActionCommand(Keys.KEY_PcrDelta_Value[0]);
        jComboBox2.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_PcrDelta_Value));
        jComboBox2.addActionListener(this._ComboBoxItemListener);
        jPanel3.add(jComboBox2);
        jPanel.add(jPanel3);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.SpecialPanel"));
    }

    protected JPanel buildExportPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.SplitPanel")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_SplitSize, Keys.KEY_Streamtype_MpgVideo, Keys.KEY_Streamtype_MpgAudio, Keys.KEY_Streamtype_Ac3Audio, Keys.KEY_Streamtype_PcmAudio, Keys.KEY_Streamtype_Teletext, Keys.KEY_Streamtype_Subpicture, Keys.KEY_Streamtype_Vbi, Keys.KEY_WriteOptions_writeVideo, Keys.KEY_WriteOptions_writeAudio, Keys.KEY_additionalOffset, Keys.KEY_ExportPanel_Export_Overlap};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            ++n;
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_Export_SplitSize);
        jComboBox.setPreferredSize(new Dimension(100, 22));
        jComboBox.setMaximumSize(new Dimension(100, 22));
        jComboBox.setEditable(true);
        jComboBox.setActionCommand(Keys.KEY_ExportPanel_SplitSize_Value[0]);
        jComboBox.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_ExportPanel_SplitSize_Value));
        jComboBox.addActionListener(this._ComboBoxItemListener);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jCheckBoxArray[0]);
        jPanel3.add(jComboBox);
        jPanel2.add(jPanel3);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_Export_Overlap);
        jComboBox2.setPreferredSize(new Dimension(100, 22));
        jComboBox2.setMaximumSize(new Dimension(100, 22));
        jComboBox2.setActionCommand(Keys.KEY_ExportPanel_Overlap_Value[0]);
        jComboBox2.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_ExportPanel_Overlap_Value));
        jComboBox2.addActionListener(this._ComboBoxIndexListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jCheckBoxArray[11]);
        jPanel4.add(jComboBox2);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(new JLabel(Resource.getString("ExportPanel.WriteOptions.InfoScan")));
        JComboBox<Object> jComboBox3 = new JComboBox<Object>(Keys.ITEMS_Infoscan);
        jComboBox3.setPreferredSize(new Dimension(60, 22));
        jComboBox3.setMaximumSize(new Dimension(60, 22));
        jComboBox3.setEditable(true);
        jComboBox3.setActionCommand(Keys.KEY_ExportPanel_Infoscan_Value[0]);
        jComboBox3.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_ExportPanel_Infoscan_Value));
        jComboBox3.addActionListener(this._ComboBoxItemListener);
        jPanel5.add(jComboBox3);
        jPanel2.add(jPanel5);
        jPanel.add(jPanel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.StreamtypePanel")));
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setToolTipText(Resource.getString("ExportPanel.StreamtypePanel.Tip"));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new ColumnLayout());
        int n2 = 1;
        while (n2 < 5) {
            jPanel7.add(jCheckBoxArray[n2]);
            ++n2;
        }
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new ColumnLayout());
        int n3 = 5;
        while (n3 < 8) {
            jPanel8.add(jCheckBoxArray[n3]);
            ++n3;
        }
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel8);
        jPanel.add(jPanel6);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new ColumnLayout());
        jPanel9.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.WriteOptions")));
        jPanel9.setToolTipText(Resource.getString("ExportPanel.WriteOptions.Tip"));
        jPanel9.add(jCheckBoxArray[8]);
        jPanel9.add(jCheckBoxArray[9]);
        jPanel.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new ColumnLayout());
        jPanel10.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.additionalOffset.Title")));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        jPanel11.add(jCheckBoxArray[10]);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_ExportPanel_additionalOffset_Value));
        jTextField.setPreferredSize(new Dimension(80, 22));
        jTextField.setMaximumSize(new Dimension(80, 22));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_ExportPanel_additionalOffset_Value[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_ExportPanel_additionalOffset_Value[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel11.add(jTextField);
        jPanel10.add(jPanel11);
        jPanel.add(jPanel10);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.ExportPanel"));
    }

    protected JPanel buildVideoPanel() {
        Object object;
        JComponent jComponent;
        JComponent jComponent2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("VideoPanel.Title1")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_VideoPanel_addEndcode, Keys.KEY_VideoPanel_insertEndcode, Keys.KEY_VideoPanel_addSequenceHeader, Keys.KEY_VideoPanel_clearCDF, Keys.KEY_VideoPanel_patchToProgressive, Keys.KEY_VideoPanel_patchToInterlaced, Keys.KEY_VideoPanel_toggleFieldorder, Keys.KEY_VideoPanel_addSde};
        final JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            ++n;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                String string = jCheckBox.getActionCommand();
                if (string.equals(Keys.KEY_VideoPanel_patchToProgressive[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[5].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_VideoPanel_patchToInterlaced[0], false);
                    return;
                }
                if (string.equals(Keys.KEY_VideoPanel_patchToInterlaced[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[4].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_VideoPanel_patchToProgressive[0], false);
                    return;
                }
            }
        };
        jCheckBoxArray[4].addActionListener(actionListener);
        jCheckBoxArray[5].addActionListener(actionListener);
        int n2 = 0;
        while (n2 < 7) {
            jPanel2.add(jCheckBoxArray[n2]);
            ++n2;
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jCheckBoxArray[7].setPreferredSize(new Dimension(180, 20));
        jCheckBoxArray[7].setMaximumSize(new Dimension(180, 20));
        jPanel3.add(jCheckBoxArray[7]);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_VideoPanel_SdeValue));
        jTextField.setPreferredSize(new Dimension(80, 20));
        jTextField.setMaximumSize(new Dimension(80, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_VideoPanel_SdeValue[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_VideoPanel_SdeValue[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel3.add(jTextField);
        jPanel2.add(jPanel3);
        jPanel2.add(new JLabel(Resource.getString("VideoPanel.patchResolution")));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setToolTipText(Resource.getString("VideoPanel.patchResolution.Tip"));
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_ConditionalHorizontalPatch);
        jComboBox.setPreferredSize(new Dimension(160, 20));
        jComboBox.setMaximumSize(new Dimension(160, 20));
        jComboBox.setActionCommand(Keys.KEY_ConditionalHorizontalPatch[0]);
        jComboBox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_ConditionalHorizontalPatch));
        jComboBox.addActionListener(this._ComboBoxIndexListener);
        jPanel4.add(jComboBox);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_ExportHorizontalResolution);
        jComboBox2.setPreferredSize(new Dimension(50, 20));
        jComboBox2.setMaximumSize(new Dimension(50, 20));
        jComboBox2.setActionCommand(Keys.KEY_ConditionalHorizontalResolution[0]);
        jComboBox2.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_ConditionalHorizontalResolution));
        jComboBox2.addActionListener(this._ComboBoxItemListener);
        jPanel4.add(jComboBox2);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new ColumnLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(Resource.getString("VideoPanel.Title1")));
        String[] stringArray = new String[]{Resource.getString("VideoPanel.ChangeVbvBuffer"), Resource.getString("VideoPanel.ChangeVbvDelay"), Resource.getString("VideoPanel.ChangeAspectRatio")};
        Object[][] objectArrayArray = new Object[][]{Keys.ITEMS_ChangeVbvBuffer, Keys.ITEMS_ChangeVbvDelay, Keys.ITEMS_ChangeAspectRatio};
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_ChangeVbvBuffer, Keys.KEY_ChangeVbvDelay, Keys.KEY_ChangeAspectRatio};
        int n3 = 0;
        while (n3 < stringArrayArray2.length) {
            jComponent2 = new JLabel(stringArray[n3]);
            jComponent2.setPreferredSize(new Dimension(120, 20));
            jComponent2.setMaximumSize(new Dimension(120, 20));
            jComponent = new JComboBox<Object>(objectArrayArray[n3]);
            jComponent.setPreferredSize(new Dimension(150, 20));
            jComponent.setMaximumSize(new Dimension(150, 20));
            ((JComboBox)jComponent).setActionCommand(stringArrayArray2[n3][0]);
            ((JComboBox)jComponent).setSelectedIndex(Common.getSettings().getIntProperty(stringArrayArray2[n3]));
            ((JComboBox)jComponent).addActionListener(this._ComboBoxIndexListener);
            object = new JPanel();
            ((Container)object).setLayout(new BoxLayout((Container)object, 0));
            ((JComponent)object).setToolTipText(stringArray[n3] + ".Tip");
            ((Container)object).add(jComponent2);
            ((Container)object).add(jComponent);
            jPanel2.add((Component)object);
            ++n3;
        }
        jPanel.add(jPanel2);
        jComponent2 = new JPanel();
        jComponent2.setLayout(new GridLayout(2, 1));
        jComponent = new JPanel();
        jComponent.setLayout(new ColumnLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder(Resource.getString("VideoPanel.Title2")));
        object = new String[]{Resource.getString("VideoPanel.patchBitrateValue"), Resource.getString("VideoPanel.patch1stBitrateValue")};
        Object[][] objectArrayArray2 = new Object[][]{Keys.ITEMS_BitrateInAllSequences, Keys.ITEMS_BitrateInFirstSequence};
        String[][] stringArrayArray3 = new String[][]{Keys.KEY_ChangeBitrateInAllSequences, Keys.KEY_ChangeBitrateInFirstSequence};
        int n4 = 0;
        while (n4 < stringArrayArray3.length) {
            JLabel jLabel = new JLabel((String)object[n4]);
            jLabel.setPreferredSize(new Dimension(270, 20));
            jLabel.setMaximumSize(new Dimension(270, 20));
            jLabel.setToolTipText((String)object[n4] + ".Tip");
            JComboBox<Object> jComboBox3 = new JComboBox<Object>(objectArrayArray2[n4]);
            jComboBox3.setPreferredSize(new Dimension(270, 20));
            jComboBox3.setMaximumSize(new Dimension(270, 20));
            jComboBox3.setActionCommand(stringArrayArray3[n4][0]);
            jComboBox3.setSelectedIndex(Common.getSettings().getIntProperty(stringArrayArray3[n4]));
            jComboBox3.addActionListener(this._ComboBoxIndexListener);
            jComponent.add(jLabel);
            jComponent.add(jComboBox3);
            ++n4;
        }
        jComponent2.add(jComponent);
        jPanel.add(jComponent2);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.VideoPanel"));
    }

    protected JPanel buildExternPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExternPanel.Title1")));
        jPanel2.setToolTipText(Resource.getString("ExternPanel.Title1.Tip"));
        String[][] stringArrayArray = new String[][]{Keys.KEY_ExternPanel_createVdrIndex, Keys.KEY_ExternPanel_createCellTimes, Keys.KEY_ExternPanel_exportPts, Keys.KEY_ExternPanel_createChapters, Keys.KEY_ExternPanel_renameAudio, Keys.KEY_ExternPanel_renameVideo, Keys.KEY_ExternPanel_appendExtension, Keys.KEY_ExternPanel_createM2sIndex, Keys.KEY_ExternPanel_createD2vIndex, Keys.KEY_ExternPanel_createDgiIndex, Keys.KEY_ExternPanel_splitProjectFile};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            if (n == 9) {
                jCheckBoxArray[n].setEnabled(false);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 7) {
            jPanel2.add(jCheckBoxArray[n2]);
            ++n2;
        }
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExternPanel.Title2")));
        jPanel3.setToolTipText(Resource.getString("ExternPanel.Title2.Tip"));
        jPanel3.add(new JLabel(Resource.getString("ExternPanel.createM2sIndex")));
        jPanel3.add(jCheckBoxArray[7]);
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(new JLabel(Resource.getString("ExternPanel.createD2vIndex")));
        int n3 = 8;
        while (n3 < stringArrayArray.length) {
            jPanel3.add(jCheckBoxArray[n3]);
            ++n3;
        }
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_ExternPanel_ProjectFileSplitSize));
        jTextField.setPreferredSize(new Dimension(70, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_ExternPanel_ProjectFileSplitSize[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_ExternPanel_ProjectFileSplitSize[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("ExternPanel.ProjectFileSplitSize"));
        jPanel4.add(jLabel);
        jPanel4.add(jTextField);
        jPanel3.add(jPanel4);
        jPanel.add(jPanel3);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.ExternPanel"));
    }

    protected JPanel buildAudioPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("AudioPanel.Title1")));
        jPanel2.add(new JLabel(Resource.getString("AudioPanel.loslessMpaConversion.Tip1")));
        jPanel2.add(new JLabel(Resource.getString("AudioPanel.loslessMpaConversion.Tip2")));
        jPanel2.setToolTipText(Resource.getString("AudioPanel.loslessMpaConversion.Tip"));
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_loslessMpaConversionMode);
        jComboBox.setPreferredSize(new Dimension(270, 20));
        jComboBox.setMaximumSize(new Dimension(270, 20));
        jComboBox.setActionCommand(Keys.KEY_AudioPanel_loslessMpaConversionMode[0]);
        jComboBox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_AudioPanel_loslessMpaConversionMode));
        jComboBox.addActionListener(this._ComboBoxIndexListener);
        jPanel2.add(jComboBox);
        jPanel2.add(new JLabel(" "));
        String[][] stringArrayArray = new String[][]{Keys.KEY_AudioPanel_decodeMpgAudio, Keys.KEY_AudioPanel_Normalize, Keys.KEY_AudioPanel_Downmix, Keys.KEY_AudioPanel_changeByteorder, Keys.KEY_AudioPanel_addRiffHeader, Keys.KEY_AudioPanel_addAiffHeader, Keys.KEY_AudioPanel_validateCRC, Keys.KEY_AudioPanel_clearCRC, Keys.KEY_AudioPanel_fillGapsWithLastFrame, Keys.KEY_AudioPanel_addFrames, Keys.KEY_AudioPanel_patch1stAc3Header, Keys.KEY_AudioPanel_replaceAc3withSilence, Keys.KEY_AudioPanel_allowSpaces, Keys.KEY_AudioPanel_addRiffToMpgAudio, Keys.KEY_AudioPanel_addRiffToMpgAudioL3, Keys.KEY_AudioPanel_addRiffToAc3, Keys.KEY_AudioPanel_createDDWave};
        final JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            ++n;
        }
        jPanel2.add(jCheckBoxArray[0]);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_resampleAudioMode);
        jComboBox2.setPreferredSize(new Dimension(270, 20));
        jComboBox2.setMaximumSize(new Dimension(270, 20));
        jComboBox2.setActionCommand(Keys.KEY_AudioPanel_resampleAudioMode[0]);
        jComboBox2.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_AudioPanel_resampleAudioMode));
        jComboBox2.addActionListener(this._ComboBoxIndexListener);
        jPanel2.add(jComboBox2);
        final JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_AudioPanel_NormalizeValue));
        jTextField.setPreferredSize(new Dimension(50, 20));
        jTextField.setMaximumSize(new Dimension(50, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_AudioPanel_NormalizeValue[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_AudioPanel_NormalizeValue[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                if (string.length() == 0) {
                    jTextField.setText("98");
                    return;
                }
                try {
                    int n = Integer.parseInt(string);
                    if (n > 100 || n < 0) {
                        n = 98;
                    }
                    jTextField.setText("" + n);
                }
                catch (Exception exception) {
                    jTextField.setText("98");
                }
            }
        });
        jCheckBoxArray[1].setPreferredSize(new Dimension(180, 20));
        jCheckBoxArray[1].setMaximumSize(new Dimension(180, 20));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jCheckBoxArray[1]);
        jPanel3.add(jTextField);
        jPanel2.add(jPanel3);
        int n2 = 2;
        while (n2 < 6) {
            jPanel2.add(jCheckBoxArray[n2]);
            ++n2;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                String string = jCheckBox.getActionCommand();
                if (string.equals(Keys.KEY_AudioPanel_changeByteorder[0]) && Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader)) {
                    jCheckBoxArray[3].setSelected(true);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_changeByteorder[0], true);
                    return;
                }
                if (string.equals(Keys.KEY_AudioPanel_addRiffHeader[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[5].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader[0], false);
                    return;
                }
                if (string.equals(Keys.KEY_AudioPanel_addAiffHeader[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[3].setSelected(true);
                    jCheckBoxArray[4].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_changeByteorder[0], true);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addRiffHeader[0], false);
                    return;
                }
            }
        };
        jCheckBoxArray[3].addActionListener(actionListener);
        jCheckBoxArray[4].addActionListener(actionListener);
        jCheckBoxArray[5].addActionListener(actionListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Resource.getString("AudioPanel.Title2")));
        int n3 = 6;
        while (n3 < stringArrayArray.length) {
            if (n3 == 13 || n3 == 16) {
                jPanel4.add(Box.createRigidArea(new Dimension(1, 10)));
            }
            jPanel4.add(jCheckBoxArray[n3]);
            ++n3;
        }
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                String string = jCheckBox.getActionCommand();
                if (string.equals(Keys.KEY_AudioPanel_addRiffToMpgAudioL3[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[14].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudio[0], false);
                    return;
                }
                if (string.equals(Keys.KEY_AudioPanel_addRiffToMpgAudio[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[15].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudioL3[0], false);
                    return;
                }
            }
        };
        jCheckBoxArray[14].addActionListener(actionListener2);
        jCheckBoxArray[15].addActionListener(actionListener2);
        jPanel.add(jPanel2);
        jPanel.add(jPanel4);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.AudioPanel"));
    }

    protected JPanel buildSubtitlePanel() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("SubtitlePanel.Title.Teletext")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_SubtitlePanel_decodeMegaradio, Keys.KEY_SubtitlePanel_decodeHiddenRows, Keys.KEY_SubtitlePanel_rebuildPTS, Keys.KEY_SubtitlePanel_keepOriginalTimecode, Keys.KEY_SubtitlePanel_exportTextAsUnicode, Keys.KEY_SubtitlePanel_specialTermination, Keys.KEY_SubtitlePanel_useTextOutline};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(260, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(260, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            ++n;
        }
        jPanel2.add(jCheckBoxArray[0]);
        jPanel2.add(jCheckBoxArray[1]);
        jPanel2.add(jCheckBoxArray[2]);
        jPanel2.add(jCheckBoxArray[3]);
        jPanel2.add(jCheckBoxArray[4]);
        jPanel2.add(jCheckBoxArray[5]);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JLabel jLabel = new JLabel(Resource.getString("SubtitlePanel.TtxPages"));
        jLabel.setToolTipText(Resource.getString("SubtitlePanel.TtxPages.Tip"));
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_SubtitlePanel_TtxPage1, Keys.KEY_SubtitlePanel_TtxPage2, Keys.KEY_SubtitlePanel_TtxPage3, Keys.KEY_SubtitlePanel_TtxPage4, Keys.KEY_SubtitlePanel_TtxPage5, Keys.KEY_SubtitlePanel_TtxPage6};
        Object[] objectArray = new Object[]{"null", "149", "150", "199", "299", "599", "691", "692", "693", "694", "699", "777", "779", "784", "785", "786", "881", "882", "884", "885", "886", "887", "888", "889"};
        int n2 = 0;
        while (n2 < stringArrayArray2.length) {
            jComponent = new JComboBox<Object>(objectArray);
            jComponent.setPreferredSize(new Dimension(73, 22));
            jComponent.setMaximumSize(new Dimension(73, 22));
            ((JComboBox)jComponent).setEditable(true);
            ((JComboBox)jComponent).setActionCommand(stringArrayArray2[n2][0]);
            ((JComboBox)jComponent).setSelectedItem(Common.getSettings().getProperty(stringArrayArray2[n2]));
            ((JComboBox)jComponent).addActionListener(this._ComboBoxItemListener);
            if (n2 < 3) {
                jPanel3.add(jComponent);
            } else {
                jPanel4.add(jComponent);
            }
            ++n2;
        }
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 0));
        JLabel jLabel2 = new JLabel(Resource.getString("SubtitlePanel.Language"));
        jLabel2.setToolTipText(Resource.getString("SubtitlePanel.Language.Tip"));
        jLabel2.setPreferredSize(new Dimension(80, 22));
        jLabel2.setMaximumSize(new Dimension(80, 22));
        jComponent.add(jLabel2);
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_TtxLanguagePair);
        jComboBox.setPreferredSize(new Dimension(140, 22));
        jComboBox.setMaximumSize(new Dimension(140, 22));
        jComboBox.setActionCommand(Keys.KEY_TtxLanguagePair[0]);
        jComboBox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_TtxLanguagePair));
        jComboBox.addActionListener(this._ComboBoxIndexListener);
        jComponent.add(jComboBox);
        jPanel2.add(jComponent);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setToolTipText(Resource.getString("SubtitlePanel.Format.Tip"));
        jPanel5.add(new JLabel("1. " + Resource.getString("SubtitlePanel.Format")));
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_SubtitleExportFormat);
        jComboBox2.setPreferredSize(new Dimension(80, 22));
        jComboBox2.setMaximumSize(new Dimension(80, 22));
        jComboBox2.setActionCommand(Keys.KEY_SubtitleExportFormat[0]);
        jComboBox2.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubtitleExportFormat));
        jComboBox2.addActionListener(this._ComboBoxItemListener);
        jPanel5.add(jComboBox2);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setToolTipText(Resource.getString("SubtitlePanel.Format.Tip"));
        jPanel6.add(new JLabel("2. " + Resource.getString("SubtitlePanel.Format")));
        JComboBox<Object> jComboBox3 = new JComboBox<Object>(Keys.ITEMS_SubtitleExportFormat);
        jComboBox3.setPreferredSize(new Dimension(80, 22));
        jComboBox3.setMaximumSize(new Dimension(80, 22));
        jComboBox3.setActionCommand(Keys.KEY_SubtitleExportFormat_2[0]);
        jComboBox3.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubtitleExportFormat_2));
        jComboBox3.addActionListener(this._ComboBoxItemListener);
        jComboBox3.setEnabled(false);
        jPanel6.add(jComboBox3);
        jPanel2.add(jPanel6);
        jPanel.add(jPanel2);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new ColumnLayout());
        jPanel7.setBorder(BorderFactory.createTitledBorder(Resource.getString("SubtitlePanel.Title")));
        jPanel7.add(new JLabel(Resource.getString("SubtitlePanel.Title.Teletext")));
        jPanel7.add(jCheckBoxArray[6]);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        JLabel jLabel3 = new JLabel(Resource.getString("SubtitlePanel.Font"));
        jLabel3.setToolTipText(Resource.getString("SubtitlePanel.Font.Tip"));
        jLabel3.setPreferredSize(new Dimension(100, 22));
        jLabel3.setMaximumSize(new Dimension(100, 22));
        jPanel8.add(jLabel3);
        JComboBox<Object> jComboBox4 = new JComboBox<Object>(Common.getFonts());
        jComboBox4.setPreferredSize(new Dimension(150, 22));
        jComboBox4.setMaximumSize(new Dimension(150, 22));
        jComboBox4.setActionCommand(Keys.KEY_SubtitleFont[0]);
        jComboBox4.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubtitleFont));
        jComboBox4.addActionListener(this._ComboBoxItemListener);
        jPanel8.add(jComboBox4);
        jPanel7.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        JLabel jLabel4 = new JLabel(Resource.getString("SubtitlePanel.SupValues"));
        jLabel4.setPreferredSize(new Dimension(60, 22));
        jLabel4.setMaximumSize(new Dimension(60, 22));
        jPanel9.add(jLabel4);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_SubtitlePanel_Format_SUP_Values));
        jTextField.setPreferredSize(new Dimension(190, 22));
        jTextField.setMaximumSize(new Dimension(190, 22));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_SubtitlePanel_Format_SUP_Values[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_SubtitlePanel_Format_SUP_Values[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel9.add(jTextField);
        jPanel7.add(jPanel9);
        jPanel7.add(Box.createRigidArea(new Dimension(1, 20)));
        JLabel jLabel5 = new JLabel(Resource.getString("SubtitlePanel.Colormodel"));
        jLabel5.setToolTipText(Resource.getString("SubtitlePanel.Colormodel.Tip"));
        jPanel7.add(jLabel5);
        JComboBox<Object> jComboBox5 = new JComboBox<Object>(Common.getColorModels());
        jComboBox5.setPreferredSize(new Dimension(130, 22));
        jComboBox5.setMaximumSize(new Dimension(130, 22));
        jComboBox5.setActionCommand(Keys.KEY_SubpictureColorModel[0]);
        jComboBox5.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubpictureColorModel));
        jComboBox5.addActionListener(this._ComboBoxItemListener);
        jPanel7.add(jComboBox5);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        jPanel10.add(new JLabel(Resource.getString("SubtitlePanel.PageId")));
        JTextField jTextField2 = new JTextField(Common.getSettings().getProperty(Keys.KEY_SubtitlePanel_PageId_Value));
        jTextField2.setPreferredSize(new Dimension(40, 20));
        jTextField2.setMaximumSize(new Dimension(100, 20));
        jTextField2.setToolTipText(Resource.getString(Keys.KEY_SubtitlePanel_PageId_Value[0] + ".Tip"));
        jTextField2.setEditable(true);
        jTextField2.setActionCommand(Keys.KEY_SubtitlePanel_PageId_Value[0]);
        jTextField2.addActionListener(this._TextFieldListener);
        jTextField2.addKeyListener(this._TextFieldKeyListener);
        jPanel10.add(jTextField2);
        jPanel7.add(jPanel10);
        jPanel.add(jPanel7);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.SubtitlePanel"));
    }

    protected JPanel buildOptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("OptionPanel.Various.Title")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_dumpDroppedGop, Keys.KEY_holdStreamInfoOnOSD};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            jPanel2.add(jCheckBoxArray[n]);
            ++n;
        }
        jPanel2.add(Box.createRigidArea(new Dimension(1, 4)));
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_StartPath_Value));
        jTextField.setPreferredSize(new Dimension(250, 25));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_StartPath_Value[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_StartPath_Value[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel2.add(new JLabel(Resource.getString("OptionPanel.StartPath")));
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Resource.getString("OptionPanel.Buffer.Title")));
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_MainBuffer, Keys.KEY_ScanBuffer, Keys.KEY_PreviewBuffer};
        Object[][] objectArrayArray = new Object[][]{{"10240000", "8192000", "7168000", "6144000", "5120000", "4096000", "3072000", "2048000", "1024000"}, {"384000", "512000", "1024000", "1536000", "2048000", "2560000", "3072000"}, {"256000", "384000", "512000", "768000", "1024000", "1536000", "2048000", "2560000", "3072000"}};
        int n2 = 0;
        while (n2 < stringArrayArray2.length) {
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArrayArray[n2]);
            jComboBox.setPreferredSize(new Dimension(100, 24));
            jComboBox.setMaximumSize(new Dimension(100, 24));
            jComboBox.setEditable(true);
            jComboBox.setMaximumRowCount(6);
            jComboBox.setActionCommand(stringArrayArray2[n2][0]);
            jComboBox.setSelectedItem(Common.getSettings().getProperty(stringArrayArray2[n2]));
            jComboBox.addActionListener(this._ComboBoxItemListener);
            JLabel jLabel = new JLabel(Resource.getString(stringArrayArray2[n2][0]));
            jLabel.setToolTipText(Resource.getString(stringArrayArray2[n2][0] + ".Tip"));
            jPanel3.add(jLabel);
            jPanel3.add(jComboBox);
            ++n2;
        }
        jPanel.add(jPanel3);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.OptionPanel"));
    }

    protected JPanel buildNetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("FtpPanel.Title")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_killFtpClient, Keys.KEY_useFtpServerResume, Keys.KEY_autostartWebServer};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        int n = 0;
        while (n < 2) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            jPanel2.add(jCheckBoxArray[n]);
            ++n;
        }
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JLabel jLabel = new JLabel(Resource.getString("ftp.command.label"));
        jLabel.setPreferredSize(new Dimension(100, 20));
        jLabel.setMaximumSize(new Dimension(100, 20));
        jLabel.setToolTipText(Resource.getString("ftp.command.tip"));
        jPanel3.add(jLabel);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_FtpServer_Commands));
        jTextField.setPreferredSize(new Dimension(160, 20));
        jTextField.setMaximumSize(new Dimension(160, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_FtpServer_Commands[0] + ".Tip"));
        jTextField.setActionCommand(Keys.KEY_FtpServer_Commands[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel3.add(jTextField);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Resource.getString("NetPanel.Title")));
        int n2 = 2;
        while (n2 < stringArrayArray.length) {
            jCheckBoxArray[n2] = new JCheckBox(Resource.getString(stringArrayArray[n2][0]));
            jCheckBoxArray[n2].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[n2].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[n2].setToolTipText(Resource.getString(stringArrayArray[n2][0] + ".Tip"));
            jCheckBoxArray[n2].setActionCommand(stringArrayArray[n2][0]);
            jCheckBoxArray[n2].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n2]));
            jCheckBoxArray[n2].addActionListener(this._CheckBoxListener);
            jPanel4.add(jCheckBoxArray[n2]);
            ++n2;
        }
        jPanel4.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JLabel jLabel2 = new JLabel("Port:");
        jLabel2.setPreferredSize(new Dimension(100, 20));
        jLabel2.setMaximumSize(new Dimension(100, 20));
        jPanel5.add(jLabel2);
        JTextField jTextField2 = new JTextField(Common.getSettings().getProperty(Keys.KEY_WebServerPort));
        jTextField2.setPreferredSize(new Dimension(160, 20));
        jTextField2.setMaximumSize(new Dimension(160, 20));
        jTextField2.setToolTipText(Resource.getString(Keys.KEY_WebServerPort[0] + ".Tip"));
        jTextField2.setActionCommand(Keys.KEY_WebServerPort[0]);
        jTextField2.addActionListener(this._TextFieldListener);
        jTextField2.addKeyListener(this._TextFieldKeyListener);
        jPanel5.add(jTextField2);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        JLabel jLabel3 = new JLabel("Keyword:");
        jLabel3.setPreferredSize(new Dimension(100, 20));
        jLabel3.setMaximumSize(new Dimension(100, 20));
        jLabel3.setToolTipText("mustn't be empty");
        jPanel6.add(jLabel3);
        JTextField jTextField3 = new JTextField(Common.getSettings().getProperty(Keys.KEY_WebServerAccess));
        jTextField3.setPreferredSize(new Dimension(160, 20));
        jTextField3.setMaximumSize(new Dimension(160, 20));
        jTextField3.setToolTipText(Resource.getString(Keys.KEY_WebServerAccess[0] + ".Tip"));
        jTextField3.setActionCommand(Keys.KEY_WebServerAccess[0]);
        jTextField3.addActionListener(this._TextFieldListener);
        jTextField3.addKeyListener(this._TextFieldKeyListener);
        jPanel6.add(jTextField3);
        jPanel4.add(jPanel6);
        JButton jButton = new JButton("re-/start WebIF");
        jButton.setPreferredSize(new Dimension(120, 22));
        jButton.setMaximumSize(new Dimension(120, 22));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.startWebServer();
            }
        });
        JButton jButton2 = new JButton("stop WebIF");
        jButton2.setPreferredSize(new Dimension(120, 22));
        jButton2.setMaximumSize(new Dimension(120, 22));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.stopWebServer();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add(jPanel4);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.NetPanel"));
    }

    protected JPanel buildPostCommandsPanel() {
        JComponent jComponent;
        JComponent jComponent2;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    String string2 = "";
                    if (string.equals(Keys.KEY_PostCommands_Cmd1[0])) {
                        string2 = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd1);
                    } else if (string.equals(Keys.KEY_PostCommands_Cmd2[0])) {
                        string2 = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd2);
                    } else if (string.equals(Keys.KEY_PostCommands_Cmd3[0])) {
                        string2 = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd3);
                    }
                    Common.performCommand(string2);
                }
                catch (Exception exception) {
                    Common.setExceptionMessage(exception);
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("PostCommands.Title")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_PostCommands_Cmd1, Keys.KEY_PostCommands_Cmd2, Keys.KEY_PostCommands_Cmd3, Keys.KEY_PostCommands_Cmd4, Keys.KEY_PostCommands_Cmd5, Keys.KEY_PostCommands_Cmd6, Keys.KEY_PostCommands_Cmd7, Keys.KEY_PostCommands_Cmd8};
        int n = 0;
        while (n < 3) {
            jComponent2 = new JTextField(Common.getSettings().getProperty(stringArrayArray[n]));
            jComponent2.setPreferredSize(new Dimension(400, 25));
            ((JTextComponent)jComponent2).setEditable(true);
            ((JTextField)jComponent2).setActionCommand(stringArrayArray[n][0]);
            ((JTextField)jComponent2).addActionListener(this._TextFieldListener);
            jComponent2.addKeyListener(this._TextFieldKeyListener);
            JButton jButton = new JButton(Resource.getString("PostCommands.Execute"));
            jButton.setActionCommand(stringArrayArray[n][0]);
            jButton.setPreferredSize(new Dimension(100, 20));
            jButton.addActionListener(actionListener);
            jComponent = new JPanel();
            jComponent.setLayout(new BoxLayout(jComponent, 0));
            jComponent.add(jComponent2);
            jComponent.add(jButton);
            jPanel.add(jComponent);
            ++n;
        }
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        jComponent2 = new JLabel(Resource.getString("PostCommands.PostProcessing"));
        jComponent2.setToolTipText(Resource.getString("PostCommands.PostProcessing.Tip"));
        jPanel.add(jComponent2);
        int n2 = 3;
        while (n2 < stringArrayArray.length) {
            jComponent = new JTextField(Common.getSettings().getProperty(stringArrayArray[n2]));
            jComponent.setPreferredSize(new Dimension(400, 25));
            ((JTextComponent)jComponent).setEditable(true);
            ((JTextField)jComponent).setActionCommand(stringArrayArray[n2][0]);
            ((JTextField)jComponent).addActionListener(this._TextFieldListener);
            jComponent.addKeyListener(this._TextFieldKeyListener);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(jComponent);
            jPanel2.add(new JLabel(Keys.ITEMS_ConversionMode[n2 - 3].toString()));
            jPanel.add(jPanel2);
            ++n2;
        }
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.PostCommandsPanel"));
    }
}

