/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class Start {
    private static ArrayList cli_switches = new ArrayList();

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = stringArray.length == 0;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = -1;
        String string = null;
        String string2 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            cli_switches.add(stringArray[n2]);
            ++n2;
        }
        try {
            if (Start.getBooleanSwitch("-version")) {
                System.out.println("Version: " + Common.getVersionName() + "/" + Common.getVersionDate());
            }
            System.out.println("Reading GUI-Switch...");
            if (Start.getBooleanSwitch("-gui")) {
                bl2 = true;
            }
            System.out.println("Reading Help Switch...");
            if (Start.getBooleanSwitch("-?")) {
                bl3 = true;
            }
            System.out.println("Reading Config File Switch...");
            n = Start.getSwitch("-ini");
            if (n >= 0) {
                bl4 = false;
                if (n < cli_switches.size()) {
                    string2 = cli_switches.get(n).toString();
                    if (new File(string2).exists()) {
                        string = string2;
                        bl = true;
                    } else {
                        bl4 = true;
                    }
                    cli_switches.remove(n);
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    System.out.println("stopped, config file '" + string + "' not found ...");
                    System.exit(1);
                }
            }
            System.out.println(bl2 ? "Start with GUI..." : "Start without GUI...");
            if (!bl) {
                System.out.println("Loading last Config or Standard File...");
                Common.setSettings();
            } else {
                System.out.println("Loading Config File: '" + string + "' ...");
                Common.setSettings(string);
            }
            Resource.loadLang(Common.getSettings().getProperty(Keys.KEY_Language));
            Common.getSettings().setProperty(Keys.KEY_Language[0], Resource.getChosenLanguage());
            System.out.println("Loading Language -> '" + Resource.getChosenLanguage() + "'");
            if (stringArray.length != 0) {
                Common.getSettings().setProperty(Keys.KEY_SaveSettingsOnExit[0], "0");
            }
            String[] stringArray2 = Common.getVersion();
            System.out.println();
            System.out.println(stringArray2[0] + "/" + stringArray2[1] + " " + stringArray2[2] + " " + stringArray2[3]);
            System.out.println();
            System.out.println(Resource.getString("terms"));
            Object[] objectArray = Common.getJavaEV(Common.getSettings().getInifile());
            int n3 = 0;
            while (n3 < objectArray.length) {
                System.out.println(objectArray[n3].toString());
                ++n3;
            }
            System.out.println();
            System.out.println(Resource.getString("usage"));
            System.out.println();
            if (bl3) {
                Common.exitApplication(0);
            }
            System.out.println("Loading Basic Classes...");
            Common.init();
            System.out.println("Reading CLI Switches...");
            if (Start.readSwitches(cli_switches)) {
                System.out.println("Error while reading CLI Switches ...");
            }
            Common.prepareGui(bl2);
            System.out.println("Checking Commons-Net library access...");
            string2 = Common.checkLibraryAccess();
            if (string2 != null) {
                throw new Exception(string2);
            }
            System.out.println("Loading AC3 frames...");
            Common.loadAC3();
            if (Common.getSettings().getBooleanProperty(Keys.KEY_autostartWebServer)) {
                Common.startWebServer();
            }
            if (!bl2) {
                if (!Common.getSettings().getBooleanProperty(Keys.KEY_autostartWebServer)) {
                    if (Common.isCollectionListEmpty()) {
                        System.out.println("Error: No Collection to Process ...");
                        Common.exitApplication(2);
                    }
                    System.out.println("Starting Collection Process...");
                    Common.setRunningCLI(true);
                    Common.setRunningProcess(true);
                    Common.startMainProcess();
                } else {
                    System.out.println("Starting WebIF...");
                }
            } else if (!Common.getGuiInterface().isAvailable()) {
                System.out.println("Stopped! Can't start GUI, Classes not available...");
            } else if (!Common.isCollectionListEmpty()) {
                Common.getGuiInterface().addCollectionAtEnd();
                Common.getGuiInterface().showActiveCollection(0);
            }
        }
        catch (Exception exception) {
            if (bl2) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                Common.getGuiInterface().showErrorMessageDialog(Resource.getString("StartUp.Error") + Common.getLineSeparator() + Common.getLineSeparator() + stringWriter.toString(), Resource.getString("StartUp.Error.Title"));
            } else {
                System.out.println("Stopped! An Error has occured...");
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }

    private static JobCollection createCollection(JobCollection jobCollection) {
        if (jobCollection == null) {
            jobCollection = Common.addCollection(false);
            Common.setActiveCollection(0);
        }
        return jobCollection;
    }

    private static boolean getBooleanSwitch(String string) {
        return Start.getSwitch(string) >= 0;
    }

    private static int getSwitch(String string) {
        int n = cli_switches.indexOf(string);
        if (n >= 0) {
            cli_switches.remove(n);
        }
        return n;
    }

    private static boolean readSwitches(ArrayList arrayList) {
        JobCollection jobCollection = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        int n = -1;
        try {
            int n2;
            if (Start.getBooleanSwitch("-dvx1")) {
                Common.getSettings().setProperty(Keys.KEY_ExternPanel_splitProjectFile[0], "1");
            }
            if (Start.getBooleanSwitch("-dvx2")) {
                Common.getSettings().setProperty(Keys.KEY_ExternPanel_splitProjectFile[0], "1");
                Common.getSettings().setProperty(Keys.KEY_AudioPanel_addRiffToAc3[0], "1");
            }
            if (Start.getBooleanSwitch("-dvx3")) {
                Common.getSettings().setProperty(Keys.KEY_ExternPanel_splitProjectFile[0], "1");
                Common.getSettings().setProperty(Keys.KEY_AudioPanel_addRiffToMpgAudio[0], "1");
            }
            if (Start.getBooleanSwitch("-dvx4")) {
                Common.getSettings().setProperty(Keys.KEY_ExternPanel_splitProjectFile[0], "1");
                Common.getSettings().setProperty(Keys.KEY_AudioPanel_addRiffToAc3[0], "1");
                Common.getSettings().setProperty(Keys.KEY_AudioPanel_addRiffToMpgAudio[0], "1");
            }
            if (Start.getBooleanSwitch("-log")) {
                Common.getSettings().setProperty(Keys.KEY_NormalLog[0], "1");
            }
            if (Start.getBooleanSwitch("-saveini")) {
                Common.getSettings().setProperty(Keys.KEY_SaveSettingsOnExit[0], "1");
            }
            if (Start.getBooleanSwitch("-webif")) {
                Common.getSettings().setProperty(Keys.KEY_autostartWebServer[0], "1");
            }
            if (Start.getBooleanSwitch("-demux")) {
                Common.getSettings().setProperty(Keys.KEY_ConversionMode[0], "0");
            }
            if (Start.getBooleanSwitch("-tovdr")) {
                Common.getSettings().setProperty(Keys.KEY_ConversionMode[0], "1");
            }
            if (Start.getBooleanSwitch("-tom2p")) {
                Common.getSettings().setProperty(Keys.KEY_ConversionMode[0], "2");
            }
            if (Start.getBooleanSwitch("-topva")) {
                Common.getSettings().setProperty(Keys.KEY_ConversionMode[0], "3");
            }
            if (Start.getBooleanSwitch("-tots")) {
                Common.getSettings().setProperty(Keys.KEY_ConversionMode[0], "4");
            }
            if (Start.getBooleanSwitch("-filter")) {
                Common.getSettings().setProperty(Keys.KEY_ConversionMode[0], "5");
            }
            if ((n = Start.getSwitch("-split")) >= 0) {
                bl2 = false;
                if (n < arrayList.size()) {
                    string = arrayList.get(n).toString();
                    try {
                        n2 = Integer.parseInt(string);
                        Common.getSettings().setProperty(Keys.KEY_SplitSize[0], "1");
                        Common.getSettings().setProperty(Keys.KEY_ExportPanel_SplitSize_Value[0], String.valueOf(n2));
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    arrayList.remove(n);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    System.out.println("can't set split size value ...");
                    bl = true;
                }
            }
            if ((n = Start.getSwitch("-out")) >= 0) {
                bl2 = false;
                jobCollection = Start.createCollection(jobCollection);
                if (n < arrayList.size()) {
                    string = arrayList.get(n).toString();
                    if (new File(string).exists()) {
                        jobCollection.setOutputDirectory(string);
                    } else {
                        bl2 = true;
                    }
                    arrayList.remove(n);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    System.out.println("can't set output directory ...");
                    bl = true;
                }
            }
            if ((n = Start.getSwitch("-name")) >= 0) {
                bl2 = false;
                jobCollection = Start.createCollection(jobCollection);
                if (n < arrayList.size()) {
                    string = arrayList.get(n).toString();
                    if (string.length() > 0) {
                        jobCollection.setOutputName(string);
                    } else {
                        bl2 = false;
                    }
                    arrayList.remove(n);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    System.out.println("can't set output name ...");
                    bl = true;
                }
            }
            if ((n = Start.getSwitch("-cut")) >= 0) {
                bl2 = false;
                jobCollection = Start.createCollection(jobCollection);
                if (n < arrayList.size()) {
                    string = arrayList.get(n).toString();
                    if (new File(string).exists()) {
                        Start.loadCutPoints(jobCollection, string);
                    } else {
                        bl2 = false;
                    }
                    arrayList.remove(n);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    System.out.println("can't set cutpoints ...");
                    bl = true;
                }
            }
            if ((n = Start.getSwitch("-chp")) >= 0) {
                bl2 = false;
                jobCollection = Start.createCollection(jobCollection);
                if (n < arrayList.size()) {
                    string = arrayList.get(n).toString();
                    if (new File(string).exists()) {
                        Start.loadChapterPoints(jobCollection, string);
                    } else {
                        bl2 = false;
                    }
                    arrayList.remove(n);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    System.out.println("can't set chapterpoints ...");
                    bl = true;
                }
            }
            if ((n = Start.getSwitch("-id")) >= 0) {
                bl2 = false;
                jobCollection = Start.createCollection(jobCollection);
                if (n < arrayList.size()) {
                    string = arrayList.get(n).toString();
                    if (string.length() > 0) {
                        Start.loadIDs(jobCollection, string);
                    } else {
                        bl2 = false;
                    }
                    arrayList.remove(n);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    System.out.println("can't set pidfilter ...");
                    bl = true;
                }
            }
            n2 = 0;
            while (n2 < arrayList.size()) {
                jobCollection = Start.createCollection(jobCollection);
                try {
                    String string2 = arrayList.get(n2).toString();
                    string = string2.toLowerCase();
                    XInputFile xInputFile = null;
                    if (string.endsWith("bfl") || string.endsWith("tpl")) {
                        XInputFile xInputFile2 = Common.getInputFile(string2);
                        if (xInputFile2 != null) {
                            xInputFile2.randomAccessOpen("r");
                            xInputFile2.randomAccessSeek(0L);
                            while ((string = xInputFile2.randomAccessReadLine()) != null) {
                                xInputFile = Common.getInputFile(string);
                                if (xInputFile == null) continue;
                                jobCollection.addInputFile(xInputFile);
                            }
                            xInputFile2.randomAccessClose();
                        }
                    } else {
                        xInputFile = Common.getInputFile(string2);
                        if (xInputFile != null) {
                            jobCollection.addInputFile(xInputFile);
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("File input error");
                    bl = true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        catch (Error error) {
            bl = true;
        }
        return bl;
    }

    private static void loadIDs(JobCollection jobCollection, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        int n = 0;
        jobCollection.clearPIDs();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("0x")) {
                string2 = "0x" + Integer.toHexString(Integer.parseInt(string2));
            }
            jobCollection.addPID(string2);
            ++n;
        }
        Common.setMessage(Resource.getString("msg.loading.pids", String.valueOf(jobCollection.getPIDCount())));
    }

    private static void loadCutPoints(JobCollection jobCollection, String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().equals("")) continue;
                if (string2.startsWith(Keys.KEY_CutMode[0])) {
                    Common.getSettings().setProperty(Keys.KEY_CutMode[0], string2.substring(string2.indexOf("=") + 1).trim());
                    continue;
                }
                if (string2.startsWith("(")) continue;
                jobCollection.addCutpoint(string2);
            }
            bufferedReader.close();
            Common.setMessage("Successful reading of " + String.valueOf(jobCollection.getCutpointCount()) + " cutpoints");
        }
        catch (Exception exception) {
            Common.setMessage("Error while reading file: '" + string + "'");
            Common.setExceptionMessage(exception);
        }
    }

    private static void loadChapterPoints(JobCollection jobCollection, String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().equals("")) continue;
                jobCollection.addChapterpoint(string2);
            }
            bufferedReader.close();
            Common.setMessage("Successful reading of " + String.valueOf(jobCollection.getChapterpointCount()) + " chapterpoints");
        }
        catch (Exception exception) {
            Common.setMessage("Error while reading file: '" + string + "'");
            Common.setExceptionMessage(exception);
        }
    }
}

