/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.GuiInterface;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.Settings;
import net.sourceforge.dvb.projectx.net.WebInterface;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.MainProcess;
import net.sourceforge.dvb.projectx.parser.Scan;
import net.sourceforge.dvb.projectx.subtitle.Subpicture;
import net.sourceforge.dvb.projectx.video.MpvDecoder;
import net.sourceforge.dvb.projectx.xinput.DirType;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.topfield_raw.RawInterface;

public final class Common {
    private static String version_name = "ProjectX 0.90.3.00";
    private static String version_date = "31.12.2005";
    private static String line_separator = System.getProperty("line.separator");
    private static String messagelog = "";
    private static int ProcessedCollection = 0;
    private static int ActiveCollection = -1;
    private static int ProcessedPercent = 0;
    private static int ErrorCount = 0;
    private static boolean showGUI = false;
    private static boolean runningCLI = false;
    private static boolean runningProcess = false;
    private static boolean GlobalDebug = false;
    private static boolean TimeLog = false;
    private static boolean MaxLog = false;
    private static boolean canAccessFtp = true;
    private static boolean canAccessRawread = true;
    private static boolean canAccessColorTable = true;
    private static boolean canAccessSilentAC3 = true;
    private static final String COLOUR_TABLES_FILENAME = "colours.tbl";
    private static final String AC3_FILENAME = "ac3.bin";
    private static ArrayList subpicture_colormodels = null;
    private static List AC3list = new ArrayList();
    private static DateFormat time_format_1 = new SimpleDateFormat("HH:mm:ss.SSS");
    private static DateFormat time_format_2 = new SimpleDateFormat("HH:mm:ss:SSS");
    private static DateFormat time_format_3 = new SimpleDateFormat("dd.MM.yy  HH:mm");
    private static DateFormat time_format_4 = new SimpleDateFormat("HH:mm:ss");
    private static byte temp_byte;
    private static Settings settings;
    private static int[] FpsValue;
    private static long[] Data_Troughput;
    private static int SplitPart;
    private static String StatusString;
    private static GuiInterface guiInterface;
    private static Subpicture subpicture;
    private static Scan scan;
    private static MpvDecoder mpvdecoder;
    private static WebInterface webserver;
    private static MainProcess mainprocess;
    private static long ProcessTime;
    private static List collectionList;

    private Common() {
    }

    public static void exitApplication(int n) {
        if (n == 0 && Common.getSettings().getBooleanProperty(Keys.KEY_SaveSettingsOnExit)) {
            Common.saveSettings();
        }
        System.exit(n);
    }

    public static void setSettings() {
        Common.setSettings(null);
    }

    public static void setSettings(String string) {
        if (settings != null) {
            return;
        }
        settings = string == null ? new Settings() : new Settings(string);
    }

    public static Settings getSettings() {
        return settings;
    }

    public static void saveSettings() {
        Common.saveSettings(null);
    }

    public static void saveSettings(String string) {
        Common.getSettings().setProperty(Keys.KEY_Language[0], Resource.getChosenLanguage());
        Common.getMainFrameBounds();
        settings.save(string);
    }

    public static void init() {
        StatusString = Resource.getString("run.status");
        scan = new Scan();
        subpicture = new Subpicture();
        mpvdecoder = new MpvDecoder();
        subpicture_colormodels = Common.loadColorModels();
    }

    public static void startWebServer() {
        if (webserver == null) {
            webserver = new WebInterface();
        }
        Common.stopWebServer();
        webserver.start();
    }

    public static void stopWebServer() {
        if (webserver == null) {
            return;
        }
        webserver.stop();
    }

    public static boolean isWebServerOnline() {
        return webserver != null && webserver.isOnline();
    }

    public static void prepareGui(boolean bl) {
        showGUI = bl;
        guiInterface = new GuiInterface(showGUI);
        if (Common.showGUI()) {
            Common.getGuiInterface().loadGui();
        }
    }

    public static GuiInterface getGuiInterface() {
        return guiInterface;
    }

    public static boolean showGUI() {
        return showGUI;
    }

    public static Subpicture getSubpictureClass() {
        return subpicture;
    }

    public static Scan getScanClass() {
        return scan;
    }

    public static MpvDecoder getMpvDecoderClass() {
        return mpvdecoder;
    }

    public static boolean startProcess() {
        boolean bl = true;
        if (Common.isRunningProcess()) {
            return !bl;
        }
        if (Common.isCollectionListEmpty()) {
            return !bl;
        }
        Common.setRunningProcess(bl);
        CommonParsing.setPvaPidToExtract(-1);
        return bl;
    }

    public static boolean waitingMainProcess() {
        return mainprocess != null ? mainprocess.pause() : false;
    }

    public static void startMainProcess() {
        mainprocess = new MainProcess();
        mainprocess.start();
    }

    public static void breakMainProcess() {
        if (!Common.isRunningProcess()) {
            return;
        }
        Common.setMessage(Resource.getString("golistener.msg.cancelled"), true, 0xE0E0FF);
        CommonParsing.setProcessPausing(false);
        CommonParsing.setProcessCancelled(true);
    }

    public static void setRunningProcess(boolean bl) {
        runningProcess = bl;
        TimeLog = Common.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg4);
        MaxLog = Common.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg8);
        ErrorCount = 0;
        if (runningProcess) {
            Common.setMessage(null, true, 0xFFFFFF);
            if (Common.getSettings().getBooleanProperty(Keys.KEY_minimizeMainFrame)) {
                Common.showMainFrame(false);
            }
            if (Common.getSettings().getBooleanProperty(Keys.KEY_hideProcessWindow)) {
                Common.getGuiInterface().closeLogWindow();
            }
        } else {
            Common.showMainFrame(true);
            Common.getGuiInterface().showLogWindow();
        }
    }

    public static boolean isRunningProcess() {
        return runningProcess;
    }

    public static void setRunningCLI(boolean bl) {
        runningCLI = bl;
    }

    public static boolean isRunningCLI() {
        return runningCLI;
    }

    public static void setProcessTime(long l) {
        ProcessTime = l;
    }

    public static long getProcessTime() {
        if (!Common.isRunningProcess() || ProcessTime <= 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - ProcessTime;
    }

    public static void setGlobalDebug(boolean bl) {
        GlobalDebug = bl;
    }

    public static boolean getGlobalDebug() {
        return GlobalDebug;
    }

    public static int getProcessedCollection() {
        return ProcessedCollection;
    }

    public static void setProcessedCollection(int n) {
        ProcessedCollection = n;
    }

    public static int getActiveCollection() {
        return ActiveCollection;
    }

    public static void setActiveCollection(int n) {
        ActiveCollection = n;
    }

    public static String getLineSeparator() {
        return line_separator;
    }

    public static String getVersionName() {
        return version_name;
    }

    public static String getVersionDate() {
        return version_date;
    }

    public static String[] getVersion() {
        return new String[]{Common.getVersionName(), Common.getVersionDate(), Resource.getString("version.info"), Resource.getString("version.user") + System.getProperty("user.name")};
    }

    public static String getDateAndTime() {
        return DateFormat.getDateInstance(1).format(new Date()) + "    " + DateFormat.getTimeInstance(1).format(new Date());
    }

    public static String formatNumber(long l) {
        return NumberFormat.getInstance().format(l);
    }

    public static boolean isCollectionListEmpty() {
        return collectionList.isEmpty();
    }

    public static int getCollectionListSize() {
        return collectionList.size();
    }

    public static boolean removeCollection(int n) {
        if (n < 0 || n >= collectionList.size()) {
            return false;
        }
        if (Common.getCollection(n).isActive()) {
            return false;
        }
        collectionList.remove(n);
        return true;
    }

    public static JobCollection getCollection() {
        return Common.getCollection(Common.getActiveCollection());
    }

    public static JobCollection getCollection(int n) {
        if (n < 0 || n >= collectionList.size()) {
            return null;
        }
        return (JobCollection)collectionList.get(n);
    }

    public static JobCollection addCollection() {
        return Common.addCollection(true);
    }

    public static JobCollection addCollection(boolean bl) {
        if (!bl && !collectionList.isEmpty()) {
            return null;
        }
        return Common.addCollection(new JobCollection(Common.getSettings().getProperty(Keys.KEY_OutputDirectory)));
    }

    public static JobCollection addCollection(JobCollection jobCollection) {
        collectionList.add(jobCollection);
        Common.addCollectionAtEnd();
        return jobCollection;
    }

    public static String checkLibraryAccess() {
        try {
            Class<?> clazz = Class.forName("org.apache.commons.net.ftp.FTPClient");
            canAccessFtp = true;
            return null;
        }
        catch (Exception exception) {
        }
        catch (Error error) {
        }
        return "\ncommons-net library not accessible! see readme.txt [ii]\nensure the correct location/classpath, related to the executed .jar\n";
    }

    public static boolean canAccessFtp() {
        return canAccessFtp;
    }

    public static boolean canAccessRawRead() {
        return canAccessRawread;
    }

    public static boolean canAccessColorTable() {
        return canAccessColorTable;
    }

    public static boolean canAccessSilentAC3() {
        return canAccessSilentAC3;
    }

    public static void changeByteOrder(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 < n4) {
            temp_byte = byArray[n3 + 1];
            byArray[n3 + 1] = byArray[n3];
            byArray[n3] = temp_byte;
            n3 += 2;
        }
        if ((n2 & 1) != 0) {
            Common.setMessage("!> byte swap, len has an odd value: " + n2 + " /off " + n);
        }
    }

    public static boolean renameTo(File file, File file2) {
        System.gc();
        int n = 0;
        while (n < 10000) {
            if (file.renameTo(file2)) {
                return true;
            }
            ++n;
        }
        Common.setMessage(Resource.getString("common.rename_error1") + " '" + file.toString() + "' " + Resource.getString("common.rename_error2") + " '" + file2.toString() + "'", true, 0xFFE0E0);
        return false;
    }

    public static boolean renameTo(String string, String string2) {
        return Common.renameTo(new File(string), new File(string2));
    }

    public static String adaptString(int n, int n2) {
        return Common.adaptString(String.valueOf(n), n2);
    }

    public static String adaptString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, "0");
        }
        return stringBuffer.toString();
    }

    public static String formatTime_1(long l) {
        time_format_1.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        return time_format_1.format(new Date(l));
    }

    public static String formatTime_2(long l, long l2) {
        time_format_2.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        String string = time_format_2.format(new Date(l));
        return string.substring(0, string.length() - 3) + Common.adaptString(Integer.parseInt(string.substring(string.length() - 3)) * 90 / (int)l2, 2);
    }

    public static String formatTime_3(long l) {
        return time_format_3.format(new Date(l));
    }

    public static String formatTime_4(long l) {
        time_format_4.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        return time_format_4.format(new Date(l));
    }

    public static Object[] getColorModels() {
        return subpicture_colormodels.toArray();
    }

    public static ArrayList getColorModelsList() {
        return subpicture_colormodels;
    }

    private static ArrayList loadColorModels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Resource.getString("SubtitlePanel.Colormodel.Mode0"));
        arrayList.add(Resource.getString("SubtitlePanel.Colormodel.Mode1"));
        arrayList.add(Resource.getString("SubtitlePanel.Colormodel.Mode2"));
        URL uRL = Resource.getResourceURL(COLOUR_TABLES_FILENAME);
        if (uRL == null) {
            return arrayList;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().length() == 0 || !string.startsWith("table")) continue;
                arrayList.add(string.substring(string.indexOf("=") + 1).trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException loadColorModels " + iOException);
        }
        if (arrayList.size() <= 3) {
            canAccessColorTable = false;
        }
        return arrayList;
    }

    public static Hashtable getUserColourTable(String string) throws IOException {
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        URL uRL = Resource.getResourceURL(COLOUR_TABLES_FILENAME);
        if (uRL == null) {
            return hashtable;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.trim().length() == 0) continue;
            if (string2.startsWith("table")) {
                bl = string2.substring(string2.indexOf("=") + 1).trim().equals(string);
                continue;
            }
            if (!bl) continue;
            if (string2.startsWith("model")) {
                hashtable.put("model", string2.substring(string2.indexOf("=") + 1).trim());
                continue;
            }
            hashtable.put(string2.substring(0, string2.indexOf("=")).trim(), string2.substring(string2.indexOf("=") + 1).trim());
        }
        bufferedReader.close();
        if (!hashtable.isEmpty() && !hashtable.containsKey("model")) {
            hashtable.put("model", "16");
        }
        return hashtable;
    }

    public static void loadAC3() {
        AudioFormat audioFormat = new AudioFormat(0);
        AC3list.clear();
        try {
            URL uRL = Resource.getResourceURL(AC3_FILENAME);
            if (uRL != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = -1;
                while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                Common.setMessage(Resource.getString("ac3.msg.loading.start"));
                int n2 = 0;
                int n3 = 0;
                while (n2 < byArray2.length) {
                    audioFormat.parseHeader(byArray2, n2);
                    Common.setMessage("(" + n3 + ") " + audioFormat.saveAndDisplayHeader());
                    byte[] byArray3 = new byte[audioFormat.getSize()];
                    System.arraycopy(byArray2, n2, byArray3, 0, audioFormat.getSize());
                    AC3list.add(byArray3);
                    n2 += AudioFormat.Size;
                    ++n3;
                }
                byArray2 = null;
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            AC3list.clear();
        }
        if (AC3list.size() > 0) {
            Common.setMessage(Resource.getString("ac3.msg.frames", "" + AC3list.size()));
        } else {
            canAccessSilentAC3 = false;
        }
    }

    public static List getAC3list() {
        return AC3list;
    }

    public static Object[] getFonts() {
        Object[] objectArray = new Object[]{};
        try {
            objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        catch (Exception exception) {
            System.out.println(Resource.getString("SubtitlePanel.Font.LoadError") + ": " + exception);
        }
        catch (Error error) {
            System.out.println(Resource.getString("SubtitlePanel.Font.LoadError") + ": " + error);
        }
        return objectArray;
    }

    public static void appendLogMessage(String string) {
        messagelog = messagelog + Common.getLineSeparator() + string;
    }

    public static void clearMessageLog() {
        messagelog = "";
        ErrorCount = 0;
    }

    public static String getMessageLog() {
        return messagelog;
    }

    public static int getErrorCount() {
        return ErrorCount;
    }

    public static void setMessage(Object[] objectArray) {
        int n = 0;
        while (objectArray != null && n < objectArray.length) {
            Common.setMessage(objectArray[n].toString());
            ++n;
        }
    }

    public static void setMessage(String string) {
        Common.setMessage(string, false);
    }

    public static void setMessage(String string, boolean bl) {
        Common.setMessage(string, bl, -1);
    }

    public static void setMessage(String string, boolean bl, int n) {
        if (string == null) {
            if (!Common.isRunningCLI()) {
                if (Common.getGuiInterface() != null) {
                    Common.getGuiInterface().setMessage(string, bl, n);
                } else {
                    System.out.println(string);
                }
            }
            return;
        }
        if (string.startsWith("!>") && MaxLog && ++ErrorCount > 500) {
            return;
        }
        if (MaxLog && ErrorCount == 500) {
            string = string + Common.getLineSeparator() + Resource.getString("all.msg.error.max");
        }
        if (TimeLog) {
            string = "[" + Common.formatTime_1(System.currentTimeMillis()) + "] " + string;
        }
        if (Common.getGlobalDebug()) {
            System.out.println(string);
        }
        if (Common.isRunningCLI() || Common.getGuiInterface() == null) {
            System.out.println(string);
        } else {
            Common.getGuiInterface().setMessage(string, bl, n);
        }
        Common.appendLogMessage(string);
    }

    public static void setExceptionMessage(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        Common.setErrorMessage(stringWriter.toString());
    }

    public static void setErrorMessage(Error error) {
        StringWriter stringWriter = new StringWriter();
        error.printStackTrace(new PrintWriter(stringWriter));
        Common.setErrorMessage(stringWriter.toString());
    }

    public static void setErrorMessage(String string) {
        Common.setMessage("");
        Common.setMessage("!> an error has occured..  (please inform the autors at 'forum.dvbtechnics.info')");
        Common.setMessage(string, true, 0xFFE0E0);
    }

    public static void setOSDMessage(String string) {
        Common.setOSDMessage(string, false);
    }

    public static void setOSDErrorMessage(String string) {
        Common.setOSDMessage(string, true);
    }

    public static void setOSDMessage(String string, boolean bl) {
        Common.getGuiInterface().setOSDMessage(string, bl);
    }

    public static void performCommand(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    public static void performPostCommand(Object[] objectArray) {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_enablePostProcessing)) {
            return;
        }
        String string = "";
        switch (Common.getSettings().getIntProperty(Keys.KEY_ConversionMode)) {
            case 0: {
                string = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd4);
                break;
            }
            case 1: {
                string = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd5);
                break;
            }
            case 2: {
                string = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd6);
                break;
            }
            case 3: {
                string = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd7);
                break;
            }
            case 4: {
                string = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd8);
            }
            default: {
                return;
            }
        }
        string = string.trim();
        if (string.length() > 0 && objectArray.length > 0) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string2 = "";
            boolean bl = false;
            int n = string.lastIndexOf(" \"?");
            if (n < 0) {
                n = string.lastIndexOf(" ?");
            } else {
                bl = true;
            }
            if (n < 0) {
                arrayList.add(string.trim());
            } else {
                string2 = string.substring(n).replace('\"', ' ').trim();
                string = string.substring(0, n).trim();
                arrayList.add(string);
                n = Integer.parseInt(string2.substring(1));
                if (n == 0 || n > objectArray.length) {
                    n = objectArray.length;
                }
                int n2 = 0;
                while (n2 < objectArray.length && n2 < n) {
                    object = objectArray[n2].toString();
                    object = ((String)object).substring(((String)object).indexOf("'") + 1, ((String)object).length() - 1);
                    if (bl) {
                        arrayList.add("\"" + (String)object + '\"');
                    } else {
                        arrayList.add(object);
                    }
                    ++n2;
                }
            }
            String string3 = "";
            object = new String[arrayList.size()];
            int n3 = 0;
            while (n3 < ((String[])object).length) {
                object[n3] = arrayList.get(n3).toString();
                string3 = string3 + (n3 == 0 ? "" : " ");
                string3 = string3 + object[n3];
                ++n3;
            }
            Common.setMessage(Resource.getString("working.post.command") + " {" + string3 + "}");
            try {
                Runtime.getRuntime().exec((String[])object);
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
            arrayList = null;
        }
    }

    public static XInputFile getInputFile(String string) {
        XInputFile xInputFile = null;
        URL uRL = null;
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("ftp")) {
                XInputDirectory xInputDirectory = new XInputDirectory(uRL);
                XInputFile[] xInputFileArray = xInputDirectory.getFiles();
                int n = 0;
                while (n < xInputFileArray.length) {
                    if (new URL(xInputFileArray[n].toString()).getFile().equals(uRL.getFile())) {
                        xInputFile = xInputFileArray[n];
                        break;
                    }
                    ++n;
                }
            } else if (string2.equals("file")) {
                xInputFile = new XInputFile(new File(uRL.getHost() + uRL.getFile()));
            } else {
                System.out.println("!> Protocol not yet supported: " + string2);
            }
            return xInputFile;
        }
        catch (Exception exception) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    xInputFile = new XInputFile(file);
                    return xInputFile;
                }
            }
            catch (Exception exception2) {
                System.out.println("local Filesystem access: '" + string + "' > " + exception2);
            }
            try {
                xInputFile = new XInputFile(string);
                return xInputFile;
            }
            catch (Exception exception3) {
                System.out.println("ext. Filesystem access: '" + string + "' > " + exception3);
                return null;
            }
        }
    }

    public static Object[] getJavaEV(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Java Environment");
        arrayList.add(Common.getDateAndTime());
        arrayList.add(Resource.getString("javaev.java.version") + "\t" + System.getProperty("java.version"));
        arrayList.add(Resource.getString("javaev.java.vendor") + "\t" + System.getProperty("java.vendor"));
        arrayList.add(Resource.getString("javaev.java.home") + "\t" + System.getProperty("java.home"));
        arrayList.add(Resource.getString("javaev.java.vm.version") + "\t" + System.getProperty("java.vm.version"));
        arrayList.add(Resource.getString("javaev.java.vm.vendor") + "\t" + System.getProperty("java.vm.vendor"));
        arrayList.add(Resource.getString("javaev.java.vm.name") + "\t" + System.getProperty("java.vm.name"));
        arrayList.add(Resource.getString("javaev.java.class.vers") + "\t" + System.getProperty("java.class.version"));
        arrayList.add(Resource.getString("javaev.java.class.path") + "\t" + System.getProperty("java.class.path"));
        arrayList.add(Resource.getString("javaev.java.os.name") + "\t" + System.getProperty("os.name"));
        arrayList.add(Resource.getString("javaev.java.os.arch") + "\t" + System.getProperty("os.arch"));
        arrayList.add(Resource.getString("javaev.java.os.version") + "\t" + System.getProperty("os.version"));
        arrayList.add(Resource.getString("javaev.java.ini.file") + "\t" + string);
        String string2 = new RawInterface("").GetLoadStatus();
        if (string2 == null) {
            string2 = Resource.getString("rawread.msg1");
            canAccessRawread = false;
        }
        arrayList.add(Resource.getString("javaev.java.disk.access") + "\t" + string2);
        arrayList.add(Resource.getString("javaev.java.user.lang") + "\t" + Resource.getChosenLanguage());
        arrayList.add(Resource.getString("javaev.java.user.name") + "\t" + System.getProperty("user.name"));
        arrayList.add(Resource.getString("javaev.java.user.home") + "\t" + System.getProperty("user.home"));
        return arrayList.toArray();
    }

    public static String getDataTroughput() {
        long l = (Data_Troughput[1] - Data_Troughput[0]) / 1024L;
        Common.Data_Troughput[0] = 0L;
        Common.Data_Troughput[1] = 0L;
        return String.valueOf(l < 0L ? 0L : l);
    }

    public static String getFps() {
        int n = FpsValue[1] - FpsValue[0];
        Common.FpsValue[0] = 0;
        Common.FpsValue[1] = 0;
        return String.valueOf(n < 0 ? 0 : n);
    }

    public static void setFps(int n) {
        Common.FpsValue[1] = FpsValue[0] == 0 ? (Common.FpsValue[0] = n) : n;
    }

    public static String getExportedSize() {
        JobCollection jobCollection = Common.getCollection(Common.getProcessedCollection());
        long l = jobCollection == null || jobCollection.getJobProcessing() == null ? 0L : jobCollection.getJobProcessing().getMediaFilesExportLength() / 0x100000L;
        return String.valueOf(l) + " MB - " + SplitPart;
    }

    public static void showSplitPart(int n) {
        SplitPart = n;
    }

    public static int getProcessedPercent() {
        return ProcessedPercent;
    }

    public static void updateProgressBar(long l, long l2) {
        int n;
        Common.Data_Troughput[1] = Data_Troughput[0] == 0L ? (Common.Data_Troughput[0] = l) : l;
        if (l2 <= 0L) {
            l2 = 1L;
        }
        if ((n = (int)(l * 100L / l2) + 1) == ProcessedPercent) {
            return;
        }
        ProcessedPercent = n;
        Common.getGuiInterface().updateProgressBar(ProcessedPercent);
    }

    public static void updateProgressBar(String string) {
        Common.setStatusString(string);
        Common.getGuiInterface().updateProgressBar(string);
    }

    public static void updateProgressBar(String string, long l, long l2) {
        if (string != null) {
            Common.updateProgressBar(string);
        }
        Common.updateProgressBar(l, l2);
    }

    public static String getStatusString() {
        return StatusString;
    }

    public static void setStatusString(String string) {
        StatusString = string;
    }

    public static void checkVersion() {
        try {
            String string;
            URL uRL = new URL("http://project-x.sourceforge.net/update/update.txt");
            URLConnection uRLConnection = uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string2 = string = bufferedReader.readLine();
            String string3 = null;
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
            }
            if (string3 != null) {
                string2 = string2 + "\n" + string3;
            }
            Common.getGuiInterface().showMessageDialog(Resource.getString("help.version.info") + "\n" + string2, Resource.getString("help.version.info.title"));
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    public static void getMainFrameBounds() {
        Rectangle rectangle = (Rectangle)Common.getGuiInterface().getMainFrameBounds();
        if (rectangle != null) {
            Common.getSettings().setIntProperty(Keys.KEY_WindowPositionMain_X[0], (int)rectangle.getX());
            Common.getSettings().setIntProperty(Keys.KEY_WindowPositionMain_Y[0], (int)rectangle.getY());
            Common.getSettings().setIntProperty(Keys.KEY_WindowPositionMain_Width[0], (int)rectangle.getWidth());
            Common.getSettings().setIntProperty(Keys.KEY_WindowPositionMain_Height[0], (int)rectangle.getHeight());
        }
    }

    public static void showMainFrame(boolean bl) {
        Common.getGuiInterface().showMainFrame(bl);
    }

    public static void setFrameTitle(String string) {
        Common.getGuiInterface().setMainFrameTitle(string);
    }

    public static void addCollectionAtEnd() {
        if (Common.getGuiInterface() != null) {
            Common.getGuiInterface().addCollectionAtEnd();
        }
    }

    public static Object[] reloadInputDirectories() {
        XInputFile[] xInputFileArray;
        Object object;
        ArrayList<XInputFile> arrayList = new ArrayList<XInputFile>();
        ArrayList arrayList2 = Common.getSettings().getInputDirectories();
        int n = 0;
        while (n < arrayList2.size()) {
            object = arrayList2.get(n);
            xInputFileArray = (XInputFile[])object;
            XInputFile[] xInputFileArray2 = xInputFileArray.getFiles();
            if (xInputFileArray2.length > 0) {
                class MyComparator
                implements Comparator {
                    MyComparator() {
                    }

                    public int compare(Object object, Object object2) {
                        return object.toString().compareTo(object2.toString());
                    }
                }
                Arrays.sort(xInputFileArray2, new MyComparator());
            }
            int n2 = 0;
            while (n2 < xInputFileArray2.length) {
                arrayList.add(xInputFileArray2[n2]);
                ++n2;
            }
            ++n;
        }
        try {
            object = new XInputDirectory(DirType.RAW_DIR);
            xInputFileArray = ((XInputDirectory)object).getFiles();
            if (xInputFileArray.length > 0) {
                class MyComparator
                implements Comparator {
                    MyComparator() {
                    }

                    public int compare(Object object, Object object2) {
                        return object.toString().compareTo(object2.toString());
                    }
                }
                Arrays.sort(xInputFileArray, new MyComparator());
            }
            int n3 = 0;
            while (n3 < xInputFileArray.length) {
                arrayList.add(xInputFileArray[n3]);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return arrayList.isEmpty() ? new Object[]{} : arrayList.toArray();
    }

    static {
        FpsValue = new int[]{0, 0};
        Data_Troughput = new long[]{0L, 0L};
        SplitPart = 0;
        StatusString = null;
        guiInterface = null;
        subpicture = null;
        scan = null;
        mpvdecoder = null;
        webserver = null;
        mainprocess = null;
        ProcessTime = 0L;
        collectionList = new ArrayList();
    }
}

