/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatWAV
extends AudioFormat {
    private final int[] WaveChunks = new int[]{1463899717, 1668637984, 1684108385, 1717658484, 1718449184, 1768846196, 1818321516, 1818850164, 1819572340, 1852798053, 1886155636, 1936552044};
    private final String[] LSB_mode = new String[]{"F", "X"};
    private final String[] compression = new String[]{"", "PCM", "MPEG", "MPEG-L3", "AC3"};

    public int parseHeader(byte[] byArray, int n) {
        AudioFormat.INTEL = false;
        if (byArray[n] != 82 || byArray[n + 1] != 73 || byArray[n + 2] != 70) {
            return -1;
        }
        if (byArray[n + 3] == 70) {
            AudioFormat.INTEL = true;
        } else if (byArray[n + 3] != 88) {
            return -2;
        }
        AudioFormat.ID = AudioFormat.INTEL ? 0 : 1;
        AudioFormat.Emphasis = 0;
        AudioFormat.Protection_bit = 1;
        Arrays.sort(this.WaveChunks);
        if (this.littleEndian(byArray, n + 8, 4, false) != this.WaveChunks[0]) {
            return -3;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n + 12;
        while (n4 < byArray.length - 4) {
            n2 = this.littleEndian(byArray, n4, 4, false);
            if (Arrays.binarySearch(this.WaveChunks, n2) >= 0) {
                if (n2 == this.WaveChunks[4]) {
                    n3 = this.littleEndian(byArray, n4 + 4, 4, AudioFormat.INTEL);
                    AudioFormat.Layer = this.littleEndian(byArray, n4 + 8, 2, AudioFormat.INTEL);
                    AudioFormat.Channel = this.littleEndian(byArray, n4 + 10, 2, AudioFormat.INTEL);
                    AudioFormat.Sampling_frequency = this.littleEndian(byArray, n4 + 12, 4, AudioFormat.INTEL);
                    AudioFormat.Bitrate = this.littleEndian(byArray, n4 + 16, 4, AudioFormat.INTEL) * 8;
                    AudioFormat.Mode = this.littleEndian(byArray, n4 + 20, 2, AudioFormat.INTEL);
                    AudioFormat.Size = this.littleEndian(byArray, n4 + 22, 2, AudioFormat.INTEL);
                } else if (n2 == this.WaveChunks[2]) {
                    AudioFormat.Size_base = n3 = this.littleEndian(byArray, n4 + 4, 4, AudioFormat.INTEL);
                    AudioFormat.Emphasis = n4 + 8;
                } else {
                    n3 = this.littleEndian(byArray, n4 + 4, 4, AudioFormat.INTEL);
                }
                n4 += n3 + 3;
            }
            ++n4;
        }
        if (AudioFormat.Bitrate < 1 || AudioFormat.Sampling_frequency < 1 || AudioFormat.Channel < 1) {
            return -4;
        }
        AudioFormat.Padding_bit = 0;
        AudioFormat.Private_bit = 0;
        AudioFormat.Copyright = 0;
        AudioFormat.Original = 0;
        AudioFormat.Time_length = 90000.0 / (double)AudioFormat.Sampling_frequency;
        switch (AudioFormat.Layer) {
            case 1: {
                AudioFormat.Mode_extension = 1;
                return 1;
            }
            case 80: {
                AudioFormat.Mode_extension = 2;
                return 0;
            }
            case 85: {
                AudioFormat.Mode_extension = 3;
                return 0;
            }
            case 8192: {
                AudioFormat.Mode_extension = 4;
                return 0;
            }
        }
        AudioFormat.Mode_extension = 0;
        return 0;
    }

    public String displayHeader() {
        return "RIF" + this.LSB_mode[AudioFormat.lID] + ", " + (AudioFormat.lMode_extension > 0 ? this.compression[AudioFormat.lMode_extension] : "tag 0x" + Integer.toHexString(AudioFormat.Layer)) + ", " + AudioFormat.lChannel + "-ch, " + AudioFormat.lSampling_frequency + "Hz, " + AudioFormat.lSize + "bit, " + (double)AudioFormat.lBitrate / 1000.0 + "kbps";
    }
}

