/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatLPCM
extends AudioFormat {
    private int[] lpcm_frequency_index = new int[]{48000, 96000};
    private int[] lpcm_bps_index = new int[]{16, 20, 24, -1};

    public int parseHeader(byte[] byArray, int n) {
        AudioFormat.INTEL = true;
        AudioFormat.ID = 0xFF & byArray[n];
        AudioFormat.Padding_bit = (0xFF & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
        AudioFormat.Layer = 0xFF & byArray[n + 3];
        AudioFormat.Protection_bit = 1;
        AudioFormat.Private_bit = 0;
        AudioFormat.Copyright = 0;
        AudioFormat.Original = 0;
        AudioFormat.Size_base = 0;
        AudioFormat.Size = this.lpcm_bps_index[3 & byArray[n + 4] >>> 6];
        AudioFormat.Sampling_frequency = this.lpcm_frequency_index[1 & byArray[n + 4] >>> 4];
        AudioFormat.Channel = 1 + (7 & byArray[n + 4]);
        AudioFormat.Emphasis = 0xFF & byArray[n + 5];
        AudioFormat.Mode = AudioFormat.Channel * AudioFormat.Size / 8;
        AudioFormat.Bitrate = AudioFormat.Channel * AudioFormat.Sampling_frequency * AudioFormat.Size;
        if (AudioFormat.Size < 1) {
            return -1;
        }
        AudioFormat.Time_length = 90000.0 / (double)AudioFormat.Sampling_frequency;
        return 0;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        AudioFormat.INTEL = true;
        this.nID = 0xFF & byArray[n];
        this.nPadding_bit = (0xFF & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
        this.nLayer = 0xFF & byArray[n + 3];
        this.nProtection_bit = 1;
        this.nPrivate_bit = 0;
        this.nCopyright = 0;
        this.nOriginal = 0;
        this.nSize_base = 0;
        this.nSize = this.lpcm_bps_index[3 & byArray[n + 4] >>> 6];
        this.nSampling_frequency = this.lpcm_frequency_index[1 & byArray[n + 4] >>> 4];
        this.nChannel = 1 + (7 & byArray[n + 4]);
        this.nEmphasis = 0xFF & byArray[n + 5];
        this.nMode = this.nChannel * this.nSize / 8;
        this.nBitrate = this.nChannel * this.nSampling_frequency * this.nSize;
        if (this.nSize < 1) {
            return -1;
        }
        this.nTime_length = 90000.0 / (double)this.nSampling_frequency;
        return 0;
    }

    public String displayHeader() {
        return "LPCM, DR-" + AudioFormat.lEmphasis + ", " + AudioFormat.lChannel + "-ch, " + AudioFormat.lSampling_frequency + "Hz, " + AudioFormat.lSize + "bit, " + (double)AudioFormat.lBitrate / 1000.0 + "kbps";
    }

    public int compareHeader() {
        if (AudioFormat.lChannel != AudioFormat.Channel) {
            return 1;
        }
        if (AudioFormat.lSampling_frequency != AudioFormat.Sampling_frequency) {
            return 2;
        }
        if (AudioFormat.lSize != AudioFormat.Size) {
            return 3;
        }
        if (AudioFormat.lEmphasis != AudioFormat.Emphasis) {
            return 4;
        }
        return 0;
    }
}

