/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import java.util.ArrayList;

public class ZPriorityQueue {
    public static final int QUEUE_MAXIMUM_ORDERING = 0;
    public static final int QUEUE_MINIMUM_ORDERING = 1;
    private ArrayList fElements;
    private int fQueueOrdering;

    public ZPriorityQueue() {
        this(0);
    }

    public ZPriorityQueue(int aOrdering) {
        this.fQueueOrdering = aOrdering;
    }

    public void insert(Comparable aComparable) {
        this.expand();
        int i = this.size() - 1;
        while (i > 0 && !this.isProposedOrderCorrect(this.get(this.parent(i)), aComparable)) {
            this.set(i, this.get(this.parent(i)));
            i = this.parent(i);
        }
        this.set(i, aComparable);
    }

    public Object first() {
        return this.get(0);
    }

    public Object extractFirst() {
        Comparable first = this.get(0);
        this.set(0, this.get(this.size() - 1));
        this.contract();
        this.heapify(0);
        return first;
    }

    public int size() {
        return this.elements().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected ArrayList elements() {
        if (this.fElements == null) {
            this.fElements = new ArrayList();
        }
        return this.fElements;
    }

    protected int parent(int index) {
        return index / 2;
    }

    protected int left(int index) {
        return 2 * index;
    }

    protected int right(int index) {
        return 2 * index + 1;
    }

    protected void heapify(int index) {
        int left = this.left(index);
        int right = this.right(index);
        int first = -1;
        first = left < this.size() && this.isProposedOrderCorrect(this.get(left), this.get(index)) ? left : index;
        if (right < this.size() && this.isProposedOrderCorrect(this.get(right), this.get(first))) {
            first = right;
        }
        if (first != index) {
            this.exchange(index, first);
            this.heapify(first);
        }
    }

    protected void exchange(int a, int b) {
        Comparable temp = this.get(a);
        this.set(a, this.get(b));
        this.set(b, temp);
    }

    protected Comparable get(int index) {
        return (Comparable)this.elements().get(index);
    }

    protected void set(int index, Comparable aComparable) {
        this.elements().set(index, aComparable);
    }

    protected void expand() {
        this.elements().add(null);
    }

    protected void contract() {
        this.elements().remove(this.size() - 1);
    }

    protected boolean isProposedOrderCorrect(Comparable aProposedFirst, Comparable aProposedSecond) {
        int compareValue = aProposedFirst.compareTo(aProposedSecond);
        switch (this.fQueueOrdering) {
            case 0: {
                return compareValue >= 0;
            }
            case 1: {
                return compareValue <= 0;
            }
        }
        throw new RuntimeException("Bad Ordering State in ZPriorityQueue");
    }

    static {
        QUEUE_MAXIMUM_ORDERING = 0;
        QUEUE_MINIMUM_ORDERING = 1;
    }
}

