/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import edu.umd.cs.jazz.io.ZParser;
import edu.umd.cs.jazz.io.ZSerializable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ZObjectOutputStream
extends OutputStream
implements Serializable {
    protected static final Class[] NULL_ARGS = new Class[0];
    protected DataOutputStream dos;
    protected int id;
    protected Hashtable objs;
    protected Hashtable unsavedObjs;
    protected Hashtable replacedObjs;
    protected boolean writingState;
    protected boolean stateWritten;

    public ZObjectOutputStream(OutputStream out) {
        this.dos = new DataOutputStream(out);
        this.objs = new Hashtable();
        this.unsavedObjs = new Hashtable();
        this.replacedObjs = new Hashtable();
    }

    public static boolean isSavable(Object obj) {
        boolean rc = false;
        if (obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Boolean || obj instanceof String || obj instanceof Byte || obj instanceof Color || obj instanceof Font || obj instanceof Rectangle2D || obj instanceof AffineTransform || obj instanceof Image || obj instanceof ZSerializable) {
            rc = true;
        }
        return rc;
    }

    public void writeObject(ZSerializable obj) throws IOException {
        int objId;
        ZSerializable zobj;
        int i = 0;
        this.id = 1;
        this.writingState = false;
        this.objs.clear();
        this.unsavedObjs.clear();
        this.replacedObjs.clear();
        this.dos.writeBytes("#JAZZ1.0");
        this.dos.writeBytes("\n");
        this.addObject(obj);
        ZSerializable[] zobjs = new ZSerializable[this.objs.size()];
        Enumeration e = this.objs.keys();
        while (e.hasMoreElements()) {
            zobj = (ZSerializable)e.nextElement();
            zobjs[i++] = zobj;
        }
        Arrays.sort(zobjs, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer i1 = (Integer)ZObjectOutputStream.this.objs.get(o1);
                Integer i2 = (Integer)ZObjectOutputStream.this.objs.get(o2);
                return i1.compareTo(i2);
            }
        });
        this.dos.writeBytes("[\n");
        i = 0;
        while (i < zobjs.length) {
            zobj = zobjs[i];
            objId = (Integer)this.objs.get(zobj);
            this.dos.writeBytes("  Z" + objId + " " + zobj.getClass().getName() + "\n");
            ++i;
        }
        Enumeration e2 = this.unsavedObjs.keys();
        while (e2.hasMoreElements()) {
            zobj = (ZSerializable)e2.nextElement();
            objId = (Integer)this.unsavedObjs.get(zobj);
            this.dos.writeBytes("  # Unsaved object skipped: Z" + objId + " " + zobj.getClass().getName() + "\n");
        }
        this.dos.writeBytes("]\n");
        i = 0;
        while (i < zobjs.length) {
            zobj = zobjs[i];
            objId = (Integer)this.objs.get(zobj);
            this.dos.writeBytes("[OBJECT @Z" + objId + " # " + zobj.getClass().getName() + "\n");
            this.dos.writeBytes("  {");
            this.writingState = true;
            this.stateWritten = false;
            zobj.writeObject(this);
            this.writingState = false;
            if (this.stateWritten) {
                this.dos.writeBytes("  ");
            }
            this.dos.writeBytes("}\n");
            this.dos.writeBytes("]\n");
            ++i;
        }
        this.dos.writeBytes("[RETURN @Z" + (Integer)this.objs.get(obj) + "]\n");
    }

    public void addObject(ZSerializable obj) throws IOException {
        block10: {
            try {
                Method writeReplaceMethod = obj.getClass().getDeclaredMethod("writeReplace", NULL_ARGS);
                int mods = writeReplaceMethod.getModifiers();
                if ((mods & 8) != 0) break block10;
                Object replacementObj = null;
                try {
                    replacementObj = writeReplaceMethod.invoke((Object)obj, (Object[])NULL_ARGS);
                    if (replacementObj == null) {
                        if (!this.unsavedObjs.containsKey(obj)) {
                            this.unsavedObjs.put(obj, new Integer(this.id));
                            ++this.id;
                        }
                        obj = null;
                        break block10;
                    }
                    if (replacementObj == obj) break block10;
                    if (!this.replacedObjs.containsKey(obj)) {
                        this.replacedObjs.put(obj, replacementObj);
                    }
                    if (replacementObj instanceof ZSerializable) {
                        obj = (ZSerializable)replacementObj;
                        break block10;
                    }
                    throw new IOException("ZObjectOutputStream.addObject: Error saving: " + obj + ", Replacement is not ZSerializable: " + replacementObj);
                }
                catch (IllegalAccessException e) {
                    throw new IOException("ZObjectOutputStream.addObject: Error saving: " + obj + ", Can't access writeReplace method: " + e);
                }
                catch (InvocationTargetException e) {
                    throw new IOException("ZObjectOutputStream.addObject: Error saving: " + obj + ", " + e);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (obj != null && !this.objs.containsKey(obj)) {
            this.objs.put(obj, new Integer(this.id));
            ++this.id;
            obj.writeObjectRecurse(this);
        }
    }

    public void writeState(String type, String name, List value) throws IOException {
        Iterator i;
        Object obj;
        boolean first = true;
        Vector unsavedObjsList = null;
        if (!this.writingState) {
            throw new IOException("ZObjectOutputStream.writeState: Error: can't call writeState unless within a writeObject method");
        }
        if (!this.stateWritten) {
            this.stateWritten = true;
            this.dos.writeBytes("\n");
        }
        Iterator i2 = value.iterator();
        while (i2.hasNext()) {
            obj = i2.next();
            if (this.isSaved(obj)) continue;
            if (unsavedObjsList == null) {
                unsavedObjsList = new Vector();
            }
            unsavedObjsList.add(obj);
        }
        if (unsavedObjsList != null) {
            this.dos.writeBytes("    # Reference to unsaved objects skipped:");
            i = unsavedObjsList.iterator();
            while (i.hasNext()) {
                obj = i.next();
                int objId = (Integer)this.unsavedObjs.get(obj);
                this.dos.writeBytes(" @Z" + objId);
            }
            this.dos.writeBytes("\n");
        }
        if (value.size() > 0 && (unsavedObjsList == null || value.size() > unsavedObjsList.size())) {
            this.dos.writeBytes("    " + type + " " + name + " [");
            i = value.iterator();
            while (i.hasNext()) {
                obj = i.next();
                if (!this.isSaved(obj)) continue;
                if (first) {
                    first = false;
                } else {
                    this.dos.writeBytes(" ");
                }
                this.writeState(obj);
            }
            this.dos.writeBytes("]\n");
        }
    }

    public void writeState(String type, String name, short s) throws IOException {
        this.writeState(type, name, new Short(s));
    }

    public void writeState(String type, String name, int i) throws IOException {
        this.writeState(type, name, new Integer(i));
    }

    public void writeState(String type, String name, long l) throws IOException {
        this.writeState(type, name, new Long(l));
    }

    public void writeState(String type, String name, float f) throws IOException {
        this.writeState(type, name, new Float(f));
    }

    public void writeState(String type, String name, double d) throws IOException {
        this.writeState(type, name, new Double(d));
    }

    public void writeState(String type, String name, boolean b) throws IOException {
        this.writeState(type, name, new Boolean(b));
    }

    public void writeState(String type, String name, byte b) throws IOException {
        this.writeState(type, name, new Byte(b));
    }

    public void writeState(String type, String name, Object obj) throws IOException {
        if (!this.writingState) {
            throw new IOException("ZObjectOutputStream.writeState: Error: can't call writeState unless within a writeObject method");
        }
        if (!this.stateWritten) {
            this.stateWritten = true;
            this.dos.writeBytes("\n");
        }
        if (this.isSaved(obj)) {
            this.dos.writeBytes("    " + type + " " + name + " ");
            this.writeState(obj);
            this.dos.writeBytes("\n");
        } else {
            int objId = (Integer)this.unsavedObjs.get(obj);
            this.dos.writeBytes("    # Reference to unsaved object skipped: @Z" + objId + "\n");
        }
    }

    public boolean isSaved(Object obj) {
        boolean rc = !(obj instanceof ZSerializable) || this.unsavedObjs.get(obj) == null;
        return rc;
    }

    public void writeState(Object obj) throws IOException {
        if (obj instanceof Short) {
            this.dos.writeBytes(((Short)obj).toString());
        } else if (obj instanceof Integer) {
            this.dos.writeBytes(((Integer)obj).toString());
        } else if (obj instanceof Long) {
            this.dos.writeBytes(((Long)obj).toString());
        } else if (obj instanceof Float) {
            this.dos.writeBytes(((Float)obj).toString() + "f");
        } else if (obj instanceof Double) {
            this.dos.writeBytes(((Double)obj).toString() + "d");
        } else if (obj instanceof Boolean) {
            this.dos.writeBytes(((Boolean)obj).toString());
        } else if (obj instanceof String) {
            this.dos.writeBytes("\"" + ZParser.translateJavaToJazz((String)obj) + "\"");
        } else if (obj instanceof Byte) {
            this.dos.writeBytes(((Byte)obj).toString());
        } else if (obj instanceof Color) {
            float[] colors = ((Color)obj).getComponents(null);
            this.dos.writeBytes("[");
            int i = 0;
            while (i < colors.length) {
                if (i > 0) {
                    this.dos.writeBytes(" ");
                }
                this.dos.writeBytes(Float.toString(colors[i]));
                ++i;
            }
            this.dos.writeBytes("]");
        } else if (obj instanceof Font) {
            Font font = (Font)obj;
            this.dos.writeBytes("[\"" + font.getName() + "\" " + font.getStyle() + " " + font.getSize() + "]");
        } else if (obj instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)obj;
            this.dos.writeBytes("[" + rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight() + "]");
        } else if (obj instanceof AffineTransform) {
            AffineTransform at = (AffineTransform)obj;
            double[] matrix = new double[6];
            at.getMatrix(matrix);
            this.dos.writeBytes("[" + matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5] + "]");
        } else if (obj instanceof Image) {
            BufferedImage bufferedImage;
            Image image = (Image)obj;
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                Graphics2D g2 = bufferedImage.createGraphics();
                g2.drawImage(image, null, null);
                image = bufferedImage;
            }
            ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)tmpOut);
            encoder.encode(bufferedImage);
            try {
                tmpOut.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.dos.writeBytes(" " + Long.toString(tmpOut.size()) + "\n");
            tmpOut.writeTo(this.dos);
        } else if (obj instanceof ZSerializable) {
            Object value;
            Object replacementObj = this.replacedObjs.get(obj);
            if (replacementObj != null) {
                obj = replacementObj;
            }
            if ((value = this.objs.get(obj)) == null) {
                throw new IOException("ZObjectOutputStream.writeState: Error writing obj that is referenced, but not added to write list: " + obj);
            }
            int objId = (Integer)value;
            this.dos.writeBytes("@Z" + objId);
        } else {
            throw new IOException("ZObjectOutputStream.writeState: Error: can't write out object of type: " + obj.getClass());
        }
    }

    public void write(int b) {
    }

    public void flush() {
        try {
            this.dos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

