/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZDragSequenceEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class ZoomEventHandler
extends ZDragSequenceEventHandler {
    private boolean fIsZooming = false;
    private double fMinMagnification = 0.0;
    private double fMaxMagnification = -1.0;
    private Point2D fGlobalPressPoint;

    public ZoomEventHandler(ZSceneGraphObject aFilteredMouseEventSource) {
        super(aFilteredMouseEventSource);
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter(4);
        }
        return this.fMouseFilter;
    }

    public double getMinMagnification() {
        return this.fMinMagnification;
    }

    public void setMinMagnification(double aMagnification) {
        this.fMinMagnification = aMagnification;
    }

    public double getMaxMagnification() {
        return this.fMaxMagnification;
    }

    public void setMaxMagnification(double aMagnification) {
        this.fMaxMagnification = aMagnification;
    }

    protected void startDrag(ZMouseEvent e) {
        super.startDrag(e);
        this.startZooming(e);
    }

    protected void endDrag(ZMouseEvent e) {
        super.endDrag(e);
        this.stopZooming(e);
    }

    protected void startZooming(ZMouseEvent e) {
        this.isZooming(true);
        this.fGlobalPressPoint = new Point2D.Double(e.getX(), e.getY());
        e.getPath().screenToCamera(this.fGlobalPressPoint, this.getInteractionCamera());
        this.getInteractionCamera().cameraToLocal(this.fGlobalPressPoint, null);
        this.zoomOneStep();
    }

    protected void zoomOneStep() {
        if (this.isZooming()) {
            this.getInteractionCamera().setViewTransform(this.generateNextViewTransform());
            try {
                Thread.sleep(20L);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ZoomEventHandler.this.zoomOneStep();
                    }
                });
            }
            catch (InterruptedException e) {
                this.isZooming(false);
            }
        }
    }

    protected void stopZooming(ZMouseEvent e) {
        this.isZooming(false);
    }

    protected boolean isZooming() {
        return this.fIsZooming;
    }

    protected void isZooming(boolean aBoolean) {
        this.fIsZooming = aBoolean;
    }

    protected AffineTransform generateNextViewTransform() {
        AffineTransform result = this.getInteractionCamera().getViewTransform();
        double dx = this.getCurrentScreenPoint().getX() - this.getDragStartScreenPoint().getX();
        double scaleDelta = 1.0 + 0.001 * dx;
        double currentMag = this.getInteractionCamera().getMagnification();
        double newMag = currentMag * scaleDelta;
        if (newMag < this.fMinMagnification) {
            scaleDelta = this.fMinMagnification / currentMag;
        }
        if (this.fMaxMagnification > 0.0 && newMag > this.fMaxMagnification) {
            scaleDelta = this.fMaxMagnification / currentMag;
        }
        result.translate(this.fGlobalPressPoint.getX(), this.fGlobalPressPoint.getY());
        result.scale(scaleDelta, scaleDelta);
        result.translate(-this.fGlobalPressPoint.getX(), -this.fGlobalPressPoint.getY());
        return result;
    }
}

