/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class ZSwing
extends ZVisualComponent
implements Serializable,
PropertyChangeListener {
    protected double renderCutoff = 0.3f;
    protected JComponent component = null;
    protected double minFontSize = Double.MAX_VALUE;
    protected transient Stroke defaultStroke = new BasicStroke();
    protected Font defaultFont = new Font("Serif", 0, 12);
    public static final String VISUAL_COMPONENT_KEY = "ZSwing";

    public ZSwing(ZCanvas zbc, JComponent component) {
        this.component = component;
        component.putClientProperty(VISUAL_COMPONENT_KEY, this);
        this.init(component);
        zbc.getSwingWrapper().add(component);
        component.revalidate();
        this.reshape();
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        if (this.defaultStroke == null) {
            this.defaultStroke = new BasicStroke();
        }
        g2.setStroke(this.defaultStroke);
        if (this.defaultFont == null) {
            this.defaultFont = new Font("Serif", 0, 12);
        }
        g2.setFont(this.defaultFont);
        if (this.component.getParent() == null) {
            ZCanvas canvas = (ZCanvas)renderContext.getDrawingSurface().getComponent();
            canvas.getSwingWrapper().add(this.component);
            this.component.revalidate();
        }
        if (renderContext.getCompositeMagnification() < this.renderCutoff && renderContext.getDrawingSurface().isInteracting() || this.minFontSize * renderContext.getCompositeMagnification() < 0.5) {
            this.paintAsGreek(g2);
        } else {
            this.paint(g2);
        }
    }

    public void paintAsGreek(Graphics2D g2) {
        Color background = this.component.getBackground();
        Color foreground = this.component.getForeground();
        Rectangle2D.Double rect = new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        if (background != null) {
            g2.setColor(background);
        }
        g2.fill(rect);
        if (foreground != null) {
            g2.setColor(foreground);
        }
        g2.draw(rect);
    }

    public void paint(Graphics2D g2) {
        ZCanvas.ZBasicRepaintManager manager = (ZCanvas.ZBasicRepaintManager)RepaintManager.currentManager(this.component);
        manager.lockRepaint(this.component);
        this.component.paint(g2);
        manager.unlockRepaint(this.component);
    }

    public void repaint(ZBounds repaintBounds) {
        ZNode[] parentsRef = this.getParentsReference();
        int numParents = this.getNumParents();
        int i = 0;
        while (i < numParents) {
            if (i == numParents - 1) {
                parentsRef[i].repaint(repaintBounds);
            } else {
                parentsRef[i].repaint((ZBounds)repaintBounds.clone());
            }
            ++i;
        }
    }

    public void computeBounds() {
        Dimension d = this.component.getPreferredSize();
        this.bounds.setRect(0.0, 0.0, d.getWidth(), d.getHeight());
        if (!this.component.getSize().equals(d)) {
            this.component.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    void init(Component c) {
        Component[] children = null;
        if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (c.getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)c.getFont().getSize());
        }
        if (children != null) {
            int j = 0;
            while (j < children.length) {
                this.init(children[j]);
                ++j;
            }
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setDoubleBuffered(false);
            c.addPropertyChangeListener("font", this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.component.isAncestorOf((Component)evt.getSource()) && ((Component)evt.getSource()).getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)((Component)evt.getSource()).getFont().getSize());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init(this.component);
    }

    static {
        VISUAL_COMPONENT_KEY = VISUAL_COMPONENT_KEY;
    }
}

