/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.ZBoundsLocator;
import edu.umd.cs.jazz.ZHandle;
import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class ZRectangle
extends ZShape {
    public static final Stroke DEFAULT_RECT_STROKE = new BasicStroke(1.0f, 0, 0);
    protected transient Rectangle2D rectangle;

    public ZRectangle() {
        this(new Rectangle2D.Double());
    }

    public ZRectangle(double x, double y) {
        this(new Rectangle2D.Double(x, y, 0.0, 0.0));
    }

    public ZRectangle(double x, double y, double width, double height) {
        this(new Rectangle2D.Double(x, y, width, height));
    }

    public ZRectangle(Rectangle2D r) {
        this.setRect((Rectangle2D)r.clone());
        this.stroke = (BasicStroke)DEFAULT_RECT_STROKE;
    }

    protected Object duplicateObject() {
        ZRectangle newRectangle = (ZRectangle)super.duplicateObject();
        newRectangle.rectangle = (Rectangle2D)this.getRect().clone();
        return newRectangle;
    }

    public Collection getHandles() {
        ArrayList<ZHandle> result = new ArrayList<ZHandle>(8);
        result.add(new ZHandle(ZBoundsLocator.createNorthLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                if (ZRectangle.this.rectangle.getHeight() - dy < 0.0) {
                    dy -= Math.abs(ZRectangle.this.rectangle.getHeight() - dy);
                }
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX(), ZRectangle.this.rectangle.getY() + dy, ZRectangle.this.rectangle.getWidth(), ZRectangle.this.rectangle.getHeight() - dy);
                super.handleDragged(dx, dy, e);
            }
        });
        result.add(new ZHandle(ZBoundsLocator.createEastLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX(), ZRectangle.this.rectangle.getY(), ZRectangle.this.rectangle.getWidth() + dx, ZRectangle.this.rectangle.getHeight());
                super.handleDragged(dx, dy, e);
            }
        });
        result.add(new ZHandle(ZBoundsLocator.createWestLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                if (ZRectangle.this.rectangle.getWidth() - dx < 0.0) {
                    dx -= Math.abs(ZRectangle.this.rectangle.getWidth() - dx);
                }
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX() + dx, ZRectangle.this.rectangle.getY(), ZRectangle.this.rectangle.getWidth() - dx, ZRectangle.this.rectangle.getHeight());
                super.handleDragged(dx, dy, e);
            }
        });
        result.add(new ZHandle(ZBoundsLocator.createSouthLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX(), ZRectangle.this.rectangle.getY(), ZRectangle.this.rectangle.getWidth(), ZRectangle.this.rectangle.getHeight() + dy);
                super.handleDragged(dx, dy, e);
            }
        });
        result.add(new ZHandle(ZBoundsLocator.createNorthWestLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                if (ZRectangle.this.rectangle.getWidth() - dx < 0.0) {
                    dx -= Math.abs(ZRectangle.this.rectangle.getWidth() - dx);
                }
                if (ZRectangle.this.rectangle.getHeight() - dy < 0.0) {
                    dy -= Math.abs(ZRectangle.this.rectangle.getHeight() - dy);
                }
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX() + dx, ZRectangle.this.rectangle.getY() + dy, ZRectangle.this.rectangle.getWidth() - dx, ZRectangle.this.rectangle.getHeight() - dy);
                super.handleDragged(dx, dy, e);
            }
        });
        result.add(new ZHandle(ZBoundsLocator.createSouthWestLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                if (ZRectangle.this.rectangle.getWidth() - dx < 0.0) {
                    dx -= Math.abs(ZRectangle.this.rectangle.getWidth() - dx);
                }
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX() + dx, ZRectangle.this.rectangle.getY(), ZRectangle.this.rectangle.getWidth() - dx, ZRectangle.this.rectangle.getHeight() + dy);
                super.handleDragged(dx, dy, e);
            }
        });
        result.add(new ZHandle(ZBoundsLocator.createNorthEastLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                if (ZRectangle.this.rectangle.getHeight() - dy < 0.0) {
                    dy -= Math.abs(ZRectangle.this.rectangle.getHeight() - dy);
                }
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX(), ZRectangle.this.rectangle.getY() + dy, ZRectangle.this.rectangle.getWidth() + dx, ZRectangle.this.rectangle.getHeight() - dy);
                super.handleDragged(dx, dy, e);
            }
        });
        result.add(new ZHandle(ZBoundsLocator.createSouthEastLocator(this)){

            public void handleDragged(double dx, double dy, ZMouseEvent e) {
                ZRectangle.this.setRect(ZRectangle.this.rectangle.getX(), ZRectangle.this.rectangle.getY(), ZRectangle.this.rectangle.getWidth() + dx, ZRectangle.this.rectangle.getHeight() + dy);
                super.handleDragged(dx, dy, e);
            }
        });
        return result;
    }

    public Rectangle2D getRect() {
        if (this.rectangle == null) {
            this.rectangle = new Rectangle2D.Double();
        }
        return this.rectangle;
    }

    public Shape getShape() {
        return this.getRect();
    }

    public void setRect(double x, double y, double width, double height) {
        if (width < 0.0) {
            width = 0.0;
        }
        if (height < 0.0) {
            height = 0.0;
        }
        this.getRect().setRect(x, y, width, height);
        this.reshape();
    }

    public void setRect(Rectangle2D r) {
        this.getRect().setRect(r);
        this.reshape();
    }

    public void setPenWidth(double width) {
        this.penWidth = width;
        this.absPenWidth = false;
        this.setVolatileBounds(false);
        this.stroke = new BasicStroke((float)this.penWidth, 0, 0);
        this.reshape();
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        Rectangle2D rect = this.getRect();
        Vector<Double> dimensions = new Vector<Double>();
        dimensions.add(new Double(rect.getX()));
        dimensions.add(new Double(rect.getY()));
        dimensions.add(new Double(rect.getWidth()));
        dimensions.add(new Double(rect.getHeight()));
        out.writeState("rectangle", "rect", dimensions);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("rect") == 0) {
            Vector dim = (Vector)fieldValue;
            double xpos = (Double)dim.get(0);
            double ypos = (Double)dim.get(1);
            double width = (Double)dim.get(2);
            double height = (Double)dim.get(3);
            this.setRect(xpos, ypos, width, height);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Rectangle2D rect = this.getRect();
        out.writeDouble(rect.getX());
        out.writeDouble(rect.getY());
        out.writeDouble(rect.getWidth());
        out.writeDouble(rect.getHeight());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x = in.readDouble();
        double y = in.readDouble();
        double w = in.readDouble();
        double h = in.readDouble();
        this.rectangle = new Rectangle2D.Double(x, y, w, h);
    }
}

