/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.component.ZFillColor;
import edu.umd.cs.jazz.component.ZFillPaint;
import edu.umd.cs.jazz.component.ZPenColor;
import edu.umd.cs.jazz.component.ZPenPaint;
import edu.umd.cs.jazz.component.ZStroke;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ZBasicVisualComponent
extends ZVisualComponent
implements ZStroke,
ZPenPaint,
ZFillPaint,
ZPenColor,
ZFillColor {
    public static final double DEFAULT_PEN_WIDTH = 1.0;
    public static final boolean DEFAULT_ABS_PEN_WIDTH = false;
    public static final Paint DEFAULT_PEN_PAINT;
    public static final Paint DEFAULT_FILL_PAINT;
    public static final Stroke DEFAULT_STROKE;
    protected transient Paint fillPaint = DEFAULT_FILL_PAINT;
    protected transient Paint penPaint = DEFAULT_PEN_PAINT;
    protected transient BasicStroke stroke = (BasicStroke)DEFAULT_STROKE;
    protected double penWidth = 1.0;
    protected boolean absPenWidth = false;

    protected Object duplicateObject() {
        ZBasicVisualComponent newBasicVisualComponent = (ZBasicVisualComponent)super.duplicateObject();
        newBasicVisualComponent.penPaint = this.penPaint;
        newBasicVisualComponent.fillPaint = this.fillPaint;
        newBasicVisualComponent.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        newBasicVisualComponent.penWidth = this.penWidth;
        newBasicVisualComponent.absPenWidth = this.absPenWidth;
        return newBasicVisualComponent;
    }

    public double getAbsPenWidth() {
        if (this.absPenWidth) {
            return this.penWidth;
        }
        return 0.0;
    }

    public Color getFillColor() {
        return (Color)this.getFillPaint();
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public Color getPenColor() {
        return (Color)this.getPenPaint();
    }

    public Paint getPenPaint() {
        return this.penPaint;
    }

    public double getPenWidth() {
        if (this.absPenWidth || this.penPaint == null) {
            return 0.0;
        }
        return this.penWidth;
    }

    protected double getPenWidthForCurrentContext() {
        double result = 0.0;
        if (this.penPaint != null) {
            if (this.absPenWidth) {
                ZRoot aRoot = this.getRoot();
                if (aRoot != null) {
                    ZRenderContext rc = aRoot.getCurrentRenderContext();
                    double mag = rc == null ? 1.0 : rc.getCameraMagnification();
                    result = this.penWidth / mag;
                } else {
                    result = this.penWidth;
                }
            } else {
                result = this.penWidth;
            }
        }
        return result;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setAbsPenWidth(double width) {
        this.penWidth = width;
        this.absPenWidth = true;
        this.reshape();
    }

    public void setFillColor(Color color) {
        this.setFillPaint(color);
    }

    public void setFillPaint(Paint aPaint) {
        this.fillPaint = aPaint;
        this.repaint();
    }

    public void setPenColor(Color color) {
        this.setPenPaint(color);
    }

    public void setPenPaint(Paint aPaint) {
        boolean boundsChanged = false;
        if (this.penPaint == null && aPaint != null || this.penPaint != null && aPaint == null) {
            boundsChanged = true;
        }
        this.penPaint = aPaint;
        if (boundsChanged) {
            this.reshape();
        } else {
            this.repaint();
        }
    }

    public void setPenWidth(double width) {
        this.penWidth = width;
        this.absPenWidth = false;
        if (this.volatileBounds) {
            this.setVolatileBounds(false);
        }
        this.stroke = new BasicStroke((float)this.penWidth, 0, 2);
        this.reshape();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = (BasicStroke)stroke;
        this.penWidth = this.stroke.getLineWidth();
        this.absPenWidth = false;
        this.setVolatileBounds(false);
        this.reshape();
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        float[] dash = null;
        if (fieldName.compareTo("penPaint") == 0) {
            if (fieldValue.equals("nopaint")) {
                this.penPaint = null;
            } else {
                this.setPenPaint((Paint)fieldValue);
            }
        } else if (fieldName.compareTo("fillPaint") == 0) {
            if (fieldValue.equals("nopaint")) {
                this.fillPaint = null;
            } else {
                this.setFillPaint((Paint)fieldValue);
            }
        } else if (fieldName.compareTo("penWidth") == 0) {
            if (this.absPenWidth) {
                this.setAbsPenWidth((Double)fieldValue);
            } else {
                this.setPenWidth((Double)fieldValue);
            }
        } else if (fieldName.compareTo("dashArray") == 0) {
            Vector dashArray = (Vector)fieldValue;
            if (dashArray.size() > 0) {
                dash = new float[dashArray.size()];
                int i = 0;
                while (i < dashArray.size()) {
                    dash[i] = ((Float)dashArray.elementAt(i)).floatValue();
                    ++i;
                }
            }
        } else if (fieldName.compareTo("stroke") == 0) {
            Vector strokeVector = (Vector)fieldValue;
            float width = ((Float)strokeVector.elementAt(0)).floatValue();
            int cap = (Integer)strokeVector.elementAt(1);
            int join = (Integer)strokeVector.elementAt(2);
            float miterlimit = ((Float)strokeVector.elementAt(3)).floatValue();
            float dash_phase = ((Float)strokeVector.elementAt(4)).floatValue();
            if (dash == null) {
                this.setStroke(new BasicStroke(width, cap, join, miterlimit));
            } else {
                this.setStroke(new BasicStroke(width, cap, join, miterlimit, dash, dash_phase));
            }
        } else if (fieldName.compareTo("fillColor") == 0) {
            this.setFillPaint((Paint)fieldValue);
        } else if (fieldName.compareTo("penColor") == 0) {
            this.setPenPaint((Paint)fieldValue);
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.penPaint != DEFAULT_PEN_PAINT) {
            if (this.penPaint != null) {
                out.writeState("java.awt.Color", "penPaint", this.penPaint);
            } else {
                out.writeState("java.lang.String", "penPaint", "nopaint");
            }
        }
        if (this.fillPaint != DEFAULT_FILL_PAINT) {
            if (this.fillPaint != null) {
                out.writeState("java.awt.Color", "fillPaint", this.fillPaint);
            } else {
                out.writeState("java.lang.String", "fillPaint", "nopaint");
            }
        }
        if (this.absPenWidth) {
            out.writeState("boolean", "absPenWidth", this.absPenWidth);
        }
        if (this.getPenWidth() != 1.0) {
            out.writeState("double", "penWidth", this.getPenWidth());
        }
        if (this.stroke != null && this.stroke != DEFAULT_STROKE) {
            float[] dash = this.stroke.getDashArray();
            Vector<Float> dashArray = new Vector<Float>();
            if (dash != null && dash.length > 0) {
                int i = 0;
                while (i < dash.length) {
                    dashArray.addElement(new Float(dash[i]));
                    ++i;
                }
            }
            out.writeState("java.util.Vector", "dashArray", dashArray);
            Vector<Number> strokeVector = new Vector<Number>();
            strokeVector.addElement(new Float(this.stroke.getLineWidth()));
            strokeVector.addElement(new Integer(this.stroke.getEndCap()));
            strokeVector.addElement(new Integer(this.stroke.getLineJoin()));
            strokeVector.addElement(new Float(this.stroke.getMiterLimit()));
            strokeVector.addElement(new Float(this.stroke.getDashPhase()));
            out.writeState("java.util.Vector", "stroke", strokeVector);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.penPaint == null || this.penPaint instanceof Color) {
            out.writeBoolean(true);
            out.writeObject(this.penPaint);
        } else {
            out.writeBoolean(false);
        }
        if (this.fillPaint == null || this.fillPaint instanceof Color) {
            out.writeBoolean(true);
            out.writeObject(this.fillPaint);
        } else {
            out.writeBoolean(false);
        }
        float[] dash = this.stroke.getDashArray();
        Vector<Float> dashArray = new Vector<Float>();
        if (dash != null && dash.length > 0) {
            int i = 0;
            while (i < dash.length) {
                dashArray.addElement(new Float(dash[i]));
                ++i;
            }
        }
        out.writeObject(dashArray);
        Vector<Number> strokeVector = new Vector<Number>();
        strokeVector.addElement(new Float(this.stroke.getLineWidth()));
        strokeVector.addElement(new Integer(this.stroke.getEndCap()));
        strokeVector.addElement(new Integer(this.stroke.getLineJoin()));
        strokeVector.addElement(new Float(this.stroke.getMiterLimit()));
        strokeVector.addElement(new Float(this.stroke.getDashPhase()));
        out.writeObject(strokeVector);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean exist = in.readBoolean();
        if (exist) {
            this.penPaint = (Paint)in.readObject();
        }
        if (exist = in.readBoolean()) {
            this.fillPaint = (Paint)in.readObject();
        }
        float[] dash = null;
        Vector dashArray = (Vector)in.readObject();
        if (dashArray.size() > 0) {
            dash = new float[dashArray.size()];
            int i = 0;
            while (i < dashArray.size()) {
                dash[i] = ((Float)dashArray.elementAt(i)).floatValue();
                ++i;
            }
        }
        Vector strokeVector = (Vector)in.readObject();
        float width = ((Float)strokeVector.elementAt(0)).floatValue();
        int cap = (Integer)strokeVector.elementAt(1);
        int join = (Integer)strokeVector.elementAt(2);
        float miterlimit = ((Float)strokeVector.elementAt(3)).floatValue();
        float dash_phase = ((Float)strokeVector.elementAt(4)).floatValue();
        this.stroke = dash == null ? new BasicStroke(width, cap, join, miterlimit) : new BasicStroke(width, cap, join, miterlimit, dash, dash_phase);
    }

    static {
        DEFAULT_PEN_WIDTH = 1.0;
        DEFAULT_ABS_PEN_WIDTH = false;
        DEFAULT_PEN_PAINT = Color.black;
        DEFAULT_FILL_PAINT = Color.white;
        DEFAULT_STROKE = new BasicStroke(1.0f, 0, 2);
    }
}

