/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.animation;

import edu.umd.cs.jazz.animation.ZAnimation;
import edu.umd.cs.jazz.animation.ZNextFrameCondition;
import edu.umd.cs.jazz.animation.ZNextFrameOnElapsedFrames;
import edu.umd.cs.jazz.animation.ZNextFrameOnElapsedTime;
import edu.umd.cs.jazz.util.ZPriorityQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Timer;

public class ZAnimationScheduler
implements ActionListener {
    private static ZAnimationScheduler theAnimationScheduler;
    private Timer fTimer;
    private int fFrameDelay = 20;
    private long fCurrentTime = 0L;
    private long fCurrentFrame = 0L;
    private ArrayList fProcessList = new ArrayList();
    private ZPriorityQueue fTimeConditionQueue = new ZPriorityQueue();
    private ZPriorityQueue fFrameConditionQueue = new ZPriorityQueue();

    public static ZAnimationScheduler instance() {
        if (theAnimationScheduler == null) {
            theAnimationScheduler = new ZAnimationScheduler();
        }
        return theAnimationScheduler;
    }

    protected ZAnimationScheduler() {
    }

    public long getCurrentTime() {
        return this.fCurrentTime;
    }

    public long getCurrentFrame() {
        return this.fCurrentFrame;
    }

    public int getFrameDelay() {
        return this.fFrameDelay;
    }

    public void setFrameDelay(int aDelay) {
        this.stopAnimationScheduler();
        this.fFrameDelay = aDelay;
        this.startAnimationScheduler();
    }

    public void scheduleAnimation(ZAnimation aAnimation, ZNextFrameCondition aCondition) {
        if (aCondition instanceof ZNextFrameOnElapsedTime) {
            this.fTimeConditionQueue.insert(new ZScheduledAnimation(aAnimation, aCondition));
        } else if (aCondition instanceof ZNextFrameOnElapsedFrames) {
            this.fFrameConditionQueue.insert(new ZScheduledAnimation(aAnimation, aCondition));
        }
        if (!this.isAnimationSchedulerRunning()) {
            this.startAnimationScheduler();
        }
    }

    public void processAnimations(long aTime) {
        this.fCurrentTime = aTime;
        Iterator i = this.getAnimationsToProcessForCurrentFrame();
        while (i.hasNext()) {
            ZAnimation each = (ZAnimation)i.next();
            if (each.isStopped()) continue;
            each.animateFrameForTime(this.fCurrentTime);
        }
        if (this.fTimeConditionQueue.isEmpty() && this.fFrameConditionQueue.isEmpty()) {
            this.stopAnimationScheduler();
        }
        ++this.fCurrentFrame;
    }

    protected Iterator getAnimationsToProcessForCurrentFrame() {
        ZScheduledAnimation scheduledAnimation;
        this.fProcessList.clear();
        while (!this.fTimeConditionQueue.isEmpty()) {
            scheduledAnimation = (ZScheduledAnimation)this.fTimeConditionQueue.first();
            if (!scheduledAnimation.isReadyToAnimate()) break;
            this.fTimeConditionQueue.extractFirst();
            this.fProcessList.add(scheduledAnimation.getAnimation());
        }
        while (!this.fFrameConditionQueue.isEmpty()) {
            scheduledAnimation = (ZScheduledAnimation)this.fFrameConditionQueue.first();
            if (!scheduledAnimation.isReadyToAnimate()) break;
            this.fFrameConditionQueue.extractFirst();
            this.fProcessList.add(scheduledAnimation.getAnimation());
        }
        return this.fProcessList.iterator();
    }

    public boolean isAnimationSchedulerRunning() {
        return this.getTimer().isRunning();
    }

    protected synchronized void startAnimationScheduler() {
        this.getTimer().start();
    }

    protected synchronized void stopAnimationScheduler() {
        this.getTimer().stop();
    }

    public void actionPerformed(ActionEvent e) {
        this.processAnimations(System.currentTimeMillis());
    }

    protected Timer getTimer() {
        if (this.fTimer == null) {
            this.fTimer = new Timer(this.getFrameDelay(), this);
        }
        return this.fTimer;
    }

    private class ZScheduledAnimation
    implements Comparable {
        private ZAnimation fAnimation;
        private ZNextFrameCondition fFrameCondition;

        public ZScheduledAnimation(ZAnimation aAnimation, ZNextFrameCondition aCondition) {
            this.fAnimation = aAnimation;
            this.fFrameCondition = aCondition;
        }

        public boolean isReadyToAnimate() {
            return this.fFrameCondition.isReadyToAnimate();
        }

        public ZAnimation getAnimation() {
            return this.fAnimation;
        }

        public int compareTo(Object o) {
            ZScheduledAnimation scheduledAnimation = (ZScheduledAnimation)o;
            return this.fFrameCondition.compareTo(scheduledAnimation.fFrameCondition);
        }
    }
}

