/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZLeaf;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ZVisualLeaf
extends ZLeaf
implements ZSerializable,
Serializable {
    protected ZList.ZVisualComponentList visualComponents = ZListImpl.NullList;
    private transient boolean cacheVolatile = false;

    public ZVisualLeaf() {
    }

    public ZVisualLeaf(ZVisualComponent visualComponent) {
        this.setVisualComponent(visualComponent);
    }

    public void addVisualComponent(ZVisualComponent visualComponent) {
        if (visualComponent == null) {
            return;
        }
        if (this.visualComponents.isNull()) {
            this.visualComponents = new ZListImpl.ZVisualComponentListImpl(1);
        }
        if (this.visualComponents.contains(visualComponent)) {
            return;
        }
        if (this.inTransaction != visualComponent.inTransaction) {
            if (this.inTransaction) {
                visualComponent.markInTransaction();
            } else {
                visualComponent.markNotInTransaction();
            }
        }
        this.visualComponents.add(visualComponent);
        visualComponent.addParent(this);
        this.updateBounds();
        this.updateVolatility();
        visualComponent.repaint();
    }

    public void addVisualComponents(Collection aVisualComponentCollection) {
        if (this.visualComponents.isNull()) {
            this.visualComponents = new ZListImpl.ZVisualComponentListImpl(1);
        }
        Iterator i = aVisualComponentCollection.iterator();
        while (i.hasNext()) {
            ZVisualComponent each = (ZVisualComponent)i.next();
            if (this.inTransaction != each.inTransaction) {
                if (this.inTransaction) {
                    each.markInTransaction();
                } else {
                    each.markNotInTransaction();
                }
            }
            this.visualComponents.add(each);
            each.addParent(this);
        }
        this.updateVolatility();
        this.reshape();
    }

    public void clearVisualComponents() {
        ZVisualComponent[] visualComponentsRef = this.visualComponents.getVisualComponentsReference();
        int i = 0;
        while (i < this.visualComponents.size()) {
            visualComponentsRef[i].removeParent(this);
            ++i;
        }
        this.visualComponents.clear();
        this.visualComponents = ZListImpl.NullList;
        this.repaint();
        this.updateBounds();
        this.updateVolatility();
    }

    protected void computeBounds() {
        this.bounds.reset();
        this.bounds = this.visualComponents.collectiveBoundsReference(this.bounds);
    }

    protected Object duplicateObject() {
        ZVisualLeaf newObject = (ZVisualLeaf)super.duplicateObject();
        if (!this.visualComponents.isNull()) {
            newObject.visualComponents = (ZList.ZVisualComponentList)this.visualComponents.clone();
            ZVisualComponent[] visualComponentsRef = this.visualComponents.getVisualComponentsReference();
            int i = 0;
            while (i < this.visualComponents.size()) {
                visualComponentsRef[i].clone();
                ++i;
            }
        }
        return newObject;
    }

    public final ZVisualComponent getFirstVisualComponent() {
        return (ZVisualComponent)this.visualComponents.get(0);
    }

    public Collection getHandles() {
        ArrayList result = new ArrayList();
        ZVisualComponent[] visualComponentsRef = this.getVisualComponents();
        int i = 0;
        while (i < this.visualComponents.size()) {
            result.addAll(visualComponentsRef[i].getHandles());
            ++i;
        }
        return result;
    }

    public int getNumVisualComponents() {
        return this.visualComponents.size();
    }

    public ZVisualComponent getVisualComponent(int i) {
        return (ZVisualComponent)this.visualComponents.get(i);
    }

    public ZBounds getVisualComponentBounds() {
        return this.visualComponents.collectiveBoundsReference(new ZBounds());
    }

    public ZBounds getVisualComponentGlobalBounds() {
        if (this.visualComponents.isNull()) {
            return null;
        }
        ZBounds result = this.getVisualComponentBounds();
        this.localToGlobal(result);
        return result;
    }

    public final ZVisualComponent[] getVisualComponents() {
        return this.visualComponents.getVisualComponentsReference();
    }

    public boolean getVolatileBounds() {
        return super.getVolatileBounds() || this.cacheVolatile;
    }

    protected void computeVolatileBounds() {
        super.computeVolatileBounds();
        this.cacheVolatile = !this.visualComponents.isNull() ? this.visualComponents.collectiveHasVolatileBounds() : false;
    }

    public int indexOf(ZVisualComponent vis) {
        return this.visualComponents.indexOf(vis);
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.isPickable() && !this.visualComponents.isNull()) {
            path.push(this);
            ZVisualComponent picked = (ZVisualComponent)this.visualComponents.collectivePick(rect, path);
            if (picked != null) {
                if (!(picked instanceof ZCamera)) {
                    path.setObject(picked);
                }
                return true;
            }
            path.pop(this);
        }
        return false;
    }

    public void removeVisualComponent(ZVisualComponent visualComponent) {
        if (visualComponent == null) {
            return;
        }
        int index = this.visualComponents.indexOf(visualComponent);
        if (index == -1) {
            return;
        }
        this.visualComponents.remove(index);
        visualComponent.removeParent(this);
        this.repaint();
        this.updateBounds();
        this.updateVolatility();
    }

    public void render(ZRenderContext renderContext) {
        ZVisualComponent[] visualComponentsRef = this.getVisualComponents();
        int i = 0;
        while (i < this.visualComponents.size()) {
            visualComponentsRef[i].render(renderContext);
            ++i;
        }
        ZDebug.incPaintCount();
        if (ZDebug.showBounds) {
            Graphics2D g2 = renderContext.getGraphics2D();
            g2.setColor(new Color(60, 60, 60));
            g2.setStroke(new BasicStroke((float)(1.0 / renderContext.getCompositeMagnification()), 0, 0));
            g2.draw(this.getBoundsReference());
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("visualComponents") == 0) {
            this.addVisualComponents((Vector)fieldValue);
        } else if (fieldName.compareTo("visualComponent") == 0) {
            ZVisualComponent visualComponent = (ZVisualComponent)fieldValue;
            this.setVisualComponent(visualComponent);
        }
    }

    public void setVisualComponent(int i, ZVisualComponent visualComponent) {
        ZVisualComponent old = (ZVisualComponent)this.visualComponents.get(i);
        old.removeParent(this);
        this.visualComponents.set(i, visualComponent);
        visualComponent.addParent(this);
        if (this.inTransaction != visualComponent.inTransaction) {
            if (this.inTransaction) {
                visualComponent.markInTransaction();
            } else {
                visualComponent.markNotInTransaction();
            }
        }
        this.updateVolatility();
        this.reshape();
    }

    public void setVisualComponent(ZVisualComponent visualComponent) {
        this.clearVisualComponents();
        this.addVisualComponent(visualComponent);
    }

    public void trimToSize() {
        super.trimToSize();
        this.visualComponents.trimToSize();
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        super.updateObjectReferences(objRefTable);
        if (!this.visualComponents.isNull()) {
            int n = 0;
            ZVisualComponent[] visualComponentsRef = this.visualComponents.getVisualComponentsReference();
            int i = 0;
            while (i < this.visualComponents.size()) {
                ZVisualComponent newComponent = (ZVisualComponent)objRefTable.getNewObjectReference(visualComponentsRef[i]);
                if (newComponent != null) {
                    visualComponentsRef[n++] = newComponent;
                }
                ++i;
            }
            this.visualComponents.setSize(n);
        }
    }

    protected void markInTransaction() {
        super.markInTransaction();
        ZVisualComponent[] components = this.visualComponents.getVisualComponentsReference();
        int i = 0;
        while (i < this.visualComponents.size()) {
            components[i].markInTransaction();
            ++i;
        }
    }

    protected void markNotInTransaction() {
        super.markNotInTransaction();
        ZVisualComponent[] components = this.visualComponents.getVisualComponentsReference();
        int i = 0;
        while (i < this.visualComponents.size()) {
            components[i].markNotInTransaction();
            ++i;
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        this.visualComponents.writeObject("visualComponents", out);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        ZVisualComponent[] visualComponentsRef = this.getVisualComponents();
        int i = 0;
        while (i < this.visualComponents.size()) {
            out.addObject(visualComponentsRef[i]);
            ++i;
        }
    }
}

