/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZMagBoundsFindFilter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;

public class ZSpatialIndex
implements Serializable {
    private int minChildren = 5;
    private int maxChildren = 10;
    private int nodesSearched;
    protected ZCamera camera;
    private boolean status;
    protected RTreeNode root;
    protected Hashtable drawOrder;
    private DrawOrderComp doc;
    private AffineTransform groupNodeTransform = null;

    public ZSpatialIndex() {
        this.camera = new ZCamera();
        this.status = true;
        this.root = new RTreeNodeLeaf();
        this.drawOrder = new Hashtable();
        this.doc = new DrawOrderComp();
    }

    public ZSpatialIndex(ZCamera aCamera) {
        this.camera = aCamera;
        this.status = true;
        this.root = new RTreeNodeLeaf();
        this.drawOrder = new Hashtable();
        this.doc = new DrawOrderComp();
    }

    private void incrementNodesSearched() {
        ++this.nodesSearched;
    }

    public int getNodesSearched() {
        return this.nodesSearched;
    }

    public void setStatus(boolean aStatus) {
        if (aStatus != this.status) {
            if (aStatus) {
                this.status = true;
                this.reIndex();
            } else {
                this.status = false;
                this.root = null;
            }
        }
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setGroupNodeTransform(AffineTransform at) {
        this.getGroupNodeTransform().setTransform(at);
    }

    public AffineTransform getGroupNodeTransform() {
        if (this.groupNodeTransform == null) {
            this.groupNodeTransform = new AffineTransform();
        }
        return this.groupNodeTransform;
    }

    public void reIndex() {
        this.root = new RTreeNodeLeaf();
        ZMagBoundsFindFilter filter = new ZMagBoundsFindFilter(this.camera.getViewBounds(), this.camera.getMagnification());
        ArrayList nodes = this.camera.findNodes(filter);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            ZNode node = (ZNode)i.next();
            this.add(node);
        }
    }

    public void addNode(ZNode node) {
        this.add(node);
        this.drawOrder.put(node, new Integer(this.drawOrder.size()));
    }

    protected void add(ZNode obj) {
        if (!this.status) {
            return;
        }
        RTreeNode[] nodeArray = new RTreeNode[2];
        boolean split = this.root.add(obj, nodeArray);
        if (split) {
            this.root = new RTreeNodeInternal();
            this.root.add(nodeArray[0]);
            this.root.add(nodeArray[1]);
        }
    }

    public boolean removeNode(ZNode node) {
        boolean result = this.remove(node);
        if (result) {
            this.drawOrder.remove(node);
        }
        return result;
    }

    protected boolean remove(ZNode obj) {
        ArrayList reinsertList = new ArrayList();
        ArrayList objList = new ArrayList();
        if (!this.status) {
            return false;
        }
        boolean rc = this.root.remove(obj, reinsertList);
        if (rc) {
            if (this.root.getNumRegions() == 1 && !this.root.isLeaf()) {
                RTreeNode oldRoot = this.root;
                this.root = ((RTreeNodeInternal)this.root).getChildNode(0);
            }
            Object[] reinsertListArray = reinsertList.toArray();
            int i = 0;
            while (i < reinsertListArray.length) {
                ((RTreeNode)reinsertListArray[i]).extractObjs(objList);
                ++i;
            }
            Object[] objListArray = objList.toArray();
            int i2 = 0;
            while (i2 < objListArray.length) {
                this.add((ZNode)objListArray[i2]);
                ++i2;
            }
        }
        return rc;
    }

    public void queryPoint(ArrayList result, Point2D pt) {
        this.queryPoint(result, pt, 0.0, 1.0);
    }

    public void queryPoint(ArrayList result, Point2D pt, double minSize, double currentMag) {
        if (!this.status) {
            return;
        }
        result.clear();
        this.nodesSearched = 0;
        this.root.queryPoint(result, pt, minSize, currentMag);
        Object[] resultArray = result.toArray();
        Arrays.sort(resultArray, this.doc);
        result.clear();
        int i = 0;
        while (i < resultArray.length) {
            result.add(resultArray[i]);
            ++i;
        }
    }

    public void queryWindow(ArrayList result, Rectangle2D queryBBox) {
        this.queryWindow(result, queryBBox, 0.0, 1.0);
    }

    public void queryWindow(ArrayList result, Rectangle2D queryBBox, double minSize, double currentMag) {
        if (!this.status) {
            return;
        }
        result.clear();
        this.nodesSearched = 0;
        this.root.queryWindow(result, queryBBox, minSize, currentMag);
        Object[] resultArray = result.toArray();
        Arrays.sort(resultArray, this.doc);
        result.clear();
        int i = 0;
        while (i < resultArray.length) {
            result.add(resultArray[i]);
            ++i;
        }
    }

    public void displayTree(String tree) {
        if (!this.status) {
            return;
        }
        System.out.println("+++++++++++++++++++++++++++++++++++++++++");
        this.root.displayTree(tree, 0);
        System.out.println("+++++++++++++++++++++++++++++++++++++++++");
    }

    public int getMinChildren() {
        return this.minChildren;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMinChildren(int aMinChildren) {
        this.minChildren = aMinChildren;
        this.reIndex();
    }

    public void setMaxChildren(int aMaxChildren) {
        this.maxChildren = aMaxChildren;
        this.reIndex();
    }

    private ZBounds getCurrentBounds(ZNode obj) {
        ZBounds bbox = obj.getBounds();
        if (obj.editor().hasTransformGroup()) {
            bbox.transform(obj.editor().getTransformGroup().getTransform());
        }
        bbox.transform(this.groupNodeTransform);
        return bbox;
    }

    abstract class RTreeNode {
        Rectangle2D region = new Rectangle2D.Double();

        RTreeNode() {
        }

        abstract void add(ZNode var1);

        abstract void add(RTreeNode var1);

        abstract boolean add(ZNode var1, RTreeNode[] var2);

        abstract void extractObjs(ArrayList var1);

        abstract int getNumRegions();

        abstract Rectangle2D getChildRegion(int var1);

        abstract boolean isLeaf();

        abstract boolean remove(ZNode var1, ArrayList var2);

        abstract void updateRegion();

        abstract void queryPoint(ArrayList var1, Point2D var2, double var3, double var5);

        abstract void queryPoint(ArrayList var1, Point2D var2);

        abstract void queryWindow(ArrayList var1, Rectangle2D var2, double var3, double var5);

        abstract void queryWindow(ArrayList var1, Rectangle2D var2);

        abstract void displaySelf(String var1);

        abstract void displayTree(String var1, int var2);

        double computeExpansion(Rectangle2D aRegion) {
            Rectangle2D bbox = this.region;
            Rectangle2D.union(bbox, aRegion, bbox);
            double expansion = bbox.getHeight() * bbox.getWidth() - this.region.getHeight() * this.region.getWidth();
            return expansion;
        }

        int[] computeMostDistantRegions() {
            double val;
            int regions = this.getNumRegions();
            if (regions < 2) {
                System.err.println("RTreeNode::ComputeMostDistantRegions: ERROR: Less than 2 regions");
                System.exit(1);
            }
            double llval = this.getChildRegion(0).getX() + this.getChildRegion(0).getY();
            double urval = this.getChildRegion(0).getX() + this.getChildRegion(0).getWidth() + (this.getChildRegion(0).getY() + this.getChildRegion(0).getHeight());
            int llrect = 0;
            int urrect = 0;
            int i = 1;
            while (i < regions) {
                val = this.getChildRegion(i).getX() + this.getChildRegion(i).getY();
                if (val < llval) {
                    llval = val;
                    llrect = i;
                }
                if ((val = this.getChildRegion(i).getX() + this.getChildRegion(i).getHeight() + (this.getChildRegion(i).getY() + this.getChildRegion(i).getWidth())) > urval) {
                    urval = val;
                    urrect = i;
                }
                ++i;
            }
            if (llrect == urrect) {
                boolean first = true;
                int rect = llrect;
                double minllval = llval;
                double maxurval = urval;
                i = 0;
                while (i < regions) {
                    if (i != rect) {
                        if (first) {
                            llval = this.getChildRegion(i).getX() + this.getChildRegion(i).getY();
                            urval = this.getChildRegion(i).getX() + this.getChildRegion(i).getWidth() + (this.getChildRegion(i).getY() + this.getChildRegion(i).getHeight());
                            llrect = i;
                            urrect = i;
                            first = false;
                        } else {
                            val = this.getChildRegion(i).getX() + this.getChildRegion(i).getY();
                            if (val < llval) {
                                llval = val;
                                llrect = i;
                            }
                            if ((val = this.getChildRegion(i).getX() + this.getChildRegion(i).getWidth() + (this.getChildRegion(i).getY() + this.getChildRegion(i).getHeight())) > urval) {
                                urval = val;
                                urrect = i;
                            }
                        }
                    }
                    ++i;
                }
                if (llval - minllval > maxurval - urval) {
                    llrect = rect;
                } else {
                    urrect = rect;
                }
            }
            int[] aRegion = new int[]{llrect, urrect};
            return aRegion;
        }

        Rectangle2D getRegion() {
            return this.region;
        }
    }

    class RTreeNodeLeaf
    extends RTreeNode {
        int numObjs;
        ZNode[] object;

        RTreeNodeLeaf() {
            int aMaxChildren = ZSpatialIndex.this.getMaxChildren();
            this.numObjs = 0;
            this.object = new ZNode[aMaxChildren];
            int i = 0;
            while (i < aMaxChildren) {
                this.object[i] = new ZNode();
                ++i;
            }
        }

        RTreeNodeLeaf(ZNode obj) {
            int aMaxChildren = ZSpatialIndex.this.getMaxChildren();
            this.numObjs = 0;
            this.object = new ZNode[aMaxChildren];
            int i = 0;
            while (i < aMaxChildren) {
                this.object[i] = new ZNode();
                ++i;
            }
            this.add(obj);
        }

        boolean isLeaf() {
            return true;
        }

        int getNumRegions() {
            return this.numObjs;
        }

        Rectangle2D getChildRegion(int regionNum) {
            if (regionNum < this.numObjs) {
                return ZSpatialIndex.this.getCurrentBounds(this.object[regionNum]);
            }
            return null;
        }

        void add(ZNode obj) {
            if (this.numObjs == ZSpatialIndex.this.getMaxChildren()) {
                System.err.println("add(): ERROR: Node is full, can't add object");
                System.exit(1);
            }
            this.object[this.numObjs] = obj;
            ++this.numObjs;
            this.updateRegion();
        }

        void add(RTreeNode node) {
            System.err.println("add(): ERROR: Can't add node directly to leaf node");
            System.exit(1);
        }

        boolean add(ZNode obj, RTreeNode[] nodeArray) {
            boolean split;
            if (this.numObjs == ZSpatialIndex.this.getMaxChildren()) {
                this.split(nodeArray);
                RTreeNode node1 = nodeArray[0];
                RTreeNode node2 = nodeArray[1];
                double expansion1 = node1.computeExpansion(ZSpatialIndex.this.getCurrentBounds(obj));
                double expansion2 = node2.computeExpansion(ZSpatialIndex.this.getCurrentBounds(obj));
                if (expansion1 < expansion2) {
                    node1.add(obj);
                } else {
                    node2.add(obj);
                }
                split = true;
                nodeArray[0] = node1;
                nodeArray[1] = node2;
            } else {
                this.add(obj);
                split = false;
            }
            return split;
        }

        void split(RTreeNode[] nodeArray) {
            int region1 = 0;
            int region2 = 0;
            int[] regions = this.computeMostDistantRegions();
            region1 = regions[0];
            region2 = regions[1];
            RTreeNodeLeaf node1 = new RTreeNodeLeaf(this.object[region1]);
            RTreeNodeLeaf node2 = new RTreeNodeLeaf(this.object[region2]);
            int aMinChildren = ZSpatialIndex.this.getMinChildren();
            int remainingObjs = this.numObjs - 2;
            int i = 0;
            while (i < this.numObjs) {
                if (i != region1 && i != region2) {
                    if (node1.getNumRegions() + remainingObjs <= aMinChildren) {
                        node1.add(this.object[i]);
                    } else if (node2.getNumRegions() + remainingObjs <= aMinChildren) {
                        node2.add(this.object[i]);
                    } else {
                        double expansion2;
                        double expansion1 = node1.computeExpansion(ZSpatialIndex.this.getCurrentBounds(this.object[i]));
                        if (expansion1 < (expansion2 = node2.computeExpansion(ZSpatialIndex.this.getCurrentBounds(this.object[i])))) {
                            node1.add(this.object[i]);
                        } else {
                            node2.add(this.object[i]);
                        }
                    }
                    --remainingObjs;
                }
                ++i;
            }
            nodeArray[0] = node1;
            nodeArray[1] = node2;
        }

        boolean remove(ZNode obj, ArrayList list) {
            boolean rc = false;
            int i = 0;
            while (i < this.numObjs) {
                if (this.object[i] == obj) {
                    int j = i;
                    while (j < this.numObjs - 1) {
                        this.object[j] = this.object[j + 1];
                        ++j;
                    }
                    --this.numObjs;
                    this.updateRegion();
                    rc = true;
                    break;
                }
                ++i;
            }
            return rc;
        }

        void updateRegion() {
            if (this.numObjs == 0) {
                this.region.setRect(0.0, 0.0, 0.0, 0.0);
            }
            this.region = ZSpatialIndex.this.getCurrentBounds(this.object[0]);
            int i = 1;
            while (i < this.numObjs) {
                this.region = this.region.createUnion(ZSpatialIndex.this.getCurrentBounds(this.object[i]));
                ++i;
            }
        }

        void extractObjs(ArrayList objList) {
            int i = 0;
            while (i < this.numObjs) {
                objList.add(this.object[i]);
                ++i;
            }
        }

        public void displaySelf(String tree) {
            String buf = null;
            System.out.println(tree + "leaf node x: " + this.region.getX() + " y: " + this.region.getY() + "w: " + this.region.getWidth() + " h: " + this.region.getHeight());
            tree = tree + buf;
            System.out.println("");
            System.out.println("{");
            int i = 0;
            while (i < this.numObjs) {
                System.out.println(this.object[i].toString());
                System.out.println("  " + ZSpatialIndex.this.getCurrentBounds(this.object[i]));
                ++i;
            }
            System.out.println("}\n");
        }

        public void displayTree(String tree, int level) {
            int i = 0;
            while (i < level) {
                tree = tree + "  ";
                ++i;
            }
            this.displaySelf(tree);
        }

        void queryPoint(ArrayList result, Point2D pt) {
            this.queryPoint(result, pt, 0.0, 1.0);
        }

        void queryPoint(ArrayList result, Point2D pt, double minSize, double currentMag) {
            int i = 0;
            while (i < this.numObjs) {
                ZSpatialIndex.this.incrementNodesSearched();
                ZBounds bbox = ZSpatialIndex.this.getCurrentBounds(this.object[i]);
                double maxDim = Math.max(((RectangularShape)bbox).getHeight(), ((RectangularShape)bbox).getWidth()) * currentMag;
                if (bbox.contains(pt.getX(), pt.getY()) && maxDim >= minSize) {
                    result.add(this.object[i]);
                }
                ++i;
            }
        }

        void queryWindow(ArrayList result, Rectangle2D queryBBox) {
            this.queryWindow(result, queryBBox, 0.0, 1.0);
        }

        void queryWindow(ArrayList result, Rectangle2D queryBBox, double minSize, double currentMag) {
            int i = 0;
            while (i < this.numObjs) {
                ZSpatialIndex.this.incrementNodesSearched();
                ZBounds bbox = ZSpatialIndex.this.getCurrentBounds(this.object[i]);
                double maxDim = Math.max(((RectangularShape)bbox).getHeight(), ((RectangularShape)bbox).getWidth()) * currentMag;
                boolean overlaps = bbox.intersects(queryBBox.getX(), queryBBox.getY(), queryBBox.getWidth(), queryBBox.getHeight());
                if (overlaps && maxDim >= minSize) {
                    result.add(this.object[i]);
                }
                ++i;
            }
        }
    }

    class RTreeNodeInternal
    extends RTreeNode {
        protected RTreeNode[] child;
        protected int numChildren;

        RTreeNodeInternal() {
            int aMaxChildren = ZSpatialIndex.this.getMaxChildren();
            this.numChildren = 0;
            this.child = new RTreeNode[aMaxChildren];
            int i = 0;
            while (i < aMaxChildren) {
                this.child[i] = null;
                ++i;
            }
        }

        RTreeNodeInternal(RTreeNode node) {
            int aMaxChildren = ZSpatialIndex.this.getMaxChildren();
            this.numChildren = 0;
            this.child = new RTreeNode[aMaxChildren];
            int i = 0;
            while (i < aMaxChildren) {
                this.child[i] = null;
                ++i;
            }
            this.add(node);
        }

        boolean isLeaf() {
            return false;
        }

        int getNumRegions() {
            return this.numChildren;
        }

        Rectangle2D getChildRegion(int regionNum) {
            if (regionNum < this.numChildren) {
                return this.child[regionNum].getRegion();
            }
            return null;
        }

        RTreeNode getChildNode(int nodeNum) {
            if (nodeNum < this.numChildren) {
                return this.child[nodeNum];
            }
            return null;
        }

        void add(ZNode obj) {
            System.err.println("add(): ERROR: Can't add object directly to internal node");
            System.exit(1);
        }

        void add(RTreeNode node) {
            if (this.numChildren == ZSpatialIndex.this.getMaxChildren()) {
                System.err.println("add(): ERROR: Node is full, can't add child");
                System.exit(1);
            }
            this.child[this.numChildren] = node;
            ++this.numChildren;
            this.updateRegion();
        }

        boolean add(ZNode obj, RTreeNode[] nodeArray) {
            boolean split = false;
            boolean first = true;
            int aChild = 0;
            double minExpansion = 0.0;
            RTreeNode node1 = nodeArray[0];
            RTreeNode node2 = nodeArray[1];
            ZBounds bbox = ZSpatialIndex.this.getCurrentBounds(obj);
            int i = 0;
            while (i < this.numChildren) {
                double expansion = this.child[i].computeExpansion(bbox);
                if (first) {
                    minExpansion = expansion;
                    aChild = i;
                    first = false;
                } else if (expansion < minExpansion) {
                    minExpansion = expansion;
                    aChild = i;
                }
                ++i;
            }
            if (this.child[aChild].add(obj, nodeArray)) {
                this.child[aChild] = nodeArray[0];
                if (this.numChildren == ZSpatialIndex.this.getMaxChildren()) {
                    RTreeNode nodeToAdd = nodeArray[1];
                    this.split(nodeArray);
                    node1 = nodeArray[0];
                    node2 = nodeArray[1];
                    double expansion1 = node1.computeExpansion(nodeToAdd.getRegion());
                    double expansion2 = node2.computeExpansion(nodeToAdd.getRegion());
                    if (expansion1 < expansion2) {
                        node1.add(nodeToAdd);
                    } else {
                        node2.add(nodeToAdd);
                    }
                    nodeArray[0] = node1;
                    nodeArray[1] = node2;
                    split = true;
                } else {
                    this.add(nodeArray[1]);
                    split = false;
                }
            } else {
                this.updateRegion();
            }
            return split;
        }

        void split(RTreeNode[] nodeArray) {
            int region1 = 0;
            int region2 = 0;
            int[] regions = this.computeMostDistantRegions();
            region1 = regions[0];
            region2 = regions[1];
            RTreeNodeInternal node1 = new RTreeNodeInternal(this.child[region1]);
            RTreeNodeInternal node2 = new RTreeNodeInternal(this.child[region2]);
            int aMinChildren = ZSpatialIndex.this.getMinChildren();
            int remainingObjs = this.numChildren - 2;
            int i = 0;
            while (i < this.numChildren) {
                if (i != region1 && i != region2) {
                    if (node1.getNumRegions() + remainingObjs <= aMinChildren) {
                        node1.add(this.child[i]);
                    } else if (node2.getNumRegions() + remainingObjs <= aMinChildren) {
                        node2.add(this.child[i]);
                    } else {
                        double expansion2;
                        double expansion1 = node1.computeExpansion(this.child[i].getRegion());
                        if (expansion1 < (expansion2 = node2.computeExpansion(this.child[i].getRegion()))) {
                            node1.add(this.child[i]);
                        } else {
                            node2.add(this.child[i]);
                        }
                    }
                    --remainingObjs;
                }
                ++i;
            }
            nodeArray[0] = node1;
            nodeArray[1] = node2;
        }

        protected boolean remove(ZNode obj, ArrayList reinsertList) {
            boolean rc = false;
            int aMinChildren = ZSpatialIndex.this.getMinChildren();
            int i = 0;
            while (i < this.numChildren) {
                ZBounds glob;
                boolean overlaps;
                Rectangle2D reg = this.child[i].getRegion();
                boolean bl = overlaps = !reg.createUnion(glob = ZSpatialIndex.this.getCurrentBounds(obj)).isEmpty();
                if (overlaps && (rc = this.child[i].remove(obj, reinsertList))) {
                    if (this.child[i].getNumRegions() < aMinChildren) {
                        reinsertList.add(this.child[i]);
                        int j = i;
                        while (j < this.numChildren - 1) {
                            this.child[j] = this.child[j + 1];
                            ++j;
                        }
                        --this.numChildren;
                    }
                    this.updateRegion();
                    break;
                }
                ++i;
            }
            return rc;
        }

        void updateRegion() {
            if (this.numChildren == 0) {
                this.region.setRect(0.0, 0.0, 0.0, 0.0);
            }
            this.region = this.child[0].getRegion();
            int i = 1;
            while (i < this.numChildren) {
                this.region = this.region.createUnion(this.child[i].getRegion());
                ++i;
            }
        }

        void extractObjs(ArrayList objList) {
            int i = 0;
            while (i < this.numChildren) {
                this.child[i].extractObjs(objList);
                ++i;
            }
        }

        public void displaySelf(String tree) {
            System.out.println(tree + "internal node: x: " + this.region.getX() + " y: " + this.region.getY() + "w: " + this.region.getWidth() + " h: " + this.region.getHeight());
        }

        public void displayTree(String tree, int level) {
            int j = 0;
            while (j < level) {
                tree = tree + "  ";
                ++j;
            }
            this.displaySelf(tree);
            System.out.println("children: " + this.numChildren);
            int i = 0;
            while (i < this.numChildren) {
                this.child[i].displayTree(tree, level + 1);
                ++i;
            }
        }

        void queryPoint(ArrayList result, Point2D pt) {
            this.queryPoint(result, pt, 0.0, 1.0);
        }

        void queryPoint(ArrayList result, Point2D pt, double minSize, double currentMag) {
            int i = 0;
            while (i < this.numChildren) {
                ZSpatialIndex.this.incrementNodesSearched();
                Rectangle2D bbox = this.child[i].getRegion();
                double maxDim = Math.max(bbox.getHeight(), bbox.getWidth()) * currentMag;
                if (bbox.contains(pt.getX(), pt.getY()) && maxDim >= minSize) {
                    this.child[i].queryPoint(result, pt, minSize, currentMag);
                }
                ++i;
            }
        }

        void queryWindow(ArrayList result, Rectangle2D queryBBox) {
            this.queryWindow(result, queryBBox, 0.0, 1.0);
        }

        void queryWindow(ArrayList result, Rectangle2D queryBBox, double minSize, double currentMag) {
            int i = 0;
            while (i < this.numChildren) {
                ZSpatialIndex.this.incrementNodesSearched();
                Rectangle2D bbox = this.child[i].getRegion();
                double maxDim = Math.max(bbox.getHeight(), bbox.getWidth()) * currentMag;
                boolean overlaps = bbox.intersects(queryBBox.getX(), queryBBox.getY(), queryBBox.getWidth(), queryBBox.getHeight());
                if (overlaps && maxDim >= minSize) {
                    this.child[i].queryWindow(result, queryBBox, minSize, currentMag);
                }
                ++i;
            }
        }
    }

    public class DrawOrderComp
    implements Comparator {
        public int compare(Object a, Object b) {
            ZNode nodeA = (ZNode)a;
            ZNode nodeB = (ZNode)b;
            Integer valA = (Integer)ZSpatialIndex.this.drawOrder.get(nodeA);
            Integer valB = (Integer)ZSpatialIndex.this.drawOrder.get(nodeB);
            return valA.compareTo(valB);
        }
    }
}

