/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ZLayerGroup
extends ZGroup
implements ZSerializable,
Serializable {
    private ZList.ZCameraList cameras = new ZListImpl.ZCameraListImpl(1);

    public ZLayerGroup() {
    }

    public ZLayerGroup(ZNode child) {
        this();
        this.insertAbove(child);
    }

    protected Object duplicateObject() {
        ZLayerGroup newLayer = (ZLayerGroup)super.duplicateObject();
        if (!this.cameras.isNull()) {
            newLayer.cameras = (ZList.ZCameraList)this.cameras.clone();
        }
        return newLayer;
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        super.updateObjectReferences(objRefTable);
        if (this.cameras.size() > 0) {
            int n = 0;
            ZCamera[] camerasRef = this.cameras.getCamerasReference();
            int i = 0;
            while (i < this.cameras.size()) {
                ZCamera newCamera = (ZCamera)objRefTable.getNewObjectReference(camerasRef[i]);
                if (newCamera != null) {
                    camerasRef[n++] = newCamera;
                }
                ++i;
            }
            this.cameras.setSize(n);
        }
    }

    public void trimToSize() {
        super.trimToSize();
        this.cameras.trimToSize();
    }

    void addCamera(ZCamera camera) {
        if (this.cameras.contains(camera)) {
            return;
        }
        this.cameras.add(camera);
        this.repaint();
    }

    void removeCamera(ZCamera camera) {
        this.repaint();
        this.cameras.remove(camera);
    }

    public ZCamera[] getCameras() {
        return (ZCamera[])this.cameras.toArray();
    }

    protected ZCamera[] getCamerasReference() {
        return this.cameras.getCamerasReference();
    }

    public int getNumCameras() {
        return this.cameras.size();
    }

    public void repaint() {
        if (ZDebug.debugRepaint) {
            System.out.println("ZNode.repaint: this = " + this);
        }
        if (!this.inTransaction) {
            this.repaint(this.getBounds());
        }
    }

    public void repaint(ZBounds repaintBounds) {
        if (ZDebug.debugRepaint) {
            System.out.println("ZLayerGroup.repaint(ZBounds): this = " + this);
            System.out.println("ZLayerGroup.repaint(ZBounds): repaintBounds = " + repaintBounds);
        }
        if (this.inTransaction) {
            return;
        }
        ZBounds origRepaintBounds = (ZBounds)repaintBounds.clone();
        ZCamera[] camerasRef = this.getCamerasReference();
        int i = 0;
        while (i < this.cameras.size()) {
            repaintBounds.setRect(origRepaintBounds);
            camerasRef[i].repaint(repaintBounds);
            ++i;
        }
        super.repaint(origRepaintBounds);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.cameras == null) {
            this.cameras = new ZListImpl.ZCameraListImpl(1);
        }
    }
}

