/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.event.ZCameraEvent;
import edu.umd.cs.jazz.event.ZCameraListener;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ZConstraintGroup
extends ZTransformGroup
implements Serializable {
    protected ZCamera camera = null;
    private transient ZCameraListener cameraListener = null;

    public ZConstraintGroup() {
        this.init(null);
    }

    public ZConstraintGroup(ZCamera camera) {
        this.init(camera);
    }

    public ZConstraintGroup(ZNode child) {
        super(child);
    }

    public ZConstraintGroup(ZCamera camera, ZNode child) {
        super(child);
        this.init(camera);
    }

    public void finalize() {
        if (this.camera != null && this.cameraListener != null) {
            this.camera.removeCameraListener(this.cameraListener);
        }
    }

    protected void init(ZCamera camera) {
        this.setCamera(camera);
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        super.updateObjectReferences(objRefTable);
        this.cameraListener = null;
        if (this.camera != null) {
            ZCamera newCamera = (ZCamera)objRefTable.getNewObjectReference(this.camera);
            if (newCamera == null) {
                this.setCamera(this.camera);
            } else {
                this.setCamera(newCamera);
            }
        }
    }

    public AffineTransform computeTransform() {
        return new AffineTransform();
    }

    protected void updateTransform() {
        this.setTransform(this.computeTransform());
    }

    public ZCamera getCamera() {
        return this.camera;
    }

    public void setCamera(ZCamera camera) {
        if (camera != null && this.cameraListener != null) {
            camera.removeCameraListener(this.cameraListener);
        }
        this.camera = camera;
        if (camera != null) {
            this.createCameraListener();
            this.updateTransform();
        }
    }

    private void createCameraListener() {
        this.cameraListener = new ZCameraListener(){

            public void viewChanged(ZCameraEvent e) {
                ZConstraintGroup.this.updateTransform();
            }
        };
        this.camera.addCameraListener(this.cameraListener);
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.camera != null) {
            out.writeState("ZCamera", "camera", this.camera);
        }
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        if (this.camera != null) {
            out.addObject(this.camera);
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("camera") == 0) {
            this.setCamera((ZCamera)fieldValue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.println("unserializing ZConstraintGroup");
        in.defaultReadObject();
        this.createCameraListener();
    }
}

