/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.ZVisualGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZPenPaint;
import edu.umd.cs.jazz.component.ZPolyline;
import edu.umd.cs.jazz.component.ZStroke;
import edu.umd.cs.jazz.event.ZNodeEvent;
import edu.umd.cs.jazz.event.ZNodeListener;
import edu.umd.cs.jazz.event.ZTransformEvent;
import edu.umd.cs.jazz.event.ZTransformListener;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ZAnchorGroup
extends ZVisualGroup
implements ZSerializable,
Serializable {
    private static final int LINK_ANIMATION_TIME = 750;
    private static final int DEFAULT_CONNECTOR_WIDTH = 5;
    private static Color nodeColor;
    private static Color boundsColor;
    private ZNode destNode = null;
    private transient Rectangle2D destBounds = null;
    private transient Point2D srcPt = null;
    private transient Point2D destPt = null;
    private transient ZVisualLeaf linkNode = null;
    private transient ZTransformListener destNodeTransformListener = null;
    private transient ZNodeListener destNodeGlobalBoundsListener = null;

    public ZAnchorGroup() {
    }

    public ZAnchorGroup(ZNode child) {
        super(child);
    }

    protected Object duplicateObject() {
        ZAnchorGroup newObject = (ZAnchorGroup)super.duplicateObject();
        if (this.destBounds != null) {
            newObject.destBounds = (Rectangle2D)this.destBounds.clone();
        }
        newObject.destNodeTransformListener = null;
        newObject.destNodeGlobalBoundsListener = null;
        return newObject;
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        super.updateObjectReferences(objRefTable);
        if (this.destNode != null) {
            ZNode clonedNode = (ZNode)objRefTable.getNewObjectReference(this.destNode);
            if (clonedNode != null) {
                this.destNode = clonedNode;
            }
            this.registerDestNodeListeners();
        }
    }

    public void finalize() {
        this.removeDestinationNodeListeners();
    }

    public ZNode getDestNode() {
        return this.destNode;
    }

    public void setDestNode(ZNode node, ZCamera camera) {
        this.removeDestinationNodeListeners();
        this.destNode = node;
        this.destBounds = null;
        this.updateLinkComponent(camera);
        if (node != null) {
            // empty if block
        }
        this.registerDestNodeListeners();
    }

    private void removeDestinationNodeListeners() {
        if (this.destNode != null) {
            if (this.destNodeTransformListener != null) {
                this.destNode.editor().getTransformGroup().removeTransformListener(this.destNodeTransformListener);
                this.destNodeTransformListener = null;
            }
            if (this.destNodeGlobalBoundsListener != null) {
                this.destNode.removeNodeListener(this.destNodeGlobalBoundsListener);
                this.destNodeGlobalBoundsListener = null;
            }
        }
    }

    private void registerDestNodeListeners() {
        if (this.destNode != null) {
            this.destNodeTransformListener = new ZTransformListener(){

                public void transformChanged(ZTransformEvent e) {
                    ZAnchorGroup.this.destPt = null;
                    ZAnchorGroup.this.updateLinkComponent(null);
                }
            };
            this.destNode.editor().getTransformGroup().addTransformListener(this.destNodeTransformListener);
            this.destNodeGlobalBoundsListener = new ZNodeListener(){

                public void boundsChanged(ZNodeEvent e) {
                }

                public void globalBoundsChanged(ZNodeEvent e) {
                    ZAnchorGroup.this.destPt = null;
                    ZAnchorGroup.this.updateLinkComponent(null);
                }
            };
            this.destNode.addNodeListener(this.destNodeGlobalBoundsListener);
        }
    }

    public Rectangle2D getDestBounds() {
        return this.destBounds;
    }

    public void setDestBounds(Rectangle2D bounds, ZCamera camera) {
        ZVisualComponent linkComponent;
        this.removeDestinationNodeListeners();
        this.destNode = null;
        if (bounds != null) {
            if (this.destBounds == null) {
                this.destBounds = new ZBounds();
            }
            this.destBounds.setRect(bounds);
        } else {
            this.destBounds = bounds;
        }
        this.destPt = null;
        this.updateLinkComponent(camera);
        if (this.linkNode != null && (linkComponent = this.linkNode.getFirstVisualComponent()) instanceof ZPenPaint) {
            ((ZPenPaint)((Object)linkComponent)).setPenPaint(boundsColor);
        }
    }

    public void computeBounds() {
        super.computeBounds();
        this.srcPt = null;
        this.updateLinkComponent(null);
    }

    protected ZVisualComponent createLinkComponent() {
        ZPolyline linkComponent = new ZPolyline();
        linkComponent.setArrowHead(2);
        return linkComponent;
    }

    public void setSrcPt(Point2D pt) {
        ZVisualComponent linkComponent;
        if (this.srcPt == null) {
            this.srcPt = new Point2D.Double();
        }
        this.srcPt.setLocation(pt);
        if (this.destPt != null && this.linkNode != null && (linkComponent = this.linkNode.getFirstVisualComponent()) instanceof ZPolyline) {
            ((ZPolyline)linkComponent).setCoords(this.srcPt, this.destPt);
        }
    }

    public void setDestPt(Point2D pt) {
        ZVisualComponent linkComponent;
        if (this.destPt == null) {
            this.destPt = new Point2D.Double();
        }
        this.destPt.setLocation(pt);
        if (this.srcPt != null && this.linkNode != null && (linkComponent = this.linkNode.getFirstVisualComponent()) instanceof ZPolyline) {
            ((ZPolyline)linkComponent).setCoords(this.srcPt, this.destPt);
        }
    }

    public void updateLinkComponent(ZCamera camera) {
        ZBounds bounds;
        Point2D pt;
        if (this.linkNode == null) {
            return;
        }
        ZVisualComponent linkComponent = this.linkNode.getFirstVisualComponent();
        if (linkComponent instanceof ZPenPaint) {
            if (this.destBounds != null) {
                ((ZPenPaint)((Object)linkComponent)).setPenPaint(boundsColor);
            } else {
                ((ZPenPaint)((Object)linkComponent)).setPenPaint(nodeColor);
            }
        }
        if (camera != null && linkComponent instanceof ZStroke) {
            ((ZStroke)((Object)linkComponent)).setPenWidth(5.0 / camera.getMagnification());
        }
        if ((pt = this.srcPt) == null) {
            bounds = new ZBounds();
            ZNode[] childrenRef = this.getChildrenReference();
            int i = 0;
            while (i < this.children.size()) {
                bounds.add(childrenRef[i].getBounds());
                ++i;
            }
            if (!bounds.isEmpty()) {
                pt = new Point2D.Double(bounds.getX() + 0.5 * bounds.getWidth(), bounds.getY() + 0.5 * bounds.getHeight());
                this.localToGlobal(pt);
            }
        }
        if (pt != null) {
            this.setSrcPt(pt);
        }
        if ((pt = this.destPt) == null) {
            bounds = null;
            if (this.destNode != null) {
                bounds = this.destNode.getGlobalBounds();
            } else if (this.destBounds != null) {
                bounds = new ZBounds(this.destBounds);
            }
            if (bounds != null && !bounds.isEmpty()) {
                this.globalToLocal(bounds);
                pt = new Point2D.Double(bounds.getX() + 0.5 * bounds.getWidth(), bounds.getY() + 0.5 * bounds.getHeight());
                this.localToGlobal(pt);
            }
        }
        if (pt != null) {
            this.setDestPt(pt);
        }
    }

    public void setVisible(boolean visible, ZCamera camera) {
        if (visible) {
            ZGroup parent = this.getParent();
            if (this.linkNode == null && parent != null && camera != null) {
                ZVisualComponent linkComponent = this.createLinkComponent();
                this.linkNode = new ZVisualLeaf(linkComponent);
                this.linkNode.setPickable(false);
                this.linkNode.setFindable(false);
                ZLayerGroup[] layers = camera.getLayersReference();
                layers[camera.getNumLayers() - 1].addChild(this.linkNode);
            }
            this.updateLinkComponent(camera);
        } else if (this.linkNode != null) {
            this.linkNode.getParent().removeChild(this.linkNode);
            this.linkNode = null;
        }
    }

    public boolean isVisible() {
        return this.linkNode != null;
    }

    public void follow(ZCamera camera) {
        Rectangle2D bounds = null;
        if (this.destNode != null) {
            bounds = this.destNode.getGlobalBounds();
        } else if (this.destBounds != null) {
            bounds = this.destBounds;
        }
        if (bounds != null) {
            ZDrawingSurface surface = camera.getDrawingSurface();
            if (surface != null) {
                surface.setInteracting(true);
            }
            camera.center(bounds, 750, surface);
            if (surface != null) {
                surface.setInteracting(false);
            }
        }
    }

    public String dump() {
        String str = super.dump();
        if (this.destNode != null) {
            str = str + "\n Destination node: " + this.destNode;
        }
        if (this.destBounds != null) {
            str = str + "\n Destination bounds: " + this.destBounds;
        }
        return str;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.destNode != null) {
            out.writeState("ZNode", "destNode", this.destNode);
        }
        if (this.destBounds != null) {
            out.writeState("java.awt.geom.Rectangle2D", "destBounds", this.destBounds);
        }
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        if (this.destNode != null) {
            out.addObject(this.destNode);
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("destNode") == 0) {
            this.setDestNode((ZNode)fieldValue, null);
        } else if (fieldName.compareTo("destBounds") == 0) {
            this.setDestBounds((Rectangle2D)fieldValue, null);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.destBounds == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeDouble(this.destBounds.getX());
            out.writeDouble(this.destBounds.getY());
            out.writeDouble(this.destBounds.getWidth());
            out.writeDouble(this.destBounds.getHeight());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.readBoolean()) {
            double x = in.readDouble();
            double y = in.readDouble();
            double w = in.readDouble();
            double h = in.readDouble();
            this.destBounds = new Rectangle2D.Double(x, y, w, h);
        }
    }

    public boolean hasDestination() {
        return this.getDestNode() != null || this.getDestBounds() != null;
    }

    static {
        LINK_ANIMATION_TIME = 750;
        DEFAULT_CONNECTOR_WIDTH = 5;
        nodeColor = new Color(150, 150, 0);
        boundsColor = new Color(150, 150, 150);
    }
}

