/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Point;
import java.awt.geom.Point2D;

class SelectionEventHandler
extends ZFilteredEventHandler {
    ImagePane imagePane = null;
    boolean dragging = false;
    Point start = new Point();
    ZMouseEvent moveEvent;

    public SelectionEventHandler(ImagePane imagePane, ZSceneGraphObject zSceneGraphObject) {
        super(zSceneGraphObject);
        this.imagePane = imagePane;
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter();
            this.fMouseFilter.setOrMask(16);
        }
        return this.fMouseFilter;
    }

    public void filteredMouseMoved(ZMouseEvent zMouseEvent) {
        ImageItem imageItem;
        PhotoMesa photoMesa = this.imagePane.photomesa;
        Point2D.Double double_ = new Point2D.Double();
        ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
        PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
        this.moveEvent = zMouseEvent;
        if (pMImage != null && (imageItem = pMImage.getImageItem()) != null) {
            if (imageItem.imageWidth > 0 && imageItem.imageHeight > 0) {
                photoMesa.setStatusBarAuxText(imageItem.getImagePath() + "       (" + imageItem.imageWidth + "x" + imageItem.imageHeight + " pixels)");
            } else {
                photoMesa.setStatusBarAuxText(imageItem.getImagePath());
            }
        }
        ((Point2D)double_).setLocation(zMouseEvent.getX(), zMouseEvent.getY());
        zSceneGraphPath.screenToGlobal(double_);
        this.imagePane.computeHiliteArea(double_);
    }

    public void filteredMousePressed(ZMouseEvent zMouseEvent) {
        ImageItem imageItem = null;
        ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
        PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
        this.imagePane.setPressObj(pMImage);
        if (this.imagePane.eventHandlers.isSpaceBarDown()) {
            return;
        }
        if (pMImage == null) {
            this.imagePane.clearSelection();
            this.start.setLocation(zMouseEvent.getX(), zMouseEvent.getY());
            zSceneGraphPath.screenToGlobal(this.start);
            this.dragging = true;
            imageItem = null;
            this.imagePane.beginSelectionByDragging();
        } else {
            imageItem = pMImage.getImageItem();
            if (imageItem != null) {
                if (zMouseEvent.isShiftDown()) {
                    imageItem.setSelected(!imageItem.isSelected());
                } else if (!imageItem.isSelected()) {
                    this.imagePane.clearSelection();
                    imageItem.setSelected(true);
                }
            }
        }
    }

    protected void filteredMouseDragged(ZMouseEvent zMouseEvent) {
        if (this.dragging) {
            ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
            Point point = new Point(zMouseEvent.getX(), zMouseEvent.getY());
            zSceneGraphPath.screenToGlobal(point);
            ZBounds zBounds = new ZBounds();
            zBounds.add(this.start.getX(), this.start.getY());
            zBounds.add(point.getX(), point.getY());
            this.imagePane.updateSelectionByDragging(zBounds);
        }
    }

    public void filteredMouseReleased(ZMouseEvent zMouseEvent) {
        if (!this.imagePane.eventHandlers.isSpaceBarDown() && this.dragging) {
            this.dragging = false;
            this.imagePane.endSelectionByDragging();
        }
    }
}

