/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class PopupMenuEventHandler
extends ZFilteredEventHandler {
    ZCanvas canvas;
    ImagePane imagePane = null;
    ImageItem imageItem = null;
    JPopupMenu popup;
    JMenuItem deleteImage;
    JMenuItem zoomIn;
    JMenuItem zoomOut;
    JMenuItem zoomOutTop;
    JMenuItem zoomToFit;
    JMenuItem zoomOneToOne;
    JMenuItem editImage;
    JMenuItem renameImage;
    ZMouseEvent moveEvent = null;

    public PopupMenuEventHandler(ImagePane imagePane, ZSceneGraphObject zSceneGraphObject, ZCanvas zCanvas) {
        super(zSceneGraphObject);
        this.imagePane = imagePane;
        this.canvas = zCanvas;
        this.createPopupMenu();
    }

    public void filteredMousePressed(ZMouseEvent zMouseEvent) {
        if (!this.imagePane.photomesa.state.getRightButtonMenu() && this.imagePane.eventHandlers.getEventMode() == 1) {
            return;
        }
        ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
        PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
        this.imagePane.setPressObj(pMImage);
        if (!this.imagePane.eventHandlers.isSpaceBarDown()) {
            this.imageItem = pMImage != null ? pMImage.getImageItem() : null;
            if ((zMouseEvent.getModifiers() & 4) == 4) {
                this.imagePane.stopPreview();
                this.updateMenu();
                this.popup.show(this.canvas, zMouseEvent.getX(), zMouseEvent.getY());
            }
        }
    }

    public void filteredMouseMoved(ZMouseEvent zMouseEvent) {
        this.moveEvent = zMouseEvent;
    }

    void createPopupMenu() {
        this.popup = new JPopupMenu();
        this.zoomOut = new JMenuItem("Zoom Out");
        this.zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                if (PopupMenuEventHandler.this.imagePane.hiresImageLoaded) {
                    ZBounds zBounds = PopupMenuEventHandler.this.imagePane.hiresImageItem.getThumb().getGlobalBounds();
                    ZBounds zBounds2 = PopupMenuEventHandler.this.imagePane.getCamera().getViewBounds();
                    double d = PopupMenuEventHandler.this.imagePane.hiresImageItem.imageWidth;
                    double d2 = PopupMenuEventHandler.this.imagePane.hiresImageItem.imageHeight;
                    double d3 = PopupMenuEventHandler.this.imagePane.getCamera().getBoundsReference().getWidth();
                    double d4 = PopupMenuEventHandler.this.imagePane.getCamera().getBoundsReference().getHeight();
                    if (zBounds2.getWidth() >= zBounds.getWidth() && zBounds2.getHeight() >= zBounds.getHeight()) {
                        PopupMenuEventHandler.this.imagePane.unloadHiResImage();
                    }
                }
                PopupMenuEventHandler.this.imagePane.zoomOutStep();
                if (PopupMenuEventHandler.this.imagePane.eventHandlers.getEventMode() != 1) {
                    PopupMenuEventHandler.this.imagePane.eventHandlers.panHandler.getMouseFilter().rejectAllEventTypes();
                }
                PopupMenuEventHandler.this.imagePane.setFocus(PopupMenuEventHandler.this.moveEvent);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PopupMenuEventHandler access$000(1 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.zoomOut);
        this.zoomOutTop = new JMenuItem("Zoom Out To Topmost Level");
        this.zoomOutTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                PopupMenuEventHandler.this.imagePane.unloadHiResImage();
                PopupMenuEventHandler.this.imagePane.zoomOut();
                if (PopupMenuEventHandler.this.imagePane.eventHandlers.getEventMode() != 1) {
                    PopupMenuEventHandler.this.imagePane.eventHandlers.panHandler.getMouseFilter().rejectAllEventTypes();
                }
                PopupMenuEventHandler.this.imagePane.setFocus(PopupMenuEventHandler.this.moveEvent);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        3.access$100(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PopupMenuEventHandler access$100(3 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.zoomOutTop);
        this.popup.addSeparator();
        this.zoomIn = new JMenuItem("Zoom In");
        this.zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                if (PopupMenuEventHandler.this.imagePane.currentRegion == null && !PopupMenuEventHandler.this.imagePane.eventHandlers.isInteracting()) {
                    if (PopupMenuEventHandler.this.imagePane.armedRegion != null) {
                        PopupMenuEventHandler.this.imagePane.setCurrentRegion(PopupMenuEventHandler.this.imagePane.armedRegion);
                        if (PopupMenuEventHandler.this.imagePane.eventHandlers.getEventMode() == 1) {
                            PopupMenuEventHandler.this.imagePane.center(PopupMenuEventHandler.this.imagePane.getHiliteBounds());
                        }
                    }
                    PopupMenuEventHandler.this.imagePane.setFocus(PopupMenuEventHandler.this.moveEvent);
                }
                if (!PopupMenuEventHandler.this.imagePane.singleImageHilite) {
                    PopupMenuEventHandler.this.imagePane.magnificationPush();
                    PopupMenuEventHandler.this.imagePane.center(PopupMenuEventHandler.this.imagePane.getHiliteBounds());
                    PopupMenuEventHandler.this.imagePane.updateThumbs(true);
                } else if (PopupMenuEventHandler.this.imageItem != null) {
                    if (PopupMenuEventHandler.this.imagePane.singleImageHilite && !PopupMenuEventHandler.this.imagePane.hiresImageLoaded) {
                        PopupMenuEventHandler.this.imagePane.magnificationPush();
                        PopupMenuEventHandler.this.imagePane.unloadHiResImage();
                        PopupMenuEventHandler.this.imagePane.showHiResImage(PopupMenuEventHandler.this.imageItem);
                    } else if (PopupMenuEventHandler.this.imagePane.hiresImageLoaded && PopupMenuEventHandler.this.imageItem != PopupMenuEventHandler.this.imagePane.hiresImageItem) {
                        PopupMenuEventHandler.this.imagePane.unloadHiResImage();
                        PopupMenuEventHandler.this.imagePane.showHiResImage(PopupMenuEventHandler.this.imageItem);
                    } else if (PopupMenuEventHandler.this.imagePane.hiresImageLoaded && PopupMenuEventHandler.this.imageItem == PopupMenuEventHandler.this.imagePane.hiresImageItem) {
                        ZBounds zBounds = PopupMenuEventHandler.this.imagePane.getCamera().getViewBounds();
                        double d = zBounds.getWidth();
                        double d2 = zBounds.getHeight();
                        double d3 = zBounds.getX();
                        double d4 = zBounds.getY();
                        ZBounds zBounds2 = new ZBounds(d3 + d / 4.0, d4 + d2 / 4.0, d / 2.0, d2 / 2.0);
                        PopupMenuEventHandler.this.imagePane.magnificationPush();
                        PopupMenuEventHandler.this.imagePane.center(zBounds2, false);
                    }
                }
                PopupMenuEventHandler.this.imagePane.setFocus(PopupMenuEventHandler.this.moveEvent);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$200(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PopupMenuEventHandler access$200(5 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.zoomIn);
        this.zoomToFit = new JMenuItem("Zoom In To Full Screen");
        this.zoomToFit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                if (PopupMenuEventHandler.this.imagePane.currentRegion == null && !PopupMenuEventHandler.this.imagePane.eventHandlers.isInteracting() && PopupMenuEventHandler.this.imagePane.armedRegion != null) {
                    PopupMenuEventHandler.this.imagePane.setCurrentRegion(PopupMenuEventHandler.this.imagePane.armedRegion);
                }
                if (!PopupMenuEventHandler.this.imagePane.hiresImageLoaded) {
                    PopupMenuEventHandler.this.imagePane.magnificationPush();
                }
                if (PopupMenuEventHandler.this.imagePane.hiresImageLoaded && PopupMenuEventHandler.this.imageItem != PopupMenuEventHandler.this.imagePane.hiresImageItem) {
                    PopupMenuEventHandler.this.imagePane.unloadHiResImage();
                }
                if (PopupMenuEventHandler.this.imageItem != PopupMenuEventHandler.this.imagePane.hiresImageItem) {
                    PopupMenuEventHandler.this.imagePane.showHiResImage(PopupMenuEventHandler.this.imageItem);
                } else {
                    ZBounds zBounds = PopupMenuEventHandler.this.imageItem.getThumb().getGlobalBounds();
                    PopupMenuEventHandler.this.imagePane.center(zBounds, false);
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        7.access$300(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PopupMenuEventHandler access$300(7 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.zoomToFit);
        this.zoomOneToOne = new JMenuItem("Zoom In To 1:1 View");
        this.zoomOneToOne.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                if (PopupMenuEventHandler.this.imagePane.currentRegion == null && !PopupMenuEventHandler.this.imagePane.eventHandlers.isInteracting() && PopupMenuEventHandler.this.imagePane.armedRegion != null) {
                    PopupMenuEventHandler.this.imagePane.setCurrentRegion(PopupMenuEventHandler.this.imagePane.armedRegion);
                }
                if (!PopupMenuEventHandler.this.imagePane.hiresImageLoaded) {
                    PopupMenuEventHandler.this.imagePane.magnificationPush();
                }
                if (PopupMenuEventHandler.this.imagePane.hiresImageLoaded && PopupMenuEventHandler.this.imageItem != PopupMenuEventHandler.this.imagePane.hiresImageItem) {
                    PopupMenuEventHandler.this.imagePane.unloadHiResImage();
                }
                if (PopupMenuEventHandler.this.imageItem != PopupMenuEventHandler.this.imagePane.hiresImageItem) {
                    PopupMenuEventHandler.this.imagePane.showHiResOneToOneImage(PopupMenuEventHandler.this.imageItem);
                } else {
                    ZBounds zBounds = PopupMenuEventHandler.this.imagePane.getHiresOneToOneBounds(PopupMenuEventHandler.this.imageItem);
                    PopupMenuEventHandler.this.imagePane.center(zBounds, false);
                    PopupMenuEventHandler.this.imagePane.removeBiggerMagnification();
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        9.access$400(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PopupMenuEventHandler access$400(9 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.zoomOneToOne);
        this.popup.addSeparator();
        this.renameImage = new JMenuItem("Rename Image");
        this.renameImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                if (PopupMenuEventHandler.this.imagePane.eventHandlers.getEventMode() == 1) {
                    PopupMenuEventHandler.this.imagePane.photomesa.getImagePane().eventHandlers.fileManipHandler.renameSelection(PopupMenuEventHandler.this.imageItem);
                } else {
                    PopupMenuEventHandler.this.imagePane.photomesa.getImagePane().eventHandlers.fileManipHandler.renameSelection();
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        11.access$500(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PopupMenuEventHandler access$500(11 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.renameImage);
        this.deleteImage = new JMenuItem("Delete Image");
        this.deleteImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                if (PopupMenuEventHandler.this.imagePane.eventHandlers.getEventMode() == 1) {
                    if (PopupMenuEventHandler.this.imageItem != null) {
                        PopupMenuEventHandler.this.imagePane.deleteImage(PopupMenuEventHandler.this.imageItem);
                    }
                } else {
                    PopupMenuEventHandler.this.imagePane.deleteSelectedImages();
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        13.access$600(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PopupMenuEventHandler access$600(13 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.deleteImage);
        this.popup.addSeparator();
        this.editImage = new JMenuItem("Edit Image");
        this.editImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuEventHandler.this.imagePane.stopPreview();
                if (PopupMenuEventHandler.this.imageItem == null) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            15.access$700(this.this$1).imagePane.requestFocus();
                        }
                    });
                    return;
                }
                try {
                    EditorLauncher editorLauncher = new EditorLauncher(PopupMenuEventHandler.this.imageItem.getImagePath(), PopupMenuEventHandler.this.imagePane.photomesa);
                }
                catch (Exception exception) {
                    String string = PopupMenuEventHandler.this.imagePane.photomesa.state.getImageEditor();
                    String[] stringArray = new String[]{"Cannot lauch default image editor", "Please set \"Image Editor\" in Preference and try again."};
                    if (string != null && string.length() > 0) {
                        stringArray[0] = "Cannot lauch image editor: " + string;
                    }
                    JOptionPane.showMessageDialog(PopupMenuEventHandler.this.imagePane, stringArray, "PhotoMesa Information", 0);
                }
            }

            static /* synthetic */ PopupMenuEventHandler access$700(15 var0) {
                return var0.PopupMenuEventHandler.this;
            }
        });
        this.popup.add(this.editImage);
    }

    void updateMenu() {
        Vector vector = this.imagePane.getSelectionImageItems();
        if (this.imagePane.eventHandlers.getEventMode() == 2 && this.imageItem == null) {
            this.imagePane.clearSelection();
        } else if (this.imagePane.eventHandlers.getEventMode() == 2 && this.imageItem != null && !vector.contains(this.imageItem)) {
            this.imagePane.clearSelection();
            this.imageItem.setSelected(true);
        }
        int n = 0;
        if (this.imageItem == null) {
            n = 1;
        } else if (vector.size() == 1) {
            n = 2;
        } else if (vector.size() > 1) {
            n = 3;
        } else if (vector.size() == 0 && this.imageItem != null) {
            n = 2;
        }
        switch (n) {
            default: {
                this.zoomIn.setText("Zoom In");
                this.zoomIn.setEnabled(false);
                this.deleteImage.setText("Delete Image");
                this.deleteImage.setEnabled(false);
                this.renameImage.setText("Rename Image");
                this.renameImage.setEnabled(false);
                this.zoomToFit.setText("Zoom In To Full Screen");
                this.zoomToFit.setEnabled(false);
                this.zoomOneToOne.setText("Zoom In To 1:1 View");
                this.zoomOneToOne.setEnabled(false);
                this.editImage.setText("Edit Image");
                this.editImage.setEnabled(false);
                break;
            }
            case 2: {
                this.deleteImage.setText("Delete " + this.imageItem);
                this.deleteImage.setEnabled(true);
                this.renameImage.setText("Rename " + this.imageItem);
                this.renameImage.setEnabled(true);
                ZBounds zBounds = this.imagePane.getCamera().getViewBounds();
                this.zoomIn.setText("Zoom In");
                this.zoomIn.setEnabled(true);
                if (!this.imagePane.hiresImageLoaded || this.imagePane.hiresImageItem != this.imageItem) {
                    this.zoomToFit.setText("Zoom In " + this.imageItem + " To Full Screen");
                    this.zoomToFit.setEnabled(true);
                    this.zoomOneToOne.setText("Zoom In " + this.imageItem + " To 1:1 View");
                    this.zoomOneToOne.setEnabled(true);
                } else {
                    if (this.similarViewBounds(zBounds, this.imageItem.getThumb().getGlobalBounds())) {
                        this.zoomToFit.setText("Zoom In To Full Screen");
                        this.zoomToFit.setEnabled(false);
                    } else {
                        this.zoomToFit.setText("Zoom In " + this.imageItem + " To Full Screen");
                        this.zoomToFit.setEnabled(true);
                    }
                    if (this.similarViewBounds(zBounds, this.imagePane.getHiresOneToOneBounds(this.imageItem))) {
                        this.zoomOneToOne.setText("Zoom In To 1:1 View");
                        this.zoomOneToOne.setEnabled(false);
                    } else {
                        this.zoomOneToOne.setText("Zoom In " + this.imageItem + " To 1:1 View");
                        this.zoomOneToOne.setEnabled(true);
                    }
                }
                this.editImage.setText("Edit " + this.imageItem);
                this.editImage.setEnabled(true);
                break;
            }
            case 3: {
                if (this.imagePane.singleImageHilite && this.imageItem == null || this.imagePane.hiliteEmpty) {
                    this.zoomIn.setText("Zoom In");
                    this.zoomIn.setEnabled(false);
                } else {
                    this.zoomIn.setText("Zoom In");
                    this.zoomIn.setEnabled(true);
                }
                this.deleteImage.setText("Delete " + vector.size() + " images [" + this.imageItem + " ...]");
                this.deleteImage.setEnabled(true);
                this.zoomToFit.setText("Zoom In To Full Screen");
                this.zoomToFit.setEnabled(false);
                this.zoomOneToOne.setText("Zoom In To 1:1 View");
                this.zoomOneToOne.setEnabled(false);
                this.editImage.setText("Edit Image");
                this.editImage.setEnabled(false);
                this.renameImage.setText("Rename " + vector.size() + " images [" + this.imageItem + " ...]");
                this.renameImage.setEnabled(true);
            }
        }
        if (this.imagePane.currentRegion == null) {
            this.zoomOut.setEnabled(false);
            this.zoomOutTop.setEnabled(false);
        } else {
            this.zoomOut.setEnabled(true);
            this.zoomOutTop.setEnabled(true);
        }
    }

    boolean similarViewBounds(ZBounds zBounds, ZBounds zBounds2) {
        double d;
        double d2 = Math.abs((zBounds.getWidth() - zBounds2.getWidth()) / zBounds2.getWidth());
        if (d2 < (d = Math.abs((zBounds.getHeight() - zBounds2.getHeight()) / zBounds2.getHeight()))) {
            if (d2 > 0.1) {
                return false;
            }
            double d3 = zBounds2.getWidth() / 10.0;
            if (Math.abs(zBounds.getWidth() - zBounds2.getWidth()) > d3) {
                return false;
            }
            if (Math.abs(zBounds.getX() - zBounds2.getX()) > d3) {
                return false;
            }
            if (Math.abs(zBounds.getY() - zBounds2.getY()) > zBounds.getHeight() / 5.0) {
                return false;
            }
        } else {
            if (d > 0.1) {
                return false;
            }
            double d4 = zBounds2.getHeight() / 10.0;
            if (Math.abs(zBounds.getHeight() - zBounds2.getHeight()) > d4) {
                return false;
            }
            if (Math.abs(zBounds.getY() - zBounds2.getY()) > d4) {
                return false;
            }
            if (Math.abs(zBounds.getX() - zBounds2.getX()) > zBounds.getWidth() / 5.0) {
                return false;
            }
        }
        return true;
    }
}

