/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;

public class ImageTransferable
implements Transferable,
ClipboardOwner {
    PhotoMesa photomesa = null;
    DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
    Vector origFileList;
    Vector copyFileList;

    public ImageTransferable(PhotoMesa photoMesa, Vector vector) {
        this.photomesa = photoMesa;
        if (photoMesa.state.getExportImageSizeEnabled()) {
            this.origFileList = new Vector();
            this.copyFileList = new Vector();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ImageItem imageItem = (ImageItem)iterator.next();
                File file = imageItem.getFile();
                String string = photoMesa.getThumbDirectory() + File.separator + "temp" + File.separator + file.getName();
                File file2 = new File(string);
                int n = 1;
                while (file2.exists()) {
                    int n2 = string.lastIndexOf(46);
                    String string2 = n2 != -1 ? string.substring(0, n2) + n + string.substring(n2) : string + n;
                    file2 = new File(string2);
                    ++n;
                }
                this.origFileList.add(file);
                this.copyFileList.add(file2);
                File file3 = file2.getParentFile();
                if (file3.exists()) continue;
                file3.mkdirs();
                file3.deleteOnExit();
            }
            this.createSmallImages();
        } else {
            this.copyFileList = new Vector();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ImageItem imageItem = (ImageItem)iterator.next();
                File file = imageItem.getFile();
                this.copyFileList.add(file);
            }
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(this.flavors[0]);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.copyFileList;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.origFileList.clear();
        this.copyFileList.clear();
    }

    void createSmallImages() {
        int n = 0;
        ImagePane imagePane = this.photomesa.getImagePane();
        n = 0;
        while (n < this.origFileList.size()) {
            int n2;
            int n3;
            Image image = Toolkit.getDefaultToolkit().createImage(((File)this.origFileList.get(n)).getAbsolutePath());
            MediaTracker mediaTracker = new MediaTracker(imagePane);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Couldn't load image: " + image);
            }
            int n4 = image.getWidth(imagePane);
            int n5 = image.getHeight(imagePane);
            if (n4 <= 0 || n5 <= 0) {
                throw new RuntimeException("Empty image: " + image);
            }
            if (n4 > n5) {
                n3 = this.photomesa.state.getExportImageSize();
                n2 = n3 * n5 / n4;
            } else {
                n2 = this.photomesa.state.getExportImageSize();
                n3 = n2 * n4 / n5;
            }
            BufferedImage bufferedImage = new BufferedImage(n3, n2, 1);
            bufferedImage.getGraphics().drawImage(image, 0, 0, n3, n2, imagePane);
            mediaTracker.addImage(bufferedImage, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Couldn't create image: " + bufferedImage);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream((File)this.copyFileList.get(n));
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setQuality(this.photomesa.state.getJPEGEncodeQuality(), false);
                jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                jPEGImageEncoder.encode(bufferedImage);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            image.flush();
            bufferedImage.flush();
            ((File)this.copyFileList.get(n)).deleteOnExit();
            ++n;
        }
    }
}

