/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.component.ZText;
import edu.umd.cs.jazz.util.ZBounds;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class ImageItem {
    static final int EMPTY_PEN_WIDTH = 1;
    PhotoMesa photomesa;
    File file;
    PMImage thumb;
    int thumbLevel = -1;
    int row;
    int col;
    boolean selected = false;
    Region region;
    double scale = 1.0;
    ZText text = null;
    ZRectangle rect = null;
    ZVisualLeaf labelLeaf = null;
    boolean unloadHiResImageRequest = false;
    boolean displayHiResImageRequest = false;
    PMImage hiresImage = null;
    ZVisualLeaf hiresImageLeaf = null;
    int imageHeight = -1;
    int imageWidth = -1;
    boolean notified = false;

    public ImageItem(PhotoMesa photoMesa, File file) {
        this.photomesa = photoMesa;
        this.file = file;
        int n = PhotoMesa.THUMB_WIDTHS[0];
        int n2 = (int)((double)n / photoMesa.state.getAspectRatio());
        Image image = photoMesa.imagePane.createImage(n, n2);
        this.thumb = new PMImage(image, this);
        this.thumb.setPenWidth(1.0);
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public Region getRegion() {
        return this.region;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        ImagePane imagePane = this.photomesa.getImagePane();
        if (this.thumbLevel != -1) {
            if (!this.selected && bl) {
                this.selected = true;
                this.thumb.setPenColor(PhotoMesa.SELECTION_COLOR);
                this.thumb.setPenWidth(5.0);
                if (this.hiresImage != null) {
                    this.hiresImage.setPenColor(PhotoMesa.SELECTION_COLOR);
                    this.hiresImage.setPenWidth(5.0);
                }
                imagePane.addToSelection(this);
            } else if (this.selected && !bl) {
                this.selected = false;
                this.thumb.setPenColor(Color.black);
                this.thumb.setPenWidth(imagePane.photomesa.state.getThumbPenWidth());
                if (this.hiresImage != null) {
                    this.hiresImage.setPenColor(Color.black);
                    this.hiresImage.setPenWidth(1.0);
                }
                imagePane.removeFromSelection(this);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setGridPosition(int n, int n2) {
        this.row = n;
        this.col = n2;
    }

    public int getGridRow() {
        return this.row;
    }

    public int getGridCol() {
        return this.col;
    }

    public void requestReload() {
        this.thumbLevel = -1;
    }

    public int getThumbLevel() {
        return this.thumbLevel;
    }

    public void repaint() {
        this.thumb.repaint();
    }

    public void delete() {
        ZSceneGraphObject zSceneGraphObject;
        if (this.labelLeaf != null) {
            zSceneGraphObject = this.labelLeaf.editor().getTop();
            ((ZNode)zSceneGraphObject).getParent().removeChild((ZNode)zSceneGraphObject);
            this.labelLeaf = null;
            this.text = null;
            this.rect = null;
        }
        if (this.region != null) {
            this.region.remove(this);
        }
        zSceneGraphObject = this.getThumb();
        ZNode zNode = ((ZVisualComponent)zSceneGraphObject).getParentsReference()[0].editor().getTop();
        zNode.getParent().removeChild(zNode);
        this.file.delete();
        int n = 0;
        while (n < PhotoMesa.THUMB_WIDTHS.length) {
            File file;
            File file2 = new File(this.getGlobalThumbPath(n));
            if (file2.exists()) {
                file2.delete();
            }
            if ((file = new File(this.getLocalThumbPath(n))).exists()) {
                file.delete();
            }
            ++n;
        }
    }

    public void interactiveRename() {
        ImagePane imagePane = this.photomesa.getImagePane();
        ZCamera zCamera = imagePane.getCamera();
        ZBounds zBounds = this.getThumb().getGlobalBounds();
        this.text = new ZText(this.getImageName());
        this.text.setFont(PhotoMesa.font);
        this.text.setEditable(true);
        this.rect = new ZRectangle(this.text.getBounds());
        this.rect.setAbsPenWidth(1.0);
        this.labelLeaf = new ZVisualLeaf();
        this.labelLeaf.setFindable(false);
        this.labelLeaf.setPickable(false);
        this.labelLeaf.addVisualComponent(this.rect);
        this.labelLeaf.addVisualComponent(this.text);
        imagePane.getTopLayer().addChild(this.labelLeaf);
        ZTransformGroup zTransformGroup = this.labelLeaf.editor().getTransformGroup();
        double d = 1.0 / zCamera.getMagnification();
        zTransformGroup.scale(d);
        zTransformGroup.position((Point2D)new Point2D.Double(0.5, 0.0), (Point2D)new Point2D.Double(0.5, 1.0), zBounds, 0, imagePane.getDrawingSurface());
        ZBounds zBounds2 = zCamera.getViewBounds();
        zBounds = this.labelLeaf.getGlobalBounds();
        if (zBounds.getX() < zBounds2.getX()) {
            zTransformGroup.translate((zBounds2.getX() - zBounds.getX()) / d, 0.0);
        }
        if (zBounds.getY() < zBounds2.getY()) {
            zTransformGroup.translate(0.0, (zBounds2.getY() - zBounds.getY()) / d);
        }
        if (zBounds.getX() + zBounds.getWidth() > zBounds2.getX() + zBounds2.getWidth()) {
            zTransformGroup.translate((zBounds2.getX() + zBounds2.getWidth() - (zBounds.getX() + zBounds.getWidth())) / d, 0.0);
        }
        if (zBounds.getY() + zBounds.getHeight() > zBounds2.getY() + zBounds2.getHeight()) {
            zTransformGroup.translate(0.0, (zBounds2.getY() + zBounds2.getHeight() - (zBounds.getY() + zBounds.getHeight())) / d);
        }
    }

    public boolean interactiveRenameKeyPress(KeyEvent keyEvent) {
        boolean bl;
        ImagePane imagePane = this.photomesa.getImagePane();
        ZCamera zCamera = imagePane.getCamera();
        int n = 0;
        if (keyEvent != null) {
            n = keyEvent.getKeyCode();
        }
        if (n == 0 || n == 27 || n == 10) {
            Serializable serializable;
            if (n == 10 && !this.renameTo((File)(serializable = new File(this.file.getParentFile(), this.text.getText())))) {
                return true;
            }
            if (n == 27) {
                keyEvent.consume();
            }
            serializable = this.labelLeaf.editor().getTop();
            serializable.getParent().removeChild((ZNode)serializable);
            this.labelLeaf = null;
            this.text = null;
            this.rect = null;
            bl = false;
        } else {
            this.text.keyPressed(keyEvent);
            this.rect.setRect(this.text.getBounds());
            ZTransformGroup zTransformGroup = this.labelLeaf.editor().getTransformGroup();
            zTransformGroup.position((Point2D)new Point2D.Double(0.5, 0.0), (Point2D)new Point2D.Double(0.5, 1.0), this.getThumb().getGlobalBounds(), 0, imagePane.getDrawingSurface());
            double d = zTransformGroup.getScale();
            ZBounds zBounds = zCamera.getViewBounds();
            ZBounds zBounds2 = this.labelLeaf.getGlobalBounds();
            if (zBounds2.getX() < zBounds.getX()) {
                zTransformGroup.translate((zBounds.getX() - zBounds2.getX()) / d, 0.0);
            }
            if (zBounds2.getY() < zBounds.getY()) {
                zTransformGroup.translate(0.0, (zBounds.getY() - zBounds2.getY()) / d);
            }
            if (zBounds2.getX() + zBounds2.getWidth() > zBounds.getX() + zBounds.getWidth()) {
                zTransformGroup.translate((zBounds.getX() + zBounds.getWidth() - (zBounds2.getX() + zBounds2.getWidth())) / d, 0.0);
            }
            if (zBounds2.getY() + zBounds2.getHeight() > zBounds.getY() + zBounds.getHeight()) {
                zTransformGroup.translate(0.0, (zBounds.getY() + zBounds.getHeight() - (zBounds2.getY() + zBounds2.getHeight())) / d);
            }
            bl = true;
        }
        return bl;
    }

    protected boolean renameTo(File file) {
        if (file.exists()) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        int n = 0;
        while (n < PhotoMesa.THUMB_WIDTHS.length) {
            File file2 = new File(this.getThumbPath(n));
            File file3 = new File(file2.getParentFile(), file.getName());
            file2.renameTo(file3);
            ++n;
        }
        this.file.renameTo(file);
        this.file = file;
        return true;
    }

    public String getThumbPath(int n) {
        if (this.photomesa.state.getLocalThumbnails()) {
            return this.getLocalThumbPath(n);
        }
        return this.getGlobalThumbPath(n);
    }

    String getLocalThumbPath(int n) {
        File file = this.file.getParentFile();
        String string = file + File.separator + ".photomesa-thumbs" + File.separator + "thumbs" + n + File.separator + this.file.getName();
        return string;
    }

    String getGlobalThumbPath(int n) {
        String string = this.file.getAbsolutePath();
        int n2 = string.indexOf(58);
        String string2 = string;
        if (n2 != -1) {
            string2 = string.substring(0, n2) + string.substring(n2 + 1);
        }
        String string3 = this.photomesa.getThumbDirectory() + File.separator + "thumbs" + n + File.separator + string2;
        return string3;
    }

    public String getImagePath() {
        return this.file.getAbsolutePath();
    }

    public String getImageName() {
        return this.file.getName();
    }

    public PMImage getThumb() {
        return this.thumb;
    }

    PMImage getHiResImage() {
        Image image = Toolkit.getDefaultToolkit().createImage(this.getImagePath());
        MediaTracker mediaTracker = new MediaTracker(this.photomesa.getImagePane());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Couldn't load image: " + image);
        }
        PMImage pMImage = new PMImage(image, this);
        pMImage.setPenWidth(1.0);
        return pMImage;
    }

    void loadHiResOneToOneImage() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.imageHeight = -1;
        this.imageWidth = -1;
        this.notified = false;
        final Image image = toolkit.createImage(this.getImagePath());
        toolkit.prepareImage(image, -1, -1, new ImageObserver(){

            public boolean imageUpdate(Image image2, int n, int n2, int n3, int n4, int n5) {
                ImagePane imagePane = ImageItem.this.photomesa.getImagePane();
                if ((n & 1) == 1) {
                    ImageItem.this.imageWidth = n4;
                    if (ImageItem.this.imageHeight != -1 && !ImageItem.this.notified) {
                        imagePane.notifyOneToOne(ImageItem.this, ImageItem.this.imageWidth, ImageItem.this.imageHeight);
                        ImageItem.this.notified = true;
                    }
                }
                if ((n & 2) == 2) {
                    ImageItem.this.imageHeight = n5;
                    if (ImageItem.this.imageWidth != -1 && !ImageItem.this.notified) {
                        imagePane.notifyOneToOne(ImageItem.this, ImageItem.this.imageWidth, ImageItem.this.imageHeight);
                        ImageItem.this.notified = true;
                    }
                }
                if ((n & 0x20) == 0) {
                    return true;
                }
                ImageItem.this.hiresImage = new PMImage(image, ImageItem.this, n4, n5);
                ImageItem.this.hiresImage.setPenWidth(1.0);
                if (ImageItem.this.unloadHiResImageRequest) {
                    ImageItem.this.hiresImage.getImage().flush();
                    ImageItem.this.hiresImage = null;
                    ImageItem.this.unloadHiResImageRequest = false;
                    ImageItem.this.displayHiResImageRequest = false;
                } else if (ImageItem.this.displayHiResImageRequest) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$000(this.this$1).displayHiResImage();
                        }
                    });
                }
                return false;
            }

            static /* synthetic */ ImageItem access$000(1 var0) {
                return var0.ImageItem.this;
            }
        });
    }

    void loadHiResImage() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        final Image image = toolkit.createImage(this.getImagePath());
        toolkit.prepareImage(image, -1, -1, new ImageObserver(){

            public boolean imageUpdate(Image image2, int n, int n2, int n3, int n4, int n5) {
                if ((n & 0x20) == 0) {
                    return true;
                }
                ImageItem.this.hiresImage = new PMImage(image, ImageItem.this, n4, n5);
                ImageItem.this.hiresImage.setPenWidth(1.0);
                if (ImageItem.this.unloadHiResImageRequest) {
                    ImageItem.this.hiresImage.getImage().flush();
                    ImageItem.this.hiresImage = null;
                    ImageItem.this.unloadHiResImageRequest = false;
                    ImageItem.this.displayHiResImageRequest = false;
                } else if (ImageItem.this.displayHiResImageRequest) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            3.access$100(this.this$1).displayHiResImage();
                        }
                    });
                }
                return false;
            }

            static /* synthetic */ ImageItem access$100(3 var0) {
                return var0.ImageItem.this;
            }
        });
    }

    void unloadHiResImage() {
        if (this.hiresImage == null) {
            this.unloadHiResImageRequest = true;
        } else {
            ZNode zNode = this.hiresImageLeaf.editor().getTop();
            zNode.getParent().removeChild(zNode);
            this.hiresImageLeaf = null;
            this.hiresImage.getImage().flush();
            this.hiresImage = null;
        }
    }

    void displayHiResImage() {
        if (this.hiresImage == null) {
            this.displayHiResImageRequest = true;
        } else {
            ImagePane imagePane = this.photomesa.getImagePane();
            this.hiresImageLeaf = new ZVisualLeaf(this.hiresImage);
            imagePane.getLayer().addChild(this.hiresImageLeaf);
            ZTransformGroup zTransformGroup = this.hiresImageLeaf.editor().getTransformGroup();
            ZBounds zBounds = this.getThumb().getGlobalBounds();
            zTransformGroup.scale(zBounds.getWidth() / (double)this.hiresImage.getWidth());
            zTransformGroup.position((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 0.0), zBounds, 0, imagePane.getDrawingSurface());
            ZNode zNode = this.hiresImageLeaf.editor().getTop();
            zNode.setFindable(false);
            zNode.setPickable(false);
            this.imageWidth = this.hiresImage.getImage().getWidth(imagePane);
            this.imageHeight = this.hiresImage.getImage().getHeight(imagePane);
            this.photomesa.setStatusBarAuxText(this.getImagePath() + "       (" + this.imageWidth + "x" + this.imageHeight + " pixels)");
        }
    }

    void loadThumb(int n) {
        if (n >= this.photomesa.getNumThumbLevels()) {
            throw new RuntimeException("Invalid thumb level: " + n);
        }
        if (this.thumbLevel == n) {
            return;
        }
        ImagePane imagePane = this.photomesa.getImagePane();
        File file = new File(this.getThumbPath(n));
        if (file.exists()) {
            Image image = Toolkit.getDefaultToolkit().createImage(this.getThumbPath(n));
            MediaTracker mediaTracker = new MediaTracker(imagePane);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Couldn't load image: " + this.thumb);
            }
            this.thumb.setImage(image);
        }
        this.thumbLevel = n;
    }

    BufferedImage createThumbFile(int n, Image image) throws RuntimeException {
        int n2;
        int n3;
        if (n >= this.photomesa.getNumThumbLevels()) {
            throw new RuntimeException("Invalid thumb level: " + n);
        }
        ImagePane imagePane = this.photomesa.getImagePane();
        File file = new File(this.getThumbPath(n));
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (image == null) {
            image = Toolkit.getDefaultToolkit().createImage(this.getImagePath());
            MediaTracker mediaTracker = new MediaTracker(imagePane);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Couldn't load image: " + image);
            }
        }
        int n4 = image.getWidth(imagePane);
        int n5 = image.getHeight(imagePane);
        if (n4 <= 0 || n5 <= 0) {
            throw new RuntimeException("Empty image: " + this.getImagePath());
        }
        if (n4 > n5) {
            n3 = PhotoMesa.THUMB_WIDTHS[n];
            n2 = n3 * n5 / n4;
            if (n2 == 0) {
                n2 = 2;
            }
        } else {
            n2 = (int)((double)PhotoMesa.THUMB_WIDTHS[n] / this.photomesa.state.getAspectRatio());
            n3 = n2 * n4 / n5;
            if (n3 == 0) {
                n3 = 2;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n2, 1);
        bufferedImage.getGraphics().drawImage(image, 0, 0, n3, n2, imagePane);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        image.flush();
        image = null;
        bufferedImage.flush();
        return bufferedImage;
    }

    public String toString() {
        return this.file.getName();
    }
}

