/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

class CushionRectangle
extends ZRectangle
implements Feathered {
    PhotoMesa photomesa;
    Paint[] c;
    Rectangle2D[] r;
    Stroke featherStroke;

    public CushionRectangle(PhotoMesa photoMesa, double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.photomesa = photoMesa;
        this.updateFeatherDepth();
    }

    public void updateFeatherDepth() {
        this.c = new Paint[this.photomesa.state.getFeatherDepth()];
        this.r = new Rectangle2D[this.photomesa.state.getFeatherDepth()];
        this.setRect(this.rectangle);
        this.setPenPaint(this.getPenPaint());
    }

    public void setPenPaint(Paint paint) {
        super.setPenPaint(paint);
        double d = 1.0 / (double)(this.photomesa.state.getFeatherDepth() + 1);
        double d2 = 0.0;
        int n = 0;
        while (n < this.photomesa.state.getFeatherDepth()) {
            this.c[n] = this.colorLerp(paint, d2 += d, 255, 255, 255);
            ++n;
        }
    }

    public void setPenWidth(double d) {
        super.setPenWidth(d);
        this.featherStroke = new BasicStroke((float)(0.6 * this.penWidth), 0, 0);
    }

    Paint colorLerp(Paint paint, double d, int n, int n2, int n3) {
        Color color = null;
        if (paint != null && paint instanceof Color) {
            Color color2 = (Color)paint;
            int n4 = (int)((double)color2.getRed() + d * (double)(n - color2.getRed()));
            int n5 = (int)((double)color2.getGreen() + d * (double)(n - color2.getGreen()));
            int n6 = (int)((double)color2.getBlue() + d * (double)(n - color2.getBlue()));
            color = new Color(n4, n5, n6);
        }
        return color;
    }

    public void setRect(Rectangle2D rectangle2D) {
        super.setRect(rectangle2D);
        if (this.r != null) {
            int n = 0;
            while (n < this.photomesa.state.getFeatherDepth()) {
                this.r[n] = new Rectangle2D.Double(rectangle2D.getX() + (double)(n + 1), rectangle2D.getY() + (double)(n + 1), rectangle2D.getWidth() - (double)(2 * (n + 1)), rectangle2D.getHeight() - (double)(2 * (n + 1)));
                ++n;
            }
        }
    }

    public void render(ZRenderContext zRenderContext) {
        super.render(zRenderContext);
        Graphics2D graphics2D = zRenderContext.getGraphics2D();
        if (this.r.length > 0 && this.r[0] != null) {
            graphics2D.setStroke(this.featherStroke);
            int n = 0;
            while (n < this.photomesa.state.getFeatherDepth()) {
                graphics2D.setPaint(this.c[n]);
                graphics2D.draw(this.r[n]);
                ++n;
            }
        }
    }
}

