/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

class MP3CDGUI
extends JPanel
implements ActionListener {
    public static final int MAJORVERSION = 0;
    public static final int MINORVERSION = 9;
    public static final String VERSIONURL = "http://www.filenabber.com/maccc/version";
    JTabbedPane globaloptionspanel;
    MP3LocalPanel mp3localpanel;
    DirLocalPanel dirlocalpanel;
    FontPanel fontpanel;
    MP3GlobalPanel globalmp3panel;
    DirGlobalPanel globaldirpanel;
    MP3Table mp3table;
    JButton gobutton;
    JButton writeCoversButton;
    JButton rescanButton;
    JButton scanNewButton;
    IOPanel iopanel;
    JMenuItem aboutmi;
    JMenuItem iomi;
    JMenuItem mp3mi;
    JMenuItem dirmi;
    JMenuItem exitmi;
    JPanel aboutpanel;
    JPanel infopanel;
    JFrame optionsframe;
    public static final String fs = File.separator;
    Popups popups = new Popups(this);
    String scandir;
    JButton saveButton;
    JButton cancelButton;
    JToolBar toolbar;
    JButton scanButton;
    JButton rescanCDButton;
    JButton writeButton;
    JButton optionsButton;
    JButton aboutButton;
    JButton exitButton;
    private JTextComponent editor;
    private JMenuBar menubar;
    private JComponent status;
    private JFrame elementTreeFrame;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String exitAction = "exit";
    public static final String showElementTreeAction = "showElementTree";

    MP3CDGUI(String string) {
        super(true);
        this.scandir = string;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.setFont(new Font("monospaced", 0, 12));
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.toolbar = new JToolBar();
        this.scanButton = new JButton();
        String string2 = "toolbar/cd.gif";
        URL uRL = this.getClass().getResource(string2);
        if (uRL != null) {
            this.scanButton = new JButton(new ImageIcon(uRL));
        } else {
            System.out.println("imageurl = null");
        }
        this.toolbar.add(this.scanButton);
        this.scanButton.setToolTipText("Scan drive/dir");
        this.scanButton.addActionListener(this);
        this.rescanCDButton = new JButton();
        string2 = "toolbar/cd-rescan.gif";
        uRL = this.getClass().getResource(string2);
        if (uRL != null) {
            this.rescanCDButton = new JButton(new ImageIcon(uRL));
        }
        this.toolbar.add(this.rescanCDButton);
        this.rescanCDButton.setToolTipText("Rescan same drive/dir");
        this.rescanCDButton.addActionListener(this);
        this.writeButton = new JButton();
        string2 = "toolbar/save.gif";
        uRL = this.getClass().getResource(string2);
        if (uRL != null) {
            this.writeButton = new JButton(new ImageIcon(uRL));
        }
        this.toolbar.add(this.writeButton);
        this.writeButton.setToolTipText("Write covers");
        this.writeButton.addActionListener(this);
        this.optionsButton = new JButton();
        string2 = "toolbar/executeproject.gif";
        uRL = this.getClass().getResource(string2);
        if (uRL != null) {
            this.optionsButton = new JButton(new ImageIcon(uRL));
        }
        this.toolbar.add(this.optionsButton);
        this.optionsButton.setToolTipText("Options");
        this.optionsButton.addActionListener(this);
        this.aboutButton = new JButton();
        string2 = "toolbar/help3.gif";
        uRL = this.getClass().getResource(string2);
        if (uRL != null) {
            this.aboutButton = new JButton(new ImageIcon(uRL));
        }
        this.toolbar.add(this.aboutButton);
        this.aboutButton.setToolTipText("About");
        this.aboutButton.addActionListener(this);
        this.exitButton = new JButton("Exit");
        string2 = "toolbar/door.gif";
        uRL = this.getClass().getResource(string2);
        if (uRL != null) {
            this.exitButton = new JButton(new ImageIcon(uRL));
        }
        this.exitButton.setToolTipText("Exit");
        this.exitButton.addActionListener(this);
        this.infopanel = new JPanel();
        CardLayout cardLayout = new CardLayout();
        this.infopanel.setLayout(cardLayout);
        this.mp3localpanel = new MP3LocalPanel(this);
        this.infopanel.add("MP3", this.mp3localpanel);
        this.dirlocalpanel = new DirLocalPanel(this);
        this.infopanel.add("DIR", this.dirlocalpanel);
        this.fontpanel = new FontPanel(this);
        this.infopanel.add("FONT", this.fontpanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.exitButton);
        jPanel.add(jPanel2);
        this.mp3table = new MP3Table();
        this.mp3table.createTable(this.scandir);
        SelectionListener selectionListener = new SelectionListener(this.mp3table.getTable());
        this.mp3table.getTable().getSelectionModel().addListSelectionListener(selectionListener);
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(this.mp3table.getTable());
        this.add("North", this.toolbar);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", this.infopanel);
        jPanel3.add("South", jPanel);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel3);
        jSplitPane.setResizeWeight(1.0);
        this.add("Center", jSplitPane);
        this.aboutpanel = new JPanel();
        this.aboutpanel.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(ResourceStrings.get("COPYRIGHT_INFO"));
        ActiveURL activeURL = new ActiveURL(ResourceStrings.get("EMAIL_AUTHOR"), "mailto:maccc@filenabber.com?subject=Your MACCC program ROCKS!");
        this.aboutpanel.add((Component)jLabel, "North");
        this.aboutpanel.add((Component)activeURL, "Center");
        ActiveURL activeURL2 = new ActiveURL(ResourceStrings.get("HOMEPAGE"), "http://www.filenabber.com/maccc");
        this.aboutpanel.add((Component)activeURL2, "South");
        this.saveButton = new JButton(ResourceStrings.get("SAVE"));
        this.saveButton.addActionListener(this);
        this.cancelButton = new JButton(ResourceStrings.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.saveButton);
        jPanel4.add(this.cancelButton);
        this.globaloptionspanel = new JTabbedPane();
        this.iopanel = new IOPanel(this);
        this.globalmp3panel = new MP3GlobalPanel(this);
        this.globaldirpanel = new DirGlobalPanel(this);
        this.globaloptionspanel.add(ResourceStrings.get("INPUT_OUTPUT"), this.iopanel);
        this.globaloptionspanel.add("MP3", this.globalmp3panel);
        this.globaloptionspanel.add(ResourceStrings.get("MP3_DIRS"), this.globaldirpanel);
        this.optionsframe = new JFrame();
        this.optionsframe.setTitle(ResourceStrings.get("GLOBAL_OPTIONS"));
        this.optionsframe.getContentPane().setLayout(new BorderLayout());
        this.optionsframe.getContentPane().add("Center", this.globaloptionspanel);
        this.optionsframe.getContentPane().add("South", jPanel4);
        this.optionsframe.pack();
        int n = 480;
        int n2 = 640;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.optionsframe.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
    }

    public static String getNewVersion() {
        String string;
        block6: {
            System.out.print(ResourceStrings.get("CHECKING") + ".....");
            int n = 0;
            int n2 = 9;
            string = null;
            boolean bl = false;
            try {
                int n3;
                Properties properties = new Properties();
                URL uRL = new URL(VERSIONURL);
                properties.load(uRL.openStream());
                String string2 = properties.getProperty("maccc.major.version");
                String string3 = properties.getProperty("maccc.minor.version");
                int n4 = Integer.parseInt(string2);
                if (n4 > n) {
                    bl = true;
                } else if (n4 == n && (n3 = Integer.parseInt(string3)) > n2) {
                    bl = true;
                }
                if (bl) {
                    string = string2 + "." + string3;
                    break block6;
                }
                System.out.println(ResourceStrings.get("NO_NEW_VERSION"));
            }
            catch (Exception exception) {
                System.out.println(ResourceStrings.get("NO_CHECK_VERSION"));
            }
        }
        return string;
    }

    public static void setupLook() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (actionEvent.getSource() == this.writeButton) {
            bl = ConfigProperties.getBoolean("OUTPUTCDR");
            boolean bl2 = ConfigProperties.getBoolean("OUTPUTTXT");
            boolean bl3 = ConfigProperties.getBoolean("OUTPUTCDI");
            boolean bl4 = ConfigProperties.getBoolean("OUTPUTHTML");
            if (!(bl || bl2 || bl3 || bl4)) {
                this.popups.showInfoMessage("No output file format selected");
                return;
            }
            String string = ConfigProperties.get("OUTPUTDIR");
            if (string == null || string.equals("")) {
                this.popups.showError("No output directory entered.");
                return;
            }
            Object object = new File(string);
            if (!((File)object).exists()) {
                this.popups.showError("Output directory does not exist.");
                return;
            }
            object = ConfigProperties.get("OUTFILE");
            String string2 = string + fs + (String)object;
            if (bl) {
                OutputNewCDRLabel outputNewCDRLabel = new OutputNewCDRLabel();
                outputNewCDRLabel.setDirCount(this.mp3table.getDirCount());
                outputNewCDRLabel.setFileCount(this.mp3table.getFileCount());
                outputNewCDRLabel.writePlaylist(string2, this.mp3table.getMP3Vector());
            }
            if (bl2) {
                OutputText.writeTextFile(string2, this.mp3table.getMP3Vector());
            }
            if (bl3) {
                OutputCDI.writeCDIFile(string2, this.mp3table.getMP3Vector());
            }
            if (bl4) {
                OutputHTML.writeHTML(string2, this.mp3table.getMP3Vector());
            }
            this.popups.showInfoMessage("Successfully created covers");
        }
        if (actionEvent.getSource() == this.aboutButton) {
            JOptionPane.showMessageDialog(this, this.aboutpanel, "About MACCC", -1);
        }
        if (actionEvent.getSource() == this.exitButton && (bl = this.popups.showQuestion(ResourceStrings.get("EXIT_ARE_YOU_SURE")))) {
            System.exit(0);
        }
        if (actionEvent.getSource() == this.optionsButton) {
            this.globaloptionspanel.setSelectedIndex(0);
            this.optionsframe.show();
        } else if (actionEvent.getSource() == this.mp3mi) {
            this.globaloptionspanel.setSelectedIndex(1);
            this.optionsframe.show();
        } else if (actionEvent.getSource() == this.dirmi) {
            this.globaloptionspanel.setSelectedIndex(2);
            this.optionsframe.show();
        } else if (actionEvent.getSource() == this.saveButton) {
            this.iopanel.savePage();
            this.globalmp3panel.savePage();
            this.globaldirpanel.savePage();
            ConfigProperties.save();
            this.optionsframe.hide();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.optionsframe.hide();
        } else if (actionEvent.getSource() == this.scanButton) {
            String string = MP3CDGUI.showDirChooser(this.scandir);
            if (string != null) {
                this.scandir = string;
                this.mp3table.createTable(this.scandir);
                this.invalidate();
                this.validate();
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.rescanCDButton) {
            this.mp3table.createTable(this.scandir);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void setMP3Objects(MP3Object[] mP3ObjectArray, int[] nArray) {
        this.mp3table.setMP3Objects(mP3ObjectArray, nArray);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public static void showNewVersion(String string) {
        System.out.println("new version found: v" + string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1));
        JLabel jLabel = new JLabel("A new version is available: " + string + "!", 0);
        Font font = jLabel.getFont();
        String string2 = font.getName();
        int n = font.getSize();
        Font font2 = new Font(string2, 1, n);
        jLabel.setFont(font2);
        JLabel jLabel2 = new JLabel(" ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        JLabel jLabel3 = new JLabel("Get it here:", 0);
        ActiveURL activeURL = new ActiveURL("http://www.filenabber.com/maccc", "http://www.filenabber.com/maccc");
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        jPanel.add(activeURL);
        JOptionPane.showMessageDialog(null, jPanel, "MACCC - new version", -1);
    }

    public static String showDirChooser(String string) {
        int n;
        if (string == null) {
            string = "";
        }
        String string2 = "";
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("MACCC- choose MP3 dir/drive");
        if (string != "") {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if ((n = jFileChooser.showOpenDialog(null)) == 0) {
            File file = jFileChooser.getSelectedFile();
            string2 = file.getPath();
            ConfigProperties.set("MP3DIR", string2);
            ConfigProperties.save();
            return string2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        MP3CDGUI.setupLook();
        System.out.println("---------------------------------------------------");
        System.out.println("MP3 Automagic CD Cover Creator (MACCC) v0.9");
        System.out.println("Copyright 2002-2003 Brian Pipa");
        System.out.println("All Rights Reserved");
        System.out.println("Questions and comments can be sent to maccc@filenabber.com");
        System.out.println("Current version can be found at http://www.filenabber.com/maccc");
        System.out.println("---------------------------------------------------");
        try {
            String string;
            String string2 = System.getProperty("java.version");
            if (string2.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing must be run with a 1.1.2 or higher version VM!!!");
            }
            if (!ConfigProperties.debug() && (string = MP3CDGUI.getNewVersion()) != null) {
                MP3CDGUI.showNewVersion(string);
            }
            string = ConfigProperties.get("MP3DIR");
            JFrame jFrame = new JFrame();
            jFrame.setTitle("MP3 Automagic CD Cover Creator v0.9");
            jFrame.setBackground(Color.lightGray);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add("Center", new MP3CDGUI(string));
            jFrame.addWindowListener(new AppCloser());
            jFrame.pack();
            int n = 800;
            int n2 = 400;
            jFrame.setSize(n, n2);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
            jFrame.show();
        }
        catch (Throwable throwable) {
            System.out.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    protected JTextComponent createEditor() {
        return new JTextArea();
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    protected Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected Component createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.exitmi = new JMenuItem("Exit");
        this.exitmi.addActionListener(this);
        jMenu.add(this.exitmi);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Options");
        this.iomi = new JMenuItem("Input/Output");
        this.iomi.addActionListener(this);
        jMenu2.add(this.iomi);
        this.mp3mi = new JMenuItem("MP3 files");
        this.mp3mi.addActionListener(this);
        jMenu2.add(this.mp3mi);
        this.dirmi = new JMenuItem("MP3 Directories");
        this.dirmi.addActionListener(this);
        jMenu2.add(this.dirmi);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Help");
        this.aboutmi = new JMenuItem("About");
        this.aboutmi.addActionListener(this);
        jMenu3.add(this.aboutmi);
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == this.table.getSelectionModel()) {
                Object object;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = this.table.getSelectedRows();
                MP3Object[] mP3ObjectArray = new MP3Object[nArray.length];
                int n = -1;
                int n2 = 0;
                while (n2 < nArray.length) {
                    mP3ObjectArray[n2] = object = MP3CDGUI.this.mp3table.getMP3Object(nArray[n2]);
                    int n3 = ((MP3Object)object).getType();
                    if (n == -1) {
                        n = n3;
                    } else if (n != n3) {
                        ((CardLayout)MP3CDGUI.this.infopanel.getLayout()).show(MP3CDGUI.this.infopanel, "FONT");
                        return;
                    }
                    ++n2;
                }
                if (n == 0) {
                    MP3CDGUI.this.mp3localpanel.setMP3Objects(mP3ObjectArray, nArray);
                    ((CardLayout)MP3CDGUI.this.infopanel.getLayout()).show(MP3CDGUI.this.infopanel, "MP3");
                } else {
                    Object object2;
                    int n4;
                    object = new Vector();
                    Vector<Integer> vector = new Vector<Integer>();
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        n4 = 1;
                        int n6 = nArray[n5] + n4;
                        object2 = MP3CDGUI.this.mp3table.getMP3Object(n6);
                        while (((MP3Object)object2).isFile()) {
                            ((Vector)object).addElement(object2);
                            vector.addElement(new Integer(n6));
                            n6 = nArray[n5] + ++n4;
                            if (n6 == MP3CDGUI.this.mp3table.getMP3VectorSize()) break;
                            object2 = MP3CDGUI.this.mp3table.getMP3Object(nArray[n5] + n4);
                        }
                        ++n5;
                    }
                    n4 = ((Vector)object).size();
                    MP3Object[] mP3ObjectArray2 = new MP3Object[n4];
                    object2 = new int[n4];
                    int n7 = 0;
                    while (n7 < n4) {
                        mP3ObjectArray2[n7] = (MP3Object)((Vector)object).elementAt(n7);
                        object2[n7] = (Integer)vector.elementAt(n7);
                        ++n7;
                    }
                    MP3CDGUI.this.dirlocalpanel.setMP3Objects(mP3ObjectArray2, (int[])object2);
                    ((CardLayout)MP3CDGUI.this.infopanel.getLayout()).show(MP3CDGUI.this.infopanel, "DIR");
                }
            }
        }
    }

    class StatusBar
    extends JComponent {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            MP3CDGUI.this.undo.addEdit(undoableEditEvent.getEdit());
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

