/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.player;

import com.wet.wired.jsr.player.FrameDecompressor;
import com.wet.wired.jsr.player.ScreenPlayerListener;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.FileInputStream;
import java.io.IOException;

public class ScreenPlayer
implements Runnable {
    private ScreenPlayerListener listener;
    private MemoryImageSource mis = null;
    private Rectangle area;
    private FrameDecompressor decompressor;
    private long startTime;
    private long frameTime;
    private long lastFrameTime;
    private boolean running;
    private boolean paused;
    private boolean fastForward;
    private boolean resetReq;
    private FileInputStream iStream;
    private String videoFile;
    private int width;
    private int height;

    public ScreenPlayer(String videoFile, ScreenPlayerListener listener) {
        this.listener = listener;
        this.videoFile = videoFile;
        this.initialize();
    }

    private void initialize() {
        this.frameTime = this.startTime = System.currentTimeMillis();
        this.lastFrameTime = this.startTime;
        this.paused = true;
        try {
            this.iStream = new FileInputStream(this.videoFile);
            this.width = this.iStream.read();
            this.width <<= 8;
            this.width += this.iStream.read();
            this.height = this.iStream.read();
            this.height <<= 8;
            this.height += this.iStream.read();
            this.area = new Rectangle(this.width, this.height);
            this.decompressor = new FrameDecompressor(this.iStream, this.width * this.height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset_req() {
        this.paused = true;
        this.fastForward = false;
        this.resetReq = true;
    }

    public void reset() {
        this.resetReq = false;
        this.initialize();
    }

    public void play() {
        this.fastForward = false;
        this.paused = false;
        if (!this.running) {
            new Thread((Runnable)this, "Screen Player").start();
        }
    }

    public void fastforward() {
        this.fastForward = true;
        this.paused = false;
    }

    public void pause() {
        this.paused = true;
    }

    public void stop() {
        this.paused = false;
        this.running = false;
    }

    @Override
    public synchronized void run() {
        this.running = true;
        while (this.running) {
            while (this.paused && !this.resetReq) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.startTime += 50L;
            }
            try {
                this.readFrame();
                this.listener.newFrame();
            }
            catch (IOException ioe) {
                this.listener.showNewImage(null);
                break;
            }
            if (this.fastForward) {
                this.startTime -= this.frameTime - this.lastFrameTime;
            } else {
                while (System.currentTimeMillis() - this.startTime < this.frameTime && !this.paused) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
            }
            this.lastFrameTime = this.frameTime;
        }
        this.listener.playerStopped();
    }

    private void readFrame() throws IOException {
        if (this.resetReq) {
            this.reset();
            return;
        }
        FrameDecompressor.FramePacket frame = this.decompressor.unpack();
        this.frameTime = frame.getTimeStamp();
        int result = frame.getResult();
        if (result == 0) {
            return;
        }
        if (result == -1) {
            this.paused = true;
            this.listener.playerPaused();
            return;
        }
        if (this.mis == null) {
            this.mis = new MemoryImageSource(this.area.width, this.area.height, frame.getData(), 0, this.area.width);
            this.mis.setAnimated(true);
            this.listener.showNewImage(Toolkit.getDefaultToolkit().createImage(this.mis));
            return;
        }
        this.mis.newPixels(frame.getData(), ColorModel.getRGBdefault(), 0, this.area.width);
    }
}

