/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.Mp3;

import entagged.audioformats.Tag;
import entagged.audioformats.generic.TagField;
import entagged.audioformats.mp3.Id3v1Tag;
import entagged.audioformats.mp3.Id3v2Tag;
import entagged.audioformats.mp3.util.Id3v1TagReader;
import entagged.audioformats.mp3.util.Id3v1TagWriter;
import entagged.audioformats.mp3.util.Id3v2TagReader;
import entagged.audioformats.mp3.util.Id3v2TagWriter;
import entagged.audioformats.mp3.util.id3frames.TextId3Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Properties;
import net.sf.jmp3renamer.AbstractTranslatablePlugin;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FilePlugin;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.gui.PluginConfigGUI;
import net.sf.jmp3renamer.plugins.Mp3.Mp3FileFilter;
import net.sf.jmp3renamer.plugins.Mp3.gui.Mp3ConfigGui;
import net.sf.jmp3renamer.util.ExtendedFileFilter;
import net.sf.jmp3renamer.util.MyFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mp3
extends AbstractTranslatablePlugin
implements FilePlugin {
    private final String VERSION = "0.9.1";
    private final String AUTHOR = "Henrik Niehaus, hampelratte@users.sf.net";
    private final String NAME = "Mp3 Files";
    private Mp3FileFilter filter = new Mp3FileFilter();
    private static Properties props = new Properties();
    private static transient Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jmp3renamer$plugins$Mp3$Mp3 == null ? (class$net$sf$jmp3renamer$plugins$Mp3$Mp3 = Mp3.class$("net.sf.jmp3renamer.plugins.Mp3.Mp3")) : class$net$sf$jmp3renamer$plugins$Mp3$Mp3));
    private boolean propsLoaded = false;
    private Mp3ConfigGui configGui;
    static /* synthetic */ Class class$net$sf$jmp3renamer$plugins$Mp3$Mp3;

    public void init() {
        this.loadConfig();
        this.loadLanguage();
        this.configGui = new Mp3ConfigGui(this);
    }

    public String getVersion() {
        return "0.9.1";
    }

    public String getAuthor() {
        return "Henrik Niehaus, hampelratte@users.sf.net";
    }

    public String getDescription() {
        return I18N.translate((String)"plugin_description");
    }

    private void loadConfig() {
        props.setProperty("tagtype", "3");
        props.setProperty("readV1", "true");
        props.setProperty("readV2", "true");
        if (!this.propsLoaded) {
            String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "mp3.props";
            try {
                File conffile;
                File confdir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer");
                if (!confdir.exists()) {
                    confdir.mkdir();
                }
                if (!(conffile = new File(file)).exists()) {
                    conffile.createNewFile();
                }
                FileInputStream fin = new FileInputStream(file);
                props.load(fin);
                this.propsLoaded = true;
            }
            catch (Exception e) {
                logger.error(I18N.translate((String)"error.load_settings"), (Throwable)e);
            }
        }
    }

    public int getType() {
        return 1;
    }

    public String getName() {
        return "Mp3 Files";
    }

    public PluginConfigGUI getConfigGUI() {
        return this.configGui;
    }

    public Properties getConfig() {
        return props;
    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public void saveConfig() {
        String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "mp3.props";
        try {
            FileOutputStream fout = new FileOutputStream(file);
            props.store(fout, "Mp3 Properties");
            logger.info("{}: Saving properties: done", (Object)"Mp3 Files");
        }
        catch (Exception e) {
            logger.error(I18N.translate((String)"error.save_settings"), (Throwable)e);
        }
    }

    public DataSet getMetaData(File file) {
        DataSet dataset = null;
        try {
            if (new Boolean(Mp3.getProperty("readV1")).booleanValue()) {
                dataset = this.readV1(dataset, file);
            }
            if (new Boolean(Mp3.getProperty("readV2")).booleanValue()) {
                dataset = this.readV2(dataset, file);
            }
        }
        catch (Exception e) {
            logger.error(I18N.translate((String)"error.load_metadata"), (Throwable)e);
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private DataSet readV1(DataSet dataset, File file) {
        block11: {
            RandomAccessFile raf;
            block10: {
                if (dataset == null) {
                    dataset = new DataSet();
                }
                raf = null;
                raf = new RandomAccessFile(file, "r");
                Id3v1Tag tag = new Id3v1TagReader().read(raf);
                if (tag == null) break block10;
                dataset.setTrack(tag.getFirstTrack());
                dataset.setAlbum(tag.getFirstAlbum());
                dataset.setArtist(tag.getFirstArtist());
                dataset.setComment(tag.getFirstComment());
                dataset.setGenre(tag.getFirstGenre());
                dataset.setTitle(tag.getFirstTitle());
                dataset.setYear(tag.getFirstYear());
                DataSet dataSet = dataset;
                Object var7_7 = null;
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    logger.warn("Couldn't close mp3 file", (Throwable)ioe);
                }
                return dataSet;
            }
            Object var7_8 = null;
            try {
                raf.close();
            }
            catch (IOException ioe) {
                logger.warn("Couldn't close mp3 file", (Throwable)ioe);
            }
            break block11;
            {
                catch (Exception e) {
                    logger.debug("Couldn't read version 1 tag:\n\t" + e);
                    Object var7_9 = null;
                    try {
                        raf.close();
                    }
                    catch (IOException ioe) {
                        logger.warn("Couldn't close mp3 file", (Throwable)ioe);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    logger.warn("Couldn't close mp3 file", (Throwable)ioe);
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private DataSet readV2(DataSet dataset, File file) {
        block24: {
            RandomAccessFile raf;
            block23: {
                if (dataset == null) {
                    dataset = new DataSet();
                }
                raf = null;
                raf = new RandomAccessFile(file, "r");
                Id3v2Tag tag = new Id3v2TagReader().read(raf);
                if (tag == null) break block23;
                if (dataset.getAlbum().equals("") || dataset.getAlbum().length() < tag.getFirstAlbum().length()) {
                    dataset.setAlbum(tag.getFirstAlbum());
                }
                if (dataset.getArtist().equals("") || dataset.getArtist().length() < tag.getFirstArtist().length()) {
                    dataset.setArtist(tag.getFirstArtist());
                }
                if (dataset.getComment().equals("") || dataset.getComment().length() < tag.getFirstComment().length()) {
                    dataset.setComment(tag.getFirstComment());
                }
                if (dataset.getComposer().equals("") || dataset.getComposer().length() < this.getFirst(tag, "TCOM").length()) {
                    dataset.setComposer(this.getFirst(tag, "TCOM"));
                }
                if (dataset.getCopyright().equals("") || dataset.getCopyright().length() < this.getFirst(tag, "TCOP").length()) {
                    dataset.setCopyright(this.getFirst(tag, "TCOP"));
                }
                if (dataset.getEncodedBy().equals("") || dataset.getEncodedBy().length() < this.getFirst(tag, "TENC").length()) {
                    dataset.setEncodedBy(this.getFirst(tag, "TENC"));
                }
                if (dataset.getGenre().equals("") || dataset.getGenre().equals("unknown")) {
                    dataset.setGenre(tag.getFirstGenre());
                }
                if (dataset.getOrigArtist().equals("") || dataset.getOrigArtist().length() < this.getFirst(tag, "TOPE").length()) {
                    dataset.setOrigArtist(this.getFirst(tag, "TOPE"));
                }
                if (dataset.getTitle().equals("") || dataset.getTitle().length() < tag.getFirstTitle().length()) {
                    dataset.setTitle(tag.getFirstTitle());
                }
                if (dataset.getTrack().equals("") || dataset.getTrack().equals("0")) {
                    dataset.setTrack(tag.getFirstTrack());
                }
                if (dataset.getUrl().equals("") || dataset.getUrl().length() < this.getFirst(tag, "WXXX").length()) {
                    dataset.setUrl(this.getFirst(tag, "WXXX"));
                }
                if (dataset.getYear().equals("") || dataset.getYear().length() < this.getFirst(tag, "TYER").length()) {
                    dataset.setYear(this.getFirst(tag, "TYER"));
                }
                if (dataset.getYear().length() == 0) {
                    dataset.setYear(tag.getFirstYear());
                }
                dataset.setPartOfSet(this.getFirst(tag, "TPOS"));
                dataset.setPartOfCompilation("1".equals(this.getFirst(tag, "TCMP")));
                DataSet dataSet = dataset;
                Object var7_7 = null;
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    logger.warn("Couldn't close mp3 file", (Throwable)ioe);
                }
                return dataSet;
            }
            Object var7_8 = null;
            try {
                raf.close();
            }
            catch (IOException ioe) {
                logger.warn("Couldn't close mp3 file", (Throwable)ioe);
            }
            break block24;
            {
                catch (Exception e) {
                    logger.debug("Couldn't read version 2 tag", (Throwable)e);
                    Object var7_9 = null;
                    try {
                        raf.close();
                    }
                    catch (IOException ioe) {
                        logger.warn("Couldn't close mp3 file", (Throwable)ioe);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    logger.warn("Couldn't close mp3 file", (Throwable)ioe);
                }
                throw throwable;
            }
        }
        return dataset;
    }

    public void setMetaData(MyFile file, DataSet dataset) throws Exception {
        boolean meta = true;
        int tagtype = Integer.parseInt(props.getProperty("tagtype"));
        if (tagtype == 1) {
            meta = this.setV1Tag((File)file, dataset);
            if (!meta) {
                throw new Exception("Couldn't write ID3V1 tag");
            }
        } else if (tagtype == 2) {
            meta = this.setV2Tag((File)file, dataset);
            if (!meta) {
                throw new Exception("Couldn't write ID3V2 tag");
            }
        } else if (tagtype == 3) {
            meta = this.setV1Tag((File)file, dataset);
            if (!meta) {
                throw new Exception("Couldn't write ID3V1 tag");
            }
            meta = this.setV2Tag((File)file, dataset);
            if (!meta) {
                throw new Exception("Couldn't write ID3V2 tag");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setV1Tag(File file, DataSet dataset) {
        boolean bl;
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                Id3v1Tag tag = new Id3v1Tag();
                tag.setTitle(dataset.getTitle());
                tag.setTrack(dataset.getTrack());
                tag.setArtist(dataset.getArtist());
                tag.setAlbum(dataset.getAlbum());
                tag.setGenre(dataset.getGenre());
                tag.setComment(dataset.getComment());
                tag.setYear(dataset.getYear());
                new Id3v1TagWriter().write((Tag)tag, raf);
                bl = true;
                Object var7_8 = null;
            }
            catch (Exception e) {
                logger.warn("Couldn't write ID3V1 tag", (Throwable)e);
                boolean bl2 = false;
                Object var7_9 = null;
                try {
                    raf.close();
                    return bl2;
                }
                catch (IOException ioe) {
                    logger.warn("Couldn't close file", (Throwable)ioe);
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException ioe) {
                logger.warn("Couldn't close file", (Throwable)ioe);
                throw throwable;
            }
            raf.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            logger.warn("Couldn't close file", (Throwable)ioe);
            return bl;
        }
        raf.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setV2Tag(File file, DataSet dataset) {
        boolean bl;
        RandomAccessFile raf = null;
        RandomAccessFile tempRaf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                Id3v2Tag tag = new Id3v2Tag();
                tag.setTitle(dataset.getTitle());
                tag.setTrack(dataset.getTrack());
                tag.setArtist(dataset.getArtist());
                tag.setAlbum(dataset.getAlbum());
                tag.setComment(dataset.getComment());
                tag.set(this.createTextFrame("WXXX", dataset.getUrl()));
                tag.set(this.createTextFrame("TCOM", dataset.getComposer()));
                tag.set(this.createTextFrame("TCOP", dataset.getCopyright()));
                tag.set(this.createTextFrame("TENC", dataset.getEncodedBy()));
                tag.set(this.createTextFrame("TOPE", dataset.getOrigArtist()));
                tag.setYear(dataset.getYear());
                tag.set(this.createTextFrame("TYER", dataset.getYear()));
                tag.setGenre(dataset.getGenre());
                tag.set(this.createTextFrame("TCMP", dataset.isPartOfCompilation() ? "1" : "0"));
                tag.set(this.createTextFrame("TPOS", dataset.getPartOfSet()));
                File tempFile = File.createTempFile("jmp3renamer_mp3", "tmp");
                tempRaf = new RandomAccessFile(tempFile, "rw");
                new Id3v2TagWriter().write((Tag)tag, raf, tempRaf);
                bl = true;
                Object var9_10 = null;
            }
            catch (Exception e) {
                logger.warn("Couldn't write ID3V2 tag", (Throwable)e);
                boolean bl2 = false;
                Object var9_11 = null;
                try {
                    raf.close();
                    tempRaf.close();
                    return bl2;
                }
                catch (IOException ioe) {
                    logger.warn("Couldn't close file", (Throwable)ioe);
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {}
            catch (IOException ioe) {
                logger.warn("Couldn't close file", (Throwable)ioe);
                throw throwable;
            }
            raf.close();
            tempRaf.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            logger.warn("Couldn't close file", (Throwable)ioe);
            return bl;
        }
        raf.close();
        tempRaf.close();
        return bl;
    }

    public ExtendedFileFilter getFileFilter() {
        return this.filter;
    }

    public String toString() {
        return this.getName();
    }

    public void coreStarted() {
    }

    private String getFirst(Id3v2Tag tag, String ID) {
        List frames = tag.get(ID);
        if (frames.size() > 0) {
            return frames.get(0).toString();
        }
        return "";
    }

    private TagField createTextFrame(String id, String content) {
        TextId3Frame tag = new TextId3Frame(id, content);
        tag.setEncoding("UTF-8");
        return tag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

