/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.util;

import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.ImageLoader;
import net.sf.jmp3renamer.gui.AnimatedIcon;
import net.sf.jmp3renamer.gui.SplitPanel;

public class MyFile
extends File {
    private ImageIcon icon = ImageLoader.getInstance().loadImage("images/untouched.gif");
    private String tooltip = null;
    private AnimatedIcon animation;

    public MyFile(File file) {
        super(file.getAbsolutePath());
        if (!file.canWrite()) {
            this.setLocked();
        }
        this.animation = AnimatedIcon.getInstance(ImageLoader.getInstance().loadImage("images/untouched.gif").getImage(), new Image[]{ImageLoader.getInstance().loadImage("images/Active1.png").getImage(), ImageLoader.getInstance().loadImage("images/Active2.png").getImage(), ImageLoader.getInstance().loadImage("images/Active3.png").getImage(), ImageLoader.getInstance().loadImage("images/Active4.png").getImage()}, 10, SplitPanel.dirtable);
    }

    public String toString() {
        return this.getName();
    }

    public String getSuffix() {
        String path = this.getAbsolutePath();
        int start = path.lastIndexOf(".");
        if (start < 0) {
            return null;
        }
        return path.substring(start + 1, path.length());
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public void setRenaming() {
        this.icon = this.animation;
    }

    public void setLocked() {
        this.icon = ImageLoader.getInstance().loadImage("images/locked.png");
        this.tooltip = I18N.translate("readonly");
    }

    public void setFailed() {
        this.icon = ImageLoader.getInstance().loadImage("images/error.png");
        this.tooltip = I18N.translate("rename_failed");
    }

    public void setMetaFailed() {
        this.icon = ImageLoader.getInstance().loadImage("images/error_meta.png");
        this.tooltip = I18N.translate("meta_failed");
    }

    public void setOK() {
        this.icon = ImageLoader.getInstance().loadImage("images/ok.png");
        this.tooltip = I18N.translate("rename_ok");
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public int compareTo(File file) {
        if (file instanceof MyFile) {
            MyFile f = (MyFile)file;
            return f.getAbsolutePath().compareTo(this.getAbsolutePath());
        }
        return -1;
    }
}

