/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;

class LoggingPanel
extends JPanel
implements ActionListener {
    private JComboBox levelCombo = new JComboBox();
    private JLabel lLevel = new JLabel(I18N.translate("log_level"));
    private JTextField tLogFile = new JTextField();
    private JButton bFile = new JButton(I18N.translate("file"));
    private JCheckBox cbToFile = new JCheckBox(I18N.translate("log_to_file"));

    protected LoggingPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(I18N.translate("logging")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lLevel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.levelCombo, gbc);
        this.cbToFile.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.cbToFile, gbc);
        gbc.gridwidth = 1;
        this.tLogFile.setEnabled(false);
        Dimension d = this.tLogFile.getPreferredSize();
        d.setSize(150.0, d.getHeight());
        this.tLogFile.setPreferredSize(d);
        gbc.gridx = 2;
        gbc.fill = 2;
        this.add((Component)this.tLogFile, gbc);
        gbc.fill = 0;
        this.bFile.setEnabled(false);
        this.bFile.addActionListener(this);
        gbc.gridx = 3;
        this.add((Component)this.bFile, gbc);
        if (!Main.getProperty("logfile").equals("")) {
            this.cbToFile.setSelected(true);
            File file = new File(Main.getProperty("logfile"));
            this.tLogFile.setText(file.toString());
            this.tLogFile.setEnabled(true);
            this.bFile.setEnabled(true);
        }
        this.levelCombo.addItem(Level.OFF);
        this.levelCombo.addItem(Level.FINE);
        this.levelCombo.addItem(Level.INFO);
        this.levelCombo.addItem(Level.WARNING);
        this.levelCombo.addItem(Level.SEVERE);
        Level level = Level.parse(Main.getProperty("logging"));
        this.levelCombo.setSelectedItem(level);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc;
        int returnVal;
        if (e.getSource() == this.cbToFile) {
            this.bFile.setEnabled(this.cbToFile.isSelected());
            this.tLogFile.setEnabled(this.cbToFile.isSelected());
        } else if (e.getSource() == this.bFile && (returnVal = (fc = new JFileChooser()).showOpenDialog(Main.getGUI())) == 0) {
            File file = fc.getSelectedFile();
            this.tLogFile.setText(file.toString());
        }
    }

    public void applyConfig() {
        Main.setProperty("logging", this.levelCombo.getSelectedItem().toString());
        if (this.cbToFile.isSelected()) {
            Main.setProperty("logfile", this.tLogFile.getText());
        } else {
            Main.setProperty("logfile", "");
        }
    }
}

