/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui.components.historycombobox;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JComboBox;
import net.sf.jmp3renamer.gui.components.historycombobox.ComboBoxHistory;

public class JHistoryComboBox
extends JComboBox
implements ActionListener {
    private ComboBoxHistory history;
    private Properties properties;
    private String propertyName;

    public JHistoryComboBox(Properties properties, String propertyName) {
        this.properties = properties;
        this.propertyName = propertyName;
        this.history = new ComboBoxHistory(10);
        this.setModel(this.history);
        this.getEditor().addActionListener(this);
        this.setEditable(true);
        this.loadHistory();
    }

    private void loadHistory() {
        String historyString = this.properties.getProperty(this.propertyName);
        if (historyString != null) {
            String[] s = historyString.split("\u00a7\u00a7\u00a7");
            for (int i = s.length - 1; i >= 0; --i) {
                this.addItem(s[i]);
            }
        }
    }

    private void storeHistory() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.history.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            sb.append(element);
            if (!iter.hasNext()) continue;
            sb.append("\u00a7\u00a7\u00a7");
        }
        this.properties.setProperty(this.propertyName, sb.toString());
    }

    public void actionPerformed(ActionEvent e) {
        this.addCurrentItemToHistory();
    }

    public void addCurrentItemToHistory() {
        String regex = (String)this.getEditor().getItem();
        this.history.addElement(regex);
        this.storeHistory();
    }
}

