/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalFlowLayout
implements LayoutManager {
    private int vgap = 0;
    private int hgap = 0;

    public VerticalFlowLayout() {
        this(0);
    }

    public VerticalFlowLayout(int vgap) {
        this(vgap, 0);
    }

    public VerticalFlowLayout(int vgap, int hgap) {
        this.vgap = vgap > 0 ? vgap : 0;
        this.hgap = hgap > 0 ? hgap : 0;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int w = parent.getSize().width - insets.left - insets.right - this.vgap * 2;
        int numComponents = parent.getComponentCount();
        if (numComponents == 0) {
            return;
        }
        int y = insets.top;
        int x = insets.left + this.hgap;
        for (int i = 0; i < numComponents; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension d = c.getPreferredSize();
            c.setBounds(x, y, w, d.height);
            y += d.height + this.vgap;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int maxWidth = 0;
        int totalHeight = 0;
        int numComponents = parent.getComponentCount();
        for (int i = 0; i < numComponents; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension cd = c.getMinimumSize();
            maxWidth = Math.max(maxWidth, cd.width);
            totalHeight += cd.height;
        }
        Dimension td = new Dimension(maxWidth + insets.left + insets.right + this.hgap * 2, totalHeight + insets.top + insets.bottom + this.vgap * numComponents);
        return td;
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int maxWidth = 0;
        int totalHeight = 0;
        int numComponents = parent.getComponentCount();
        for (int i = 0; i < numComponents; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension cd = c.getPreferredSize();
            maxWidth = Math.max(maxWidth, cd.width);
            totalHeight += cd.height;
        }
        Dimension td = new Dimension(maxWidth + insets.left + insets.right + this.hgap * 2, totalHeight + insets.top + insets.bottom + this.vgap * numComponents);
        return td;
    }

    public void removeLayoutComponent(Component comp) {
    }
}

