/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import com.jgoodies.plaf.plastic.PlasticLookAndFeel;
import com.jgoodies.plaf.plastic.PlasticTheme;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.ImageLoader;
import net.sf.jmp3renamer.Plugin;
import net.sf.jmp3renamer.PluginLoader;
import net.sf.jmp3renamer.gui.MainGUI;
import net.sf.jmp3renamer.gui.SplashScreen;
import net.sf.jmp3renamer.logging.DebugConsoleHandler;
import net.sf.jmp3renamer.logging.ErrorPopupHandler;
import net.sf.jmp3renamer.logging.SimpleFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final String VERSION = "2.2.1";
    private final String PLUGINMANAGER_URL = "http://jmp3renamer.sf.net/pluginmanager/2_2/";
    public static final String CONFIG_DIR = System.getProperty("user.home") + File.separator + ".jmp3renamer";
    public static final String CONFIG_FILE = CONFIG_DIR + File.separator + "jmp3renamer.props";
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$Main == null ? (class$net$sf$jmp3renamer$Main = Main.class$("net.sf.jmp3renamer.Main")) : class$net$sf$jmp3renamer$Main);
    private SplashScreen splash;
    private static Properties lang = new Properties();
    private static ArrayList supportedLanguages = new ArrayList();
    private static Properties props = new Properties();
    DebugConsoleHandler debugConsoleHandler;
    ErrorPopupHandler errorPopupHandler;
    FileHandler fileHandler;
    private static MainGUI mainGUI;
    static /* synthetic */ Class class$net$sf$jmp3renamer$Main;

    Main(String[] args) {
        ImageIcon icon = ImageLoader.getInstance().loadImage("images/about_background.jpg");
        this.splash = new SplashScreen(icon);
        if (args.length > 0 && "-nosplash".equalsIgnoreCase(args[0])) {
            this.splash.setVisible(false);
        }
        this.splash.setStatus("Loading config...");
        this.loadConfig();
        this.splash.setStatus("Initializing logging...");
        this.initLogger();
        this.splash.setStatus("Loading language...");
        this.loadLanguage();
        this.splash.setStatus(I18N.translate("splash.laf"));
        Main.setLookAndFeel();
        this.splash.setStatus(I18N.translate("splash.gui"));
        this.initGUI();
        this.splash.setStatus(I18N.translate("splash.plugins"));
        this.loadPlugIns();
        this.splash.setStatus(I18N.translate("splash.ready"));
        this.splash.dispose();
        mainGUI.setVisible(true);
        Iterator iter = PluginLoader.getInstance().getPlugins().iterator();
        while (iter.hasNext()) {
            Plugin element = (Plugin)iter.next();
            element.coreStarted();
        }
        for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            if (!file.exists()) continue;
            FileManager.getInstance().addFile(file);
            Main.setProperty("last", file.getParent());
        }
    }

    public static void setLookAndFeel() {
        String laf = Main.getProperty("laf");
        String theme = Main.getProperty("theme");
        try {
            if (laf.equals("com.jgoodies.plaf.plastic.PlasticLookAndFeel")) {
                Class<?> c = Class.forName("com.jgoodies.plaf.plastic.theme." + theme);
                PlasticTheme ptheme = (PlasticTheme)c.newInstance();
                PlasticLookAndFeel.setMyCurrentTheme(ptheme);
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticLookAndFeel");
            } else if (laf.equals("com.jgoodies.plaf.plastic.Plastic3DLookAndFeel")) {
                Class<?> c = Class.forName("com.jgoodies.plaf.plastic.theme." + theme);
                PlasticTheme ptheme = (PlasticTheme)c.newInstance();
                PlasticLookAndFeel.setMyCurrentTheme(ptheme);
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            } else if (laf.equals("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel")) {
                Class<?> c = Class.forName("com.jgoodies.plaf.plastic.theme." + theme);
                PlasticTheme ptheme = (PlasticTheme)c.newInstance();
                PlasticLookAndFeel.setMyCurrentTheme(ptheme);
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
            } else {
                Class<?> c = Class.forName(laf);
                LookAndFeel LAF = (LookAndFeel)c.newInstance();
                UIManager.setLookAndFeel(LAF);
            }
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.laf"), e);
        }
    }

    public void exit() {
        logger.info("Exitting...");
        if (Boolean.valueOf(props.getProperty("save_on_exit")).booleanValue()) {
            logger.info("Saving config...");
            props.setProperty("extendedState", new Integer(mainGUI.getExtendedState()).toString());
            double width = mainGUI.getSize().getWidth();
            double height = mainGUI.getSize().getHeight();
            props.setProperty("width", new Double(width).toString());
            props.setProperty("height", new Double(height).toString());
            double x = mainGUI.getLocation().getX();
            double y = mainGUI.getLocation().getY();
            props.setProperty("x", new Double(x).toString());
            props.setProperty("y", new Double(y).toString());
            this.saveConfig();
        }
        logger.info("\n\nBye bye");
        System.exit(0);
    }

    private void loadConfig() {
        String version;
        props.setProperty("filename", "%artist - %track - %title");
        props.setProperty("filenameCompilation", "Various Artists - %track - %artist - %title");
        props.setProperty("logging", "2");
        props.setProperty("logfile", "");
        props.setProperty("last", System.getProperty("user.home"));
        props.setProperty("save_on_exit", "true");
        props.setProperty("extendedState", "0");
        props.setProperty("width", "800");
        props.setProperty("height", "600");
        props.setProperty("x", "0");
        props.setProperty("y", "0");
        props.setProperty("pluginmanager.url", "http://jmp3renamer.sf.net/pluginmanager/2_2/");
        props.setProperty("leading_0s", "1");
        props.setProperty("words", "1");
        props.setProperty("directory", "");
        props.setProperty("directoryCompilation", "");
        props.setProperty("version", "");
        props.setProperty("proxyHost", "");
        props.setProperty("proxyPort", "");
        props.setProperty("proxyAuth", "");
        props.setProperty("http.proxyUser", "");
        props.setProperty("http.proxyPassword", "");
        props.setProperty("laf", "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
        props.setProperty("theme", "SkyBlue");
        props.setProperty("supportedLanguages", "en,de,es,fr");
        try {
            File conffile;
            File confdir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer");
            if (!confdir.exists()) {
                confdir.mkdir();
            }
            if (!(conffile = new File(CONFIG_FILE)).exists()) {
                conffile.createNewFile();
            }
            FileInputStream fin = new FileInputStream(CONFIG_FILE);
            props.load(fin);
        }
        catch (Exception e) {
            System.err.println("Couldn't load settings: " + e);
        }
        String sl = props.getProperty("supportedLanguages");
        String[] langs = sl.split(",");
        for (int i = 0; i < langs.length; ++i) {
            supportedLanguages.add(langs[i]);
        }
        String host = props.getProperty("proxyHost");
        if (!host.equals("")) {
            logger.info("Setting proxy server: " + props.getProperty("proxyHost") + ":" + props.getProperty("proxyPort"));
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", host);
            System.setProperty("proxyPort", props.getProperty("proxyPort"));
            if (props.getProperty("proxyAuth").equals("true")) {
                System.setProperty("http.proxyUser", props.getProperty("http.proxyUser"));
                System.setProperty("http.proxyPassword", props.getProperty("http.proxyPassword"));
            }
        }
        if (!(version = props.getProperty("version")).equals(VERSION)) {
            props.setProperty("version", VERSION);
            String url = props.getProperty("pluginmanager.url");
            if (!url.equals(this.PLUGINMANAGER_URL)) {
                this.splash.setVisible(false);
                int result = JOptionPane.showConfirmDialog(null, "<html>Your are running a new version the first time and the internal address of the plugin<br>repository differs from the one in your config file. This may happen, if you have<br>changed the address manually, or if this version of JMP3Renamer needs to access<br>a new repository due to some changes in the plugin management.<br><br>Do you want to use the new setting ?<br>( " + this.PLUGINMANAGER_URL + " )</html>", "New Version", 0);
                this.splash.setVisible(true);
                if (result == 0) {
                    props.setProperty("pluginmanager.url", this.PLUGINMANAGER_URL);
                }
            }
        }
    }

    public void saveConfig() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = supportedLanguages.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            sb.append(element);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        props.setProperty("supportedLanguages", sb.toString());
        try {
            FileOutputStream fout = new FileOutputStream(CONFIG_FILE);
            props.store(fout, "JMP3Renamer Properties");
            logger.info("Settings saved");
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.save_config"), e);
        }
        Enumeration enumeration = PluginLoader.getInstance().getPlugins().elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            plugin.saveConfig();
        }
    }

    private void loadLanguage() {
        String language;
        Properties english;
        block8: {
            logger.info("Loading language file");
            english = new Properties();
            try {
                Main.loadLanguageFromJar(english, Locale.ENGLISH.getLanguage());
            }
            catch (IOException e1) {
                logger.error(I18N.translate("error.load_language", new String[]{Locale.ENGLISH.getLanguage()}), e1);
                System.exit(1);
            }
            language = props.getProperty("lang");
            if (language == null) {
                language = Locale.getDefault().getLanguage();
            }
            if (!supportedLanguages.contains(language)) {
                logger.error(I18N.translate("error.lang_not_supported"));
                language = "en";
            }
            boolean notInJar = false;
            try {
                Main.loadLanguageFromJar(lang, language);
            }
            catch (Exception e) {
                notInJar = true;
                logger.warn("Couldn't load language from jar for JMP3Renamer", e);
            }
            try {
                Main.loadlLanguageFromFile(lang, language);
            }
            catch (IOException e) {
                logger.warn("Couldn't load language from file for JMP3Renamer", e);
                if (!notInJar) break block8;
                language = "en";
                logger.warn("Falling back to default language (en)");
            }
        }
        props.setProperty("lang", language);
        I18N.registerLanguageTable(lang, language);
        I18N.registerLanguageTable(english, "en");
    }

    public void initLogger() {
        String f;
        java.util.logging.Logger root = java.util.logging.Logger.getLogger("");
        root.setLevel(Level.FINEST);
        if (this.debugConsoleHandler == null) {
            this.debugConsoleHandler = new DebugConsoleHandler();
            root.addHandler(this.debugConsoleHandler);
        }
        if (this.errorPopupHandler == null) {
            this.errorPopupHandler = new ErrorPopupHandler();
            root.addHandler(this.errorPopupHandler);
        }
        if (!(f = props.getProperty("logfile")).equals("")) {
            File file = new File(f);
            try {
                boolean success;
                if (!file.exists() && !(success = file.createNewFile())) {
                    throw new Exception();
                }
                if (this.fileHandler == null) {
                    this.fileHandler = new FileHandler(file.getAbsolutePath());
                    this.fileHandler.setLevel(Level.ALL);
                    root.addHandler(this.fileHandler);
                }
            }
            catch (Exception e) {
                logger.error(I18N.translate("error.create_log"), e);
            }
        } else if (this.fileHandler != null) {
            root.removeHandler(this.fileHandler);
            this.fileHandler.flush();
            this.fileHandler.close();
            this.fileHandler = null;
        }
        SimpleFormatter formatter = new SimpleFormatter();
        Handler[] rootHandlers = root.getHandlers();
        for (int i = 0; i < rootHandlers.length; ++i) {
            Handler h = rootHandlers[i];
            h.setFormatter(formatter);
        }
        Level level = Level.parse(props.getProperty("logging"));
        for (int i = 0; i < rootHandlers.length; ++i) {
            Handler h = rootHandlers[i];
            if (h instanceof FileHandler) continue;
            h.setLevel(level);
        }
        java.util.logging.Logger.getLogger("java.awt").setLevel(Level.SEVERE);
        java.util.logging.Logger.getLogger("sun").setLevel(Level.SEVERE);
        java.util.logging.Logger.getLogger("javax.swing").setLevel(Level.SEVERE);
    }

    private void initGUI() {
        logger.info("Initializing GUI");
        mainGUI = new MainGUI(this);
    }

    private void loadPlugIns() {
        logger.info("Loading PlugIns");
        PluginLoader pluginLoader = PluginLoader.getInstance();
        File[] plugDirs = pluginLoader.getPluginDirs();
        for (int i = 0; i < plugDirs.length; ++i) {
            logger.info("Searching for plugins in: " + plugDirs[i]);
            Object[] plugs = plugDirs[i].listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.getAbsolutePath().endsWith(".jar");
                }
            });
            if (plugs == null || plugs.length <= 0) continue;
            Arrays.sort(plugs);
            for (int j = 0; j < plugs.length; ++j) {
                Object f = plugs[j];
                pluginLoader.loadPlugin((File)f);
            }
        }
        if (PluginLoader.getInstance().getPlugins().size() == 0) {
            logger.info("No plugins found :-(");
            logger.error(I18N.translate("error.no_plugins"));
        }
    }

    public static ArrayList getSupportedLanguages() {
        return supportedLanguages;
    }

    public static void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static MainGUI getGUI() {
        return mainGUI;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            logger.info("Command line argument: " + args[i]);
        }
        new Main(args);
    }

    public static Properties getLanguageTable(String locale) throws IOException {
        Properties lang = new Properties();
        Main.loadLanguageFromJar(lang, locale);
        Main.loadlLanguageFromFile(lang, locale);
        return lang;
    }

    public static void loadLanguageFromJar(Properties lang, String locale) throws IOException {
        logger.debug("Trying to load language file from jar for JMP3Renamer for locale " + locale);
        lang.load((class$net$sf$jmp3renamer$Main == null ? (class$net$sf$jmp3renamer$Main = Main.class$("net.sf.jmp3renamer.Main")) : class$net$sf$jmp3renamer$Main).getResourceAsStream("lang/jmp3renamer_" + locale + ".properties"));
    }

    public static void loadlLanguageFromFile(Properties lang, String locale) throws IOException {
        String name;
        String dirString = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "lang";
        File file = new File(dirString, name = "jmp3renamer_" + locale + ".properties");
        if (file.exists()) {
            logger.debug("Trying to load language file from file for JMP3Renamer for locale " + locale);
            FileInputStream fis = new FileInputStream(file);
            lang.load(fis);
        }
    }

    public static Properties getProperties() {
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

