/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarClassLoader
extends ClassLoader {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$JarClassLoader == null ? (class$net$sf$jmp3renamer$JarClassLoader = JarClassLoader.class$("net.sf.jmp3renamer.JarClassLoader")) : class$net$sf$jmp3renamer$JarClassLoader);
    private JarFile jar;
    private Hashtable cache = new Hashtable();
    static /* synthetic */ Class class$net$sf$jmp3renamer$JarClassLoader;

    public JarClassLoader(String jar) throws IOException {
        this(new File(jar));
    }

    public JarClassLoader(File jar) throws IOException {
        this.jar = new JarFile(jar);
    }

    public void closeJarFile() throws IOException {
        this.jar.close();
    }

    protected Class findClass(String clazz) throws ClassNotFoundException {
        Class<?> c = null;
        c = (Class<?>)this.cache.get(clazz);
        if (c == null) {
            c = this.loadClassFromJar(clazz);
        }
        if (c == null) {
            c = this.findSystemClass(clazz);
        }
        if (c == null) {
            throw new ClassNotFoundException();
        }
        return c;
    }

    private Class loadClassFromJar(String clazz) {
        Class<?> cls = null;
        String name = this.classToFile(clazz);
        try {
            ZipEntry entry = this.jar.getEntry(name);
            if (entry == null) {
                return null;
            }
            InputStream in = this.jar.getInputStream(entry);
            int len = (int)entry.getSize();
            byte[] data = new byte[len];
            int success = 0;
            int offset = 0;
            while (success < len) {
                if ((success = in.read(data, offset += success, len -= success)) != -1) continue;
                return null;
            }
            cls = this.defineClass(clazz, data, 0, data.length);
            return cls;
        }
        catch (IOException io) {
            logger.debug("IOException", io);
            return null;
        }
    }

    public InputStream getResourceAsStream(String resource) {
        try {
            ZipEntry entry = this.jar.getEntry(resource);
            if (entry == null) {
                return null;
            }
            InputStream in = this.jar.getInputStream(entry);
            return in;
        }
        catch (IOException io) {
            logger.debug("IOException", io);
            return null;
        }
    }

    private String classToFile(String name) {
        return name.replace('.', '/').concat(".class");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

