/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.util.StringUtils;

public class I18N {
    private static Properties languageTable = new Properties();

    public static String translate(String key) {
        Throwable t = new Throwable();
        String className = t.getStackTrace()[1].getClassName();
        return I18N._translate(className, key);
    }

    public static String translate(String key, Object[] params) {
        Throwable t = new Throwable();
        String className = t.getStackTrace()[1].getClassName();
        return I18N.format(I18N._translate(className, key), params);
    }

    public static String translate(String key, String param) {
        Throwable t = new Throwable();
        String className = t.getStackTrace()[1].getClassName();
        return I18N.format(I18N._translate(className, key), new String[]{param});
    }

    private static String _translate(String className, String key) {
        String k;
        String value;
        String language = Main.getProperty("lang");
        if (language == null) {
            language = Locale.getDefault().getLanguage();
        }
        if (StringUtils.isEmpty(value = languageTable.getProperty(k = className + "." + key + "." + language))) {
            k = className + "." + key + "." + "en";
            value = languageTable.getProperty(k);
        }
        return value;
    }

    private static String format(String msg, Object[] params) {
        MessageFormat format = new MessageFormat("");
        format.applyPattern(msg);
        return format.format(params);
    }

    public static void registerLanguageTable(Properties lang, String locale) {
        Iterator<Object> it = lang.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String localKey = key + "." + locale;
            languageTable.setProperty(localKey, lang.getProperty(key));
        }
    }
}

