/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg;

import entagged.audioformats.generic.AbstractTag;
import entagged.audioformats.generic.TagField;
import entagged.audioformats.ogg.util.OggTagField;

public class OggTag
extends AbstractTag {
    private String vendor = "";
    public static final String DEFAULT_VENDOR = "Entagged - The Musical Box";

    protected TagField createAlbumField(String string) {
        return new OggTagField("ALBUM", string);
    }

    protected TagField createArtistField(String string) {
        return new OggTagField("ARTIST", string);
    }

    protected TagField createCommentField(String string) {
        return new OggTagField("DESCRIPTION", string);
    }

    protected TagField createGenreField(String string) {
        return new OggTagField("GENRE", string);
    }

    protected TagField createTitleField(String string) {
        return new OggTagField("TITLE", string);
    }

    protected TagField createTrackField(String string) {
        return new OggTagField("TRACKNUMBER", string);
    }

    protected TagField createYearField(String string) {
        return new OggTagField("DATE", string);
    }

    protected String getAlbumId() {
        return "ALBUM";
    }

    protected String getArtistId() {
        return "ARTIST";
    }

    protected String getCommentId() {
        return "DESCRIPTION";
    }

    protected String getGenreId() {
        return "GENRE";
    }

    protected String getTitleId() {
        return "TITLE";
    }

    protected String getTrackId() {
        return "TRACKNUMBER";
    }

    public String getVendor() {
        if (!this.vendor.trim().equals("")) {
            return this.vendor;
        }
        return DEFAULT_VENDOR;
    }

    protected String getYearId() {
        return "DATE";
    }

    public void setVendor(String string) {
        if (string == null) {
            this.vendor = "";
            return;
        }
        this.vendor = string;
    }

    protected boolean isAllowedEncoding(String string) {
        return string.equals("UTF-8");
    }

    public String toString() {
        return "OGG " + super.toString();
    }
}

