/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mpc.util;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.mpc.util.MpcHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MpcInfoReader {
    public EncodingInfo read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        EncodingInfo encodingInfo = new EncodingInfo();
        if (randomAccessFile.length() == 0L) {
            System.err.println("Error: File empty");
            throw new CannotReadException("File is empty");
        }
        randomAccessFile.seek(0L);
        byte[] byArray = new byte[3];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        if (!string.equals("MP+") && string.equals("ID3")) {
            randomAccessFile.seek(6L);
            int n = this.read_syncsafe_integer(randomAccessFile);
            randomAccessFile.seek(n + 10);
            byArray = new byte[3];
            randomAccessFile.read(byArray);
            string = new String(byArray);
            if (!string.equals("MP+")) {
                throw new CannotReadException("MP+ Header not found");
            }
        } else if (!string.equals("MP+")) {
            throw new CannotReadException("MP+ Header not found");
        }
        byArray = new byte[25];
        randomAccessFile.read(byArray);
        MpcHeader mpcHeader = new MpcHeader(byArray);
        double d = mpcHeader.getSamplesNumber();
        encodingInfo.setPreciseLength((float)(d * 1152.0 / (double)mpcHeader.getSamplingRate()));
        encodingInfo.setChannelNumber(mpcHeader.getChannelNumber());
        encodingInfo.setSamplingRate(mpcHeader.getSamplingRate());
        encodingInfo.setEncodingType(mpcHeader.getEncodingType());
        encodingInfo.setExtraEncodingInfos(mpcHeader.getEncoderInfo());
        encodingInfo.setBitrate(this.computeBitrate(encodingInfo.getLength(), randomAccessFile.length()));
        return encodingInfo;
    }

    private int read_syncsafe_integer(RandomAccessFile randomAccessFile) throws IOException {
        int n = 0;
        n += (randomAccessFile.read() & 0xFF) << 21;
        n += (randomAccessFile.read() & 0xFF) << 14;
        n += (randomAccessFile.read() & 0xFF) << 7;
        return n += randomAccessFile.read() & 0xFF;
    }

    private int computeBitrate(int n, long l) {
        return (int)(l / 1000L * 8L / (long)n);
    }
}

