/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp4.util;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;
import entagged.audioformats.generic.Utils;
import entagged.audioformats.mp4.util.Mp4TagField;
import java.io.UnsupportedEncodingException;

public class Mp4TagTextField
extends Mp4TagField
implements TagTextField {
    protected String content;

    public Mp4TagTextField(String string, byte[] byArray) throws UnsupportedEncodingException {
        super(string, byArray);
    }

    public Mp4TagTextField(String string, String string2) {
        super(string);
        this.content = string2;
    }

    protected void build(byte[] byArray) throws UnsupportedEncodingException {
        int n = Utils.getNumberBigEndian(byArray, 0, 3);
        this.content = Utils.getString(byArray, 16, n - 8 - 8, this.getEncoding());
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof Mp4TagTextField) {
            this.content = ((Mp4TagTextField)tagField).getContent();
        }
    }

    public String getContent() {
        return this.content;
    }

    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.content.getBytes(this.getEncoding());
    }

    public String getEncoding() {
        return "ISO-8859-1";
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] byArray = this.getDataBytes();
        byte[] byArray2 = new byte[24 + byArray.length];
        int n = 0;
        Utils.copy(Utils.getSizeBigEndian(byArray2.length), byArray2, n);
        Utils.copy(Utils.getDefaultBytes(this.getId()), byArray2, n += 4);
        Utils.copy(Utils.getSizeBigEndian(16 + byArray.length), byArray2, n += 4);
        Utils.copy(Utils.getDefaultBytes("data"), byArray2, n += 4);
        Utils.copy(new byte[]{0, 0, 0, (byte)(!this.isBinary() ? 1 : 0)}, byArray2, n += 4);
        Utils.copy(new byte[]{0, 0, 0, 0}, byArray2, n += 4);
        Utils.copy(byArray, byArray2, n += 4);
        n += byArray.length;
        return byArray2;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isEmpty() {
        return this.content.trim().equals("");
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setEncoding(String string) {
    }

    public String toString() {
        return this.content;
    }
}

