/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.io;

import entagged.audioformats.asf.data.AudioStreamChunk;
import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.data.StreamChunk;
import entagged.audioformats.asf.data.VideoStreamChunk;
import entagged.audioformats.asf.util.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public class StreamChunkReader {
    protected StreamChunkReader() {
    }

    public static StreamChunk read(RandomAccessFile randomAccessFile, Chunk chunk) throws IOException {
        if (randomAccessFile == null || chunk == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_STREAM.equals(chunk.getGuid())) {
            randomAccessFile.seek(chunk.getPosition());
            return new StreamChunkReader().parseData(randomAccessFile);
        }
        return null;
    }

    private StreamChunk parseData(RandomAccessFile randomAccessFile) throws IOException {
        StreamChunk streamChunk = null;
        long l = randomAccessFile.getFilePointer();
        GUID gUID = Utils.readGUID(randomAccessFile);
        if (GUID.GUID_STREAM.equals(gUID)) {
            BigInteger bigInteger = Utils.readBig64(randomAccessFile);
            GUID gUID2 = Utils.readGUID(randomAccessFile);
            if (GUID.GUID_AUDIOSTREAM.equals(gUID2) || GUID.GUID_VIDEOSTREAM.equals(gUID2)) {
                GUID gUID3 = Utils.readGUID(randomAccessFile);
                long l2 = Utils.readUINT64(randomAccessFile);
                long l3 = Utils.readUINT32(randomAccessFile);
                long l4 = Utils.readUINT32(randomAccessFile);
                int n = Utils.readUINT16(randomAccessFile);
                int n2 = n & 0x7F;
                boolean bl = (n & 0x8000) != 0;
                randomAccessFile.skipBytes(4);
                if (GUID.GUID_AUDIOSTREAM.equals(gUID2)) {
                    AudioStreamChunk audioStreamChunk = new AudioStreamChunk(l, bigInteger);
                    streamChunk = audioStreamChunk;
                    long l5 = Utils.readUINT16(randomAccessFile);
                    long l6 = Utils.readUINT16(randomAccessFile);
                    long l7 = Utils.readUINT32(randomAccessFile);
                    long l8 = Utils.readUINT32(randomAccessFile);
                    long l9 = Utils.readUINT16(randomAccessFile);
                    int n3 = Utils.readUINT16(randomAccessFile);
                    int n4 = Utils.readUINT16(randomAccessFile);
                    byte[] byArray = new byte[n4];
                    randomAccessFile.readFully(byArray);
                    audioStreamChunk.setCompressionFormat(l5);
                    audioStreamChunk.setChannelCount(l6);
                    audioStreamChunk.setSamplingRate(l7);
                    audioStreamChunk.setAverageBytesPerSec(l8);
                    audioStreamChunk.setErrorConcealment(gUID3);
                    audioStreamChunk.setBlockAlignment(l9);
                    audioStreamChunk.setBitsPerSample(n3);
                    audioStreamChunk.setCodecData(byArray);
                } else if (GUID.GUID_VIDEOSTREAM.equals(gUID2)) {
                    VideoStreamChunk videoStreamChunk = new VideoStreamChunk(l, bigInteger);
                    streamChunk = videoStreamChunk;
                    long l10 = Utils.readUINT32(randomAccessFile);
                    long l11 = Utils.readUINT32(randomAccessFile);
                    randomAccessFile.skipBytes(1);
                    long l12 = Utils.readUINT16(randomAccessFile);
                    randomAccessFile.skipBytes(16);
                    byte[] byArray = new byte[4];
                    randomAccessFile.read(byArray);
                    videoStreamChunk.setPictureWidth(l10);
                    videoStreamChunk.setPictureHeight(l11);
                    videoStreamChunk.setCodecId(byArray);
                }
                streamChunk.setStreamNumber(n2);
                streamChunk.setStreamSpecificDataSize(l4);
                streamChunk.setTypeSpecificDataSize(l3);
                streamChunk.setTimeOffset(l2);
                streamChunk.setContentEncrypted(bl);
            }
        }
        return streamChunk;
    }
}

