/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.Tag;
import entagged.audioformats.asf.data.AsfHeader;
import entagged.audioformats.asf.io.AsfHeaderReader;
import entagged.audioformats.asf.util.TagConverter;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.generic.AudioFileReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class AsfFileReader
extends AudioFileReader {
    protected EncodingInfo getEncodingInfo(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        randomAccessFile.seek(0L);
        EncodingInfo encodingInfo = new EncodingInfo();
        try {
            AsfHeader asfHeader = AsfHeaderReader.readHeader(randomAccessFile);
            if (asfHeader == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            encodingInfo.setBitrate(asfHeader.getAudioStreamChunk().getKbps());
            encodingInfo.setChannelNumber((int)asfHeader.getAudioStreamChunk().getChannelCount());
            encodingInfo.setEncodingType("ASF (audio): " + asfHeader.getAudioStreamChunk().getCodecDescription());
            encodingInfo.setPreciseLength(asfHeader.getFileHeader().getPreciseDuration());
            encodingInfo.setSamplingRate((int)asfHeader.getAudioStreamChunk().getSamplingRate());
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CannotReadException) {
                throw (CannotReadException)exception;
            }
            throw new CannotReadException("Failed to read. Cause: " + exception.getMessage());
        }
        return encodingInfo;
    }

    protected Tag getTag(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        randomAccessFile.seek(0L);
        Tag tag = null;
        try {
            AsfHeader asfHeader = AsfHeaderReader.readHeader(randomAccessFile);
            if (asfHeader == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            tag = TagConverter.createTagOf(asfHeader);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CannotReadException) {
                throw (CannotReadException)exception;
            }
            throw new CannotReadException("Failed to read. Cause: " + exception.getMessage());
        }
        return tag;
    }
}

