/* ----------------------------------------------------------------------------
   The Kiwi Toolkit
   Copyright (C) 1998-99 Mark A. Lindner

   This file is part of Kiwi.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
   The author may be contacted at:
   
   frenzy@ix.netcom.com
   ----------------------------------------------------------------------------

   $Log: TaggedObject.java,v $
   Revision 1.2  1999/01/10 03:56:22  markl
   added GPL header & RCS tag

   ----------------------------------------------------------------------------
*/

package kiwi.util;

/** An object-id or object-tag pair. Sometimes it is useful to assign a tag
  * or numeric ID to an object for purposes of identification. Most commonly
  * the identifier is a unique integer, but in some circumstances it is more
  * appropriate to use another object as an identifier. This class allows
  * an object to be associated with either an integer or an arbitrary object.
  *
  * @author Mark Lindner
  * @author PING Software Group
  * @version 1.0 (11/98)
  */

public class TaggedObject
  {
  private Object obj;
  private Object tag = null;
  private int id = -1;

  /** Construct a new <code>TaggedObject</code> for the given user object
    * and identifier object.
    *
    * @param obj The user object.
    * @param tag The identifier object.
    */
  
  public TaggedObject(Object obj, Object tag)
    {
    this.obj = obj;
    this.tag = tag;
    }

  /** Construct a new <code>TaggedObject</code> for the given user object
    * and numerical ID.
    *
    * @param obj The user object.
    * @param id The numerical ID.
    */
  
  public TaggedObject(Object obj, int id)
    {
    this.obj = obj;
    this.id = id;
    }

  /** Get the user object.
    *
    * @return The user object.
    */
  
  public final Object getObject()
    {
    return(obj);
    }

  /** Get the numerical ID.
    *
    * @return The numerical ID, or -1 if there is no numerical ID for this
    * object.
    */
  
  public final int getID()
    {
    return(id);
    }

  /** Get the identifier object.
    *
    * @return The identifier object, or <b>null</b> if there is no identifier
    * object for this object.
    */
  
  public final Object getTag()
    {
    return(tag);
    }
  }
