/* ----------------------------------------------------------------------------
   The Kiwi Toolkit
   Copyright (C) 1998-99 Mark A. Lindner

   This file is part of Kiwi.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
   The author may be contacted at:
   
   frenzy@ix.netcom.com
   ----------------------------------------------------------------------------

   $Log: HashCodeComparator.java,v $
   Revision 1.1  1999/06/08 06:45:41  markl
   Initial revision


   ----------------------------------------------------------------------------
*/

package kiwi.util;

/** A hash code comparator. This class compares the hash codes of two objects.
 *
 * @author Mark Lindner
 * @author PING Software Group
 * @version 1.0 (6/99)
 */

public class HashCodeComparator implements Comparator
  {

  /** Construct a new <code>HashCodeComparator</code>.
   */
  
  public HashCodeComparator()
    {
    }
  
  /** Compare the hash codes of two objects. A
   * <code>hashCode()</code> is performed on both objects, and then the
   * resulting integers are compared.
   *
   * @param a The first object.
   * @param b The second object.
   * @return 0 if the objects are equal, -1 if <tt>a</tt> is less than
   * <tt>b</tt>, and 1 if <tt>a</tt> is greater than <tt>b</tt>.
   */

  public int compare(Object a, Object b)
    {
    int ha = a.hashCode(), hb = b.hashCode();

    return((ha == hb) ? 0 : ((ha > hb) ? 1 : -1));
    }
  }
