/* ----------------------------------------------------------------------------
   The Kiwi Toolkit
   Copyright (C) 1998-99 Mark A. Lindner

   This file is part of Kiwi.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
   The author may be contacted at:
   
   frenzy@ix.netcom.com
   ----------------------------------------------------------------------------

   $Log: DoubleHolder.java,v $
   Revision 1.5  1999/07/25 13:39:39  markl
   Added a constructor that accepts a subtype.

   Revision 1.4  1999/07/16 07:12:36  markl
   Modified to subclass HolderObject.

   Revision 1.3  1999/02/09 05:02:56  markl
   added toString() method

   Revision 1.2  1999/01/10 03:47:05  markl
   added GPL header & RCS tag

   ----------------------------------------------------------------------------
*/

package kiwi.util;

/** A mutable holder for a <code>double</code> value.
  *
  * @author Mark Lindner
  * @author PING Software Group
  * @version 1.0 (11/98)
  */

public class DoubleHolder extends HolderObject
  {
  /** The current value. */
  protected double value;

  /** Construct a new <code>DoubleHolder</code> with an initial value of 0.0
   * and default subtype of 0.
   */
  
  public DoubleHolder()
    {
    this(0.0, 0);
    }

  /** Construct a new <code>DoubleHolder</code> with a specified initial
   * value and default subtype of 0.
   *
   * @param value The initial value.
   */
  
  public DoubleHolder(double value)
    {
    this(value, 0);
    }

  /** Construct a new <code>DoubleHolder</code> with a specified initial
   * value and subtype.
   *
   * @param value The initial value.
   * @param subtype The subtype for this value.
   */
  
  public DoubleHolder(double value, int subtype)
    {
    super(subtype);
    
    this.value = value;
    }
  
  /** Set the <code>DoubleHolder</code>'s value.
    *
    * @param value The new value.
    */
  
  public synchronized final void setValue(double value)
    {
    this.value = value;
    }

  /** Get the <code>DoubleHolder</code>'s value.
    *
    * @return The current value.
    */
  
  public synchronized final double getValue()
    {
    return(value);
    }

  /** Get a string representation for this object. */
  
  public String toString()
    {
    return(String.valueOf(value));
    }

  /** Compare this holder object to another. */
  
  public int compareTo(HolderObject other)
    {
    double v = ((DoubleHolder)other).getValue();

    return((value < v) ? -1 : ((value > v) ? 1 : 0));
    }
  }
