/* ----------------------------------------------------------------------------
   The Kiwi Toolkit
   Copyright (C) 1998-99 Mark A. Lindner

   This file is part of Kiwi.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
   The author may be contacted at:
   
   frenzy@ix.netcom.com
   ----------------------------------------------------------------------------

   $Log: ScrollbackView.java,v $
   Revision 1.3  2000/10/11 10:52:52  markl
   Added mutator.

   Revision 1.2  1999/01/10 02:56:27  markl
   added GPL header & RCS tag

   ----------------------------------------------------------------------------
*/

package kiwi.ui;

import java.awt.Color;
import javax.swing.*;

import kiwi.util.ListConsumer;

/** This class represents a visual <i>scrollback</i> buffer. Lines of text may
  * be added to the buffer, which always displays the most recently-added
  * lines. Older lines may be viewed by scrolling back to them using the
  * scrollbar.
  * <p>
  * Once the buffer is full, the oldest lines are discarded as new lines
  * are added.
  *
  * @author Mark Lindner
  * @author PING Software Group
  * @version 2.0 (10/98)
  */

public class ScrollbackView extends JList implements ListConsumer
  {
  private int saveLines = 100;
  private DefaultListModel model;
  private boolean autoScrollsOnAdd = true;

  /** Construct a new <code>ScrollBackView</code>.
    *
    * @param rows The height for the component, in rows.
    */

  public ScrollbackView()
    {
    model = new DefaultListModel();
    setModel(model);
    }

  /** Clear the scrollback. Removes all rows from the buffer. */

  public void clear()
    {
    model.removeAllElements();
    }

  /** Set the buffer size.
   *
   * @param lines The maximum number of lines to save in the buffer.
   * @see #getSaveLines
    */

  public void setSaveLines(int lines)
    {
    if(lines > 0)
      saveLines = lines;
    }

  /** Get the buffer size.
    *
    * @return The maximum number of lines that this buffer will save.
    * @see #setSaveLines
    */

  public int getSaveLines()
    {
    return(saveLines);
    }

  /** Add an item to the buffer. Adds the specified item to the end of the
    * buffer. If the buffer was full, the oldest line is discarded. If
    * necessary, the buffer is scrolled to make the new item visible.
    *
    * @param item The item to add.
    */

  public void addItem(Object item)
    {
    if(model.size() > saveLines)
      model.removeRange(0, (model.size() - saveLines));
    model.addElement(item);
    if(autoScrollsOnAdd)
      ensureIndexIsVisible(model.size() - 1);
    }

  /** Specify whether the buffer should automatically scroll to the bottom
   * when a new item is added.
   *
   * @param flag A flag specifying whether autoscrolling should be enabled or
   * disabled.
   */

  public void setAutoScrollsOnAdd(boolean flag)
    {
    autoScrollsOnAdd = flag;
    }
  }

