
package kiwi.ui;

import java.awt.*;
import java.awt.datatransfer.*;
import java.io.*;

public class ImageSelection implements Transferable, ClipboardOwner
  {
  public static DataFlavor ImageFlavor
    = new DataFlavor(Image.class, "AWT Image");
  private DataFlavor flavors[] = { ImageFlavor };
  private Image image;

  public ImageSelection(Image image)
    {
    this.image = image;
    }

  public synchronized DataFlavor[] getTransferDataFlavors()
    {
    return(flavors);
    }

  public boolean isDataFlavorSupported(DataFlavor flavor)
    {
    return(flavor.equals(ImageFlavor));
    }

  public synchronized Object getTransferData(DataFlavor flavor)
    throws UnsupportedFlavorException, IOException
    {
    if(flavor.equals(ImageFlavor))
      return(image);
    else
      throw(new UnsupportedFlavorException(flavor));
    }

  public void lostOwnership(Clipboard c, Transferable t)
    {
    }
  }
